/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.TextView;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.animation.AnimationUtils;
import com.tr4android.support.extension.drawable.RoundRectDrawable;
import com.tr4android.support.extension.drawable.ShadowDrawableWrapper;
import com.tr4android.support.extension.utils.ViewCompatUtils;

public class LabelView
extends TextView {
    private static final int SHOW_HIDE_ANIM_DURATION = 200;
    private int mBackgroundColor;
    private int mRippleColor;
    private float mCornerRadius;
    private float mElevation;
    private boolean mIsHiding;
    private float mAnimationOffset;

    public LabelView(Context context) {
        this(context, null);
    }

    public LabelView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LabelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attr2 = context.obtainStyledAttributes(attrs, R.styleable.LabelView, defStyleAttr, 0);
        this.mBackgroundColor = attr2.getColor(R.styleable.LabelView_labelBackgroundColor, 0);
        this.mRippleColor = attr2.getColor(R.styleable.LabelView_labelRippleColor, 0);
        this.mCornerRadius = attr2.getDimension(R.styleable.LabelView_labelCornerRadius, 0.0f);
        this.mElevation = attr2.getDimension(R.styleable.LabelView_labelElevation, 0.0f);
        int paddingHorizontal = attr2.getDimensionPixelSize(R.styleable.LabelView_labelPaddingHorizontal, 0);
        int paddingVertical = attr2.getDimensionPixelSize(R.styleable.LabelView_labelPaddingVertical, 0);
        attr2.recycle();
        this.setFocusable(true);
        this.setClickable(true);
        this.initBackground();
        this.setCompatPadding(paddingHorizontal, paddingVertical, paddingHorizontal, paddingVertical);
    }

    public void setAnimationOffset(float offset) {
        this.mAnimationOffset = offset;
    }

    public float getAnimationOffset() {
        return this.mAnimationOffset;
    }

    public void setCompatPadding(int left, int top, int right, int bottom) {
        Rect shadowPadding = new Rect();
        this.getBackground().getPadding(shadowPadding);
        this.setPadding(left + shadowPadding.left, top + shadowPadding.top, right + shadowPadding.right, bottom + shadowPadding.bottom);
    }

    public void hide() {
        if (this.mIsHiding || this.getVisibility() != 0) {
            return;
        }
        if (!ViewCompat.isLaidOut((View)this)) {
            this.setVisibility(8);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            this.hideIceCreamSandwich();
        } else {
            this.hideEclairMr1();
        }
    }

    @TargetApi(value=14)
    private void hideIceCreamSandwich() {
        this.animate().cancel();
        this.animate().translationX(this.mAnimationOffset).alpha(0.0f).setDuration(200L).setInterpolator((TimeInterpolator)AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            private boolean mCancelled;

            public void onAnimationStart(Animator animation) {
                LabelView.this.mIsHiding = true;
            }

            public void onAnimationCancel(Animator animation) {
                LabelView.this.mIsHiding = false;
                this.mCancelled = true;
            }

            public void onAnimationEnd(Animator animation) {
                LabelView.this.mIsHiding = false;
                if (!this.mCancelled) {
                    LabelView.this.setVisibility(8);
                }
            }
        });
    }

    private void hideEclairMr1() {
        Animation anim = LabelView.createAnimationSet(1.0f, 0.0f, 0, Math.round(this.mAnimationOffset));
        anim.setInterpolator(AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR);
        anim.setDuration(200L);
        anim.setAnimationListener((Animation.AnimationListener)new AnimationUtils.AnimationListenerAdapter(){

            @Override
            public void onAnimationStart(Animation animation) {
                LabelView.this.mIsHiding = true;
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                LabelView.this.mIsHiding = false;
                LabelView.this.setVisibility(8);
            }
        });
        this.startAnimation(anim);
    }

    public void show() {
        if (!this.mIsHiding && this.getVisibility() == 0) {
            return;
        }
        if (!ViewCompat.isLaidOut((View)this)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            this.showIceCreamSandwich();
        } else {
            this.showEclairMr1();
        }
    }

    @TargetApi(value=14)
    private void showIceCreamSandwich() {
        this.animate().cancel();
        if (this.getVisibility() != 0) {
            this.setTranslationX(this.mAnimationOffset);
            this.setAlpha(0.0f);
        }
        this.animate().translationX(0.0f).alpha(1.0f).setDuration(200L).setInterpolator((TimeInterpolator)AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                LabelView.this.setVisibility(0);
            }
        });
    }

    private void showEclairMr1() {
        this.clearAnimation();
        this.setVisibility(0);
        Animation anim = LabelView.createAnimationSet(0.0f, 1.0f, Math.round(this.mAnimationOffset), 0);
        anim.setDuration(200L);
        anim.setInterpolator(AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
        this.startAnimation(anim);
    }

    private void initBackground() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.initBackgroundLollipop();
        } else {
            this.initBackgroundEclairMr1();
        }
    }

    @TargetApi(value=21)
    private void initBackgroundLollipop() {
        RoundRectDrawable shapeDrawable = new RoundRectDrawable(this.mBackgroundColor, this.mCornerRadius);
        RippleDrawable rippleDrawable = new RippleDrawable(ColorStateList.valueOf((int)this.mRippleColor), (Drawable)shapeDrawable, null);
        this.setElevation(this.mElevation);
        ViewCompatUtils.setBackground((View)this, (Drawable)rippleDrawable);
    }

    private void initBackgroundEclairMr1() {
        RoundRectDrawable shapeDrawable = new RoundRectDrawable(this.mBackgroundColor, this.mCornerRadius);
        shapeDrawable.setRoundRectTintList(LabelView.createColorStateList(this.mRippleColor, this.mBackgroundColor));
        ShadowDrawableWrapper shadowDrawable = new ShadowDrawableWrapper(this.getResources(), shapeDrawable, this.mCornerRadius, this.mElevation, this.mElevation);
        shadowDrawable.setAddPaddingForCorners(false);
        ViewCompatUtils.setBackground((View)this, (Drawable)shadowDrawable);
    }

    private static Animation createAnimationSet(float fromAlpha, float toAlpha, int fromXDelta, int toXDelta) {
        AnimationSet anim = new AnimationSet(true);
        anim.addAnimation((Animation)new AlphaAnimation(fromAlpha, toAlpha));
        anim.addAnimation((Animation)new TranslateAnimation((float)fromXDelta, (float)toXDelta, 0.0f, 0.0f));
        return anim;
    }

    private static ColorStateList createColorStateList(int rippleColor, int backgroundColor) {
        int compositeColor = ColorUtils.compositeColors((int)rippleColor, (int)backgroundColor);
        return new ColorStateList((int[][])new int[][]{{16842908}, {16842919}, new int[0]}, new int[]{compositeColor, compositeColor, backgroundColor});
    }
}

