/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatDrawableManager;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.drawable.ColorTransitionDrawable;
import com.tr4android.support.extension.drawable.RotationTransitionDrawable;
import com.tr4android.support.extension.internal.PairedTouchListener;
import com.tr4android.support.extension.utils.ViewCompatUtils;
import com.tr4android.support.extension.widget.LabelView;

@CoordinatorLayout.DefaultBehavior(value=Behavior.class)
@SuppressLint(value={"NewApi"})
public class FloatingActionMenu
extends ViewGroup {
    public static final int EXPAND_UP = 0;
    public static final int EXPAND_DOWN = 1;
    public static final int EXPAND_LEFT = 2;
    public static final int EXPAND_RIGHT = 3;
    public static final int LABELS_ON_LEFT_SIDE = 0;
    public static final int LABELS_ON_RIGHT_SIDE = 1;
    private RotationTransitionDrawable mToggleDrawable;
    private ColorTransitionDrawable mDimDrawable;
    private Handler mAnimationHandler = new Handler();
    private int mAnimationDuration = 300;
    private int mAnimationDelay = 50;
    private Rect childBackgroundPadding = new Rect();
    private int mButtonSpacing;
    private int mLabelsMargin;
    private int mLabelsVerticalOffset;
    private int mExpandDirection;
    private boolean mExpanded;
    private FloatingActionButton mMainButton;
    private int mButtonsCount;
    private int mMaxButtonWidth;
    private int mMaxButtonHeight;
    private int mLabelsStyle;
    private int mLabelsPosition;
    private Drawable mCloseDrawable;
    private float mCloseAngle;
    private View mDimmingView;
    private OnFloatingActionsMenuUpdateListener mListener;

    public FloatingActionMenu(Context context) {
        this(context, null);
    }

    public FloatingActionMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionMenu(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.mButtonSpacing = this.getResources().getDimensionPixelSize(R.dimen.fam_spacing);
        this.mLabelsMargin = this.getResources().getDimensionPixelSize(R.dimen.fam_label_spacing);
        this.mLabelsVerticalOffset = 0;
        TypedArray attr2 = context.obtainStyledAttributes(attributeSet, R.styleable.FloatingActionMenu, 0, 0);
        this.mExpandDirection = attr2.getInt(R.styleable.FloatingActionMenu_fabMenuExpandDirection, 0);
        this.mLabelsPosition = attr2.getInt(R.styleable.FloatingActionMenu_fabMenuLabelPosition, 0);
        this.mLabelsStyle = attr2.getResourceId(R.styleable.FloatingActionMenu_fabMenuLabelStyle, 0);
        int mCloseDrawableResourceId = attr2.getResourceId(R.styleable.FloatingActionMenu_fabMenuCloseIconSrc, 0);
        this.mCloseDrawable = mCloseDrawableResourceId == 0 ? null : AppCompatDrawableManager.get().getDrawable(this.getContext(), mCloseDrawableResourceId);
        this.mCloseAngle = attr2.getFloat(R.styleable.FloatingActionMenu_fabMenuCloseIconAngle, 0.0f);
        this.mButtonSpacing = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_fabMenuSpacing, this.mButtonSpacing);
        attr2.recycle();
        if (this.mLabelsStyle != 0 && this.expandsHorizontally()) {
            throw new IllegalStateException("Action labels in horizontal expand orientation is not supported.");
        }
        this.setFocusableInTouchMode(true);
    }

    public void setOnFloatingActionsMenuUpdateListener(OnFloatingActionsMenuUpdateListener listener) {
        this.mListener = listener;
    }

    private boolean expandsHorizontally() {
        return this.mExpandDirection == 2 || this.mExpandDirection == 3;
    }

    private void setupMainButton() {
        this.mMainButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingActionMenu.this.toggle();
            }
        });
        this.mToggleDrawable = new RotationTransitionDrawable(this.mMainButton.getDrawable(), this.mCloseDrawable);
        this.mToggleDrawable.setMaxRotation(this.mCloseAngle);
        this.mMainButton.setImageDrawable((Drawable)this.mToggleDrawable);
    }

    private int getColor(@ColorRes int id2) {
        return this.getResources().getColor(id2);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int width = 0;
        int height = 0;
        this.mMaxButtonWidth = 0;
        this.mMaxButtonHeight = 0;
        int maxLabelWidth = 0;
        for (int i = 0; i < this.mButtonsCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.getBackground().getPadding(this.childBackgroundPadding);
            if (!this.expandsHorizontally()) {
                this.mMaxButtonWidth = Math.max(this.mMaxButtonWidth, child.getMeasuredWidth() - this.childBackgroundPadding.left - this.childBackgroundPadding.right);
                height += child.getMeasuredHeight() - this.childBackgroundPadding.top - this.childBackgroundPadding.bottom;
                LabelView label = (LabelView)((Object)child.getTag(R.id.fab_label));
                if (label == null) continue;
                maxLabelWidth = Math.max(maxLabelWidth, label.getMeasuredWidth());
                continue;
            }
            width += child.getMeasuredWidth() - this.childBackgroundPadding.left - this.childBackgroundPadding.right;
            this.mMaxButtonHeight = Math.max(this.mMaxButtonHeight, child.getMeasuredHeight() - this.childBackgroundPadding.top - this.childBackgroundPadding.bottom);
        }
        LayoutParams mainButtonParams = (LayoutParams)this.mMainButton.getLayoutParams();
        if (!this.expandsHorizontally()) {
            width = this.mMaxButtonWidth + (maxLabelWidth > 0 ? maxLabelWidth + this.mLabelsMargin : 0);
            width += mainButtonParams.leftMargin + mainButtonParams.rightMargin;
            height += this.mButtonSpacing * (this.mButtonsCount - 1);
            height = this.adjustForOvershoot(height);
            height += this.mExpandDirection == 0 ? mainButtonParams.bottomMargin + this.childBackgroundPadding.top : mainButtonParams.topMargin + this.childBackgroundPadding.bottom;
        } else {
            height = this.mMaxButtonHeight;
            height += mainButtonParams.topMargin + mainButtonParams.rightMargin;
            width += this.mButtonSpacing * (this.mButtonsCount - 1);
            width = this.adjustForOvershoot(width);
            width += this.mExpandDirection == 2 ? mainButtonParams.rightMargin + this.childBackgroundPadding.left : mainButtonParams.leftMargin + this.childBackgroundPadding.right;
        }
        this.setMeasuredDimension(width, height);
    }

    private int adjustForOvershoot(int dimension) {
        return dimension * 12 / 10;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        switch (this.mExpandDirection) {
            case 0: 
            case 1: {
                boolean expandUp = this.mExpandDirection == 0;
                this.mMainButton.getBackground().getPadding(this.childBackgroundPadding);
                LayoutParams mainButtonParamsHorizontal = (LayoutParams)this.mMainButton.getLayoutParams();
                int addButtonY = expandUp ? b - t - this.mMainButton.getMeasuredHeight() + this.childBackgroundPadding.top + this.childBackgroundPadding.bottom - mainButtonParamsHorizontal.bottomMargin : mainButtonParamsHorizontal.topMargin;
                int buttonsHorizontalCenter = this.mLabelsPosition == 0 ? r - l - this.mMaxButtonWidth / 2 - mainButtonParamsHorizontal.rightMargin : this.mMaxButtonWidth / 2 + mainButtonParamsHorizontal.leftMargin;
                int addButtonLeft = buttonsHorizontalCenter - (this.mMainButton.getMeasuredWidth() - this.childBackgroundPadding.left - this.childBackgroundPadding.right) / 2;
                this.mMainButton.layout(addButtonLeft - this.childBackgroundPadding.left, addButtonY - this.childBackgroundPadding.top, addButtonLeft - this.childBackgroundPadding.left + this.mMainButton.getMeasuredWidth(), addButtonY - this.childBackgroundPadding.top + this.mMainButton.getMeasuredHeight());
                int labelsOffset = this.mMaxButtonWidth / 2 + this.mLabelsMargin;
                int labelsXNearButton = this.mLabelsPosition == 0 ? buttonsHorizontalCenter - labelsOffset : buttonsHorizontalCenter + labelsOffset;
                int nextY = expandUp ? addButtonY + this.childBackgroundPadding.top - this.mButtonSpacing : (addButtonY -= this.childBackgroundPadding.top) + this.mMainButton.getMeasuredHeight() - this.childBackgroundPadding.top - this.childBackgroundPadding.bottom + this.mButtonSpacing;
                for (int i = this.mButtonsCount - 1; i >= 0; --i) {
                    LabelView label;
                    View child = this.getChildAt(i);
                    if (child == this.mMainButton || child.getVisibility() == 8) continue;
                    child.getBackground().getPadding(this.childBackgroundPadding);
                    int childX = buttonsHorizontalCenter - (child.getMeasuredWidth() - this.childBackgroundPadding.left - this.childBackgroundPadding.right) / 2;
                    int childY = expandUp ? nextY - child.getMeasuredHeight() + this.childBackgroundPadding.top + this.childBackgroundPadding.bottom : nextY;
                    child.layout(childX - this.childBackgroundPadding.left, childY - this.childBackgroundPadding.top, childX - this.childBackgroundPadding.left + child.getMeasuredWidth(), childY - this.childBackgroundPadding.top + child.getMeasuredHeight());
                    childY -= this.childBackgroundPadding.top;
                    if (this.mExpanded) {
                        ((FloatingActionButton)child).show();
                    } else {
                        ((FloatingActionButton)child).hide();
                    }
                    LayoutParams params = (LayoutParams)child.getLayoutParams();
                    if (!params.isAnimated()) {
                        params.setAnimated(true);
                    }
                    if ((label = (LabelView)((Object)child.getTag(R.id.fab_label))) != null) {
                        int labelXAwayFromButton = this.mLabelsPosition == 0 ? labelsXNearButton - label.getMeasuredWidth() : labelsXNearButton + label.getMeasuredWidth();
                        int labelLeft = this.mLabelsPosition == 0 ? labelXAwayFromButton : labelsXNearButton;
                        int labelRight = this.mLabelsPosition == 0 ? labelsXNearButton : labelXAwayFromButton;
                        int labelTop = childY - this.mLabelsVerticalOffset + (child.getMeasuredHeight() - label.getMeasuredHeight()) / 2;
                        label.layout(labelLeft, labelTop, labelRight, labelTop + label.getMeasuredHeight());
                        label.setOnTouchListener(new PairedTouchListener(child));
                        child.setOnTouchListener((View.OnTouchListener)new PairedTouchListener((View)label));
                        if (this.mExpanded) {
                            label.setVisibility(0);
                        } else {
                            label.setVisibility(8);
                        }
                        LayoutParams labelParams = (LayoutParams)label.getLayoutParams();
                        if (!labelParams.isAnimated()) {
                            labelParams.setAnimated(true);
                        }
                    }
                    nextY = expandUp ? childY + this.childBackgroundPadding.top - this.mButtonSpacing : childY + child.getMeasuredHeight() - this.childBackgroundPadding.top - this.childBackgroundPadding.right + this.mButtonSpacing;
                }
                break;
            }
            case 2: 
            case 3: {
                boolean expandLeft = this.mExpandDirection == 2;
                this.mMainButton.getBackground().getPadding(this.childBackgroundPadding);
                LayoutParams mainButtonParamsVertical = (LayoutParams)this.mMainButton.getLayoutParams();
                int addButtonX = expandLeft ? r - l - this.mMainButton.getMeasuredWidth() + this.childBackgroundPadding.right - mainButtonParamsVertical.rightMargin : mainButtonParamsVertical.leftMargin - this.childBackgroundPadding.left;
                int addButtonTop = b - t - this.mMaxButtonHeight + (this.mMaxButtonHeight - this.mMainButton.getMeasuredHeight() - this.childBackgroundPadding.top - this.childBackgroundPadding.bottom) / 2 - mainButtonParamsVertical.bottomMargin + this.childBackgroundPadding.bottom;
                this.mMainButton.layout(addButtonX, addButtonTop, addButtonX + this.mMainButton.getMeasuredWidth(), addButtonTop + this.mMainButton.getMeasuredHeight());
                int nextX = expandLeft ? addButtonX + this.childBackgroundPadding.left - this.mButtonSpacing : addButtonX + this.mMainButton.getMeasuredWidth() - this.childBackgroundPadding.left - this.childBackgroundPadding.right + this.mButtonSpacing;
                for (int i = this.mButtonsCount - 1; i >= 0; --i) {
                    View child = this.getChildAt(i);
                    if (child == this.mMainButton || child.getVisibility() == 8) continue;
                    child.getBackground().getPadding(this.childBackgroundPadding);
                    int childX = expandLeft ? nextX - child.getMeasuredWidth() + this.childBackgroundPadding.right : nextX - this.childBackgroundPadding.left;
                    int childY = addButtonTop + (this.mMainButton.getMeasuredHeight() - child.getMeasuredHeight()) / 2;
                    child.layout(childX, childY, childX + child.getMeasuredWidth(), childY + child.getMeasuredHeight());
                    if (this.mExpanded) {
                        ((FloatingActionButton)child).show();
                    } else {
                        ((FloatingActionButton)child).hide();
                    }
                    LayoutParams params = (LayoutParams)child.getLayoutParams();
                    if (!params.isAnimated()) {
                        params.setAnimated(true);
                    }
                    nextX = expandLeft ? childX + this.childBackgroundPadding.left - this.mButtonSpacing : childX + child.getMeasuredWidth() - this.childBackgroundPadding.left - this.childBackgroundPadding.right + this.mButtonSpacing;
                }
                break;
            }
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMainButton = (FloatingActionButton)this.getChildAt(0);
        this.bringChildToFront((View)this.mMainButton);
        this.setupMainButton();
        this.mButtonsCount = this.getChildCount();
        if (this.mLabelsStyle != 0) {
            this.createLabels();
        }
    }

    private void createLabels() {
        ContextThemeWrapper context = new ContextThemeWrapper(this.getContext(), this.mLabelsStyle);
        for (int i = 0; i < this.mButtonsCount; ++i) {
            FloatingActionButton button = (FloatingActionButton)this.getChildAt(i);
            CharSequence title = button.getContentDescription();
            if (button == this.mMainButton || title == null || button.getTag(R.id.fab_label) != null) continue;
            LabelView label = new LabelView((Context)context);
            label.setAnimationOffset((float)this.mMaxButtonWidth / 2.0f + (float)this.mLabelsMargin);
            label.setTextAppearance(this.getContext(), this.mLabelsStyle);
            label.setText(title);
            this.addView((View)label);
            button.setTag(R.id.fab_label, (Object)label);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mMainButton.setEnabled(enabled);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mExpanded) {
            event.startTracking();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mExpanded) {
            this.collapse();
            return true;
        }
        return false;
    }

    private void startExpandAnimation(boolean animate) {
        int delay = animate ? this.mAnimationDelay : 0;
        this.mToggleDrawable.startTransition(animate ? this.mAnimationDuration : 0);
        if (this.mDimDrawable != null) {
            this.mDimDrawable.startTransition(animate ? this.mAnimationDuration : 0);
        }
        int childIndex = 0;
        for (int i = this.mButtonsCount - 1; i >= 0; --i) {
            final View child = this.getChildAt(i);
            if (child == this.mMainButton) continue;
            this.mAnimationHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((FloatingActionButton)child).show();
                    LabelView label = (LabelView)((Object)child.getTag(R.id.fab_label));
                    if (label != null) {
                        label.show();
                    }
                }
            }, (long)(delay * childIndex));
            ++childIndex;
        }
    }

    private void startCollapseAnimation(boolean animate) {
        int delay = animate ? this.mAnimationDelay : 0;
        this.mToggleDrawable.reverseTransition(animate ? this.mAnimationDuration : 0);
        if (this.mDimDrawable != null) {
            this.mDimDrawable.reverseTransition(animate ? this.mAnimationDuration : 0);
        }
        int childIndex = 0;
        for (int i = 0; i < this.mButtonsCount; ++i) {
            final View child = this.getChildAt(i);
            if (child == this.mMainButton) continue;
            this.mAnimationHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((FloatingActionButton)child).hide();
                    LabelView label = (LabelView)((Object)child.getTag(R.id.fab_label));
                    if (label != null) {
                        label.hide();
                    }
                }
            }, (long)(delay * childIndex));
            ++childIndex;
        }
    }

    public void setupWithDimmingView(View dimmingView, @ColorInt int dimmingColor) {
        this.mDimmingView = dimmingView;
        this.mDimDrawable = new ColorTransitionDrawable(0, dimmingColor);
        ViewCompatUtils.setBackground(this.mDimmingView, this.mDimDrawable);
        ViewCompat.setElevation((View)this, (float)this.getContext().getResources().getDimensionPixelSize(R.dimen.design_fab_elevation));
        ViewCompat.setElevation((View)this.mDimmingView, (float)this.getContext().getResources().getDimensionPixelSize(R.dimen.dim_elevation));
        this.mDimmingView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingActionMenu.this.collapse();
            }
        });
        this.mDimmingView.setClickable(false);
    }

    public void collapse() {
        this.collapse(true);
    }

    public void collapseImmediately() {
        this.collapse(false);
    }

    public void collapse(boolean animate) {
        if (this.mExpanded) {
            this.mExpanded = false;
            this.startCollapseAnimation(animate);
            if (this.mListener != null) {
                this.mListener.onMenuCollapsed();
            }
            this.clearFocus();
            if (this.mDimmingView != null) {
                this.mDimmingView.setClickable(false);
            }
        }
    }

    public void expand() {
        this.expand(true);
    }

    public void expandImmediately() {
        this.expand(false);
    }

    public void expand(boolean animate) {
        if (!this.mExpanded) {
            this.mExpanded = true;
            this.startExpandAnimation(animate);
            if (this.mListener != null) {
                this.mListener.onMenuExpanded();
            }
            this.requestFocus();
            if (this.mDimmingView != null) {
                this.mDimmingView.setClickable(true);
            }
        }
    }

    public void toggle() {
        if (this.mExpanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public boolean isExpanded() {
        return this.mExpanded;
    }

    public void addButton(FloatingActionButton button) {
        this.addView((View)button, this.mButtonsCount - 1);
        ++this.mButtonsCount;
        if (this.mLabelsStyle != 0) {
            this.createLabels();
        }
    }

    public void removeButton(FloatingActionButton button) {
        this.removeView((View)button.getTag(R.id.fab_label));
        this.removeView((View)button);
        button.setTag(R.id.fab_label, null);
        --this.mButtonsCount;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.mExpanded = this.mExpanded;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState savedState = (SavedState)state;
            this.mExpanded = savedState.mExpanded;
            this.mToggleDrawable.setRotation(this.mExpanded ? this.mCloseAngle : 0.0f);
            this.mDimDrawable.setColorRatio(this.mExpanded ? 1.0f : 0.0f);
            super.onRestoreInstanceState(savedState.getSuperState());
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public static class Behavior
    extends CoordinatorLayout.Behavior<FloatingActionMenu> {
        private static final boolean SNACKBAR_BEHAVIOR_ENABLED = Build.VERSION.SDK_INT >= 11;

        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public boolean layoutDependsOn(CoordinatorLayout parent, FloatingActionMenu child, View dependency) {
            return SNACKBAR_BEHAVIOR_ENABLED && dependency instanceof Snackbar.SnackbarLayout;
        }

        public boolean onDependentViewChanged(CoordinatorLayout parent, FloatingActionMenu child, View dependency) {
            float translationY = Math.min(0.0f, dependency.getTranslationY() - (float)dependency.getHeight());
            child.setTranslationY(translationY);
            return true;
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public boolean mExpanded;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable parcel) {
            super(parcel);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mExpanded = in.readInt() == 1;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mExpanded ? 1 : 0);
        }
    }

    private class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private boolean mAnimated;

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public boolean isAnimated() {
            return this.mAnimated;
        }

        public void setAnimated(boolean animated) {
            this.mAnimated = animated;
        }
    }

    public static interface OnFloatingActionsMenuUpdateListener {
        public void onMenuExpanded();

        public void onMenuCollapsed();
    }
}

