/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.design.widget.AppBarLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.animation.AnimationUtils;
import com.tr4android.support.extension.animation.ValueAnimatorCompat;
import com.tr4android.support.extension.internal.ViewOffsetHelper;
import com.tr4android.support.extension.widget.CollapsingDrawableHelper;
import com.tr4android.support.extension.widget.CollapsingTextHelper;
import com.tr4android.support.extension.widget.ViewGroupUtils;

public class FlexibleToolbarLayout
extends FrameLayout {
    private static final int SCRIM_ANIMATION_DURATION = 600;
    private boolean mRefreshToolbar = true;
    private int mToolbarId;
    private Toolbar mToolbar;
    private View mDummyView;
    private int mExpandedMarginLeft;
    private int mExpandedMarginTop;
    private int mExpandedMarginRight;
    private int mExpandedMarginBottom;
    private final Rect mTmpRect = new Rect();
    private final Rect mExpandedBounds = new Rect();
    private boolean mDrawTitles;
    private int mSpaceTitleSubtitle;
    private int mSpaceIconTitles;
    private final CollapsingTextHelper mTitleCollapsingTextHelper = new CollapsingTextHelper((View)this);
    private boolean mCollapsingTitleEnabled;
    private final CollapsingTextHelper mSubtitleCollapsingTextHelper;
    private boolean mCollapsingSubtitleEnabled;
    private final CollapsingDrawableHelper mIconCollapsingHelper;
    private boolean mCollapsingIconEnabled;
    private Drawable mContentScrim;
    private Drawable mStatusBarScrim;
    private int mScrimAlpha;
    private boolean mScrimsAreShown;
    private ValueAnimatorCompat mScrimAnimator;
    private AppBarLayout.OnOffsetChangedListener mOnOffsetChangedListener;
    private int mCurrentOffset;
    private WindowInsetsCompat mLastInsets;

    public FlexibleToolbarLayout(Context context) {
        this(context, null);
    }

    public FlexibleToolbarLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlexibleToolbarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        boolean isRtl;
        this.mTitleCollapsingTextHelper.setTextSizeInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        this.mSubtitleCollapsingTextHelper = new CollapsingTextHelper((View)this);
        this.mSubtitleCollapsingTextHelper.setTextSizeInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        this.mIconCollapsingHelper = new CollapsingDrawableHelper((View)this);
        this.mIconCollapsingHelper.setIconSizeInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlexibleToolbarLayout, defStyleAttr, R.style.Widget_Design_FlexibleToolbarLayout);
        int expandedVerticalGravity = a.getInt(R.styleable.FlexibleToolbarLayout_expandedGravity, 16);
        this.mTitleCollapsingTextHelper.setExpandedTextGravity(0x800003 | expandedVerticalGravity);
        this.mTitleCollapsingTextHelper.setCollapsedTextGravity(8388627);
        this.mSubtitleCollapsingTextHelper.setExpandedTextGravity(0x800003 | expandedVerticalGravity);
        this.mSubtitleCollapsingTextHelper.setCollapsedTextGravity(8388627);
        this.mExpandedMarginRight = this.mExpandedMarginBottom = a.getDimensionPixelSize(R.styleable.FlexibleToolbarLayout_expandedMargin, 0);
        this.mExpandedMarginTop = this.mExpandedMarginBottom;
        this.mExpandedMarginLeft = this.mExpandedMarginBottom;
        boolean bl = isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
        if (a.hasValue(R.styleable.FlexibleToolbarLayout_expandedMarginStart)) {
            int marginStart = a.getDimensionPixelSize(R.styleable.FlexibleToolbarLayout_expandedMarginStart, 0);
            if (isRtl) {
                this.mExpandedMarginRight = marginStart;
            } else {
                this.mExpandedMarginLeft = marginStart;
            }
        }
        if (a.hasValue(R.styleable.FlexibleToolbarLayout_expandedMarginEnd)) {
            int marginEnd = a.getDimensionPixelSize(R.styleable.FlexibleToolbarLayout_expandedMarginEnd, 0);
            if (isRtl) {
                this.mExpandedMarginLeft = marginEnd;
            } else {
                this.mExpandedMarginRight = marginEnd;
            }
        }
        if (a.hasValue(R.styleable.FlexibleToolbarLayout_expandedMarginTop)) {
            this.mExpandedMarginTop = a.getDimensionPixelSize(R.styleable.FlexibleToolbarLayout_expandedMarginTop, 0);
        }
        if (a.hasValue(R.styleable.FlexibleToolbarLayout_expandedMarginBottom)) {
            this.mExpandedMarginBottom = a.getDimensionPixelSize(R.styleable.FlexibleToolbarLayout_expandedMarginBottom, 0);
        }
        this.mCollapsingTitleEnabled = a.getBoolean(R.styleable.FlexibleToolbarLayout_titleFlexibleEnabled, true);
        this.setTitle(a.getText(R.styleable.FlexibleToolbarLayout_title));
        this.mCollapsingSubtitleEnabled = a.getBoolean(R.styleable.FlexibleToolbarLayout_subtitleFlexibleEnabled, true);
        this.setSubtitle(a.getText(R.styleable.FlexibleToolbarLayout_subtitle));
        this.mCollapsingIconEnabled = a.getBoolean(R.styleable.FlexibleToolbarLayout_iconFlexibleEnabled, true);
        this.setIcon(a.getDrawable(R.styleable.FlexibleToolbarLayout_icon));
        this.mTitleCollapsingTextHelper.setExpandedTextAppearance(R.style.TextAppearance_Design_FlexibleToolbarLayout_ExpandedTitle);
        this.mTitleCollapsingTextHelper.setCollapsedTextAppearance(R.style.TextAppearance_Design_FlexibleToolbarLayout_CollapsedTitle);
        this.mSubtitleCollapsingTextHelper.setExpandedTextAppearance(R.style.TextAppearance_Design_FlexibleToolbarLayout_Subtitle);
        this.mSubtitleCollapsingTextHelper.setCollapsedTextAppearance(R.style.TextAppearance_Design_FlexibleToolbarLayout_Subtitle);
        if (a.hasValue(R.styleable.FlexibleToolbarLayout_titleExpandedTextAppearance)) {
            this.mTitleCollapsingTextHelper.setExpandedTextAppearance(a.getResourceId(R.styleable.FlexibleToolbarLayout_titleExpandedTextAppearance, 0));
        }
        if (a.hasValue(R.styleable.FlexibleToolbarLayout_titleCollapsedTextAppearance)) {
            this.mTitleCollapsingTextHelper.setCollapsedTextAppearance(a.getResourceId(R.styleable.FlexibleToolbarLayout_titleCollapsedTextAppearance, 0));
        }
        if (a.hasValue(R.styleable.FlexibleToolbarLayout_subtitleExpandedTextAppearance)) {
            this.mSubtitleCollapsingTextHelper.setExpandedTextAppearance(a.getResourceId(R.styleable.FlexibleToolbarLayout_subtitleExpandedTextAppearance, 0));
        }
        if (a.hasValue(R.styleable.FlexibleToolbarLayout_subtitleCollapsedTextAppearance)) {
            this.mSubtitleCollapsingTextHelper.setCollapsedTextAppearance(a.getResourceId(R.styleable.FlexibleToolbarLayout_subtitleCollapsedTextAppearance, 0));
        }
        this.mIconCollapsingHelper.setCollapsedIconSize(a.getDimensionPixelSize(R.styleable.FlexibleToolbarLayout_iconCollapsedSize, 0));
        this.mIconCollapsingHelper.setExpandedIconSize(a.getDimensionPixelSize(R.styleable.FlexibleToolbarLayout_iconExpandedSize, 0));
        this.mSpaceTitleSubtitle = a.getDimensionPixelSize(R.styleable.FlexibleToolbarLayout_spaceTitleSubtitle, 0);
        this.mSpaceIconTitles = a.getDimensionPixelSize(R.styleable.FlexibleToolbarLayout_spaceIconTitles, 0);
        this.setContentScrim(a.getDrawable(R.styleable.FlexibleToolbarLayout_contentScrimColor));
        this.setStatusBarScrim(a.getDrawable(R.styleable.FlexibleToolbarLayout_statusBarScrimColor));
        this.mToolbarId = a.getResourceId(R.styleable.FlexibleToolbarLayout_toolbarRefId, -1);
        a.recycle();
        this.setWillNotDraw(false);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                FlexibleToolbarLayout.this.mLastInsets = insets;
                FlexibleToolbarLayout.this.requestLayout();
                return insets.consumeSystemWindowInsets();
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent parent = this.getParent();
        if (parent instanceof AppBarLayout) {
            if (this.mOnOffsetChangedListener == null) {
                this.mOnOffsetChangedListener = new OffsetUpdateListener();
            }
            ((AppBarLayout)parent).addOnOffsetChangedListener(this.mOnOffsetChangedListener);
        }
    }

    protected void onDetachedFromWindow() {
        ViewParent parent = this.getParent();
        if (this.mOnOffsetChangedListener != null && parent instanceof AppBarLayout) {
            ((AppBarLayout)parent).removeOnOffsetChangedListener(this.mOnOffsetChangedListener);
        }
        super.onDetachedFromWindow();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.ensureToolbar();
        if (this.mToolbar == null && this.mContentScrim != null && this.mScrimAlpha > 0) {
            this.mContentScrim.mutate().setAlpha(this.mScrimAlpha);
            this.mContentScrim.draw(canvas);
        }
        if (this.mCollapsingTitleEnabled && this.mDrawTitles) {
            this.mTitleCollapsingTextHelper.draw(canvas);
        }
        if (this.mCollapsingSubtitleEnabled && this.mDrawTitles) {
            this.mSubtitleCollapsingTextHelper.draw(canvas);
        }
        if (this.mCollapsingIconEnabled && this.mDrawTitles) {
            this.mIconCollapsingHelper.draw(canvas);
        }
        if (this.mStatusBarScrim != null && this.mScrimAlpha > 0) {
            int topInset;
            int n = topInset = this.mLastInsets != null ? this.mLastInsets.getSystemWindowInsetTop() : 0;
            if (topInset > 0) {
                this.mStatusBarScrim.setBounds(0, -this.mCurrentOffset, this.getWidth(), topInset - this.mCurrentOffset);
                this.mStatusBarScrim.mutate().setAlpha(this.mScrimAlpha);
                this.mStatusBarScrim.draw(canvas);
            }
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        this.ensureToolbar();
        if (child == this.mToolbar && this.mContentScrim != null && this.mScrimAlpha > 0) {
            this.mContentScrim.mutate().setAlpha(this.mScrimAlpha);
            this.mContentScrim.draw(canvas);
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mContentScrim != null) {
            this.mContentScrim.setBounds(0, 0, w, h);
        }
    }

    private void ensureToolbar() {
        if (!this.mRefreshToolbar) {
            return;
        }
        Toolbar fallback = null;
        Toolbar selected = null;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof Toolbar)) continue;
            if (this.mToolbarId != -1) {
                if (this.mToolbarId == child.getId()) {
                    selected = (Toolbar)child;
                    break;
                }
                if (fallback != null) continue;
                fallback = (Toolbar)child;
                continue;
            }
            selected = (Toolbar)child;
            break;
        }
        if (selected == null) {
            selected = fallback;
        }
        this.mToolbar = selected;
        this.updateDummyView();
        this.mRefreshToolbar = false;
    }

    private void updateDummyView() {
        ViewParent parent;
        if (!this.mCollapsingTitleEnabled && this.mDummyView != null && (parent = this.mDummyView.getParent()) instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(this.mDummyView);
        }
        if (this.mCollapsingTitleEnabled && this.mToolbar != null) {
            if (this.mDummyView == null) {
                this.mDummyView = new View(this.getContext());
            }
            if (this.mDummyView.getParent() == null) {
                this.mToolbar.addView(this.mDummyView, -1, -1);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.ensureToolbar();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mDrawTitles = this.mDummyView != null && this.mDummyView.isShown();
        int horizontalOffsetCollapsed = this.mCollapsingIconEnabled ? (int)this.mIconCollapsingHelper.getCollapsedIconSize() + this.mSpaceIconTitles : 0;
        int horizontalOffsetExpanded = this.mCollapsingIconEnabled ? (int)this.mIconCollapsingHelper.getExpandedIconSize() + this.mSpaceIconTitles : 0;
        int expandedIconSize = (int)this.mIconCollapsingHelper.getExpandedIconSize();
        this.mExpandedBounds.set(this.mExpandedMarginLeft, this.mCollapsingIconEnabled ? bottom - top - this.mExpandedMarginBottom - expandedIconSize : this.mTmpRect.bottom + this.mExpandedMarginTop, right - left - this.mExpandedMarginRight, bottom - top - this.mExpandedMarginBottom);
        if (this.mCollapsingTitleEnabled && this.mDrawTitles) {
            ViewGroupUtils.getDescendantRect((ViewGroup)this, this.mDummyView, this.mTmpRect);
            this.mTitleCollapsingTextHelper.setCollapsedBounds(this.mTmpRect.left + horizontalOffsetCollapsed, bottom - this.mTmpRect.height(), this.mTmpRect.right, bottom);
            this.mTitleCollapsingTextHelper.setExpandedBounds(this.mExpandedBounds.left + horizontalOffsetExpanded, this.mExpandedBounds.top, this.mExpandedBounds.right, this.mExpandedBounds.bottom);
            if (this.mCollapsingSubtitleEnabled) {
                this.mTitleCollapsingTextHelper.setCollapsedTextOffsetBottom((float)this.mSpaceTitleSubtitle + this.mSubtitleCollapsingTextHelper.getCollapsedTextHeight());
                this.mTitleCollapsingTextHelper.setExpandedTextOffsetBottom((float)this.mSpaceTitleSubtitle + this.mSubtitleCollapsingTextHelper.getExpandedTextHeight());
            }
            this.mTitleCollapsingTextHelper.recalculate();
        }
        if (this.mCollapsingSubtitleEnabled && this.mDrawTitles) {
            ViewGroupUtils.getDescendantRect((ViewGroup)this, this.mDummyView, this.mTmpRect);
            this.mSubtitleCollapsingTextHelper.setCollapsedBounds(this.mTmpRect.left + horizontalOffsetCollapsed, bottom - this.mTmpRect.height(), this.mTmpRect.right, bottom);
            this.mSubtitleCollapsingTextHelper.setExpandedBounds(this.mExpandedBounds.left + horizontalOffsetExpanded, this.mExpandedBounds.top, this.mExpandedBounds.right, this.mExpandedBounds.bottom);
            if (this.mCollapsingTitleEnabled) {
                this.mSubtitleCollapsingTextHelper.setCollapsedTextOffsetTop((float)this.mSpaceTitleSubtitle + this.mTitleCollapsingTextHelper.getCollapsedTextHeight());
                this.mSubtitleCollapsingTextHelper.setExpandedTextOffsetTop((float)this.mSpaceTitleSubtitle + this.mTitleCollapsingTextHelper.getExpandedTextHeight());
            }
            this.mSubtitleCollapsingTextHelper.recalculate();
        }
        if (this.mCollapsingIconEnabled && this.mDrawTitles) {
            ViewGroupUtils.getDescendantRect((ViewGroup)this, this.mDummyView, this.mTmpRect);
            int collapsedIconSize = (int)this.mIconCollapsingHelper.getCollapsedIconSize();
            int collapsedTop = bottom - this.mTmpRect.height() + Math.round((float)(this.mTmpRect.height() - collapsedIconSize) / 2.0f);
            this.mIconCollapsingHelper.setCollapsedBounds(this.mTmpRect.left, collapsedTop, this.mTmpRect.left + collapsedIconSize, collapsedTop + collapsedIconSize);
            this.mIconCollapsingHelper.setExpandedBounds(this.mExpandedBounds.left, this.mExpandedBounds.top, this.mExpandedMarginLeft + expandedIconSize, this.mExpandedBounds.bottom);
            this.mIconCollapsingHelper.recalculate();
        }
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            if (this.mLastInsets != null && !ViewCompat.getFitsSystemWindows((View)child)) {
                int insetTop = this.mLastInsets.getSystemWindowInsetTop();
                if (child.getTop() < insetTop) {
                    child.offsetTopAndBottom(insetTop);
                }
            }
            FlexibleToolbarLayout.getViewOffsetHelper(child).onViewLayout();
        }
        if (this.mToolbar != null) {
            if (this.mCollapsingTitleEnabled && TextUtils.isEmpty((CharSequence)this.mTitleCollapsingTextHelper.getText())) {
                this.mTitleCollapsingTextHelper.setText(this.mToolbar.getTitle());
            }
            this.setMinimumHeight(this.mToolbar.getHeight());
        }
    }

    private static ViewOffsetHelper getViewOffsetHelper(View view) {
        ViewOffsetHelper offsetHelper = (ViewOffsetHelper)view.getTag(R.id.view_offset_helper);
        if (offsetHelper == null) {
            offsetHelper = new ViewOffsetHelper(view);
            view.setTag(R.id.view_offset_helper, (Object)offsetHelper);
        }
        return offsetHelper;
    }

    public void collapse() {
        ViewParent parent = this.getParent();
        if (parent instanceof AppBarLayout) {
            ((AppBarLayout)parent).setExpanded(false);
        }
    }

    public void collapse(boolean animate) {
        ViewParent parent = this.getParent();
        if (parent instanceof AppBarLayout) {
            ((AppBarLayout)parent).setExpanded(false, animate);
        }
    }

    public void expand() {
        ViewParent parent = this.getParent();
        if (parent instanceof AppBarLayout) {
            ((AppBarLayout)parent).setExpanded(true);
        }
    }

    public void expand(boolean animate) {
        ViewParent parent = this.getParent();
        if (parent instanceof AppBarLayout) {
            ((AppBarLayout)parent).setExpanded(true, animate);
        }
    }

    public void setTitle(@Nullable CharSequence title) {
        this.mTitleCollapsingTextHelper.setText(title);
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mCollapsingTitleEnabled ? this.mTitleCollapsingTextHelper.getText() : null;
    }

    public void setTitleEnabled(boolean enabled) {
        if (enabled != this.mCollapsingTitleEnabled) {
            this.mCollapsingTitleEnabled = enabled;
            this.updateDummyView();
            this.requestLayout();
        }
    }

    public boolean isTitleEnabled() {
        return this.mCollapsingTitleEnabled;
    }

    public void setSubtitle(@Nullable CharSequence subtitle) {
        this.mSubtitleCollapsingTextHelper.setText(subtitle);
    }

    @Nullable
    public CharSequence getSubtitle() {
        return this.mCollapsingSubtitleEnabled ? this.mSubtitleCollapsingTextHelper.getText() : null;
    }

    public void setSubtitleEnabled(boolean enabled) {
        if (enabled != this.mCollapsingSubtitleEnabled) {
            this.mCollapsingSubtitleEnabled = enabled;
            this.updateDummyView();
            this.requestLayout();
        }
    }

    public boolean isSubtitleEnabled() {
        return this.mCollapsingSubtitleEnabled;
    }

    public void setIcon(@Nullable Drawable icon) {
        this.mIconCollapsingHelper.setDrawable(icon);
    }

    @Nullable
    public Drawable getIcon() {
        return this.mCollapsingIconEnabled ? this.mIconCollapsingHelper.getDrawable() : null;
    }

    public void setIconEnabled(boolean enabled) {
        if (enabled != this.mCollapsingIconEnabled) {
            this.mCollapsingIconEnabled = enabled;
            this.requestLayout();
        }
    }

    public boolean isIconEnabled() {
        return this.mCollapsingIconEnabled;
    }

    public void setScrimsShown(boolean shown) {
        this.setScrimsShown(shown, ViewCompat.isLaidOut((View)this) && !this.isInEditMode());
    }

    public void setScrimsShown(boolean shown, boolean animate) {
        if (this.mScrimsAreShown != shown) {
            if (animate) {
                this.animateScrim(shown ? 255 : 0);
            } else {
                this.setScrimAlpha(shown ? 255 : 0);
            }
            this.mScrimsAreShown = shown;
        }
    }

    private void animateScrim(int targetAlpha) {
        this.ensureToolbar();
        if (this.mScrimAnimator == null) {
            this.mScrimAnimator = AnimationUtils.createAnimator();
            this.mScrimAnimator.setDuration(600);
            this.mScrimAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.mScrimAnimator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                @Override
                public void onAnimationUpdate(ValueAnimatorCompat animator) {
                    FlexibleToolbarLayout.this.setScrimAlpha(animator.getAnimatedIntValue());
                }
            });
        } else if (this.mScrimAnimator.isRunning()) {
            this.mScrimAnimator.cancel();
        }
        this.mScrimAnimator.setIntValues(this.mScrimAlpha, targetAlpha);
        this.mScrimAnimator.start();
    }

    private void setScrimAlpha(int alpha) {
        if (alpha != this.mScrimAlpha) {
            Drawable contentScrim = this.mContentScrim;
            if (contentScrim != null && this.mToolbar != null) {
                ViewCompat.postInvalidateOnAnimation((View)this.mToolbar);
            }
            this.mScrimAlpha = alpha;
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setContentScrim(@Nullable Drawable drawable2) {
        if (this.mContentScrim != drawable2) {
            if (this.mContentScrim != null) {
                this.mContentScrim.setCallback(null);
            }
            if (drawable2 != null) {
                this.mContentScrim = drawable2.mutate();
                drawable2.setBounds(0, 0, this.getWidth(), this.getHeight());
                drawable2.setCallback((Drawable.Callback)this);
                drawable2.setAlpha(this.mScrimAlpha);
            } else {
                this.mContentScrim = null;
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setContentScrimColor(@ColorInt int color2) {
        this.setContentScrim((Drawable)new ColorDrawable(color2));
    }

    public void setContentScrimResource(@DrawableRes int resId) {
        this.setContentScrim(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
    }

    public Drawable getContentScrim() {
        return this.mContentScrim;
    }

    public void setStatusBarScrim(@Nullable Drawable drawable2) {
        if (this.mStatusBarScrim != drawable2) {
            if (this.mStatusBarScrim != null) {
                this.mStatusBarScrim.setCallback(null);
            }
            this.mStatusBarScrim = drawable2;
            drawable2.setCallback((Drawable.Callback)this);
            drawable2.mutate().setAlpha(this.mScrimAlpha);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setStatusBarScrimColor(@ColorInt int color2) {
        this.setStatusBarScrim((Drawable)new ColorDrawable(color2));
    }

    public void setStatusBarScrimResource(@DrawableRes int resId) {
        this.setStatusBarScrim(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
    }

    public Drawable getStatusBarScrim() {
        return this.mStatusBarScrim;
    }

    public void setCollapsedTitleTextAppearance(@StyleRes int resId) {
        this.mTitleCollapsingTextHelper.setCollapsedTextAppearance(resId);
    }

    public void setCollapsedTitleTextColor(@ColorInt int color2) {
        this.mTitleCollapsingTextHelper.setCollapsedTextColor(color2);
    }

    public void setExpandedTitleTextAppearance(@StyleRes int resId) {
        this.mTitleCollapsingTextHelper.setExpandedTextAppearance(resId);
    }

    public void setExpandedTitleColor(@ColorInt int color2) {
        this.mTitleCollapsingTextHelper.setExpandedTextColor(color2);
    }

    final int getScrimTriggerOffset() {
        return 2 * ViewCompat.getMinimumHeight((View)this);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(super.generateDefaultLayoutParams());
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected FrameLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    private class OffsetUpdateListener
    implements AppBarLayout.OnOffsetChangedListener {
        private OffsetUpdateListener() {
        }

        public void onOffsetChanged(AppBarLayout layout2, int verticalOffset) {
            FlexibleToolbarLayout.this.mCurrentOffset = verticalOffset;
            int insetTop = FlexibleToolbarLayout.this.mLastInsets != null ? FlexibleToolbarLayout.this.mLastInsets.getSystemWindowInsetTop() : 0;
            int scrollRange = layout2.getTotalScrollRange();
            int z = FlexibleToolbarLayout.this.getChildCount();
            block4: for (int i = 0; i < z; ++i) {
                View child = FlexibleToolbarLayout.this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                ViewOffsetHelper offsetHelper = FlexibleToolbarLayout.getViewOffsetHelper(child);
                switch (lp.mCollapseMode) {
                    case 1: {
                        if (FlexibleToolbarLayout.this.getHeight() - insetTop + verticalOffset < child.getHeight()) continue block4;
                        offsetHelper.setTopAndBottomOffset(-verticalOffset);
                        continue block4;
                    }
                    case 2: {
                        offsetHelper.setTopAndBottomOffset(Math.round((float)(-verticalOffset) * lp.mParallaxMult));
                    }
                }
            }
            if (FlexibleToolbarLayout.this.mContentScrim != null || FlexibleToolbarLayout.this.mStatusBarScrim != null) {
                FlexibleToolbarLayout.this.setScrimsShown(FlexibleToolbarLayout.this.getHeight() + verticalOffset < FlexibleToolbarLayout.this.getScrimTriggerOffset() + insetTop);
            }
            if (FlexibleToolbarLayout.this.mStatusBarScrim != null && insetTop > 0) {
                ViewCompat.postInvalidateOnAnimation((View)FlexibleToolbarLayout.this);
            }
            int expandRange = FlexibleToolbarLayout.this.getHeight() - ViewCompat.getMinimumHeight((View)FlexibleToolbarLayout.this) - insetTop;
            float fraction = (float)Math.abs(verticalOffset) / (float)expandRange;
            FlexibleToolbarLayout.this.mTitleCollapsingTextHelper.setExpansionFraction(fraction);
            FlexibleToolbarLayout.this.mSubtitleCollapsingTextHelper.setExpansionFraction(fraction);
            FlexibleToolbarLayout.this.mIconCollapsingHelper.setExpansionFraction(fraction);
        }
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        private static final float DEFAULT_PARALLAX_MULTIPLIER = 0.5f;
        public static final int COLLAPSE_MODE_OFF = 0;
        public static final int COLLAPSE_MODE_PIN = 1;
        public static final int COLLAPSE_MODE_PARALLAX = 2;
        int mCollapseMode = 0;
        float mParallaxMult = 0.5f;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.FlexibleToolbarLayout_LayoutParams);
            this.mCollapseMode = a.getInt(R.styleable.FlexibleToolbarLayout_LayoutParams_layout_collapseMode, 0);
            this.setParallaxMultiplier(a.getFloat(R.styleable.FlexibleToolbarLayout_LayoutParams_layout_collapseParallaxMultiplier, 0.5f));
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height, gravity);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(FrameLayout.LayoutParams source) {
            super(source);
        }

        public void setCollapseMode(int collapseMode) {
            this.mCollapseMode = collapseMode;
        }

        public int getCollapseMode() {
            return this.mCollapseMode;
        }

        public void setParallaxMultiplier(float multiplier) {
            this.mParallaxMult = multiplier;
        }

        public float getParallaxMultiplier() {
            return this.mParallaxMult;
        }
    }
}

