/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.typeface;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Environment;
import android.support.v4.util.LruCache;
import android.util.Log;
import com.tr4android.support.extension.typeface.TypefaceUtils;
import java.util.HashMap;

@Deprecated
public class TypefaceCompat {
    private static final HashMap<String, String> FONT_FAMILY_FILE_PREFIX = new HashMap();
    private static final String[] STYLE_SUFFIX = new String[]{"Regular", "Bold", "Italic", "BoldItalic"};
    private static final String TTF_SUFFIX = ".ttf";
    private static final int TYPEFACE_CACHE_MAX_SIZE = 8;
    private static final LruCache<String, Typeface> TYPEFACE_CACHE = new LruCache(8);
    private static final String SYSTEM_ROBOTO_REGULAR_FILE_PATH = Environment.getRootDirectory() + "/fonts/Roboto-Regular.ttf";
    private static boolean mIsUsingDefaultFont = true;
    private static boolean mTypefaceDetectionEnabled = true;
    private static boolean mInitialized;

    @Deprecated
    private static void initialize() {
        Typeface roboto;
        Log.w((String)"TypefaceCompat", (String)"TypefaceCompat is deprecated. Use downloadable fonts or FontsContractCompat instead.");
        if (mTypefaceDetectionEnabled && Build.VERSION.SDK_INT >= 14 && (roboto = Typeface.createFromFile((String)SYSTEM_ROBOTO_REGULAR_FILE_PATH)) != null) {
            mIsUsingDefaultFont = TypefaceUtils.sameAs(roboto, Typeface.SANS_SERIF);
        }
        mInitialized = true;
    }

    @Deprecated
    public static void initialize(boolean typefaceDetectionEnabled) {
        TypefaceCompat.setTypefaceDetectionEnabled(typefaceDetectionEnabled);
    }

    @Deprecated
    public static void setTypefaceDetectionEnabled(boolean typefaceDetectionEnabled) {
        mTypefaceDetectionEnabled = typefaceDetectionEnabled;
        TypefaceCompat.initialize();
    }

    @Deprecated
    public static Typeface create(Context ctx, String familyName, int style2) {
        if (!mInitialized) {
            TypefaceCompat.initialize();
        }
        if (TypefaceCompat.isSupported(familyName) || familyName == null) {
            boolean styleAfterwards = false;
            String fileName = FONT_FAMILY_FILE_PREFIX.get(familyName == null ? "sans-serif" : familyName);
            if (fileName.endsWith("-")) {
                fileName = fileName + STYLE_SUFFIX[style2];
            } else {
                switch (style2) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 3: {
                        styleAfterwards = true;
                        break;
                    }
                    case 2: {
                        fileName = fileName + STYLE_SUFFIX[style2];
                    }
                }
            }
            fileName = fileName + TTF_SUFFIX;
            Typeface tf = (Typeface)TYPEFACE_CACHE.get((Object)fileName);
            if (tf == null) {
                String fontPath = "fonts/" + fileName;
                tf = Typeface.createFromAsset((AssetManager)ctx.getAssets(), (String)fontPath);
                if (tf != null) {
                    TYPEFACE_CACHE.put((Object)fileName, (Object)tf);
                }
            }
            if (tf != null) {
                return styleAfterwards ? Typeface.create((Typeface)tf, (int)style2) : tf;
            }
        }
        return Typeface.create((String)familyName, (int)style2);
    }

    @Deprecated
    public static boolean isSupported(String familyName) {
        if (!mInitialized) {
            TypefaceCompat.initialize();
        }
        return FONT_FAMILY_FILE_PREFIX.containsKey(familyName) && mIsUsingDefaultFont && Build.VERSION.SDK_INT < 21;
    }

    static {
        FONT_FAMILY_FILE_PREFIX.put("sans-serif", "Roboto-");
        FONT_FAMILY_FILE_PREFIX.put("sans-serif-light", "Roboto-Light");
        FONT_FAMILY_FILE_PREFIX.put("sans-serif-thin", "Roboto-Thin");
        FONT_FAMILY_FILE_PREFIX.put("sans-serif-condensed", "RobotoCondensed-");
        FONT_FAMILY_FILE_PREFIX.put("sans-serif-medium", "Roboto-Medium");
        FONT_FAMILY_FILE_PREFIX.put("sans-serif-black", "Roboto-Black");
        FONT_FAMILY_FILE_PREFIX.put("sans-serif-condensed-light", "RobotoCondensed-Light");
    }
}

