/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.picker.time;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.SpannableStringBuilder;
import android.text.format.DateUtils;
import android.text.style.TtsSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.CheckedTextView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.picker.DateFormatUtils;
import com.tr4android.support.extension.picker.PickerThemeUtils;
import com.tr4android.support.extension.picker.time.AppCompatTimePicker;
import com.tr4android.support.extension.picker.time.RadialTimePickerView;
import com.tr4android.support.extension.utils.ThemeUtils;
import com.tr4android.support.extension.utils.ViewCompatUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

class AppCompatTimePickerDelegate
extends AppCompatTimePicker.AbstractTimePickerDelegate
implements RadialTimePickerView.OnValueSelectedListener {
    private static final String TAG = "TimePickerClockDelegate";
    private static final int HOUR_INDEX = 0;
    private static final int MINUTE_INDEX = 1;
    private static final int AMPM_INDEX = 2;
    private static final int ENABLE_PICKER_INDEX = 3;
    static final int AM = 0;
    static final int PM = 1;
    private static final int HOURS_IN_HALF_DAY = 12;
    private final View mHeaderView;
    private final TextView mHourView;
    private final TextView mMinuteView;
    private final View mAmPmLayout;
    private final CheckedTextView mAmLabel;
    private final CheckedTextView mPmLabel;
    private final RadialTimePickerView mRadialTimePickerView;
    private final TextView mSeparatorView;
    private final String mAmText;
    private final String mPmText;
    private boolean mIsEnabled = true;
    private boolean mAllowAutoAdvance;
    private int mInitialHourOfDay;
    private int mInitialMinute;
    private boolean mIs24HourView;
    private boolean mIsAmPmAtStart;
    private char mPlaceholderText;
    private String mDoublePlaceholderText;
    private String mDeletedKeyFormat;
    private boolean mInKbMode;
    private ArrayList<Integer> mTypedTimes = new ArrayList();
    private Node mLegalTimesTree;
    private int mAmKeyCode;
    private int mPmKeyCode;
    private String mSelectHours;
    private String mSelectMinutes;
    private CharSequence mLastAnnouncedText;
    private boolean mLastAnnouncedIsHour;
    private Calendar mTempCalendar;
    private final View.OnClickListener mClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            int i = v.getId();
            if (i == R.id.am_label) {
                AppCompatTimePickerDelegate.this.setAmOrPm(0);
            } else if (i == R.id.pm_label) {
                AppCompatTimePickerDelegate.this.setAmOrPm(1);
            } else if (i == R.id.hours) {
                AppCompatTimePickerDelegate.this.setCurrentItemShowing(0, true, true);
            } else if (i == R.id.minutes) {
                AppCompatTimePickerDelegate.this.setCurrentItemShowing(1, true, true);
            } else {
                return;
            }
            AppCompatTimePickerDelegate.this.tryVibrate();
        }
    };
    private final View.OnKeyListener mKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (event.getAction() == 1) {
                return AppCompatTimePickerDelegate.this.processKeyUp(keyCode);
            }
            return false;
        }
    };
    private final View.OnFocusChangeListener mFocusListener = new View.OnFocusChangeListener(){

        public void onFocusChange(View v, boolean hasFocus) {
            if (!hasFocus && AppCompatTimePickerDelegate.this.mInKbMode && AppCompatTimePickerDelegate.this.isTypedTimeFullyLegal()) {
                AppCompatTimePickerDelegate.this.finishKbMode();
                if (AppCompatTimePickerDelegate.this.mOnTimeChangedListener != null) {
                    AppCompatTimePickerDelegate.this.mOnTimeChangedListener.onTimeChanged(AppCompatTimePickerDelegate.this.mDelegator, AppCompatTimePickerDelegate.this.mRadialTimePickerView.getCurrentHour(), AppCompatTimePickerDelegate.this.mRadialTimePickerView.getCurrentMinute());
                }
            }
        }
    };

    public AppCompatTimePickerDelegate(AppCompatTimePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(delegator, context);
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePickerDialog, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        Resources res = this.mContext.getResources();
        this.mSelectHours = res.getString(R.string.select_hours);
        this.mSelectMinutes = res.getString(R.string.select_minutes);
        String[] amPmStrings = AppCompatTimePickerDelegate.getAmPmStrings(context);
        this.mAmText = amPmStrings[0];
        this.mPmText = amPmStrings[1];
        View mainView = inflater.inflate(R.layout.time_picker_material, (ViewGroup)delegator);
        this.mHeaderView = mainView.findViewById(R.id.time_header);
        this.mHourView = (TextView)mainView.findViewById(R.id.hours);
        this.mHourView.setOnClickListener(this.mClickListener);
        ViewCompat.setAccessibilityDelegate((View)this.mHourView, (AccessibilityDelegateCompat)new ClickActionDelegate(context, R.string.select_hours));
        this.mSeparatorView = (TextView)mainView.findViewById(R.id.separator);
        this.mMinuteView = (TextView)mainView.findViewById(R.id.minutes);
        this.mMinuteView.setOnClickListener(this.mClickListener);
        ViewCompat.setAccessibilityDelegate((View)this.mMinuteView, (AccessibilityDelegateCompat)new ClickActionDelegate(context, R.string.select_minutes));
        this.mHourView.setMinWidth(this.computeStableWidth(this.mHourView, 24));
        this.mMinuteView.setMinWidth(this.computeStableWidth(this.mMinuteView, 60));
        this.mAmPmLayout = mainView.findViewById(R.id.ampm_layout);
        this.mAmLabel = (CheckedTextView)this.mAmPmLayout.findViewById(R.id.am_label);
        this.mAmLabel.setText(AppCompatTimePickerDelegate.obtainVerbatim(amPmStrings[0]));
        this.mAmLabel.setOnClickListener(this.mClickListener);
        this.mPmLabel = (CheckedTextView)this.mAmPmLayout.findViewById(R.id.pm_label);
        this.mPmLabel.setText(AppCompatTimePickerDelegate.obtainVerbatim(amPmStrings[1]));
        this.mPmLabel.setOnClickListener(this.mClickListener);
        ColorStateList headerTextColor = a.hasValue(R.styleable.TimePickerDialog_headerTextColor) ? a.getColorStateList(R.styleable.DatePickerDialog_headerTextColor) : PickerThemeUtils.getHeaderTextColorStateList(this.mContext);
        this.mHourView.setTextColor(headerTextColor);
        this.mSeparatorView.setTextColor(headerTextColor);
        this.mMinuteView.setTextColor(headerTextColor);
        this.mAmLabel.setTextColor(headerTextColor);
        this.mPmLabel.setTextColor(headerTextColor);
        ViewCompatUtils.setBackground(this.mHeaderView, PickerThemeUtils.getHeaderBackground(this.mContext, a.getColor(R.styleable.DatePickerDialog_headerBackground, ThemeUtils.getThemeAttrColor(this.mContext, R.attr.colorAccent))));
        a.recycle();
        this.mRadialTimePickerView = (RadialTimePickerView)mainView.findViewById(R.id.radial_picker);
        this.setupListeners();
        this.mAllowAutoAdvance = true;
        this.mDoublePlaceholderText = res.getString(R.string.time_placeholder);
        this.mDeletedKeyFormat = res.getString(R.string.deleted_key);
        this.mPlaceholderText = this.mDoublePlaceholderText.charAt(0);
        this.mPmKeyCode = -1;
        this.mAmKeyCode = -1;
        this.generateLegalTimesTree();
        Calendar calendar = Calendar.getInstance(this.mCurrentLocale);
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        this.initialize(currentHour, currentMinute, false, 0);
    }

    private static final CharSequence obtainVerbatim(String text) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new SpannableStringBuilder().append((CharSequence)text, (Object)new TtsSpan.VerbatimBuilder(text).build(), 0);
        }
        return text;
    }

    private int computeStableWidth(TextView v, int maxNumber) {
        int maxWidth = 0;
        for (int i = 0; i < maxNumber; ++i) {
            String text = String.format("%02d", i);
            v.setText((CharSequence)text);
            v.measure(0, 0);
            int width = v.getMeasuredWidth();
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    private void initialize(int hourOfDay, int minute, boolean is24HourView, int index) {
        this.mInitialHourOfDay = hourOfDay;
        this.mInitialMinute = minute;
        this.mIs24HourView = is24HourView;
        this.mInKbMode = false;
        this.updateUI(index);
    }

    private void setupListeners() {
        this.mHeaderView.setOnKeyListener(this.mKeyListener);
        this.mHeaderView.setOnFocusChangeListener(this.mFocusListener);
        this.mHeaderView.setFocusable(true);
        this.mRadialTimePickerView.setOnValueSelectedListener(this);
    }

    private void updateUI(int index) {
        this.updateRadialPicker(index);
        this.updateHeaderAmPm();
        this.updateHeaderHour(this.mInitialHourOfDay, false);
        this.updateHeaderSeparator();
        this.updateHeaderMinute(this.mInitialMinute, false);
        this.mDelegator.invalidate();
    }

    private void updateRadialPicker(int index) {
        this.mRadialTimePickerView.initialize(this.mInitialHourOfDay, this.mInitialMinute, this.mIs24HourView);
        this.setCurrentItemShowing(index, false, true);
    }

    private void updateHeaderAmPm() {
        if (this.mIs24HourView) {
            this.mAmPmLayout.setVisibility(8);
        } else {
            String dateTimePattern = DateFormatUtils.getBestDateTimePattern(this.mCurrentLocale, "hm");
            boolean isAmPmAtStart = dateTimePattern.startsWith("a");
            this.setAmPmAtStart(isAmPmAtStart);
            this.updateAmPmLabelStates(this.mInitialHourOfDay < 12 ? 0 : 1);
        }
    }

    private void setAmPmAtStart(boolean isAmPmAtStart) {
        if (this.mIsAmPmAtStart != isAmPmAtStart) {
            this.mIsAmPmAtStart = isAmPmAtStart;
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mAmPmLayout.getLayoutParams();
            if (ViewCompatUtils.getRule(params, 1) != 0 || ViewCompatUtils.getRule(params, 0) != 0) {
                if (isAmPmAtStart) {
                    this.mAmPmLayout.setPadding(0, 0, this.mAmPmLayout.getPaddingLeft(), 0);
                    ViewCompatUtils.removeRule(params, 1);
                    params.addRule(0, this.mHourView.getId());
                } else {
                    this.mAmPmLayout.setPadding(this.mAmPmLayout.getPaddingLeft(), 0, 0, 0);
                    ViewCompatUtils.removeRule(params, 0);
                    params.addRule(1, this.mMinuteView.getId());
                }
            }
            this.mAmPmLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    @Override
    public void setCurrentHour(int currentHour) {
        if (this.mInitialHourOfDay == currentHour) {
            return;
        }
        this.mInitialHourOfDay = currentHour;
        this.updateHeaderHour(currentHour, true);
        this.updateHeaderAmPm();
        this.mRadialTimePickerView.setCurrentHour(currentHour);
        this.mRadialTimePickerView.setAmOrPm(this.mInitialHourOfDay < 12 ? 0 : 1);
        this.mDelegator.invalidate();
        this.onTimeChanged();
    }

    @Override
    public int getCurrentHour() {
        int currentHour = this.mRadialTimePickerView.getCurrentHour();
        if (this.mIs24HourView) {
            return currentHour;
        }
        switch (this.mRadialTimePickerView.getAmOrPm()) {
            case 1: {
                return currentHour % 12 + 12;
            }
        }
        return currentHour % 12;
    }

    @Override
    public void setCurrentMinute(int currentMinute) {
        if (this.mInitialMinute == currentMinute) {
            return;
        }
        this.mInitialMinute = currentMinute;
        this.updateHeaderMinute(currentMinute, true);
        this.mRadialTimePickerView.setCurrentMinute(currentMinute);
        this.mDelegator.invalidate();
        this.onTimeChanged();
    }

    @Override
    public int getCurrentMinute() {
        return this.mRadialTimePickerView.getCurrentMinute();
    }

    @Override
    public void setIs24HourView(boolean is24HourView) {
        int hour;
        if (is24HourView == this.mIs24HourView) {
            return;
        }
        this.mIs24HourView = is24HourView;
        this.generateLegalTimesTree();
        this.mInitialHourOfDay = hour = this.mRadialTimePickerView.getCurrentHour();
        this.updateHeaderHour(hour, false);
        this.updateHeaderAmPm();
        this.updateRadialPicker(this.mRadialTimePickerView.getCurrentItemShowing());
        this.mDelegator.invalidate();
    }

    @Override
    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    @Override
    public void setOnTimeChangedListener(AppCompatTimePicker.OnTimeChangedListener callback) {
        this.mOnTimeChangedListener = callback;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mHourView.setEnabled(enabled);
        this.mMinuteView.setEnabled(enabled);
        this.mAmLabel.setEnabled(enabled);
        this.mPmLabel.setEnabled(enabled);
        this.mRadialTimePickerView.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @Override
    public int getBaseline() {
        return -1;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.updateUI(this.mRadialTimePickerView.getCurrentItemShowing());
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable superState) {
        return new SavedState(superState, this.getCurrentHour(), this.getCurrentMinute(), this.is24HourView(), this.inKbMode(), this.getTypedTimes(), this.getCurrentItemShowing());
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.setInKbMode(ss.inKbMode());
        this.setTypedTimes(ss.getTypesTimes());
        this.initialize(ss.getHour(), ss.getMinute(), ss.is24HourMode(), ss.getCurrentItemShowing());
        this.mRadialTimePickerView.invalidate();
        if (this.mInKbMode) {
            this.tryStartingKbMode(-1);
            this.mHourView.invalidate();
        }
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        super.setCurrentLocale(locale);
        this.mTempCalendar = Calendar.getInstance(locale);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 1;
        flags = this.mIs24HourView ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String selectedDate = DateUtils.formatDateTime((Context)this.mContext, (long)this.mTempCalendar.getTimeInMillis(), (int)flags);
        event.getText().add(selectedDate);
    }

    private void setInKbMode(boolean inKbMode) {
        this.mInKbMode = inKbMode;
    }

    private boolean inKbMode() {
        return this.mInKbMode;
    }

    private void setTypedTimes(ArrayList<Integer> typeTimes) {
        this.mTypedTimes = typeTimes;
    }

    private ArrayList<Integer> getTypedTimes() {
        return this.mTypedTimes;
    }

    private int getCurrentItemShowing() {
        return this.mRadialTimePickerView.getCurrentItemShowing();
    }

    private void onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    private void tryVibrate() {
        this.mDelegator.performHapticFeedback(4);
    }

    private void updateAmPmLabelStates(int amOrPm) {
        boolean isAm = amOrPm == 0;
        this.mAmLabel.setSelected(isAm);
        this.mAmLabel.setChecked(isAm);
        boolean isPm = amOrPm == 1;
        this.mPmLabel.setSelected(isPm);
        this.mPmLabel.setChecked(isPm);
    }

    @Override
    public void onValueSelected(int pickerIndex, int newValue, boolean autoAdvance) {
        switch (pickerIndex) {
            case 0: {
                if (this.mAllowAutoAdvance && autoAdvance) {
                    this.updateHeaderHour(newValue, false);
                    this.setCurrentItemShowing(1, true, false);
                    ViewCompatUtils.announceForAccessibility((View)this.mDelegator, newValue + ". " + this.mSelectMinutes);
                    break;
                }
                this.updateHeaderHour(newValue, true);
                break;
            }
            case 1: {
                this.updateHeaderMinute(newValue, true);
                break;
            }
            case 2: {
                this.updateAmPmLabelStates(newValue);
                break;
            }
            case 3: {
                if (!this.isTypedTimeFullyLegal()) {
                    this.mTypedTimes.clear();
                }
                this.finishKbMode();
            }
        }
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    private void updateHeaderHour(int value, boolean announce) {
        String bestDateTimePattern = DateFormatUtils.getBestDateTimePattern(this.mCurrentLocale, this.mIs24HourView ? "Hm" : "hm");
        int lengthPattern = bestDateTimePattern.length();
        boolean hourWithTwoDigit = false;
        char hourFormat = '\u0000';
        for (int i = 0; i < lengthPattern; ++i) {
            char c = bestDateTimePattern.charAt(i);
            if (c != 'H' && c != 'h' && c != 'K' && c != 'k') continue;
            hourFormat = c;
            if (i + 1 >= lengthPattern || c != bestDateTimePattern.charAt(i + 1)) break;
            hourWithTwoDigit = true;
            break;
        }
        String format = hourWithTwoDigit ? "%02d" : "%d";
        if (this.mIs24HourView) {
            if (hourFormat == 'k' && value == 0) {
                value = 24;
            }
        } else {
            value = AppCompatTimePickerDelegate.modulo12(value, hourFormat == 'K');
        }
        String text = String.format(format, value);
        this.mHourView.setText((CharSequence)text);
        if (announce) {
            this.tryAnnounceForAccessibility(text, true);
        }
    }

    private void tryAnnounceForAccessibility(CharSequence text, boolean isHour) {
        if (this.mLastAnnouncedIsHour != isHour || !text.equals(this.mLastAnnouncedText)) {
            ViewCompatUtils.announceForAccessibility((View)this.mDelegator, text);
            this.mLastAnnouncedText = text;
            this.mLastAnnouncedIsHour = isHour;
        }
    }

    private static int modulo12(int n, boolean startWithZero) {
        int value = n % 12;
        if (value == 0 && !startWithZero) {
            value = 12;
        }
        return value;
    }

    private void updateHeaderSeparator() {
        String bestDateTimePattern = DateFormatUtils.getBestDateTimePattern(this.mCurrentLocale, this.mIs24HourView ? "Hm" : "hm");
        char[] hourFormats = new char[]{'H', 'h', 'K', 'k'};
        int hIndex = AppCompatTimePickerDelegate.lastIndexOfAny(bestDateTimePattern, hourFormats);
        String separatorText = hIndex == -1 ? ":" : Character.toString(bestDateTimePattern.charAt(hIndex + 1));
        this.mSeparatorView.setText((CharSequence)separatorText);
    }

    private static int lastIndexOfAny(String str, char[] any) {
        int lengthAny = any.length;
        if (lengthAny > 0) {
            for (int i = str.length() - 1; i >= 0; --i) {
                char c = str.charAt(i);
                for (int j = 0; j < lengthAny; ++j) {
                    if (c != any[j]) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private void updateHeaderMinute(int value, boolean announceForAccessibility) {
        if (value == 60) {
            value = 0;
        }
        String text = String.format(this.mCurrentLocale, "%02d", value);
        this.mMinuteView.setText((CharSequence)text);
        if (announceForAccessibility) {
            this.tryAnnounceForAccessibility(text, false);
        }
    }

    private void setCurrentItemShowing(int index, boolean animateCircle, boolean announce) {
        this.mRadialTimePickerView.setCurrentItemShowing(index, animateCircle);
        if (index == 0) {
            if (announce) {
                ViewCompatUtils.announceForAccessibility((View)this.mDelegator, this.mSelectHours);
            }
        } else if (announce) {
            ViewCompatUtils.announceForAccessibility((View)this.mDelegator, this.mSelectMinutes);
        }
        this.mHourView.setSelected(index == 0);
        this.mMinuteView.setSelected(index == 1);
    }

    private void setAmOrPm(int amOrPm) {
        this.updateAmPmLabelStates(amOrPm);
        this.mRadialTimePickerView.setAmOrPm(amOrPm);
    }

    private boolean processKeyUp(int keyCode) {
        if (keyCode == 67) {
            if (this.mInKbMode && !this.mTypedTimes.isEmpty()) {
                int deleted = this.deleteLastTypedKey();
                String deletedKeyStr = deleted == this.getAmOrPmKeyCode(0) ? this.mAmText : (deleted == this.getAmOrPmKeyCode(1) ? this.mPmText : String.format("%d", this.getValFromKeyCode(deleted)));
                ViewCompatUtils.announceForAccessibility((View)this.mDelegator, String.format(this.mDeletedKeyFormat, deletedKeyStr));
                this.updateDisplay(true);
            }
        } else if (keyCode == 7 || keyCode == 8 || keyCode == 9 || keyCode == 10 || keyCode == 11 || keyCode == 12 || keyCode == 13 || keyCode == 14 || keyCode == 15 || keyCode == 16 || !this.mIs24HourView && (keyCode == this.getAmOrPmKeyCode(0) || keyCode == this.getAmOrPmKeyCode(1))) {
            if (!this.mInKbMode) {
                if (this.mRadialTimePickerView == null) {
                    Log.e((String)TAG, (String)"Unable to initiate keyboard mode, TimePicker was null.");
                    return true;
                }
                this.mTypedTimes.clear();
                this.tryStartingKbMode(keyCode);
                return true;
            }
            if (this.addKeyIfLegal(keyCode)) {
                this.updateDisplay(false);
            }
            return true;
        }
        return false;
    }

    private void tryStartingKbMode(int keyCode) {
        if (keyCode == -1 || this.addKeyIfLegal(keyCode)) {
            this.mInKbMode = true;
            this.onValidationChanged(false);
            this.updateDisplay(false);
            this.mRadialTimePickerView.setInputEnabled(false);
        }
    }

    private boolean addKeyIfLegal(int keyCode) {
        if (this.mIs24HourView && this.mTypedTimes.size() == 4 || !this.mIs24HourView && this.isTypedTimeFullyLegal()) {
            return false;
        }
        this.mTypedTimes.add(keyCode);
        if (!this.isTypedTimeLegalSoFar()) {
            this.deleteLastTypedKey();
            return false;
        }
        int val = this.getValFromKeyCode(keyCode);
        ViewCompatUtils.announceForAccessibility((View)this.mDelegator, String.format("%d", val));
        if (this.isTypedTimeFullyLegal()) {
            if (!this.mIs24HourView && this.mTypedTimes.size() <= 3) {
                this.mTypedTimes.add(this.mTypedTimes.size() - 1, 7);
                this.mTypedTimes.add(this.mTypedTimes.size() - 1, 7);
            }
            this.onValidationChanged(true);
        }
        return true;
    }

    private boolean isTypedTimeLegalSoFar() {
        Node node = this.mLegalTimesTree;
        for (int keyCode : this.mTypedTimes) {
            if ((node = node.canReach(keyCode)) != null) continue;
            return false;
        }
        return true;
    }

    private boolean isTypedTimeFullyLegal() {
        if (this.mIs24HourView) {
            int[] values = this.getEnteredTime(null);
            return values[0] >= 0 && values[1] >= 0 && values[1] < 60;
        }
        return this.mTypedTimes.contains(this.getAmOrPmKeyCode(0)) || this.mTypedTimes.contains(this.getAmOrPmKeyCode(1));
    }

    private int deleteLastTypedKey() {
        int deleted = this.mTypedTimes.remove(this.mTypedTimes.size() - 1);
        if (!this.isTypedTimeFullyLegal()) {
            this.onValidationChanged(false);
        }
        return deleted;
    }

    private void finishKbMode() {
        this.mInKbMode = false;
        if (!this.mTypedTimes.isEmpty()) {
            int[] values = this.getEnteredTime(null);
            this.mRadialTimePickerView.setCurrentHour(values[0]);
            this.mRadialTimePickerView.setCurrentMinute(values[1]);
            if (!this.mIs24HourView) {
                this.mRadialTimePickerView.setAmOrPm(values[2]);
            }
            this.mTypedTimes.clear();
        }
        this.updateDisplay(false);
        this.mRadialTimePickerView.setInputEnabled(true);
    }

    private void updateDisplay(boolean allowEmptyDisplay) {
        if (!allowEmptyDisplay && this.mTypedTimes.isEmpty()) {
            int hour = this.mRadialTimePickerView.getCurrentHour();
            int minute = this.mRadialTimePickerView.getCurrentMinute();
            this.updateHeaderHour(hour, false);
            this.updateHeaderMinute(minute, false);
            if (!this.mIs24HourView) {
                this.updateAmPmLabelStates(hour < 12 ? 0 : 1);
            }
            this.setCurrentItemShowing(this.mRadialTimePickerView.getCurrentItemShowing(), true, true);
            this.onValidationChanged(true);
        } else {
            boolean[] enteredZeros = new boolean[]{false, false};
            int[] values = this.getEnteredTime(enteredZeros);
            String hourFormat = enteredZeros[0] ? "%02d" : "%2d";
            String minuteFormat = enteredZeros[1] ? "%02d" : "%2d";
            String hourStr = values[0] == -1 ? this.mDoublePlaceholderText : String.format(hourFormat, values[0]).replace(' ', this.mPlaceholderText);
            String minuteStr = values[1] == -1 ? this.mDoublePlaceholderText : String.format(minuteFormat, values[1]).replace(' ', this.mPlaceholderText);
            this.mHourView.setText((CharSequence)hourStr);
            this.mHourView.setSelected(false);
            this.mMinuteView.setText((CharSequence)minuteStr);
            this.mMinuteView.setSelected(false);
            if (!this.mIs24HourView) {
                this.updateAmPmLabelStates(values[2]);
            }
        }
    }

    private int getValFromKeyCode(int keyCode) {
        switch (keyCode) {
            case 7: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 5;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 7;
            }
            case 15: {
                return 8;
            }
            case 16: {
                return 9;
            }
        }
        return -1;
    }

    private int[] getEnteredTime(boolean[] enteredZeros) {
        int amOrPm = -1;
        int startIndex = 1;
        if (!this.mIs24HourView && this.isTypedTimeFullyLegal()) {
            int keyCode = this.mTypedTimes.get(this.mTypedTimes.size() - 1);
            if (keyCode == this.getAmOrPmKeyCode(0)) {
                amOrPm = 0;
            } else if (keyCode == this.getAmOrPmKeyCode(1)) {
                amOrPm = 1;
            }
            startIndex = 2;
        }
        int minute = -1;
        int hour = -1;
        for (int i = startIndex; i <= this.mTypedTimes.size(); ++i) {
            int val = this.getValFromKeyCode(this.mTypedTimes.get(this.mTypedTimes.size() - i));
            if (i == startIndex) {
                minute = val;
                continue;
            }
            if (i == startIndex + 1) {
                minute += 10 * val;
                if (enteredZeros == null || val != 0) continue;
                enteredZeros[1] = true;
                continue;
            }
            if (i == startIndex + 2) {
                hour = val;
                continue;
            }
            if (i != startIndex + 3) continue;
            hour += 10 * val;
            if (enteredZeros == null || val != 0) continue;
            enteredZeros[0] = true;
        }
        return new int[]{hour, minute, amOrPm};
    }

    private int getAmOrPmKeyCode(int amOrPm) {
        if (this.mAmKeyCode == -1 || this.mPmKeyCode == -1) {
            KeyCharacterMap kcm = KeyCharacterMap.load((int)-1);
            String amText = this.mAmText.toLowerCase(this.mCurrentLocale);
            String pmText = this.mPmText.toLowerCase(this.mCurrentLocale);
            int N = Math.min(amText.length(), pmText.length());
            for (int i = 0; i < N; ++i) {
                char pmChar;
                char amChar = amText.charAt(i);
                if (amChar == (pmChar = pmText.charAt(i))) continue;
                KeyEvent[] events = kcm.getEvents(new char[]{amChar, pmChar});
                if (events != null && events.length == 4) {
                    this.mAmKeyCode = events[0].getKeyCode();
                    this.mPmKeyCode = events[2].getKeyCode();
                    break;
                }
                Log.e((String)TAG, (String)"Unable to find keycodes for AM and PM.");
                break;
            }
        }
        if (amOrPm == 0) {
            return this.mAmKeyCode;
        }
        if (amOrPm == 1) {
            return this.mPmKeyCode;
        }
        return -1;
    }

    private void generateLegalTimesTree() {
        int k0 = 7;
        int k1 = 8;
        int k2 = 9;
        int k3 = 10;
        int k4 = 11;
        int k5 = 12;
        int k6 = 13;
        int k7 = 14;
        int k8 = 15;
        int k9 = 16;
        this.mLegalTimesTree = new Node(new int[0]);
        if (this.mIs24HourView) {
            Node minuteFirstDigit = new Node(7, 8, 9, 10, 11, 12);
            Node minuteSecondDigit = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            minuteFirstDigit.addChild(minuteSecondDigit);
            Node firstDigit = new Node(7, 8);
            this.mLegalTimesTree.addChild(firstDigit);
            Node secondDigit = new Node(7, 8, 9, 10, 11, 12);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            Node thirdDigit = new Node(13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            secondDigit = new Node(13, 14, 15, 16);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            firstDigit = new Node(9);
            this.mLegalTimesTree.addChild(firstDigit);
            secondDigit = new Node(7, 8, 9, 10);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            secondDigit = new Node(11, 12);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteSecondDigit);
            firstDigit = new Node(10, 11, 12, 13, 14, 15, 16);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(minuteFirstDigit);
        } else {
            Node ampm = new Node(this.getAmOrPmKeyCode(0), this.getAmOrPmKeyCode(1));
            Node firstDigit = new Node(8);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            Node secondDigit = new Node(7, 8, 9);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(ampm);
            Node thirdDigit = new Node(7, 8, 9, 10, 11, 12);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            Node fourthDigit = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            thirdDigit.addChild(fourthDigit);
            fourthDigit.addChild(ampm);
            thirdDigit = new Node(13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            secondDigit = new Node(10, 11, 12);
            firstDigit.addChild(secondDigit);
            thirdDigit = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            firstDigit = new Node(9, 10, 11, 12, 13, 14, 15, 16);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            secondDigit = new Node(7, 8, 9, 10, 11, 12);
            firstDigit.addChild(secondDigit);
            thirdDigit = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
        }
    }

    public static String[] getAmPmStrings(Context context) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("a", context.getResources().getConfiguration().locale);
        String[] result = new String[2];
        calendar.set(9, 0);
        result[0] = formatter.format(calendar.getTime());
        calendar.set(9, 1);
        result[1] = formatter.format(calendar.getTime());
        return result;
    }

    private class Node {
        private int[] mLegalKeys;
        private ArrayList<Node> mChildren;

        public Node(int ... legalKeys) {
            this.mLegalKeys = legalKeys;
            this.mChildren = new ArrayList();
        }

        public void addChild(Node child) {
            this.mChildren.add(child);
        }

        public boolean containsKey(int key) {
            for (int i = 0; i < this.mLegalKeys.length; ++i) {
                if (this.mLegalKeys[i] != key) continue;
                return true;
            }
            return false;
        }

        public Node canReach(int key) {
            if (this.mChildren == null) {
                return null;
            }
            for (Node child : this.mChildren) {
                if (!child.containsKey(key)) continue;
                return child;
            }
            return null;
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mHour;
        private final int mMinute;
        private final boolean mIs24HourMode;
        private final boolean mInKbMode;
        private final ArrayList<Integer> mTypedTimes;
        private final int mCurrentItemShowing;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int hour, int minute, boolean is24HourMode, boolean isKbMode, ArrayList<Integer> typedTimes, int currentItemShowing) {
            super(superState);
            this.mHour = hour;
            this.mMinute = minute;
            this.mIs24HourMode = is24HourMode;
            this.mInKbMode = isKbMode;
            this.mTypedTimes = typedTimes;
            this.mCurrentItemShowing = currentItemShowing;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
            this.mIs24HourMode = in.readInt() == 1;
            this.mInKbMode = in.readInt() == 1;
            this.mTypedTimes = in.readArrayList(((Object)((Object)this)).getClass().getClassLoader());
            this.mCurrentItemShowing = in.readInt();
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        public boolean is24HourMode() {
            return this.mIs24HourMode;
        }

        public boolean inKbMode() {
            return this.mInKbMode;
        }

        public ArrayList<Integer> getTypesTimes() {
            return this.mTypedTimes;
        }

        public int getCurrentItemShowing() {
            return this.mCurrentItemShowing;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
            dest.writeInt(this.mIs24HourMode ? 1 : 0);
            dest.writeInt(this.mInKbMode ? 1 : 0);
            dest.writeList(this.mTypedTimes);
            dest.writeInt(this.mCurrentItemShowing);
        }
    }

    private static class ClickActionDelegate
    extends AccessibilityDelegateCompat {
        private final AccessibilityNodeInfoCompat.AccessibilityActionCompat mClickAction;

        public ClickActionDelegate(Context context, int resId) {
            this.mClickAction = new AccessibilityNodeInfoCompat.AccessibilityActionCompat(16, (CharSequence)context.getString(resId));
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.addAction(this.mClickAction);
        }
    }
}

