/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.picker.time;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import com.tr4android.support.extension.picker.time.AppCompatTimePickerDelegate;
import java.util.Locale;

public class AppCompatTimePicker
extends FrameLayout {
    private static final int MODE_SPINNER = 1;
    private static final int MODE_CLOCK = 2;
    private final TimePickerDelegate mDelegate;

    public AppCompatTimePicker(Context context) {
        this(context, null);
    }

    public AppCompatTimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AppCompatTimePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mDelegate = new AppCompatTimePickerDelegate(this, context, attrs, defStyleAttr, 0);
    }

    public void setHour(int hour) {
        this.mDelegate.setCurrentHour(hour);
    }

    public int getHour() {
        return this.mDelegate.getCurrentHour();
    }

    public void setMinute(int minute) {
        this.mDelegate.setCurrentMinute(minute);
    }

    public int getMinute() {
        return this.mDelegate.getCurrentMinute();
    }

    @Deprecated
    public void setCurrentHour(@NonNull Integer currentHour) {
        this.setHour(currentHour);
    }

    @Deprecated
    @NonNull
    public Integer getCurrentHour() {
        return this.mDelegate.getCurrentHour();
    }

    @Deprecated
    public void setCurrentMinute(@NonNull Integer currentMinute) {
        this.mDelegate.setCurrentMinute(currentMinute);
    }

    @Deprecated
    @NonNull
    public Integer getCurrentMinute() {
        return this.mDelegate.getCurrentMinute();
    }

    public void setIs24HourView(@NonNull Boolean is24HourView) {
        if (is24HourView == null) {
            return;
        }
        this.mDelegate.setIs24HourView(is24HourView);
    }

    public boolean is24HourView() {
        return this.mDelegate.is24HourView();
    }

    public void setOnTimeChangedListener(OnTimeChangedListener onTimeChangedListener) {
        this.mDelegate.setOnTimeChangedListener(onTimeChangedListener);
    }

    public void setValidationCallback(@Nullable ValidationCallback callback) {
        this.mDelegate.setValidationCallback(callback);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mDelegate.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.mDelegate.isEnabled();
    }

    public int getBaseline() {
        return this.mDelegate.getBaseline();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDelegate.onConfigurationChanged(newConfig);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return this.mDelegate.onSaveInstanceState(superState);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState ss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mDelegate.onRestoreInstanceState((Parcelable)ss);
    }

    public CharSequence getAccessibilityClassName() {
        return AppCompatTimePicker.class.getName();
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return this.mDelegate.dispatchPopulateAccessibilityEvent(event);
    }

    static abstract class AbstractTimePickerDelegate
    implements TimePickerDelegate {
        protected AppCompatTimePicker mDelegator;
        protected Context mContext;
        protected Locale mCurrentLocale;
        protected OnTimeChangedListener mOnTimeChangedListener;
        protected ValidationCallback mValidationCallback;

        public AbstractTimePickerDelegate(AppCompatTimePicker delegator, Context context) {
            this.mDelegator = delegator;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
        }

        public void setCurrentLocale(Locale locale) {
            if (locale.equals(this.mCurrentLocale)) {
                return;
            }
            this.mCurrentLocale = locale;
        }

        @Override
        public void setValidationCallback(ValidationCallback callback) {
            this.mValidationCallback = callback;
        }

        protected void onValidationChanged(boolean valid) {
            if (this.mValidationCallback != null) {
                this.mValidationCallback.onValidationChanged(valid);
            }
        }
    }

    public static interface ValidationCallback {
        public void onValidationChanged(boolean var1);
    }

    static interface TimePickerDelegate {
        public void setCurrentHour(int var1);

        public int getCurrentHour();

        public void setCurrentMinute(int var1);

        public int getCurrentMinute();

        public void setIs24HourView(boolean var1);

        public boolean is24HourView();

        public void setOnTimeChangedListener(OnTimeChangedListener var1);

        public void setValidationCallback(ValidationCallback var1);

        public void setEnabled(boolean var1);

        public boolean isEnabled();

        public int getBaseline();

        public void onConfigurationChanged(Configuration var1);

        public Parcelable onSaveInstanceState(Parcelable var1);

        public void onRestoreInstanceState(Parcelable var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public void onPopulateAccessibilityEvent(AccessibilityEvent var1);
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(AppCompatTimePicker var1, int var2, int var3);
    }
}

