/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.picker.date;

import android.content.Context;
import android.content.res.Resources;
import android.support.v4.view.accessibility.AccessibilityEventCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.TextView;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.utils.ViewCompatUtils;
import java.util.Calendar;

class YearPickerView
extends RecyclerView
implements View.OnClickListener {
    private final YearAdapter mAdapter;
    private final int mChildSize;
    private OnYearSelectedListener mOnYearSelectedListener;
    private long mCurrentTimeMillis;

    public YearPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YearPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        RecyclerView.LayoutParams frame = new RecyclerView.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)frame);
        Resources res = context.getResources();
        this.mChildSize = res.getDimensionPixelOffset(R.dimen.datepicker_year_label_height);
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mAdapter = new YearAdapter(this.getContext(), this);
        this.setAdapter(this.mAdapter);
    }

    public void onClick(View view) {
        int position = this.getChildAdapterPosition(view);
        if (position == -1) {
            return;
        }
        int year = this.mAdapter.getYearForPosition(position);
        this.mAdapter.setSelection(year);
        if (this.mOnYearSelectedListener != null) {
            this.mOnYearSelectedListener.onYearChanged(this, year);
        }
    }

    public void setOnYearSelectedListener(OnYearSelectedListener listener) {
        this.mOnYearSelectedListener = listener;
    }

    public void setDate(long currentTimeMillis) {
        this.mCurrentTimeMillis = currentTimeMillis;
    }

    public void setYear(final int year) {
        this.mAdapter.setSelection(year);
        this.post(new Runnable(){

            @Override
            public void run() {
                int position = YearPickerView.this.mAdapter.getPositionForYear(year);
                if (position >= 0 && position < YearPickerView.this.mAdapter.getItemCount()) {
                    YearPickerView.this.setSelectionCentered(position);
                }
            }
        });
    }

    public void setSelectionCentered(int position) {
        int offset = this.getMeasuredHeight() / 2 - this.mChildSize / 2;
        this.setSelectionFromTop(position, offset);
    }

    public void setRange(Calendar min, Calendar max) {
        this.mAdapter.setRange(min, max);
    }

    public void setSelectionFromTop(int position, int offset) {
        ((LinearLayoutManager)this.getLayoutManager()).scrollToPositionWithOffset(position, offset);
    }

    public int getFirstVisiblePosition() {
        return ((LinearLayoutManager)this.getLayoutManager()).findFirstVisibleItemPosition();
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 4096) {
            AccessibilityEventCompat.asRecord((AccessibilityEvent)event).setFromIndex(0);
            AccessibilityEventCompat.asRecord((AccessibilityEvent)event).setToIndex(0);
        }
    }

    public static interface OnYearSelectedListener {
        public void onYearChanged(YearPickerView var1, int var2);
    }

    private static class YearAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private static final int ITEM_LAYOUT = R.layout.year_label_text_view;
        private static final int ITEM_TEXT_APPEARANCE = R.style.TextAppearance_Material_DatePicker_List_YearLabel;
        private static final int ITEM_TEXT_SELECTED_APPEARANCE = R.style.TextAppearance_Material_DatePicker_List_YearLabel_Selected;
        private static final int ITEM_IS_SELECTED = R.id.date_picker_year_item_is_selected;
        private final LayoutInflater mInflater;
        private final View.OnClickListener mListener;
        private int mSelectedYear;
        private int mMinYear;
        private int mCount;

        public YearAdapter(Context context, View.OnClickListener listener) {
            this.mInflater = LayoutInflater.from((Context)context);
            this.mListener = listener;
        }

        public void setRange(Calendar minDate, Calendar maxDate) {
            int minYear = minDate.get(1);
            int count = maxDate.get(1) - minYear + 1;
            if (this.mMinYear != minYear || this.mCount != count) {
                this.mMinYear = minYear;
                this.mCount = count;
                this.notifyDataSetChanged();
            }
        }

        public boolean setSelection(int year) {
            if (this.mSelectedYear != year) {
                this.mSelectedYear = year;
                this.notifyDataSetChanged();
                return true;
            }
            return false;
        }

        public int getItemCount() {
            return this.mCount;
        }

        public long getItemId(int position) {
            return this.getYearForPosition(position);
        }

        public int getPositionForYear(int year) {
            return year - this.mMinYear;
        }

        public int getYearForPosition(int position) {
            return this.mMinYear + position;
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new ViewHolder(this.mInflater.inflate(ITEM_LAYOUT, parent, false));
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            int year = this.getYearForPosition(position);
            boolean selected = this.mSelectedYear == year;
            Object tag = holder.mYearView.getTag(ITEM_IS_SELECTED);
            if (tag == null || (Boolean)tag != selected) {
                int textAppearanceResId = selected && ITEM_TEXT_SELECTED_APPEARANCE != 0 ? ITEM_TEXT_SELECTED_APPEARANCE : ITEM_TEXT_APPEARANCE;
                ViewCompatUtils.setTextAppearance(holder.mYearView, textAppearanceResId);
                holder.mYearView.setTag(ITEM_IS_SELECTED, (Object)selected);
            }
            holder.mYearView.setText((CharSequence)Integer.toString(year));
            holder.mYearView.setOnClickListener(this.mListener);
        }

        public static class ViewHolder
        extends RecyclerView.ViewHolder {
            public TextView mYearView;

            public ViewHolder(View itemView) {
                super(itemView);
                this.mYearView = (TextView)itemView;
            }
        }
    }
}

