/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.picker.date;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.picker.date.AppCompatDatePicker;

public class AppCompatDatePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
AppCompatDatePicker.OnDateChangedListener {
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private final AppCompatDatePicker mDatePicker;
    private final OnDateSetListener mDateSetListener;
    private final AppCompatDatePicker.ValidationCallback mValidationCallback = new AppCompatDatePicker.ValidationCallback(){

        @Override
        public void onValidationChanged(boolean valid) {
            Button positive = AppCompatDatePickerDialog.this.getButton(-1);
            if (positive != null) {
                positive.setEnabled(valid);
            }
        }
    };

    public AppCompatDatePickerDialog(Context context, OnDateSetListener listener, int year, int monthOfYear, int dayOfMonth) {
        this(context, 0, listener, year, monthOfYear, dayOfMonth);
    }

    static int resolveDialogTheme(Context context, int resid) {
        if (resid == 0) {
            TypedValue outValue = new TypedValue();
            context.getTheme().resolveAttribute(R.attr.datePickerDialogTheme, outValue, true);
            return outValue.resourceId;
        }
        return resid;
    }

    public AppCompatDatePickerDialog(Context context, int theme, OnDateSetListener listener, int year, int monthOfYear, int dayOfMonth) {
        super(context, AppCompatDatePickerDialog.resolveDialogTheme(context, theme));
        this.mDateSetListener = listener;
        Context themeContext = this.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)themeContext);
        View view = inflater.inflate(R.layout.date_picker_dialog, null);
        this.setView(view);
        this.setButton(-1, themeContext.getString(17039370), this);
        this.setButton(-2, themeContext.getString(0x1040000), this);
        this.mDatePicker = (AppCompatDatePicker)view.findViewById(R.id.datePicker);
        this.mDatePicker.init(year, monthOfYear, dayOfMonth, this);
        this.mDatePicker.setValidationCallback(this.mValidationCallback);
    }

    @Override
    public void onDateChanged(AppCompatDatePicker view, int year, int month, int day) {
        this.mDatePicker.init(year, month, day, this);
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                if (this.mDateSetListener == null) break;
                this.mDatePicker.clearFocus();
                this.mDateSetListener.onDateSet(this.mDatePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth());
                break;
            }
            case -2: {
                this.cancel();
            }
        }
    }

    public AppCompatDatePicker getDatePicker() {
        return this.mDatePicker;
    }

    public void updateDate(int year, int monthOfYear, int dayOfMonth) {
        this.mDatePicker.updateDate(year, monthOfYear, dayOfMonth);
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(YEAR, this.mDatePicker.getYear());
        state.putInt(MONTH, this.mDatePicker.getMonth());
        state.putInt(DAY, this.mDatePicker.getDayOfMonth());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int year = savedInstanceState.getInt(YEAR);
        int month = savedInstanceState.getInt(MONTH);
        int day = savedInstanceState.getInt(DAY);
        this.mDatePicker.init(year, month, day, this);
    }

    public static interface OnDateSetListener {
        public void onDateSet(AppCompatDatePicker var1, int var2, int var3, int var4);
    }
}

