/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.drawable;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;

public class RoundRectDrawable
extends Drawable {
    private boolean mHasJellybeanMr1 = Build.VERSION.SDK_INT >= 17;
    private float mRadius;
    private final Paint mPaint;
    private ColorStateList mTint;
    private final RectF mCornerRect;
    private final RectF mBoundsF;
    private final Rect mBoundsI;
    private float mPadding;

    public RoundRectDrawable(int backgroundColor, float radius) {
        this.mRadius = radius;
        if (this.mHasJellybeanMr1 && this.mRadius >= 1.0f) {
            this.mRadius += 0.5f;
        }
        this.mPaint = new Paint(5);
        this.mPaint.setColor(backgroundColor);
        this.mCornerRect = new RectF();
        this.mBoundsF = new RectF();
        this.mBoundsI = new Rect();
    }

    public void setPadding(float padding) {
        if (padding == this.mPadding) {
            return;
        }
        this.mPadding = padding;
        this.updateBounds(null);
        this.invalidateSelf();
    }

    public float getPadding() {
        return this.mPadding;
    }

    public void draw(Canvas canvas) {
        if (this.mHasJellybeanMr1) {
            canvas.drawRoundRect(this.mBoundsF, this.mRadius, this.mRadius, this.mPaint);
        } else {
            this.drawRoundRectPath(canvas, this.mPaint);
        }
    }

    private void drawRoundRectPath(Canvas canvas, Paint paint) {
        float twoRadius = this.mRadius * 2.0f;
        float innerWidth = this.mBoundsF.width() - twoRadius - 1.0f;
        float innerHeight = this.mBoundsF.height() - twoRadius - 1.0f;
        if (this.mRadius >= 1.0f) {
            this.mCornerRect.set(-this.mRadius, -this.mRadius, this.mRadius, this.mRadius);
            int saved = canvas.save();
            canvas.translate(this.mBoundsF.left + this.mRadius, this.mBoundsF.top + this.mRadius);
            canvas.drawArc(this.mCornerRect, 180.0f, 90.0f, true, paint);
            canvas.translate(innerWidth, 0.0f);
            canvas.rotate(90.0f);
            canvas.drawArc(this.mCornerRect, 180.0f, 90.0f, true, paint);
            canvas.translate(innerHeight, 0.0f);
            canvas.rotate(90.0f);
            canvas.drawArc(this.mCornerRect, 180.0f, 90.0f, true, paint);
            canvas.translate(innerWidth, 0.0f);
            canvas.rotate(90.0f);
            canvas.drawArc(this.mCornerRect, 180.0f, 90.0f, true, paint);
            canvas.restoreToCount(saved);
            canvas.drawRect(this.mBoundsF.left + this.mRadius - 1.0f, this.mBoundsF.top, this.mBoundsF.right - this.mRadius + 1.0f, this.mBoundsF.top + this.mRadius, paint);
            canvas.drawRect(this.mBoundsF.left + this.mRadius - 1.0f, this.mBoundsF.bottom - this.mRadius + 1.0f, this.mBoundsF.right - this.mRadius + 1.0f, this.mBoundsF.bottom, paint);
        }
        canvas.drawRect(this.mBoundsF.left, this.mBoundsF.top + Math.max(0.0f, this.mRadius - 1.0f), this.mBoundsF.right, this.mBoundsF.bottom - this.mRadius + 1.0f, paint);
    }

    private void updateBounds(Rect bounds) {
        if (bounds == null) {
            bounds = this.getBounds();
        }
        this.mBoundsF.set((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom);
        this.mBoundsI.set(bounds);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updateBounds(bounds);
    }

    @TargetApi(value=21)
    public void getOutline(Outline outline) {
        outline.setRoundRect(this.mBoundsI, this.mRadius);
    }

    public void setRadius(float radius) {
        if (radius == this.mRadius) {
            return;
        }
        this.mRadius = radius;
        this.updateBounds(null);
        this.invalidateSelf();
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public float getRadius() {
        return this.mRadius;
    }

    public void setRoundRectTint(int color) {
        this.mPaint.setColor(color);
        this.invalidateSelf();
    }

    public void setRoundRectTintList(ColorStateList tint) {
        this.mTint = tint;
        if (this.mTint != null) {
            this.mPaint.setColor(this.mTint.getColorForState(this.getState(), this.mPaint.getColor()));
        }
        this.invalidateSelf();
    }

    protected boolean onStateChange(int[] stateSet) {
        int currentColor;
        int newColor;
        if (this.mTint != null && (newColor = this.mTint.getColorForState(stateSet, currentColor = this.mPaint.getColor())) != currentColor) {
            this.mPaint.setColor(newColor);
            return true;
        }
        return false;
    }

    public boolean isStateful() {
        return this.mTint != null && this.mTint.isStateful() || super.isStateful();
    }
}

