/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.drawable;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import com.tr4android.support.extension.animation.AnimationUtils;
import com.tr4android.support.extension.animation.ValueAnimatorCompat;

public class RotationTransitionDrawable
extends LayerDrawable {
    private float mRotation;
    private float mMaxRotation;
    private boolean mHasSecondDrawable;
    private ValueAnimatorCompat mAnimator;
    private Interpolator mStartInterpolator;
    private Interpolator mReverseInterpolator;

    public RotationTransitionDrawable(Drawable drawable) {
        this(drawable, null);
    }

    public RotationTransitionDrawable(Drawable drawable, Drawable closeDrawable) {
        Drawable[] drawableArray;
        if (closeDrawable == null) {
            Drawable[] drawableArray2 = new Drawable[1];
            drawableArray = drawableArray2;
            drawableArray2[0] = drawable;
        } else {
            Drawable[] drawableArray3 = new Drawable[2];
            drawableArray3[0] = drawable;
            drawableArray = drawableArray3;
            drawableArray3[1] = closeDrawable;
        }
        super(drawableArray);
        this.mStartInterpolator = new OvershootInterpolator();
        this.mReverseInterpolator = new AnticipateInterpolator();
        this.mHasSecondDrawable = closeDrawable != null;
        this.mAnimator = AnimationUtils.createAnimator();
        this.mAnimator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimatorCompat animator) {
                RotationTransitionDrawable.this.setRotation(animator.getAnimatedFloatValue());
            }
        });
    }

    public void draw(Canvas canvas) {
        canvas.save();
        if (this.mHasSecondDrawable) {
            int alpha = Math.min(Math.max(0, Math.round(this.mRotation / this.mMaxRotation * 255.0f)), 255);
            canvas.rotate(this.mRotation, (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            this.getDrawable(0).setAlpha(255 - alpha);
            this.getDrawable(0).draw(canvas);
            canvas.rotate(-this.mMaxRotation, (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            this.getDrawable(1).setAlpha(alpha);
            this.getDrawable(1).draw(canvas);
        } else {
            canvas.rotate(this.mRotation, (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            super.draw(canvas);
        }
        canvas.restore();
    }

    public Interpolator getStartInterpolator() {
        return this.mStartInterpolator;
    }

    public void setStartInterpolator(Interpolator interpolator) {
        this.mStartInterpolator = interpolator;
    }

    public Interpolator getReverseInterpolator() {
        return this.mReverseInterpolator;
    }

    public void setReverseInterpolator(Interpolator interpolator) {
        this.mReverseInterpolator = interpolator;
    }

    public float getRotation() {
        return this.mRotation;
    }

    public void setRotation(float rotation) {
        this.mRotation = rotation;
        this.invalidateSelf();
    }

    public float getMaxRotation() {
        return this.mMaxRotation;
    }

    public void setMaxRotation(float rotation) {
        this.mMaxRotation = rotation;
    }

    public void startTransition(int duration) {
        this.mAnimator.cancel();
        this.mAnimator.setFloatValues(this.mRotation, this.mMaxRotation);
        this.mAnimator.setDuration(duration);
        this.mAnimator.setInterpolator(this.mStartInterpolator);
        this.mAnimator.start();
    }

    public void reverseTransition(int duration) {
        this.mAnimator.cancel();
        this.mAnimator.setFloatValues(this.mRotation, 0.0f);
        this.mAnimator.setDuration(duration);
        this.mAnimator.setInterpolator(this.mReverseInterpolator);
        this.mAnimator.start();
    }
}

