/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.drawable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.view.animation.Interpolator;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.animation.AnimationUtils;
import com.tr4android.support.extension.animation.ValueAnimatorCompat;
import com.tr4android.support.extension.utils.ThemeUtils;

public class IndeterminateProgressDrawable
extends Drawable
implements Animatable {
    private static final String TAG = "Indeterminate Progress";
    private static final Interpolator PATH_START_INTERPOLATOR;
    private static final Interpolator PATH_END_INTERPOLATOR;
    private Paint mArcPaint = new Paint(1);
    private float mArcStrokeWidth = -1.0f;
    private float mArcPadding = -1.0f;
    private RectF mArcRect = new RectF();
    private int mRotationCount = 0;
    private float mRotation;
    private float mOffset;
    private float mStart;
    private float mEnd;
    private ValueAnimatorCompat mAnimator;

    public IndeterminateProgressDrawable(Context context, @ColorInt int color, float stroke, float padding) {
        this.mArcStrokeWidth = stroke;
        this.mArcPadding = padding;
        this.mArcPaint.setStyle(Paint.Style.STROKE);
        this.mArcPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.mArcPaint.setStrokeJoin(Paint.Join.MITER);
        this.mArcPaint.setColor(color);
        this.mAnimator = AnimationUtils.createAnimator();
        this.mAnimator.setFloatValues(0.0f, 0.25f);
        this.mAnimator.setDuration(1333);
        this.mAnimator.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        this.mAnimator.setRepeatCount(-1);
        this.mAnimator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimatorCompat animator) {
                IndeterminateProgressDrawable.this.mOffset = animator.getAnimatedFloatValue();
                float fraction = animator.getAnimatedFraction();
                IndeterminateProgressDrawable.this.mStart = PATH_START_INTERPOLATOR.getInterpolation(fraction) * 0.75f;
                IndeterminateProgressDrawable.this.mEnd = PATH_END_INTERPOLATOR.getInterpolation(fraction) * 0.75f;
                IndeterminateProgressDrawable.this.mRotation = (float)(IndeterminateProgressDrawable.this.mRotationCount * 144) + IndeterminateProgressDrawable.this.mOffset * 576.0f;
                IndeterminateProgressDrawable.this.invalidateSelf();
            }
        });
        this.mAnimator.setListener(new ValueAnimatorCompat.AnimatorListener(){

            @Override
            public void onAnimationStart(ValueAnimatorCompat animator) {
            }

            @Override
            public void onAnimationEnd(ValueAnimatorCompat animator) {
            }

            @Override
            public void onAnimationCancel(ValueAnimatorCompat animator) {
            }

            @Override
            public void onAnimationRepeat(ValueAnimatorCompat animator) {
                IndeterminateProgressDrawable.this.mRotationCount = (IndeterminateProgressDrawable.this.mRotationCount + 1) % 5;
            }
        });
    }

    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        canvas.rotate(this.mRotation, this.mArcRect.centerX(), this.mArcRect.centerY());
        float startAngle = -90.0f + 360.0f * (this.mOffset + this.mStart);
        float sweepAngle = 360.0f * (this.mEnd - this.mStart);
        canvas.drawArc(this.mArcRect, startAngle, sweepAngle, false, this.mArcPaint);
        canvas.restoreToCount(saveCount);
    }

    public void setBounds(Rect bounds) {
        this.calculateArcMetrics(bounds);
        super.setBounds(bounds);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        this.calculateArcMetrics(new Rect(left, top, right, bottom));
        super.setBounds(left, top, right, bottom);
    }

    public void setAlpha(int i) {
        this.mArcPaint.setAlpha(i);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mArcPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public void start() {
        this.mAnimator.start();
    }

    public void stop() {
        this.mAnimator.cancel();
    }

    public boolean isRunning() {
        return this.mAnimator.isRunning();
    }

    private void calculateArcMetrics(Rect bounds) {
        float padding;
        float strokeWidth;
        float size = Math.min(bounds.height(), bounds.width());
        float yOffset = ((float)bounds.height() - size) / 2.0f;
        float xOffset = ((float)bounds.width() - size) / 2.0f;
        if (this.mArcStrokeWidth == -1.0f && this.mArcPadding == -1.0f) {
            strokeWidth = 0.083333336f * size;
            padding = 0.104166664f * size;
        } else if (this.mArcStrokeWidth == -1.0f) {
            strokeWidth = 0.083333336f * size;
            padding = this.mArcPadding + strokeWidth / 2.0f;
        } else if (this.mArcPadding == -1.0f) {
            strokeWidth = this.mArcStrokeWidth;
            padding = 0.0625f * size + strokeWidth / 2.0f;
        } else {
            strokeWidth = this.mArcStrokeWidth;
            padding = this.mArcPadding + strokeWidth / 2.0f;
        }
        this.mArcPaint.setStrokeWidth(strokeWidth);
        this.mArcRect.set((float)bounds.left + padding + xOffset, (float)bounds.top + padding + yOffset, (float)bounds.right - padding - xOffset, (float)bounds.bottom - padding - yOffset);
    }

    static {
        Path mPathStart = new Path();
        mPathStart.lineTo(0.5f, 0.0f);
        mPathStart.cubicTo(0.7f, 0.0f, 0.6f, 1.0f, 1.0f, 1.0f);
        PATH_START_INTERPOLATOR = PathInterpolatorCompat.create((Path)mPathStart);
        Path mPathEnd = new Path();
        mPathEnd.cubicTo(0.2f, 0.0f, 0.1f, 1.0f, 0.5f, 1.0f);
        mPathEnd.lineTo(1.0f, 1.0f);
        PATH_END_INTERPOLATOR = PathInterpolatorCompat.create((Path)mPathEnd);
    }

    public static class Builder {
        private Context mContext;
        private int mColor;
        private float mPadding;
        private float mStrokeWidth;

        public Builder(Context context) {
            this.mContext = context;
            this.mColor = ThemeUtils.getThemeAttrColor(this.mContext, R.attr.colorAccent);
            this.mPadding = -1.0f;
            this.mStrokeWidth = -1.0f;
        }

        public Builder setColor(@ColorInt int color) {
            this.mColor = color;
            return this;
        }

        public Builder setPadding(float padding) {
            this.mPadding = padding;
            return this;
        }

        public Builder setStrokeWidth(float strokeWidth) {
            this.mStrokeWidth = strokeWidth;
            return this;
        }

        public IndeterminateProgressDrawable build() {
            return new IndeterminateProgressDrawable(this.mContext, this.mColor, this.mStrokeWidth, this.mPadding);
        }
    }
}

