/*
 * Decompiled with CFR 0.152.
 */
package com.github.sumimakito.awesomeqr;

import android.graphics.Bitmap;
import android.graphics.RectF;
import com.waynejo.androidndkgif.GifDecoder;
import com.waynejo.androidndkgif.GifEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013J\u0006\u0010 \u001a\u00020\u001dJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013J\u0006\u0010$\u001a\u00020\u001dR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lcom/github/sumimakito/awesomeqr/GifPipeline;", "", "()V", "clippingRect", "Landroid/graphics/RectF;", "getClippingRect", "()Landroid/graphics/RectF;", "setClippingRect", "(Landroid/graphics/RectF;)V", "currentFrame", "", "errorInfo", "", "getErrorInfo", "()Ljava/lang/String;", "setErrorInfo", "(Ljava/lang/String;)V", "frameSequence", "Ljava/util/LinkedList;", "Landroid/graphics/Bitmap;", "gifDecoder", "Lcom/waynejo/androidndkgif/GifDecoder;", "outputFile", "Ljava/io/File;", "getOutputFile", "()Ljava/io/File;", "setOutputFile", "(Ljava/io/File;)V", "init", "", "file", "nextFrame", "postRender", "pushRendered", "", "bitmap", "release", "library_release"})
public final class GifPipeline {
    @Nullable
    private File outputFile;
    @Nullable
    private RectF clippingRect;
    @Nullable
    private String errorInfo;
    private GifDecoder gifDecoder;
    private LinkedList<Bitmap> frameSequence = new LinkedList();
    private int currentFrame;

    @Nullable
    public final File getOutputFile() {
        return this.outputFile;
    }

    public final void setOutputFile(@Nullable File file) {
        this.outputFile = file;
    }

    @Nullable
    public final RectF getClippingRect() {
        return this.clippingRect;
    }

    public final void setClippingRect(@Nullable RectF rectF) {
        this.clippingRect = rectF;
    }

    @Nullable
    public final String getErrorInfo() {
        return this.errorInfo;
    }

    public final void setErrorInfo(@Nullable String string) {
        this.errorInfo = string;
    }

    public final boolean init(@NotNull File file) {
        boolean isSucceeded;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!file.exists()) {
            this.errorInfo = "ENOENT: File does not exist.";
            return false;
        }
        if (file.isDirectory()) {
            this.errorInfo = "EISDIR: Target is a directory.";
            return false;
        }
        GifDecoder gifDecoder = this.gifDecoder = new GifDecoder();
        if (gifDecoder == null) {
            Intrinsics.throwNpe();
        }
        if (!(isSucceeded = gifDecoder.load(file.getAbsolutePath()))) {
            this.errorInfo = "Failed to decode input file as GIF.";
            return false;
        }
        return true;
    }

    @Nullable
    public final Bitmap nextFrame() {
        GifDecoder gifDecoder = this.gifDecoder;
        if (gifDecoder == null) {
            Intrinsics.throwNpe();
        }
        if (gifDecoder.frameNum() == 0) {
            this.errorInfo = "GIF contains zero frames.";
            return null;
        }
        if (this.clippingRect == null) {
            this.errorInfo = "No cropping rect provided.";
            return null;
        }
        GifDecoder gifDecoder2 = this.gifDecoder;
        if (gifDecoder2 == null) {
            Intrinsics.throwNpe();
        }
        if (this.currentFrame < gifDecoder2.frameNum()) {
            GifDecoder gifDecoder3 = this.gifDecoder;
            if (gifDecoder3 == null) {
                Intrinsics.throwNpe();
            }
            Bitmap frame = gifDecoder3.frame(this.currentFrame);
            int n = this.currentFrame;
            this.currentFrame = n + 1;
            if (this.clippingRect != null) {
                RectF rectF = this.clippingRect;
                if (rectF == null) {
                    Intrinsics.throwNpe();
                }
                int n2 = Math.round(rectF.left);
                RectF rectF2 = this.clippingRect;
                if (rectF2 == null) {
                    Intrinsics.throwNpe();
                }
                int n3 = Math.round(rectF2.top);
                RectF rectF3 = this.clippingRect;
                if (rectF3 == null) {
                    Intrinsics.throwNpe();
                }
                int n4 = Math.round(rectF3.width());
                RectF rectF4 = this.clippingRect;
                if (rectF4 == null) {
                    Intrinsics.throwNpe();
                }
                Bitmap cropped = Bitmap.createBitmap((Bitmap)frame, (int)n2, (int)n3, (int)n4, (int)Math.round(rectF4.height()));
                frame.recycle();
                return cropped;
            }
            return frame;
        }
        return null;
    }

    public final void pushRendered(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        this.frameSequence.addLast(bitmap);
    }

    public final boolean postRender() {
        if (this.outputFile == null) {
            this.errorInfo = "Output file is not yet set.";
            return false;
        }
        if (this.frameSequence.size() == 0) {
            this.errorInfo = "Zero frames in the sequence.";
            return false;
        }
        try {
            GifEncoder gifEncoder = new GifEncoder();
            Bitmap bitmap = this.frameSequence.getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"frameSequence.first");
            int n = bitmap.getWidth();
            Bitmap bitmap2 = this.frameSequence.getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"frameSequence.first");
            int n2 = bitmap2.getHeight();
            File file = this.outputFile;
            if (file == null) {
                Intrinsics.throwNpe();
            }
            gifEncoder.init(n, n2, file.getAbsolutePath(), GifEncoder.EncodingType.ENCODING_TYPE_FAST);
            int frameIndex = 0;
            while (!this.frameSequence.isEmpty()) {
                GifDecoder gifDecoder = this.gifDecoder;
                if (gifDecoder == null) {
                    Intrinsics.throwNpe();
                }
                gifEncoder.encodeFrame(this.frameSequence.removeFirst(), gifDecoder.delay(frameIndex));
            }
            gifEncoder.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.errorInfo = "FileNotFoundException. See stacktrace for more information.";
            return false;
        }
        return true;
    }

    public final boolean release() {
        return true;
    }
}

