/*
 * Decompiled with CFR 0.152.
 */
package com.github.sumimakito.awesomeqr;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import com.github.sumimakito.awesomeqr.GifPipeline;
import com.github.sumimakito.awesomeqr.RenderResult;
import com.github.sumimakito.awesomeqr.option.RenderOption;
import com.github.sumimakito.awesomeqr.option.background.Background;
import com.github.sumimakito.awesomeqr.option.background.BlendBackground;
import com.github.sumimakito.awesomeqr.option.background.GifBackground;
import com.github.sumimakito.awesomeqr.option.background.StillBackground;
import com.github.sumimakito.awesomeqr.option.logo.Logo;
import com.github.sumimakito.awesomeqr.util.RectUtils;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/github/sumimakito/awesomeqr/AwesomeQrRenderer;", "", "()V", "Companion", "library_release"})
public final class AwesomeQrRenderer {
    private static final byte BYTE_EPT = 0;
    private static final byte BYTE_DTA = 1;
    private static final byte BYTE_POS = 2;
    private static final byte BYTE_AGN = 3;
    private static final byte BYTE_TMG = 4;
    private static final byte BYTE_PTC = 5;
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final RenderResult render(@NotNull RenderOption renderOptions) throws Exception {
        return Companion.render(renderOptions);
    }

    @JvmStatic
    public static final void renderAsync(@NotNull RenderOption renderOptions, @Nullable Function1<? super RenderResult, Unit> resultCallback, @Nullable Function1<? super Exception, Unit> errorCallback) {
        Companion.renderAsync(renderOptions, resultCallback, errorCallback);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J(\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J \u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0007J@\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020&\u0018\u00010(2\u0018\u0010)\u001a\u0014\u0012\b\u0012\u00060*j\u0002`+\u0012\u0004\u0012\u00020&\u0018\u00010(H\u0007J\u001a\u0010,\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\b\u0010-\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0013H\u0002J-\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00112\b\u00104\u001a\u0004\u0018\u000103H\u0002\u00a2\u0006\u0002\u00105R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/github/sumimakito/awesomeqr/AwesomeQrRenderer$Companion;", "", "()V", "BYTE_AGN", "", "BYTE_DTA", "BYTE_EPT", "BYTE_POS", "BYTE_PTC", "BYTE_TMG", "getByteMatrix", "Lcom/google/zxing/qrcode/encoder/ByteMatrix;", "contents", "", "errorCorrectionLevel", "Lcom/google/zxing/qrcode/decoder/ErrorCorrectionLevel;", "getDominantColor", "", "bitmap", "Landroid/graphics/Bitmap;", "getProtoQrCode", "Lcom/google/zxing/qrcode/encoder/QRCode;", "isTypeAGN", "", "x", "y", "agnCenter", "", "edgeOnly", "isTypePOS", "size", "inner", "isTypeTMG", "render", "Lcom/github/sumimakito/awesomeqr/RenderResult;", "renderOptions", "Lcom/github/sumimakito/awesomeqr/option/RenderOption;", "renderAsync", "", "resultCallback", "Lkotlin/Function1;", "errorCallback", "Ljava/lang/Exception;", "Lkotlin/Exception;", "renderFrame", "backgroundFrame", "scaleBitmap", "src", "dst", "scaleImageBoundingRectByClippingRect", "", "Landroid/graphics/Rect;", "clippingRect", "(Landroid/graphics/Bitmap;ILandroid/graphics/Rect;)[Landroid/graphics/Rect;", "library_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final RenderResult render(@NotNull RenderOption renderOptions) throws Exception {
            Intrinsics.checkParameterIsNotNull((Object)renderOptions, (String)"renderOptions");
            if (renderOptions.getBackground() instanceof GifBackground) {
                Background background = renderOptions.getBackground();
                if (background == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.github.sumimakito.awesomeqr.option.background.GifBackground");
                }
                GifBackground background2 = (GifBackground)background;
                if (background2.getOutputFile() == null) {
                    throw (Throwable)new Exception("Output file has not yet been set. It is required under GIF background mode.");
                }
                GifPipeline gifPipeline = new GifPipeline();
                File file = background2.getInputFile();
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                if (!gifPipeline.init(file)) {
                    throw (Throwable)new Exception("GifPipeline failed to init: " + gifPipeline.getErrorInfo());
                }
                gifPipeline.setClippingRect(background2.getClippingRectF());
                gifPipeline.setOutputFile(background2.getOutputFile());
                Bitmap firstRenderedFrame = null;
                Bitmap frame = gifPipeline.nextFrame();
                while (frame != null) {
                    Bitmap renderedFrame = this.renderFrame(renderOptions, frame);
                    gifPipeline.pushRendered(renderedFrame);
                    if (firstRenderedFrame == null) {
                        firstRenderedFrame = renderedFrame.copy(Bitmap.Config.ARGB_8888, true);
                    }
                    frame = gifPipeline.nextFrame();
                }
                if (gifPipeline.getErrorInfo() != null) {
                    throw (Throwable)new Exception("GifPipeline failed to render frames: " + gifPipeline.getErrorInfo());
                }
                if (!gifPipeline.postRender()) {
                    throw (Throwable)new Exception("GifPipeline failed to do post render works: " + gifPipeline.getErrorInfo());
                }
                return new RenderResult(firstRenderedFrame, background2.getOutputFile(), RenderResult.OutputType.GIF);
            }
            if (renderOptions.getBackground() instanceof BlendBackground) {
                Background background = renderOptions.getBackground();
                if (background == null) {
                    Intrinsics.throwNpe();
                }
                if (background.getBitmap() != null) {
                    Bitmap bitmap;
                    Background background3 = renderOptions.getBackground();
                    if (background3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.github.sumimakito.awesomeqr.option.background.BlendBackground");
                    }
                    BlendBackground background4 = (BlendBackground)background3;
                    Bitmap clippedBackground = null;
                    if (background4.getClippingRect() != null) {
                        Bitmap bitmap2 = background4.getBitmap();
                        Rect rect = background4.getClippingRect();
                        if (rect == null) {
                            Intrinsics.throwNpe();
                        }
                        int n = Math.round(rect.left);
                        Rect rect2 = background4.getClippingRect();
                        if (rect2 == null) {
                            Intrinsics.throwNpe();
                        }
                        int n2 = Math.round(rect2.top);
                        Rect rect3 = background4.getClippingRect();
                        if (rect3 == null) {
                            Intrinsics.throwNpe();
                        }
                        int n3 = Math.round(rect3.width());
                        Rect rect4 = background4.getClippingRect();
                        if (rect4 == null) {
                            Intrinsics.throwNpe();
                        }
                        clippedBackground = Bitmap.createBitmap((Bitmap)bitmap2, (int)n, (int)n2, (int)n3, (int)Math.round(rect4.height()));
                    }
                    if ((bitmap = clippedBackground) == null) {
                        bitmap = background4.getBitmap();
                    }
                    Bitmap rendered = this.renderFrame(renderOptions, bitmap);
                    Bitmap bitmap3 = clippedBackground;
                    if (bitmap3 != null) {
                        bitmap3.recycle();
                    }
                    Bitmap bitmap4 = background4.getBitmap();
                    if (bitmap4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Rect[] scaledBoundingRects = this.scaleImageBoundingRectByClippingRect(bitmap4, renderOptions.getSize(), background4.getClippingRect());
                    Bitmap fullRendered = Bitmap.createScaledBitmap((Bitmap)background4.getBitmap(), (int)scaledBoundingRects[0].width(), (int)scaledBoundingRects[0].height(), (boolean)true);
                    Canvas fullCanvas = new Canvas(fullRendered);
                    Paint paint = new Paint();
                    paint.setAntiAlias(true);
                    paint.setColor(renderOptions.getColor().getBackground());
                    paint.setFilterBitmap(true);
                    fullCanvas.drawBitmap(rendered, new Rect(0, 0, rendered.getWidth(), rendered.getHeight()), scaledBoundingRects[1], paint);
                    return new RenderResult(fullRendered, null, RenderResult.OutputType.Blend);
                }
            }
            if (renderOptions.getBackground() instanceof StillBackground) {
                Bitmap bitmap;
                Background background = renderOptions.getBackground();
                if (background == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.github.sumimakito.awesomeqr.option.background.StillBackground");
                }
                StillBackground background5 = (StillBackground)background;
                Bitmap clippedBackground = null;
                if (background5.getClippingRect() != null) {
                    Bitmap bitmap5 = background5.getBitmap();
                    Rect rect = background5.getClippingRect();
                    if (rect == null) {
                        Intrinsics.throwNpe();
                    }
                    int n = Math.round(rect.left);
                    Rect rect5 = background5.getClippingRect();
                    if (rect5 == null) {
                        Intrinsics.throwNpe();
                    }
                    int n4 = Math.round(rect5.top);
                    Rect rect6 = background5.getClippingRect();
                    if (rect6 == null) {
                        Intrinsics.throwNpe();
                    }
                    int n5 = Math.round(rect6.width());
                    Rect rect7 = background5.getClippingRect();
                    if (rect7 == null) {
                        Intrinsics.throwNpe();
                    }
                    clippedBackground = Bitmap.createBitmap((Bitmap)bitmap5, (int)n, (int)n4, (int)n5, (int)Math.round(rect7.height()));
                }
                if ((bitmap = clippedBackground) == null) {
                    bitmap = background5.getBitmap();
                }
                Bitmap rendered = this.renderFrame(renderOptions, bitmap);
                Bitmap bitmap6 = clippedBackground;
                if (bitmap6 != null) {
                    bitmap6.recycle();
                }
                return new RenderResult(rendered, null, RenderResult.OutputType.Still);
            }
            return new RenderResult(this.renderFrame(renderOptions, null), null, RenderResult.OutputType.Still);
        }

        @JvmStatic
        public final void renderAsync(@NotNull RenderOption renderOptions, @Nullable Function1<? super RenderResult, Unit> resultCallback, @Nullable Function1<? super Exception, Unit> errorCallback) {
            Intrinsics.checkParameterIsNotNull((Object)renderOptions, (String)"renderOptions");
            new Thread(new Runnable(renderOptions, resultCallback, errorCallback){
                final /* synthetic */ RenderOption $renderOptions;
                final /* synthetic */ Function1 $resultCallback;
                final /* synthetic */ Function1 $errorCallback;

                public final void run() {
                    block2: {
                        try {
                            RenderResult renderResult = AwesomeQrRenderer.Companion.render(this.$renderOptions);
                            Function1 function1 = this.$resultCallback;
                            if (function1 == null) break block2;
                            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)renderResult);
                        }
                        catch (Exception e) {
                            Function1 function1 = this.$errorCallback;
                            if (function1 == null) break block2;
                            Unit cfr_ignored_1 = (Unit)function1.invoke((Object)e);
                        }
                    }
                }
                {
                    this.$renderOptions = renderOption;
                    this.$resultCallback = function1;
                    this.$errorCallback = function12;
                }
            }).start();
        }

        /*
         * WARNING - void declaration
         */
        private final Bitmap renderFrame(RenderOption renderOptions, Bitmap backgroundFrame) throws Exception {
            Bitmap renderedResultBitmap;
            Bitmap backgroundFrameTemp = backgroundFrame;
            CharSequence charSequence = renderOptions.getContent();
            if (charSequence.length() == 0) {
                throw (Throwable)new IllegalArgumentException("Error: content is empty. (content.isEmpty())");
            }
            if (renderOptions.getSize() < 0) {
                throw (Throwable)new IllegalArgumentException("Error: a negative size is given. (size < 0)");
            }
            if (renderOptions.getBorderWidth() < 0) {
                throw (Throwable)new IllegalArgumentException("Error: a negative borderWidth is given. (borderWidth < 0)");
            }
            if (renderOptions.getSize() - 2 * renderOptions.getBorderWidth() <= 0) {
                throw (Throwable)new IllegalArgumentException("Error: there is no space left for the QRCode. (size - 2 * borderWidth <= 0)");
            }
            ByteMatrix byteMatrix = this.getByteMatrix(renderOptions.getContent(), renderOptions.getEcl());
            if (byteMatrix == null) {
                throw (Throwable)new NullPointerException("Error: ByteMatrix based on content is null. (getByteMatrix(content, ecl) == null)");
            }
            ByteMatrix byteMatrix2 = byteMatrix;
            int innerRenderedSize = renderOptions.getSize() - 2 * renderOptions.getBorderWidth();
            int nCount = byteMatrix2.getWidth();
            int nSize = Math.round((float)innerRenderedSize / (float)nCount);
            int unscaledInnerRenderSize = nSize * nCount;
            int unscaledFullRenderSize = unscaledInnerRenderSize + 2 * renderOptions.getBorderWidth();
            if (renderOptions.getSize() - 2 * renderOptions.getBorderWidth() < byteMatrix2.getWidth()) {
                throw (Throwable)new IllegalArgumentException("Error: there is no space left for the QRCode. (size - 2 * borderWidth < " + byteMatrix2.getWidth() + ")");
            }
            if (renderOptions.getPatternScale() <= 0.0f || renderOptions.getPatternScale() > 1.0f) {
                throw (Throwable)new IllegalArgumentException("Error: an illegal pattern scale is given. (patternScale <= 0 || patternScale > 1)");
            }
            if (renderOptions.getLogo() != null) {
                Logo logo = renderOptions.getLogo();
                if (logo == null) {
                    Intrinsics.throwNpe();
                }
                if (logo.getBitmap() != null) {
                    Logo logo2;
                    Logo logo3 = renderOptions.getLogo();
                    if (logo3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((logo2 = logo3).getScale() <= 0.0f || (double)logo2.getScale() > 0.5) {
                        throw (Throwable)new IllegalArgumentException("Error: an illegal logo scale is given. (logo.scale <= 0 || logo.scale > 0.5)");
                    }
                    if (logo2.getBorderWidth() < 0 || logo2.getBorderWidth() * 2 >= unscaledInnerRenderSize) {
                        throw (Throwable)new IllegalArgumentException("Error: an illegal logo border width is given. (logo.borderWidth < 0 || logo.borderWidth * 2 >= " + unscaledInnerRenderSize + ')');
                    }
                    if (logo2.getBorderRadius() < 0) {
                        throw (Throwable)new IllegalArgumentException("Error: a negative logo border radius is given. (logo.borderRadius < 0)");
                    }
                    int logoScaledSize = (int)((float)unscaledInnerRenderSize * logo2.getScale());
                    if (logo2.getBorderRadius() * 2 > logoScaledSize) {
                        throw (Throwable)new IllegalArgumentException("Error: an illegal logo border radius is given. (logo.borderRadius * 2 > " + logoScaledSize + ')');
                    }
                }
            }
            Rect backgroundDrawingRect = new Rect(!renderOptions.getClearBorder() ? 0 : renderOptions.getBorderWidth(), !renderOptions.getClearBorder() ? 0 : renderOptions.getBorderWidth(), unscaledFullRenderSize - renderOptions.getBorderWidth() * (renderOptions.getClearBorder() ? 1 : 0), unscaledFullRenderSize - renderOptions.getBorderWidth() * (renderOptions.getClearBorder() ? 1 : 0));
            if (backgroundFrameTemp == null && (renderOptions.getBackground() instanceof StillBackground || renderOptions.getBackground() instanceof BlendBackground)) {
                Background background = renderOptions.getBackground();
                if (background == null) {
                    Intrinsics.throwNpe();
                }
                backgroundFrameTemp = background.getBitmap();
            }
            Bitmap unscaledFullRenderedBitmap = Bitmap.createBitmap((int)unscaledFullRenderSize, (int)unscaledFullRenderSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (renderOptions.getColor().getAuto() && backgroundFrame != null) {
                renderOptions.getColor().setLight(-1);
                renderOptions.getColor().setDark(this.getDominantColor(backgroundFrame));
            }
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            Paint paintBackground = new Paint();
            paintBackground.setAntiAlias(true);
            paintBackground.setColor(renderOptions.getColor().getBackground());
            paintBackground.setStyle(Paint.Style.FILL);
            Paint paintDark = new Paint();
            paintDark.setColor(renderOptions.getColor().getDark());
            paintDark.setAntiAlias(true);
            paintDark.setStyle(Paint.Style.FILL);
            Paint paintLight = new Paint();
            paintLight.setColor(renderOptions.getColor().getLight());
            paintLight.setAntiAlias(true);
            paintLight.setStyle(Paint.Style.FILL);
            Paint paintProtector = new Paint();
            paintProtector.setColor(Color.argb((int)120, (int)255, (int)255, (int)255));
            paintProtector.setAntiAlias(true);
            paintProtector.setStyle(Paint.Style.FILL);
            Canvas unscaledCanvas = new Canvas(unscaledFullRenderedBitmap);
            unscaledCanvas.drawColor(-1);
            unscaledCanvas.drawRect((float)(renderOptions.getClearBorder() ? renderOptions.getBorderWidth() : 0), (float)(renderOptions.getClearBorder() ? renderOptions.getBorderWidth() : 0), (float)(unscaledInnerRenderSize + (renderOptions.getClearBorder() ? renderOptions.getBorderWidth() : renderOptions.getBorderWidth() * 2)), (float)(unscaledInnerRenderSize + (renderOptions.getClearBorder() ? renderOptions.getBorderWidth() : renderOptions.getBorderWidth() * 2)), paintBackground);
            if (backgroundFrame != null && renderOptions.getBackground() != null) {
                float f = 255;
                Background background = renderOptions.getBackground();
                if (background == null) {
                    Intrinsics.throwNpe();
                }
                paint.setAlpha(Math.round(f * background.getAlpha()));
                unscaledCanvas.drawBitmap(backgroundFrame, null, backgroundDrawingRect, paint);
            }
            paint.setAlpha(255);
            int n = 0;
            int n2 = byteMatrix2.getHeight();
            while (n < n2) {
                void row;
                int n3 = 0;
                int n4 = byteMatrix2.getWidth();
                while (n3 < n4) {
                    void col;
                    switch (byteMatrix2.get((int)col, (int)row)) {
                        case 2: 
                        case 3: 
                        case 4: {
                            unscaledCanvas.drawRect((float)(renderOptions.getBorderWidth() + col * nSize), (float)(renderOptions.getBorderWidth() + row * nSize), (float)(renderOptions.getBorderWidth() + (col + true) * nSize), (float)(renderOptions.getBorderWidth() + (row + true) * nSize), paintDark);
                            break;
                        }
                        case 1: {
                            if (renderOptions.getRoundedPatterns()) {
                                unscaledCanvas.drawCircle((float)renderOptions.getBorderWidth() + ((float)col + 0.5f) * (float)nSize, (float)renderOptions.getBorderWidth() + ((float)row + 0.5f) * (float)nSize, renderOptions.getPatternScale() * (float)nSize * 0.5f, paintDark);
                                break;
                            }
                            unscaledCanvas.drawRect((float)renderOptions.getBorderWidth() + ((float)col + 0.5f * (1.0f - renderOptions.getPatternScale())) * (float)nSize, (float)renderOptions.getBorderWidth() + ((float)row + 0.5f * (1.0f - renderOptions.getPatternScale())) * (float)nSize, (float)renderOptions.getBorderWidth() + ((float)col + 0.5f * (1.0f + renderOptions.getPatternScale())) * (float)nSize, (float)renderOptions.getBorderWidth() + ((float)row + 0.5f * (1.0f + renderOptions.getPatternScale())) * (float)nSize, paintDark);
                            break;
                        }
                        case 5: {
                            unscaledCanvas.drawRect((float)(renderOptions.getBorderWidth() + col * nSize), (float)(renderOptions.getBorderWidth() + row * nSize), (float)(renderOptions.getBorderWidth() + (col + true) * nSize), (float)(renderOptions.getBorderWidth() + (row + true) * nSize), paintProtector);
                            break;
                        }
                        case 0: {
                            if (renderOptions.getRoundedPatterns()) {
                                unscaledCanvas.drawCircle((float)renderOptions.getBorderWidth() + ((float)col + 0.5f) * (float)nSize, (float)renderOptions.getBorderWidth() + ((float)row + 0.5f) * (float)nSize, renderOptions.getPatternScale() * (float)nSize * 0.5f, paintLight);
                                break;
                            }
                            unscaledCanvas.drawRect((float)renderOptions.getBorderWidth() + ((float)col + 0.5f * (1.0f - renderOptions.getPatternScale())) * (float)nSize, (float)renderOptions.getBorderWidth() + ((float)row + 0.5f * (1.0f - renderOptions.getPatternScale())) * (float)nSize, (float)renderOptions.getBorderWidth() + ((float)col + 0.5f * (1.0f + renderOptions.getPatternScale())) * (float)nSize, (float)renderOptions.getBorderWidth() + ((float)row + 0.5f * (1.0f + renderOptions.getPatternScale())) * (float)nSize, paintLight);
                        }
                    }
                    ++col;
                }
                ++row;
            }
            if (renderOptions.getLogo() != null) {
                Logo logo = renderOptions.getLogo();
                if (logo == null) {
                    Intrinsics.throwNpe();
                }
                if (logo.getBitmap() != null) {
                    Bitmap logoScaled;
                    Logo logo4 = renderOptions.getLogo();
                    if (logo4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Logo logo5 = logo4;
                    int logoScaledSize = (int)((float)unscaledInnerRenderSize * logo5.getScale());
                    Bitmap bitmap = logoScaled = Bitmap.createScaledBitmap((Bitmap)logo5.getBitmap(), (int)logoScaledSize, (int)logoScaledSize, (boolean)true);
                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"logoScaled");
                    Bitmap logoOpt = Bitmap.createBitmap((int)bitmap.getWidth(), (int)logoScaled.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas logoCanvas = new Canvas(logoOpt);
                    Rect logoRect = new Rect(0, 0, logoScaled.getWidth(), logoScaled.getHeight());
                    RectF logoRectF = new RectF(logoRect);
                    Paint logoPaint = new Paint();
                    logoPaint.setAntiAlias(true);
                    logoPaint.setColor(-1);
                    logoPaint.setStyle(Paint.Style.FILL);
                    logoCanvas.drawARGB(0, 0, 0, 0);
                    logoCanvas.drawRoundRect(logoRectF, (float)logo5.getBorderRadius(), (float)logo5.getBorderRadius(), logoPaint);
                    logoPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                    logoCanvas.drawBitmap(logoScaled, logoRect, logoRect, logoPaint);
                    logoPaint.setColor(renderOptions.getColor().getLight());
                    logoPaint.setStyle(Paint.Style.STROKE);
                    logoPaint.setStrokeWidth((float)logo5.getBorderWidth());
                    logoCanvas.drawRoundRect(logoRectF, (float)logo5.getBorderRadius(), (float)logo5.getBorderRadius(), logoPaint);
                    Bitmap bitmap2 = unscaledFullRenderedBitmap;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"unscaledFullRenderedBitmap");
                    int n5 = bitmap2.getWidth();
                    Bitmap bitmap3 = logoOpt;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"logoOpt");
                    unscaledCanvas.drawBitmap(logoOpt, (float)((int)(0.5 * (double)(n5 - bitmap3.getWidth()))), (float)((int)(0.5 * (double)(unscaledFullRenderedBitmap.getHeight() - logoOpt.getHeight()))), paint);
                }
            }
            Bitmap renderedScaledBitmap = Bitmap.createBitmap((int)renderOptions.getSize(), (int)renderOptions.getSize(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas scaledCanvas = new Canvas(renderedScaledBitmap);
            Bitmap bitmap = renderedScaledBitmap;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"renderedScaledBitmap");
            scaledCanvas.drawBitmap(unscaledFullRenderedBitmap, null, new Rect(0, 0, bitmap.getWidth(), renderedScaledBitmap.getHeight()), paint);
            if (renderOptions.getBackground() instanceof BlendBackground) {
                Bitmap bitmap4 = Bitmap.createBitmap((int)renderedScaledBitmap.getWidth(), (int)renderedScaledBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"Bitmap.createBitmap(rend\u2026 Bitmap.Config.ARGB_8888)");
                renderedResultBitmap = bitmap4;
                Canvas finalRenderedCanvas = new Canvas(renderedResultBitmap);
                Rect finalClippingRect = new Rect(0, 0, renderedScaledBitmap.getWidth(), renderedScaledBitmap.getHeight());
                RectF finalClippingRectF = new RectF(finalClippingRect);
                Paint finalClippingPaint = new Paint();
                finalClippingPaint.setAntiAlias(true);
                finalClippingPaint.setColor(-1);
                finalClippingPaint.setStyle(Paint.Style.FILL);
                finalRenderedCanvas.drawARGB(0, 0, 0, 0);
                Background background = renderOptions.getBackground();
                if (background == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.github.sumimakito.awesomeqr.option.background.BlendBackground");
                }
                Background background2 = renderOptions.getBackground();
                if (background2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.github.sumimakito.awesomeqr.option.background.BlendBackground");
                }
                finalRenderedCanvas.drawRoundRect(finalClippingRectF, (float)((BlendBackground)background).getBorderRadius(), (float)((BlendBackground)background2).getBorderRadius(), finalClippingPaint);
                finalClippingPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                finalRenderedCanvas.drawBitmap(renderedScaledBitmap, null, finalClippingRect, finalClippingPaint);
                renderedScaledBitmap.recycle();
            } else {
                renderedResultBitmap = renderedScaledBitmap;
            }
            unscaledFullRenderedBitmap.recycle();
            return renderedResultBitmap;
        }

        /*
         * WARNING - void declaration
         */
        private final ByteMatrix getByteMatrix(String contents, ErrorCorrectionLevel errorCorrectionLevel) {
            try {
                ByteMatrix byteMatrix;
                QRCode qrCode = this.getProtoQrCode(contents, errorCorrectionLevel);
                Version version = qrCode.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"qrCode.version");
                int[] agnCenter = version.getAlignmentPatternCenters();
                ByteMatrix byteMatrix2 = byteMatrix = qrCode.getMatrix();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteMatrix2, (String)"byteMatrix");
                int matSize = byteMatrix2.getWidth();
                int n = 0;
                int n2 = matSize;
                while (n < n2) {
                    void row;
                    int n3 = 0;
                    int n4 = matSize;
                    while (n3 < n4) {
                        void col;
                        Intrinsics.checkExpressionValueIsNotNull((Object)agnCenter, (String)"agnCenter");
                        if (this.isTypeAGN((int)col, (int)row, agnCenter, true)) {
                            if (byteMatrix.get((int)col, (int)row) != 0) {
                                byteMatrix.set((int)col, (int)row, (byte)3);
                            } else {
                                byteMatrix.set((int)col, (int)row, (byte)5);
                            }
                        } else if (this.isTypePOS((int)col, (int)row, matSize, true)) {
                            if (byteMatrix.get((int)col, (int)row) != 0) {
                                byteMatrix.set((int)col, (int)row, (byte)2);
                            } else {
                                byteMatrix.set((int)col, (int)row, (byte)5);
                            }
                        } else if (this.isTypeTMG((int)col, (int)row, matSize)) {
                            if (byteMatrix.get((int)col, (int)row) != 0) {
                                byteMatrix.set((int)col, (int)row, (byte)4);
                            } else {
                                byteMatrix.set((int)col, (int)row, (byte)5);
                            }
                        }
                        if (this.isTypePOS((int)col, (int)row, matSize, false) && byteMatrix.get((int)col, (int)row) == 0) {
                            byteMatrix.set((int)col, (int)row, (byte)5);
                        }
                        ++col;
                    }
                    ++row;
                }
                return byteMatrix;
            }
            catch (WriterException e) {
                e.printStackTrace();
                return null;
            }
        }

        private final QRCode getProtoQrCode(String contents, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
            CharSequence charSequence = contents;
            if (charSequence.length() == 0) {
                throw (Throwable)new IllegalArgumentException("Found empty content.");
            }
            Hashtable hintMap = new Hashtable();
            Map map = hintMap;
            EncodeHintType encodeHintType = EncodeHintType.CHARACTER_SET;
            String string = "UTF-8";
            map.put(encodeHintType, string);
            map = hintMap;
            encodeHintType = EncodeHintType.ERROR_CORRECTION;
            string = errorCorrectionLevel;
            map.put(encodeHintType, string);
            QRCode qRCode = Encoder.encode((String)contents, (ErrorCorrectionLevel)errorCorrectionLevel, (Map)hintMap);
            Intrinsics.checkExpressionValueIsNotNull((Object)qRCode, (String)"Encoder.encode(contents,\u2026CorrectionLevel, hintMap)");
            return qRCode;
        }

        private final boolean isTypeAGN(int x, int y, int[] agnCenter, boolean edgeOnly) {
            int[] nArray = agnCenter;
            if (nArray.length == 0) {
                return false;
            }
            int edgeCenter = agnCenter[agnCenter.length - 1];
            int n = agnCenter.length;
            for (int i = 0; i < n; ++i) {
                int agnY = agnCenter[i];
                int n2 = agnCenter.length;
                for (int j = 0; j < n2; ++j) {
                    int agnX = agnCenter[j];
                    if (edgeOnly && agnX != 6 && agnY != 6 && agnX != edgeCenter && agnY != edgeCenter || agnX == 6 && agnY == 6 || agnX == 6 && agnY == edgeCenter || agnY == 6 && agnX == edgeCenter || x < agnX - 2 || x > agnX + 2 || y < agnY - 2 || y > agnY + 2) continue;
                    return true;
                }
            }
            return false;
        }

        private final boolean isTypePOS(int x, int y, int size, boolean inner) {
            return inner ? x < 7 && (y < 7 || y >= size - 7) || x >= size - 7 && y < 7 : x <= 7 && (y <= 7 || y >= size - 8) || x >= size - 8 && y <= 7;
        }

        private final boolean isTypeTMG(int x, int y, int size) {
            return y == 6 && x >= 8 && x < size - 8 || x == 6 && y >= 8 && y < size - 8;
        }

        private final void scaleBitmap(Bitmap src, Bitmap dst) {
            Paint cPaint = new Paint();
            cPaint.setAntiAlias(true);
            cPaint.setDither(true);
            cPaint.setFilterBitmap(true);
            float ratioX = (float)dst.getWidth() / (float)src.getWidth();
            float ratioY = (float)dst.getHeight() / (float)src.getHeight();
            float middleX = (float)dst.getWidth() * 0.5f;
            float middleY = (float)dst.getHeight() * 0.5f;
            Matrix scaleMatrix = new Matrix();
            scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
            Canvas canvas = new Canvas(dst);
            canvas.setMatrix(scaleMatrix);
            canvas.drawBitmap(src, middleX - (float)(src.getWidth() / 2), middleY - (float)(src.getHeight() / 2), cPaint);
        }

        /*
         * WARNING - void declaration
         */
        private final int getDominantColor(Bitmap bitmap) {
            Bitmap newBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)8, (int)8, (boolean)true);
            int red = 0;
            int green = 0;
            int blue = 0;
            int c = 0;
            int n = 0;
            Bitmap bitmap2 = newBitmap;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"newBitmap");
            int n2 = bitmap2.getHeight();
            while (n < n2) {
                void y;
                int n3 = 0;
                int n4 = newBitmap.getHeight();
                while (n3 < n4) {
                    void x;
                    int color = newBitmap.getPixel((int)x, (int)y);
                    int r = color >> 16 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color & 0xFF;
                    if (r <= 200 && g <= 200 && b <= 200) {
                        red += r;
                        green += g;
                        blue += b;
                        ++c;
                    }
                    ++x;
                }
                ++y;
            }
            newBitmap.recycle();
            if (c == 0) {
                return -16777216;
            }
            red = Math.max(0, Math.min(255, red / c));
            green = Math.max(0, Math.min(255, green / c));
            blue = Math.max(0, Math.min(255, blue / c));
            float[] hsv = new float[3];
            Color.RGBToHSV((int)red, (int)green, (int)blue, (float[])hsv);
            hsv[2] = Math.max(hsv[2], 0.7f);
            return 0xFF000000 | Color.HSVToColor((float[])hsv);
        }

        private final Rect[] scaleImageBoundingRectByClippingRect(Bitmap bitmap, int size, Rect clippingRect) {
            if (clippingRect == null) {
                return this.scaleImageBoundingRectByClippingRect(bitmap, size, new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()));
            }
            if (clippingRect.width() != clippingRect.height() || clippingRect.width() <= size) {
                return new Rect[]{new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()), clippingRect};
            }
            float clippingSize = clippingRect.width();
            float scalingRatio = (float)size / clippingSize;
            return new Rect[]{RectUtils.INSTANCE.round(new RectF(0.0f, 0.0f, (float)bitmap.getWidth() * scalingRatio, (float)bitmap.getHeight() * scalingRatio)), RectUtils.INSTANCE.round(new RectF((float)clippingRect.left * scalingRatio, (float)clippingRect.top * scalingRatio, (float)clippingRect.right * scalingRatio, (float)clippingRect.bottom * scalingRatio))};
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

