/*
 * Decompiled with CFR 0.152.
 */
package com.stomhong.library;

import android.app.Activity;
import android.content.Context;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.os.Build;
import android.os.Handler;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.stomhong.library.PpKeyBoardView;
import com.stomhong.library.R;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class KeyboardUtil {
    private Context mContext;
    private int widthPixels;
    private Activity mActivity;
    private FrameLayout mRootView;
    private PpKeyBoardView keyboardView;
    public static Keyboard abcKeyboard;
    public static Keyboard symbolKeyboard;
    public static Keyboard numKeyboard;
    public static Keyboard keyboard;
    public boolean isUpper = false;
    public boolean isShow = false;
    InputFinishListener inputOver;
    KeyBoardStateChangeListener keyBoardStateChangeListener;
    private LinearLayout layoutView;
    private LinearLayout keyBoardLayout;
    public static int inputType;
    public static final int INPUTTYPE_NUM = 1;
    public static final int INPUTTYPE_NUM_FINISH = 2;
    public static final int INPUTTYPE_NUM_POINT = 3;
    public static final int INPUTTYPE_NUM_X = 4;
    public static final int INPUTTYPE_NUM_NEXT = 5;
    public static final int INPUTTYPE_ABC = 6;
    public static final int INPUTTYPE_SYMBOL = 7;
    public static final int INPUTTYPE_NUM_ABC = 8;
    public static final int KEYBOARD_SHOW = 1;
    public static final int KEYBOARD_HIDE = 2;
    private EditText ed;
    private Handler showHandler;
    private KeyboardUtil mKeyboardUtil;
    private ImageView ivClose;
    private KeyboardView.OnKeyboardActionListener listener = new KeyboardView.OnKeyboardActionListener(){

        public void swipeUp() {
        }

        public void swipeRight() {
        }

        public void swipeLeft() {
        }

        public void swipeDown() {
        }

        public void onText(CharSequence text) {
            if (KeyboardUtil.this.ed == null) {
                return;
            }
            Editable editable = KeyboardUtil.this.ed.getText();
            int start = KeyboardUtil.this.ed.getSelectionStart();
            int end = KeyboardUtil.this.ed.getSelectionEnd();
            String temp = editable.subSequence(0, start) + text.toString() + editable.subSequence(start, editable.length());
            KeyboardUtil.this.ed.setText((CharSequence)temp);
            Editable etext = KeyboardUtil.this.ed.getText();
            Selection.setSelection((Spannable)etext, (int)(start + 1));
        }

        public void onRelease(int primaryCode) {
            if (inputType != 8 && primaryCode == -1) {
                KeyboardUtil.this.keyboardView.setPreviewEnabled(true);
            }
        }

        public void onPress(int primaryCode) {
            if (inputType == 8 || inputType == 1 || inputType == 3 || inputType == 2 || inputType == 5 || inputType == 4) {
                KeyboardUtil.this.keyboardView.setPreviewEnabled(false);
                return;
            }
            if (primaryCode == -1 || primaryCode == -5 || primaryCode == 123123 || primaryCode == 456456 || primaryCode == 789789 || primaryCode == 32) {
                KeyboardUtil.this.keyboardView.setPreviewEnabled(false);
                return;
            }
            KeyboardUtil.this.keyboardView.setPreviewEnabled(true);
        }

        public void onKey(int primaryCode, int[] keyCodes) {
            Editable editable = KeyboardUtil.this.ed.getText();
            int start = KeyboardUtil.this.ed.getSelectionStart();
            if (primaryCode == -3) {
                KeyboardUtil.this.hideKeyboardLayout();
                if (KeyboardUtil.this.inputOver != null) {
                    KeyboardUtil.this.inputOver.inputHasOver(primaryCode, KeyboardUtil.this.ed);
                }
            } else if (primaryCode == -5) {
                if (editable != null && editable.length() > 0 && start > 0) {
                    editable.delete(start - 1, start);
                }
            } else if (primaryCode == -1) {
                KeyboardUtil.this.changeKey();
                KeyboardUtil.this.keyboardView.setKeyboard(abcKeyboard);
            } else if (primaryCode == -4) {
                if (KeyboardUtil.this.keyboardView.getRightType() == 4) {
                    KeyboardUtil.this.hideKeyboardLayout();
                    if (KeyboardUtil.this.inputOver != null) {
                        KeyboardUtil.this.inputOver.inputHasOver(KeyboardUtil.this.keyboardView.getRightType(), KeyboardUtil.this.ed);
                    }
                } else if (KeyboardUtil.this.keyboardView.getRightType() == 5 && KeyboardUtil.this.inputOver != null) {
                    KeyboardUtil.this.inputOver.inputHasOver(KeyboardUtil.this.keyboardView.getRightType(), KeyboardUtil.this.ed);
                }
            } else if (primaryCode != 0) {
                if (primaryCode == 123123) {
                    KeyboardUtil.this.isUpper = false;
                    KeyboardUtil.this.showKeyBoardLayout(KeyboardUtil.this.ed, 8);
                } else if (primaryCode == 456456) {
                    KeyboardUtil.this.isUpper = false;
                    KeyboardUtil.this.showKeyBoardLayout(KeyboardUtil.this.ed, 6);
                } else if (primaryCode == 789789) {
                    KeyboardUtil.this.isUpper = false;
                    KeyboardUtil.this.showKeyBoardLayout(KeyboardUtil.this.ed, 7);
                } else if (primaryCode == 741741) {
                    KeyboardUtil.this.showKeyBoardLayout(KeyboardUtil.this.ed, 6);
                } else {
                    editable.insert(start, (CharSequence)Character.toString((char)primaryCode));
                    Log.d((String)"KeyboardUtil", (String)("Character ===" + Character.toString((char)primaryCode) + "primaryCode===" + primaryCode));
                }
            }
        }
    };

    public KeyboardUtil(Context context) {
        this.mContext = context;
        this.mActivity = (Activity)this.mContext;
        this.mRootView = (FrameLayout)((Activity)this.mContext).getWindow().getDecorView().findViewById(0x1020002);
        this.widthPixels = this.mContext.getResources().getDisplayMetrics().widthPixels;
        this.initKeyBoardView();
        this.mKeyboardUtil = this;
    }

    public void setInputOverListener(InputFinishListener listener) {
        this.inputOver = listener;
    }

    public static Keyboard getKeyBoardType() {
        return keyboard;
    }

    private void initKeyBoardView() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        this.keyBoardLayout = (LinearLayout)inflater.inflate(R.layout.input, null);
        this.keyBoardLayout.setVisibility(8);
        this.keyBoardLayout.setBackgroundColor(this.mActivity.getResources().getColor(R.color.product_list_bac));
        this.initLayoutHeight(this.keyBoardLayout);
        this.layoutView = this.keyBoardLayout;
        this.mRootView.addView((View)this.keyBoardLayout);
        FrameLayout.LayoutParams textParams = new FrameLayout.LayoutParams(-1, -2, 80);
        this.keyBoardLayout.setLayoutParams((ViewGroup.LayoutParams)textParams);
        if (this.keyBoardLayout != null && this.keyBoardLayout.getVisibility() == 0) {
            Log.d((String)"KeyboardUtil", (String)"visible");
        }
    }

    public void initLayoutHeight(LinearLayout layoutView) {
        LinearLayout.LayoutParams keyboard_layoutlLayoutParams = (LinearLayout.LayoutParams)layoutView.getLayoutParams();
        RelativeLayout TopLayout = (RelativeLayout)layoutView.findViewById(R.id.keyboard_view_top_rl);
        this.ivClose = (ImageView)layoutView.findViewById(R.id.iv_close);
        this.ivClose.setOnClickListener((View.OnClickListener)new finishListener());
        if (keyboard_layoutlLayoutParams == null) {
            int height = (int)((float)this.mActivity.getResources().getDisplayMetrics().heightPixels * 0.391f);
            layoutView.setLayoutParams(new ViewGroup.LayoutParams(-1, height));
        } else {
            keyboard_layoutlLayoutParams.height = (int)((float)this.mActivity.getResources().getDisplayMetrics().heightPixels * 0.391f);
        }
        LinearLayout.LayoutParams TopLayoutParams = (LinearLayout.LayoutParams)TopLayout.getLayoutParams();
        if (TopLayoutParams == null) {
            int height = (int)((float)this.mActivity.getResources().getDisplayMetrics().heightPixels * 0.053f);
            TopLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, height));
        } else {
            TopLayoutParams.height = (int)((float)this.mActivity.getResources().getDisplayMetrics().heightPixels * 0.053f);
        }
    }

    public boolean setKeyBoardCursorNew(EditText edit) {
        this.ed = edit;
        boolean flag = false;
        InputMethodManager imm = (InputMethodManager)this.mContext.getSystemService("input_method");
        boolean isOpen = imm.isActive();
        if (isOpen && imm.hideSoftInputFromWindow(edit.getWindowToken(), 0)) {
            flag = true;
        }
        int currentVersion = Build.VERSION.SDK_INT;
        String methodName = null;
        if (currentVersion >= 16) {
            methodName = "setShowSoftInputOnFocus";
        } else if (currentVersion >= 14) {
            methodName = "setSoftInputShownOnFocus";
        }
        if (methodName == null) {
            edit.setInputType(0);
        } else {
            Class<EditText> cls = EditText.class;
            try {
                Method setShowSoftInputOnFocus = cls.getMethod(methodName, Boolean.TYPE);
                setShowSoftInputOnFocus.setAccessible(true);
                setShowSoftInputOnFocus.invoke((Object)edit, false);
            }
            catch (NoSuchMethodException e) {
                edit.setInputType(0);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    public void hideSystemKeyBoard() {
        InputMethodManager imm = (InputMethodManager)this.mContext.getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.keyBoardLayout.getWindowToken(), 0);
    }

    public void hideAllKeyBoard() {
        this.hideSystemKeyBoard();
        this.hideKeyboardLayout();
    }

    public int getInputType() {
        return inputType;
    }

    public boolean getKeyboardState() {
        return this.isShow;
    }

    public EditText getEd() {
        return this.ed;
    }

    public void setOtherEdittext(EditText ... edittexts) {
        for (EditText editText : edittexts) {
            editText.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 1) {
                        new Handler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                KeyboardUtil.this.hideKeyboardLayout();
                            }
                        }, 300L);
                        KeyboardUtil.this.ed = (EditText)v;
                        KeyboardUtil.this.hideKeyboardLayout();
                    }
                    return false;
                }
            });
        }
    }

    private void changeKey() {
        List keylist = abcKeyboard.getKeys();
        if (this.isUpper) {
            this.isUpper = false;
            for (Keyboard.Key key : keylist) {
                if (key.label == null || !this.isword(key.label.toString())) continue;
                key.label = key.label.toString().toLowerCase();
                key.codes[0] = key.codes[0] + 32;
            }
        } else {
            this.isUpper = true;
            for (Keyboard.Key key : keylist) {
                if (key.label == null || !this.isword(key.label.toString())) continue;
                key.label = key.label.toString().toUpperCase();
                key.codes[0] = key.codes[0] - 32;
            }
        }
    }

    public void showKeyboard() {
        if (this.keyboardView != null) {
            this.keyboardView.setVisibility(8);
        }
        this.initInputType();
        this.isShow = true;
        this.keyboardView.setVisibility(0);
    }

    private void initKeyBoard(int keyBoardViewID) {
        this.mActivity = (Activity)this.mContext;
        this.keyboardView = (PpKeyBoardView)this.mRootView.findViewById(keyBoardViewID);
        this.keyboardView.setEnabled(true);
        this.keyboardView.setOnKeyboardActionListener(this.listener);
        this.keyboardView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return event.getAction() == 2;
            }
        });
    }

    private Keyboard.Key getCodes(int i) {
        return (Keyboard.Key)this.keyboardView.getKeyboard().getKeys().get(i);
    }

    private void initInputType() {
        switch (inputType) {
            case 1: {
                this.initKeyBoard(R.id.keyboard_view);
                this.keyboardView.setPreviewEnabled(false);
                numKeyboard = new Keyboard(this.mContext, R.xml.symbols);
                this.setMyKeyBoard(numKeyboard);
                break;
            }
            case 2: {
                this.initKeyBoard(R.id.keyboard_view);
                this.keyboardView.setPreviewEnabled(false);
                numKeyboard = new Keyboard(this.mContext, R.xml.symbols_finish);
                this.setMyKeyBoard(numKeyboard);
                break;
            }
            case 3: {
                this.initKeyBoard(R.id.keyboard_view);
                this.keyboardView.setPreviewEnabled(false);
                numKeyboard = new Keyboard(this.mContext, R.xml.symbols_point);
                this.setMyKeyBoard(numKeyboard);
                break;
            }
            case 4: {
                this.initKeyBoard(R.id.keyboard_view);
                this.keyboardView.setPreviewEnabled(false);
                numKeyboard = new Keyboard(this.mContext, R.xml.symbols_x);
                this.setMyKeyBoard(numKeyboard);
                break;
            }
            case 5: {
                this.initKeyBoard(R.id.keyboard_view);
                this.keyboardView.setPreviewEnabled(false);
                numKeyboard = new Keyboard(this.mContext, R.xml.symbols_next);
                this.setMyKeyBoard(numKeyboard);
                break;
            }
            case 6: {
                this.initKeyBoard(R.id.keyboard_view_abc_sym);
                this.keyboardView.setPreviewEnabled(true);
                abcKeyboard = new Keyboard(this.mContext, R.xml.symbols_abc);
                this.setMyKeyBoard(abcKeyboard);
                break;
            }
            case 7: {
                this.initKeyBoard(R.id.keyboard_view_abc_sym);
                this.keyboardView.setPreviewEnabled(true);
                symbolKeyboard = new Keyboard(this.mContext, R.xml.symbols_symbol);
                this.setMyKeyBoard(symbolKeyboard);
                break;
            }
            case 8: {
                this.initKeyBoard(R.id.keyboard_view);
                this.keyboardView.setPreviewEnabled(false);
                numKeyboard = new Keyboard(this.mContext, R.xml.symbols_num_abc);
                this.setMyKeyBoard(numKeyboard);
            }
        }
    }

    private void setMyKeyBoard(Keyboard newkeyboard) {
        keyboard = newkeyboard;
        this.keyboardView.setKeyboard(newkeyboard);
    }

    public void hideKeyboardLayout() {
        if (this.getKeyboardState()) {
            if (this.keyBoardLayout != null) {
                this.keyBoardLayout.setVisibility(8);
            }
            if (this.keyBoardStateChangeListener != null) {
                this.keyBoardStateChangeListener.KeyBoardStateChange(2, this.ed);
            }
            this.isShow = false;
            this.isUpper = false;
            this.hideKeyboard();
            this.ed = null;
        }
    }

    public void showKeyBoardLayout(final EditText editText, int keyBoardType) {
        if (editText.equals(this.ed) && this.getKeyboardState() && inputType == keyBoardType) {
            return;
        }
        inputType = keyBoardType;
        if (this.keyBoardLayout != null && this.keyBoardLayout.getVisibility() == 0) {
            Log.d((String)"KeyboardUtil", (String)"visible");
        }
        if (this.setKeyBoardCursorNew(editText)) {
            this.showHandler = new Handler();
            this.showHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    KeyboardUtil.this.show(editText);
                }
            }, 400L);
        } else {
            this.show(editText);
        }
    }

    private void show(EditText editText) {
        this.ed = editText;
        if (this.keyBoardLayout != null) {
            this.keyBoardLayout.setVisibility(0);
        }
        this.showKeyboard();
        if (this.keyBoardStateChangeListener != null) {
            this.keyBoardStateChangeListener.KeyBoardStateChange(1, editText);
        }
    }

    private void hideKeyboard() {
        int visibility;
        this.isShow = false;
        if (this.keyboardView != null && (visibility = this.keyboardView.getVisibility()) == 0) {
            this.keyboardView.setVisibility(4);
        }
        if (this.layoutView != null) {
            this.layoutView.setVisibility(8);
        }
    }

    private boolean isword(String str) {
        String wordstr = "abcdefghijklmnopqrstuvwxyz";
        return wordstr.indexOf(str.toLowerCase()) > -1;
    }

    public void setKeyBoardStateChangeListener(KeyBoardStateChangeListener listener) {
        this.keyBoardStateChangeListener = listener;
    }

    static {
        inputType = 1;
    }

    public static interface KeyBoardStateChangeListener {
        public void KeyBoardStateChange(int var1, EditText var2);
    }

    public static interface InputFinishListener {
        public void inputHasOver(int var1, EditText var2);
    }

    class finishListener
    implements View.OnClickListener {
        finishListener() {
        }

        public void onClick(View v) {
            KeyboardUtil.this.hideKeyboardLayout();
        }
    }
}

