/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootShell;

import android.util.Log;
import com.stericson.RootShell.exceptions.RootDeniedException;
import com.stericson.RootShell.execution.Command;
import com.stericson.RootShell.execution.Shell;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class RootShell {
    public static boolean debugMode = false;
    public static final String version = "RootShell v1.6";
    public static boolean handlerEnabled = true;
    public static int defaultCommandTimeout = 20000;

    public static void closeAllShells() throws IOException {
        Shell.closeAll();
    }

    public static void closeCustomShell() throws IOException {
        Shell.closeCustomShell();
    }

    public static void closeShell(boolean root) throws IOException {
        if (root) {
            Shell.closeRootShell();
        } else {
            Shell.closeShell();
        }
    }

    public static boolean exists(String file) {
        return RootShell.exists(file, false);
    }

    public static boolean exists(String file, boolean isDir) {
        final ArrayList result = new ArrayList();
        String cmdToExecute = "ls " + (isDir ? "-d " : " ");
        Command command = new Command(0, false, new String[]{cmdToExecute + file}){

            @Override
            public void commandOutput(int id, String line) {
                RootShell.log(line);
                result.add(line);
                super.commandOutput(id, line);
            }
        };
        try {
            RootShell.getShell(false).add(command);
            RootShell.commandWait(RootShell.getShell(false), command);
        }
        catch (Exception e) {
            RootShell.log("Exception: " + e);
            return false;
        }
        for (String line : result) {
            if (!line.trim().equals(file)) continue;
            return true;
        }
        result.clear();
        command = new Command(0, false, new String[]{cmdToExecute + file}){

            @Override
            public void commandOutput(int id, String line) {
                RootShell.log(line);
                result.add(line);
                super.commandOutput(id, line);
            }
        };
        try {
            RootShell.getShell(true).add(command);
            RootShell.commandWait(RootShell.getShell(true), command);
        }
        catch (Exception e) {
            RootShell.log("Exception: " + e);
            return false;
        }
        ArrayList final_result = new ArrayList();
        final_result.addAll(result);
        for (String line : final_result) {
            if (!line.trim().equals(file)) continue;
            return true;
        }
        return false;
    }

    public static List<String> findBinary(String binaryName, boolean singlePath) {
        return RootShell.findBinary(binaryName, null, singlePath);
    }

    public static List<String> findBinary(final String binaryName, List<String> searchPaths, boolean singlePath) {
        final ArrayList<String> foundPaths = new ArrayList<String>();
        boolean found = false;
        if (searchPaths == null) {
            searchPaths = RootShell.getPath();
        }
        RootShell.log("Checking for " + binaryName);
        try {
            for (String path : searchPaths) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                final String currentPath = path;
                Command cc = new Command(0, false, new String[]{"stat " + path + binaryName}){

                    @Override
                    public void commandOutput(int id, String line) {
                        if (line.contains("File: ") && line.contains(binaryName)) {
                            foundPaths.add(currentPath);
                            RootShell.log(binaryName + " was found here: " + currentPath);
                        }
                        RootShell.log(line);
                        super.commandOutput(id, line);
                    }
                };
                cc = RootShell.getShell(false).add(cc);
                RootShell.commandWait(RootShell.getShell(false), cc);
                if (foundPaths.size() <= 0 || !singlePath) continue;
                break;
            }
            found = !foundPaths.isEmpty();
        }
        catch (Exception e) {
            RootShell.log(binaryName + " was not found, more information MAY be available with Debugging on.");
        }
        if (!found) {
            RootShell.log("Trying second method");
            for (String path : searchPaths) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if (RootShell.exists(path + binaryName)) {
                    RootShell.log(binaryName + " was found here: " + path);
                    foundPaths.add(path);
                    if (foundPaths.size() <= 0 || !singlePath) continue;
                    break;
                }
                RootShell.log(binaryName + " was NOT found here: " + path);
            }
        }
        Collections.reverse(foundPaths);
        return foundPaths;
    }

    public static Shell getCustomShell(String shellPath, int timeout) throws IOException, TimeoutException, RootDeniedException {
        return RootShell.getCustomShell(shellPath, timeout);
    }

    public static List<String> getPath() {
        return Arrays.asList(System.getenv("PATH").split(":"));
    }

    public static Shell getShell(boolean root, int timeout, Shell.ShellContext shellContext, int retry) throws IOException, TimeoutException, RootDeniedException {
        if (root) {
            return Shell.startRootShell(timeout, shellContext, retry);
        }
        return Shell.startShell(timeout);
    }

    public static Shell getShell(boolean root, int timeout, Shell.ShellContext shellContext) throws IOException, TimeoutException, RootDeniedException {
        return RootShell.getShell(root, timeout, shellContext, 3);
    }

    public static Shell getShell(boolean root, Shell.ShellContext shellContext) throws IOException, TimeoutException, RootDeniedException {
        return RootShell.getShell(root, 0, shellContext, 3);
    }

    public static Shell getShell(boolean root, int timeout) throws IOException, TimeoutException, RootDeniedException {
        return RootShell.getShell(root, timeout, Shell.defaultContext, 3);
    }

    public static Shell getShell(boolean root) throws IOException, TimeoutException, RootDeniedException {
        return RootShell.getShell(root, 0);
    }

    public static boolean isAccessGiven() {
        return RootShell.isAccessGiven(0, 3);
    }

    public static boolean isAccessGiven(int timeout, int retries) {
        final HashSet ID = new HashSet();
        int IAG = 158;
        try {
            RootShell.log("Checking for Root access");
            Command command = new Command(158, false, new String[]{"id"}){

                @Override
                public void commandOutput(int id, String line) {
                    if (id == 158) {
                        ID.addAll(Arrays.asList(line.split(" ")));
                    }
                    super.commandOutput(id, line);
                }
            };
            Shell shell = Shell.startRootShell(timeout, retries);
            shell.add(command);
            RootShell.commandWait(shell, command);
            for (String userid : ID) {
                RootShell.log(userid);
                if (!userid.toLowerCase().contains("uid=0")) continue;
                RootShell.log("Access Given");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isBusyboxAvailable() {
        return RootShell.isBusyboxAvailable(false);
    }

    public static boolean isBusyboxAvailable(boolean includeToybox) {
        if (includeToybox) {
            return RootShell.findBinary("busybox", true).size() > 0 || RootShell.findBinary("toybox", true).size() > 0;
        }
        return RootShell.findBinary("busybox", true).size() > 0;
    }

    public static boolean isRootAvailable() {
        return RootShell.findBinary("su", true).size() > 0;
    }

    public static void log(String msg) {
        RootShell.log(null, msg, LogLevel.DEBUG, null);
    }

    public static void log(String TAG, String msg) {
        RootShell.log(TAG, msg, LogLevel.DEBUG, null);
    }

    public static void log(String msg, LogLevel type, Exception e) {
        RootShell.log(null, msg, type, e);
    }

    public static boolean islog() {
        return debugMode;
    }

    public static void log(String TAG, String msg, LogLevel type, Exception e) {
        if (msg != null && !msg.equals("") && debugMode) {
            if (TAG == null) {
                TAG = version;
            }
            switch (type) {
                case VERBOSE: {
                    Log.v((String)TAG, (String)msg);
                    break;
                }
                case ERROR: {
                    Log.e((String)TAG, (String)msg, (Throwable)e);
                    break;
                }
                case DEBUG: {
                    Log.d((String)TAG, (String)msg);
                    break;
                }
                case WARN: {
                    Log.w((String)TAG, (String)msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commandWait(Shell shell, Command cmd) throws Exception {
        while (!cmd.isFinished()) {
            Exception e;
            RootShell.log(version, shell.getCommandQueuePositionString(cmd));
            RootShell.log(version, "Processed " + cmd.totalOutputProcessed + " of " + cmd.totalOutput + " output from command.");
            Command command = cmd;
            synchronized (command) {
                try {
                    if (!cmd.isFinished()) {
                        cmd.wait(2000L);
                    }
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            if (cmd.isExecuting() || cmd.isFinished()) continue;
            if (!shell.isExecuting && !shell.isReading) {
                RootShell.log(version, "Waiting for a command to be executed in a shell that is not executing and not reading! \n\n Command: " + cmd.getCommand());
                e = new Exception();
                e.setStackTrace(Thread.currentThread().getStackTrace());
                e.printStackTrace();
                continue;
            }
            if (shell.isExecuting && !shell.isReading) {
                RootShell.log(version, "Waiting for a command to be executed in a shell that is executing but not reading! \n\n Command: " + cmd.getCommand());
                e = new Exception();
                e.setStackTrace(Thread.currentThread().getStackTrace());
                e.printStackTrace();
                continue;
            }
            RootShell.log(version, "Waiting for a command to be executed in a shell that is not reading! \n\n Command: " + cmd.getCommand());
            e = new Exception();
            e.setStackTrace(Thread.currentThread().getStackTrace());
            e.printStackTrace();
        }
    }

    public static enum LogLevel {
        VERBOSE,
        ERROR,
        DEBUG,
        WARN;

    }
}

