/*
 * Decompiled with CFR 0.152.
 */
package net.steppschuh.markdowngenerator;

import java.util.Arrays;
import net.steppschuh.markdowngenerator.MarkdownElement;
import net.steppschuh.markdowngenerator.MarkdownSerializable;
import net.steppschuh.markdowngenerator.MarkdownSerializationException;
import net.steppschuh.markdowngenerator.image.Image;
import net.steppschuh.markdowngenerator.link.Link;
import net.steppschuh.markdowngenerator.list.ListBuilder;
import net.steppschuh.markdowngenerator.list.TaskList;
import net.steppschuh.markdowngenerator.list.TaskListItem;
import net.steppschuh.markdowngenerator.list.UnorderedList;
import net.steppschuh.markdowngenerator.progress.ProgressBar;
import net.steppschuh.markdowngenerator.rule.HorizontalRule;
import net.steppschuh.markdowngenerator.text.Text;
import net.steppschuh.markdowngenerator.text.code.Code;
import net.steppschuh.markdowngenerator.text.code.CodeBlockBuilder;
import net.steppschuh.markdowngenerator.text.emphasis.BoldText;
import net.steppschuh.markdowngenerator.text.emphasis.ItalicText;
import net.steppschuh.markdowngenerator.text.emphasis.StrikeThroughText;
import net.steppschuh.markdowngenerator.text.heading.Heading;
import net.steppschuh.markdowngenerator.text.quote.Quote;
import net.steppschuh.markdowngenerator.text.quote.QuoteBuilder;

public abstract class MarkdownBuilder<T extends MarkdownBuilder<T, S>, S extends MarkdownElement>
implements MarkdownSerializable {
    protected S markdownElement = this.createMarkdownElement();
    protected MarkdownBuilder parentBuilder;

    public MarkdownBuilder() {
    }

    protected MarkdownBuilder(MarkdownBuilder parentBuilder) {
        this();
        this.parentBuilder = parentBuilder;
    }

    protected abstract T getBuilder();

    protected abstract S createMarkdownElement();

    public MarkdownBuilder begin(MarkdownBuilder markdownBuilder) {
        markdownBuilder.setParentBuilder(this);
        return markdownBuilder;
    }

    public MarkdownBuilder end() {
        if (this.parentBuilder == null) {
            return this;
        }
        this.parentBuilder.append(this);
        return this.parentBuilder;
    }

    public T text(Object value) {
        return this.append(new Text(value));
    }

    public T bold(Object value) {
        return this.append(new BoldText(value));
    }

    public T italic(Object value) {
        return this.append(new ItalicText(value));
    }

    public T strikeThrough(Object value) {
        return this.append(new StrikeThroughText(value));
    }

    public T heading(String value, int level) {
        this.newParagraphIfRequired();
        this.append(new Heading(value, level));
        return this.newParagraph();
    }

    public T heading(String value) {
        return this.heading(value, 1);
    }

    public T subHeading(String value) {
        return this.heading(value, 2);
    }

    public T rule() {
        this.newLinesIfRequired(1);
        this.append(new HorizontalRule());
        return this.newLine();
    }

    public T rule(int length) {
        this.newLinesIfRequired(1);
        this.append(new HorizontalRule(length));
        return this.newLine();
    }

    public T link(String text, String url) {
        return this.append(new Link(text, url));
    }

    public T link(String url) {
        return this.append(new Link(url));
    }

    public T image(String text, String url) {
        return this.append(new Image(text, url));
    }

    public T image(String url) {
        return this.append(new Image(url));
    }

    public T progress(double progress) {
        return this.append(new ProgressBar(progress));
    }

    public T progressWithLabel(double progress) {
        ProgressBar progressBar = new ProgressBar(progress);
        progressBar.setAppendPercentage(true);
        return this.append(progressBar);
    }

    public QuoteBuilder beginQuote() {
        this.newParagraphIfRequired();
        return new QuoteBuilder(this);
    }

    public T quote(String value) {
        this.newParagraphIfRequired();
        this.append(new Quote(value));
        return this.newParagraph();
    }

    public CodeBlockBuilder beginCodeBlock(String language) {
        this.newParagraphIfRequired();
        return new CodeBlockBuilder(this, language);
    }

    public CodeBlockBuilder beginCodeBlock() {
        this.newParagraphIfRequired();
        return this.beginCodeBlock("");
    }

    public T code(Object value) {
        return this.append(new Code(value));
    }

    public ListBuilder beginList() {
        return new ListBuilder(this);
    }

    public T unorderedList(Object ... items) {
        this.newLinesIfRequired(1);
        this.append(new UnorderedList<Object>(Arrays.asList(items)));
        return this.newParagraph();
    }

    public T taskList(TaskListItem ... items) {
        this.newLinesIfRequired(1);
        this.append(new TaskList(Arrays.asList(items)));
        return this.newParagraph();
    }

    public abstract T append(Object var1);

    public T append(MarkdownSerializable value) {
        try {
            return this.append(value.toMarkdownElement().getSerialized());
        }
        catch (MarkdownSerializationException e) {
            return this.append(value);
        }
    }

    public T newParagraph() {
        return this.newLines(2);
    }

    protected T newParagraphIfRequired() {
        if (!this.endsWithLineSeparators(2)) {
            this.newParagraph();
        }
        return this.getBuilder();
    }

    public T newLine() {
        return this.newLines(1);
    }

    public T newLines(int count) {
        for (int i = 0; i < count; ++i) {
            this.append(System.lineSeparator());
        }
        return this.getBuilder();
    }

    protected T newLinesIfRequired(int count) {
        if (!this.endsWithLineSeparators(1)) {
            this.newLines(count);
        }
        return this.getBuilder();
    }

    protected boolean endsWithLineSeparators(int count) {
        String separators = "";
        for (int i = 0; i < count; ++i) {
            separators = separators + System.lineSeparator();
        }
        return ((MarkdownElement)this.markdownElement).getSerialized("").endsWith(separators);
    }

    public String toString() {
        return ((MarkdownElement)this.build()).getSerialized(this.getClass().getSimpleName());
    }

    @Override
    public MarkdownElement toMarkdownElement() throws MarkdownSerializationException {
        return this.build();
    }

    public S build() {
        return this.markdownElement;
    }

    public MarkdownBuilder getParentBuilder() {
        return this.parentBuilder;
    }

    public void setParentBuilder(MarkdownBuilder parentBuilder) {
        this.parentBuilder = parentBuilder;
    }
}

