/*
 * Decompiled with CFR 0.152.
 */
package com.sunzn.banner.library;

import android.arch.lifecycle.LifecycleOwner;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.PagerSnapHelper;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.sunzn.banner.library.BannerBaseView;
import com.sunzn.banner.library.BannerLayoutManager;
import com.sunzn.banner.library.R;
import java.util.ArrayList;
import java.util.List;

public class Banner<T>
extends BannerBaseView {
    private final String TAG = "Banner";
    private static final int DEFAULT_GAIN_COLOR = -1;
    private static final int DEFAULT_MISS_COLOR = 0x50FFFFFF;
    private final Object mLock = new Object();
    private boolean mAttached;
    private int mIndicatorMargin;
    private int mIndicatorGravity;
    private RecyclerView mRecyclerView;
    private LinearLayout mLinearLayout;
    private BannerAdapter mBannerAdapter;
    private Handler mHandler = new Handler();
    private boolean isPlaying;
    private boolean mIsIndicatorShow;
    IntentFilter mFilter = new IntentFilter();
    private List<T> mData = new ArrayList<T>();
    private OnItemBindListener<T> mOnItemBindListener;
    private OnItemClickListener<T> mOnItemClickListener;
    private Drawable mIndicatorGainDrawable;
    private Drawable mIndicatorMissDrawable;
    private int mInterval;
    private int mCurrentIndex;
    private int mIndicatorSize;
    private int mIndicatorSpace;
    private Runnable mBannerTask = new Runnable(){

        @Override
        public void run() {
            if (Banner.this.isPlaying) {
                int firstPos = ((BannerLayoutManager)Banner.this.mRecyclerView.getLayoutManager()).findFirstVisibleItemPosition();
                if (firstPos >= Banner.this.mCurrentIndex) {
                    Banner.this.mRecyclerView.smoothScrollToPosition(++Banner.this.mCurrentIndex);
                    Banner.this.switchIndicator();
                    Banner.this.mHandler.postDelayed((Runnable)this, (long)Banner.this.mInterval);
                } else {
                    Banner.this.mHandler.postDelayed((Runnable)this, (long)(Banner.this.mInterval * 2));
                }
            }
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.USER_PRESENT".equals(action)) {
                Banner.this.setPlaying(true);
            } else if ("android.intent.action.SCREEN_OFF".equals(action)) {
                Banner.this.setPlaying(false);
            } else if ("android.intent.action.SCREEN_ON".equals(action)) {
                Banner.this.setPlaying(true);
            }
        }
    };

    public Banner(Context context) {
        this(context, null);
    }

    public Banner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Banner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Banner);
        Drawable GainDrawable = attributes.getDrawable(R.styleable.Banner_indicator_gain);
        Drawable MissDrawable = attributes.getDrawable(R.styleable.Banner_indicator_miss);
        this.mIndicatorGravity = attributes.getInt(R.styleable.Banner_indicator_gravity, 1);
        this.mIsIndicatorShow = attributes.getBoolean(R.styleable.Banner_indicator_show, true);
        float mInch = attributes.getFloat(R.styleable.Banner_banner_inch, 100.0f);
        this.mInterval = attributes.getInt(R.styleable.Banner_banner_interval, 3000);
        this.mIndicatorSize = attributes.getDimensionPixelSize(R.styleable.Banner_indicator_size, 0);
        this.mIndicatorSpace = attributes.getDimensionPixelSize(R.styleable.Banner_indicator_space, this.dp2px(4));
        this.mIndicatorMargin = attributes.getDimensionPixelSize(R.styleable.Banner_indicator_margin, this.dp2px(8));
        this.mIndicatorGainDrawable = GainDrawable == null ? this.getDefaultDrawable(-1) : (GainDrawable instanceof ColorDrawable ? this.getDefaultDrawable(GainDrawable) : GainDrawable);
        this.mIndicatorMissDrawable = MissDrawable == null ? this.getDefaultDrawable(0x50FFFFFF) : (MissDrawable instanceof ColorDrawable ? this.getDefaultDrawable(MissDrawable) : MissDrawable);
        switch (this.mIndicatorGravity) {
            case 0: {
                this.mIndicatorGravity = 0x800003;
                break;
            }
            case 1: {
                this.mIndicatorGravity = 17;
                break;
            }
            case 2: {
                this.mIndicatorGravity = 0x800005;
            }
        }
        attributes.recycle();
        this.mRecyclerView = new RecyclerView(context);
        this.mLinearLayout = new LinearLayout(context);
        this.mFilter.addAction("android.intent.action.SCREEN_ON");
        this.mFilter.addAction("android.intent.action.SCREEN_OFF");
        this.mFilter.addAction("android.intent.action.USER_PRESENT");
        new PagerSnapHelper().attachToRecyclerView(this.mRecyclerView);
        this.mBannerAdapter = new BannerAdapter();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mBannerAdapter);
        this.mRecyclerView.setOverScrollMode(2);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new BannerLayoutManager(context, 0, false, mInch));
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                int ePos;
                int sPos;
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0 && (sPos = ((BannerLayoutManager)recyclerView.getLayoutManager()).findFirstVisibleItemPosition()) == (ePos = ((BannerLayoutManager)recyclerView.getLayoutManager()).findLastVisibleItemPosition()) && Banner.this.mCurrentIndex != ePos) {
                    Banner.this.mCurrentIndex = ePos;
                    Banner.this.switchIndicator();
                }
            }
        });
        FrameLayout.LayoutParams recyclerViewParams = new FrameLayout.LayoutParams(-1, -1);
        FrameLayout.LayoutParams linearLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        linearLayoutParams.gravity = 0x50 | this.mIndicatorGravity;
        linearLayoutParams.setMargins(this.mIndicatorMargin, this.mIndicatorMargin, this.mIndicatorMargin, this.mIndicatorMargin);
        this.mLinearLayout.setOrientation(0);
        this.mLinearLayout.setGravity(17);
        this.addView((View)this.mRecyclerView, (ViewGroup.LayoutParams)recyclerViewParams);
        this.addView((View)this.mLinearLayout, (ViewGroup.LayoutParams)linearLayoutParams);
    }

    private Drawable getDefaultDrawable(Drawable drawable) {
        return this.getDefaultDrawable(((ColorDrawable)drawable).getColor());
    }

    private Drawable getDefaultDrawable(int color) {
        GradientDrawable gradient = new GradientDrawable();
        gradient.setSize(this.dp2px(6), this.dp2px(6));
        gradient.setCornerRadius((float)this.dp2px(6));
        gradient.setColor(color);
        return gradient;
    }

    public void setDefaultGainColor(int color) {
        this.mIndicatorGainDrawable = this.getDefaultDrawable(color);
    }

    public void setDefaultMissColor(int color) {
        this.mIndicatorMissDrawable = this.getDefaultDrawable(color);
    }

    public void setIndicatorGravity(int gravity) {
        this.mIndicatorGravity = gravity;
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mLinearLayout.getLayoutParams();
        params.gravity = 0x50 | this.mIndicatorGravity;
        this.mLinearLayout.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setIndicatorMargin(int margin) {
        this.mIndicatorMargin = this.dp2px(margin);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mLinearLayout.getLayoutParams();
        params.setMargins(this.mIndicatorMargin, this.mIndicatorMargin, this.mIndicatorMargin, this.mIndicatorMargin);
        this.mLinearLayout.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void createIndicators() {
        if (this.mLinearLayout != null) {
            if (this.mIsIndicatorShow) {
                this.mLinearLayout.removeAllViews();
                this.mLinearLayout.setVisibility(0);
                for (int i = 0; i < (this.mData == null ? 0 : this.mData.size()); ++i) {
                    AppCompatImageView img = new AppCompatImageView(this.getContext());
                    LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
                    lp.leftMargin = this.mIndicatorSpace / 2;
                    lp.rightMargin = this.mIndicatorSpace / 2;
                    if (this.mIndicatorSize >= this.dp2px(4)) {
                        lp.width = lp.height = this.mIndicatorSize;
                    } else {
                        img.setMinimumWidth(this.dp2px(2));
                        img.setMinimumHeight(this.dp2px(2));
                    }
                    img.setImageDrawable(i == 0 ? this.mIndicatorGainDrawable : this.mIndicatorMissDrawable);
                    this.mLinearLayout.addView((View)img, (ViewGroup.LayoutParams)lp);
                }
            } else {
                this.mLinearLayout.removeAllViews();
                this.mLinearLayout.setVisibility(8);
            }
        }
    }

    private void switchIndicator() {
        if (this.mIsIndicatorShow && this.mLinearLayout != null && this.mLinearLayout.getChildCount() > 0) {
            for (int i = 0; i < this.mLinearLayout.getChildCount(); ++i) {
                if (this.mData == null || this.mData.size() <= 0) continue;
                ((AppCompatImageView)this.mLinearLayout.getChildAt(i)).setImageDrawable(i == this.mCurrentIndex % this.mData.size() ? this.mIndicatorGainDrawable : this.mIndicatorMissDrawable);
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.setPlaying(false);
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.setPlaying(true);
                break;
            }
            case 3: {
                this.setPlaying(true);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.e((String)"Banner", (String)"Banner onAttachedToWindow");
        this.setPlaying(true);
        this.regReceiver();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Log.e((String)"Banner", (String)"Banner onDetachedFromWindow");
        this.setPlaying(false);
        this.unrReceiver();
    }

    @Override
    public void onResume(@NonNull LifecycleOwner owner) {
        super.onResume(owner);
        this.setPlaying(true);
    }

    @Override
    public void onPause(@NonNull LifecycleOwner owner) {
        super.onPause(owner);
        this.setPlaying(false);
    }

    public void setBannerData(List<T> data) {
        this.setPlaying(false);
        if (data != null && data.size() > 0) {
            if (data.size() > 1) {
                this.mData.clear();
                this.mData.addAll(data);
                this.mIsIndicatorShow = true;
                this.mCurrentIndex = this.mData.size() * 100000;
                this.mBannerAdapter.notifyDataSetChanged();
                this.mRecyclerView.scrollToPosition(this.mCurrentIndex);
                this.createIndicators();
                this.setPlaying(true);
            } else {
                this.mData.clear();
                this.mCurrentIndex = 0;
                this.mData.addAll(data);
                this.mIsIndicatorShow = false;
                this.mBannerAdapter.notifyDataSetChanged();
                this.createIndicators();
            }
        }
    }

    public void scrollToCurrentPosition() {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.scrollToPosition(this.mCurrentIndex);
            this.switchIndicator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaying(boolean playing) {
        Object object = this.mLock;
        synchronized (object) {
            if (playing) {
                this.playBanner();
            } else {
                this.stopBanner();
            }
        }
    }

    public void playBanner() {
        if (this.mHandler != null && !this.isPlaying && this.mBannerAdapter.getItemCount() > 1) {
            this.isPlaying = true;
            this.mHandler.removeCallbacks(this.mBannerTask);
            this.mHandler.postDelayed(this.mBannerTask, (long)this.mInterval);
            Log.e((String)"Banner", (String)"Play Banner");
        }
    }

    public void stopBanner() {
        if (this.mHandler != null) {
            this.isPlaying = false;
            this.mHandler.removeCallbacks(this.mBannerTask);
            Log.e((String)"Banner", (String)"Stop Banner");
        }
    }

    public void setOnItemClickListener(OnItemClickListener<T> listener) {
        this.mOnItemClickListener = listener;
    }

    public void setOnItemBindListener(OnItemBindListener<T> listener) {
        this.mOnItemBindListener = listener;
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    private void regReceiver() {
        if (!this.mAttached) {
            this.mAttached = true;
            this.getContext().registerReceiver(this.mReceiver, this.mFilter);
        }
    }

    private void unrReceiver() {
        if (this.mAttached) {
            this.getContext().unregisterReceiver(this.mReceiver);
            this.mAttached = false;
        }
    }

    private static class BannerViewHolder
    extends RecyclerView.ViewHolder {
        ImageView mImageView;

        BannerViewHolder(View itemView) {
            super(itemView);
            this.mImageView = (ImageView)itemView.findViewById(R.id.banner_image_view_id);
        }
    }

    private class BannerAdapter
    extends RecyclerView.Adapter<BannerViewHolder> {
        private BannerAdapter() {
        }

        @NonNull
        public BannerViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            ImageView imageView = new ImageView(parent.getContext());
            RecyclerView.LayoutParams params = new RecyclerView.LayoutParams(-1, -1);
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            imageView.setId(R.id.banner_image_view_id);
            imageView.setLayoutParams((ViewGroup.LayoutParams)params);
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (Banner.this.mOnItemClickListener != null) {
                        Banner.this.mOnItemClickListener.onItemClick(Banner.this.mCurrentIndex % Banner.this.mData.size(), Banner.this.mData.get(Banner.this.mCurrentIndex % Banner.this.mData.size()));
                    }
                }
            });
            return new BannerViewHolder((View)imageView);
        }

        public void onBindViewHolder(@NonNull BannerViewHolder holder, int position) {
            if (Banner.this.mOnItemBindListener != null) {
                Banner.this.mOnItemBindListener.onItemBind(position % Banner.this.mData.size(), Banner.this.mData.get(position % Banner.this.mData.size()), holder.mImageView);
            }
        }

        public int getItemCount() {
            return Banner.this.mData == null ? 0 : (Banner.this.mData.size() < 2 ? Banner.this.mData.size() : Integer.MAX_VALUE);
        }
    }

    public static interface OnItemBindListener<T> {
        public void onItemBind(int var1, T var2, ImageView var3);
    }

    public static interface OnItemClickListener<T> {
        public void onItemClick(int var1, T var2);
    }
}

