/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.tool.image;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import cc.shinichi.library.ImagePreview;
import cc.shinichi.library.R;
import cc.shinichi.library.glide.FileTarget;
import cc.shinichi.library.tool.file.FileUtil;
import cc.shinichi.library.tool.file.SingleMediaScanner;
import cc.shinichi.library.tool.image.ImageUtil;
import cc.shinichi.library.tool.ui.ToastUtil;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DownloadPictureUtil {
    public static void downloadPicture(final Context context, String url) {
        Glide.with((Context)context).downloadOnly().load(url).into((Target)new FileTarget(){

            @Override
            public void onLoadStarted(@Nullable Drawable placeholder) {
                super.onLoadStarted(placeholder);
                ToastUtil.getInstance()._short(context, context.getString(R.string.toast_start_download));
                super.onLoadStarted(placeholder);
            }

            @Override
            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                super.onLoadFailed(errorDrawable);
                ToastUtil.getInstance()._short(context, context.getString(R.string.toast_save_failed));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResourceReady(@NonNull File resource, @Nullable Transition<? super File> transition) {
                super.onResourceReady(resource, transition);
                String downloadFolderName = ImagePreview.getInstance().getFolderName();
                String name = System.currentTimeMillis() + "";
                String mimeType = ImageUtil.getImageTypeWithMime(resource.getAbsolutePath());
                name = name + "." + mimeType;
                if (Build.VERSION.SDK_INT >= 29) {
                    ContentResolver resolver = context.getContentResolver();
                    ContentValues values = new ContentValues();
                    values.put("_display_name", name);
                    values.put("description", name);
                    values.put("mime_type", "image/" + mimeType);
                    values.put("relative_path", Environment.DIRECTORY_PICTURES + "/" + downloadFolderName + "/");
                    Uri insertUri = resolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                    BufferedInputStream inputStream = null;
                    OutputStream os = null;
                    try {
                        inputStream = new BufferedInputStream(new FileInputStream(resource.getAbsolutePath()));
                        if (insertUri != null) {
                            os = resolver.openOutputStream(insertUri);
                        }
                        if (os != null) {
                            int len;
                            byte[] buffer = new byte[4096];
                            while ((len = inputStream.read(buffer)) != -1) {
                                os.write(buffer, 0, len);
                            }
                            os.flush();
                        }
                        ToastUtil.getInstance()._short(context, context.getString(R.string.toast_save_success, new Object[]{Environment.DIRECTORY_PICTURES + "/" + downloadFolderName}));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        ToastUtil.getInstance()._short(context, context.getString(R.string.toast_save_failed));
                    }
                    finally {
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    String path = Environment.getExternalStorageDirectory() + "/" + downloadFolderName + "/";
                    FileUtil.createFileByDeleteOldFile(path + name);
                    boolean result = FileUtil.copyFile(resource, path, name);
                    if (result) {
                        ToastUtil.getInstance()._short(context, context.getString(R.string.toast_save_success, new Object[]{path}));
                        new SingleMediaScanner(context, path.concat(name), new SingleMediaScanner.ScanListener(){

                            @Override
                            public void onScanFinish() {
                            }
                        });
                    } else {
                        ToastUtil.getInstance()._short(context, context.getString(R.string.toast_save_failed));
                    }
                }
            }
        });
    }
}

