/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.glide.cache;

import com.bumptech.glide.load.Key;
import com.bumptech.glide.util.LruCache;
import com.bumptech.glide.util.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SafeKeyGenerator {
    private final LruCache<Key, String> loadIdToSafeHash = new LruCache(1000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSafeKey(Key key) {
        String safeKey;
        LruCache<Key, String> lruCache = this.loadIdToSafeHash;
        synchronized (lruCache) {
            safeKey = (String)this.loadIdToSafeHash.get((Object)key);
        }
        if (safeKey == null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                key.updateDiskCacheKey(messageDigest);
                safeKey = Util.sha256BytesToHex((byte[])messageDigest.digest());
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            lruCache = this.loadIdToSafeHash;
            synchronized (lruCache) {
                this.loadIdToSafeHash.put((Object)key, (Object)safeKey);
            }
        }
        return safeKey;
    }
}

