/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.tool.image;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.exifinterface.media.ExifInterface;
import cc.shinichi.library.tool.ui.PhoneUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010#\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0004J\u0018\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J \u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0002J\u0014\u00100\u001a\u000201*\u0002022\u0006\u00103\u001a\u000204H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcc/shinichi/library/tool/image/ImageUtil;", "", "()V", "TAG", "", "getBitmapDegree", "", "path", "getImageBitmap", "Landroid/graphics/Bitmap;", "srcPath", "degree", "getImageDoubleScale", "", "context", "Landroid/content/Context;", "imagePath", "getImageMaxZoomScale", "getImageTypeWithMime", "getLongImageDoubleZoomScale", "getLongImageFillWidthScale", "getLongImageMaxZoomScale", "getOrientation", "getWideImageDoubleScale", "getWideImageMaxZoomScale", "getWidthHeight", "", "isAnimImageWithMime", "", "url", "isAnimWebp", "isBmpImageWithMime", "isHeifImageWithMime", "isJpegImageWithMime", "isLandscape", "isLongImage", "isPngImageWithMime", "isStaticImage", "isTablet", "isTabletOrLandscape", "isWebpImageWithMime", "isWideImage", "rotateBitmapByDegree", "bm", "zoomBitmap", "bitmap", "width", "height", "refresh", "", "Landroid/net/Uri;", "resolver", "Landroid/content/ContentResolver;", "library_release"})
public final class ImageUtil {
    private static final String TAG = "ImageUtil";
    public static final ImageUtil INSTANCE;

    @RequiresApi(value=29)
    public final void refresh(@NotNull Uri $this$refresh, @NotNull ContentResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)$this$refresh, (String)"$this$refresh");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        ContentValues imageValues = new ContentValues();
        imageValues.put("is_pending", Integer.valueOf(0));
        resolver.update($this$refresh, imageValues, null, null);
    }

    public final int getBitmapDegree(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int degree = 0;
        try {
            int n;
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    n = 90;
                    break;
                }
                case 3: {
                    n = 180;
                    break;
                }
                case 8: {
                    n = 270;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            degree = n;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    private final Bitmap rotateBitmapByDegree(Bitmap bm, int degree) {
        Bitmap returnBm = null;
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        try {
            returnBm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        if (returnBm == null) {
            returnBm = bm;
        }
        if (Intrinsics.areEqual((Object)bm, (Object)returnBm) ^ true) {
            bm.recycle();
        }
        return returnBm;
    }

    private final int getOrientation(String imagePath) {
        try {
            int n;
            ExifInterface exifInterface = new ExifInterface(imagePath);
            switch (exifInterface.getAttributeInt("Orientation", 1)) {
                case 6: {
                    n = 90;
                    break;
                }
                case 3: {
                    n = 180;
                    break;
                }
                case 8: {
                    n = 270;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @NotNull
    public final int[] getWidthHeight(@NotNull String imagePath) {
        int[] nArray;
        int orient;
        Bitmap bitmap2;
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        CharSequence charSequence = imagePath;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return new int[]{0, 0};
        }
        int srcWidth = -1;
        int srcHeight = -1;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            Bitmap originBitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
            srcWidth = options.outWidth;
            srcHeight = options.outHeight;
            if (originBitmap != null && !originBitmap.isRecycled()) {
                originBitmap.recycle();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (srcWidth <= 0 || srcHeight <= 0) {
            try {
                ExifInterface exifInterface = new ExifInterface(imagePath);
                srcHeight = exifInterface.getAttributeInt("ImageLength", 1);
                srcWidth = exifInterface.getAttributeInt("ImageWidth", 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((srcWidth <= 0 || srcHeight <= 0) && (bitmap2 = BitmapFactory.decodeFile((String)imagePath)) != null) {
            srcWidth = bitmap2.getWidth();
            srcHeight = bitmap2.getHeight();
            try {
                if (!bitmap2.isRecycled()) {
                    bitmap2.recycle();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((orient = this.getOrientation(imagePath)) == 90 || orient == 270) {
            int[] nArray2 = new int[2];
            nArray2[0] = srcHeight;
            nArray = nArray2;
            nArray2[1] = srcWidth;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = srcWidth;
            nArray = nArray3;
            nArray3[1] = srcHeight;
        }
        return nArray;
    }

    private final boolean isTablet(Context context) {
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return (resources.getConfiguration().screenLayout & 0xF) >= 3;
    }

    private final boolean isLandscape(Context context) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        float phoneRatio = PhoneUtil.INSTANCE.getPhoneRatio(context2);
        return phoneRatio <= 1.0f;
    }

    public final boolean isTabletOrLandscape(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isTablet(context) | this.isLandscape(context);
    }

    public final boolean isLongImage(@NotNull Context context, @NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        int[] wh = this.getWidthHeight(imagePath);
        float w = wh[0];
        float h = wh[1];
        float imageRatio = h / w;
        float phoneRatio = PhoneUtil.INSTANCE.getPhoneRatio(context);
        boolean isLongImage = h > w && imageRatio > phoneRatio;
        Log.d((String)TAG, (String)("isLongImage = " + isLongImage));
        return isLongImage;
    }

    public final boolean isWideImage(@NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        int[] wh = this.getWidthHeight(imagePath);
        float w = wh[0];
        float h = wh[1];
        float imageRatio = w / h;
        boolean isWideImage = w > h && imageRatio >= (float)2;
        Log.d((String)TAG, (String)("isWideImage = " + isWideImage));
        return isWideImage;
    }

    public final float getImageMaxZoomScale(@NotNull Context context, @NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        int[] wh = this.getWidthHeight(imagePath);
        float imageWid = wh[0];
        float imageHei = wh[1];
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        float phoneHei = PhoneUtil.INSTANCE.getPhoneHei(context2);
        if (imageWid >= (float)2560) {
            return phoneHei * 4.0f / imageHei;
        }
        return phoneHei * 2.0f / imageHei;
    }

    public final float getImageDoubleScale(@NotNull Context context, @NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        int[] wh = this.getWidthHeight(imagePath);
        float imageHei = wh[1];
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        float phoneHei = PhoneUtil.INSTANCE.getPhoneHei(context2);
        return phoneHei / imageHei;
    }

    public final float getLongImageMaxZoomScale(@NotNull Context context, @NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        int[] wh = this.getWidthHeight(imagePath);
        float imageWid = wh[0];
        float imageHei = wh[1];
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        float phoneWid = PhoneUtil.INSTANCE.getPhoneWid(context2);
        float f = imageHei / imageWid;
        float f2 = phoneWid * 2.0f / imageWid;
        boolean bl = false;
        return Math.max(f, f2);
    }

    public final float getLongImageDoubleZoomScale(@NotNull Context context, @NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        int[] wh = this.getWidthHeight(imagePath);
        double imageWid = wh[0];
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        double phoneWid = PhoneUtil.INSTANCE.getPhoneWid(context2);
        return (float)(phoneWid / imageWid);
    }

    public final float getLongImageFillWidthScale(@NotNull Context context, @NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        int[] wh = this.getWidthHeight(imagePath);
        double imageWid = wh[0];
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        double phoneWid = PhoneUtil.INSTANCE.getPhoneWid(context2);
        return (float)(phoneWid / imageWid);
    }

    public final float getWideImageMaxZoomScale(@NotNull Context context, @NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        int[] wh = this.getWidthHeight(imagePath);
        float imageWid = wh[0];
        float imageHei = wh[1];
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        float phoneHei = PhoneUtil.INSTANCE.getPhoneHei(context2);
        float f = imageWid / imageHei;
        float f2 = phoneHei * 2.0f / imageHei;
        boolean bl = false;
        return Math.max(f, f2);
    }

    public final float getWideImageDoubleScale(@NotNull Context context, @NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        int[] wh = this.getWidthHeight(imagePath);
        float imageHei = wh[1];
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        float phoneHei = PhoneUtil.INSTANCE.getPhoneHei(context2);
        return phoneHei / imageHei;
    }

    @Nullable
    public final Bitmap getImageBitmap(@Nullable String srcPath, int degree) {
        int degree2 = degree;
        boolean isOOM = false;
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        float be = 1.0f;
        newOpts.inSampleSize = (int)be;
        newOpts.inPreferredConfig = Bitmap.Config.RGB_565;
        newOpts.inDither = false;
        newOpts.inPurgeable = true;
        newOpts.inInputShareable = true;
        if (bitmap != null && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        try {
            bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
        }
        catch (OutOfMemoryError e) {
            isOOM = true;
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            Runtime.getRuntime().gc();
        }
        catch (Exception e) {
            isOOM = true;
            Runtime.getRuntime().gc();
        }
        if (isOOM) {
            try {
                bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
            }
            catch (Exception e) {
                newOpts.inPreferredConfig = Bitmap.Config.RGB_565;
                bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
            }
        }
        if (bitmap != null) {
            if (degree2 == 90) {
                degree2 += 180;
            }
            bitmap = this.rotateBitmapByDegree(bitmap, degree2);
            int ttHeight = 1080 * bitmap.getHeight() / bitmap.getWidth();
            if (bitmap.getWidth() >= 1080) {
                bitmap = this.zoomBitmap(bitmap, 1080, ttHeight);
            }
        }
        return bitmap;
    }

    private final Bitmap zoomBitmap(Bitmap bitmap, int width, int height) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)width / (float)w;
        float scaleHeight = (float)height / (float)h;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u20260, 0, w, h, matrix, true)");
        return bitmap2;
    }

    @NotNull
    public final String getImageTypeWithMime(@NotNull String path) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        String type = options.outMimeType;
        Log.d((String)TAG, (String)("getImageTypeWithMime: path = " + path + ", type1 = " + type));
        if (TextUtils.isEmpty((CharSequence)type)) {
            string2 = "";
        } else {
            String string3 = type;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"type");
            String string4 = string3;
            int n = 6;
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        }
        type = string2;
        Log.d((String)TAG, (String)("getImageTypeWithMime: path = " + path + ", type2 = " + type));
        return type;
    }

    public final boolean isAnimWebp(@NotNull String url, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!this.isWebpImageWithMime(url, path)) {
            return false;
        }
        boolean result = false;
        BufferedReader br = null;
        String line = null;
        InputStream is = new FileInputStream(path);
        br = new BufferedReader(new InputStreamReader(is));
        int count = 0;
        do {
            String string2 = br.readLine();
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (string2 == null) break;
            if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"ANIM", (boolean)false, (int)2, null)) continue;
            result = true;
        } while (count++ < 5);
        Log.d((String)TAG, (String)("isAnimWebp: result = " + result));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAnimImageWithMime(@NotNull String url, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.equals((String)"gif", (String)this.getImageTypeWithMime(path), (boolean)true)) return true;
        String string2 = url;
        Locale locale = Locale.CHINA;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.CHINA");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (StringsKt.endsWith$default((String)string4, (String)"gif", (boolean)false, (int)2, null)) return true;
        if (!this.isAnimWebp(url, path)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isPngImageWithMime(@NotNull String url, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.equals((String)"png", (String)this.getImageTypeWithMime(path), (boolean)true)) return true;
        String string2 = url;
        Locale locale = Locale.CHINA;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.CHINA");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.endsWith$default((String)string4, (String)"png", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isJpegImageWithMime(@NotNull String url, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.equals((String)"jpeg", (String)this.getImageTypeWithMime(path), (boolean)true)) return true;
        if (StringsKt.equals((String)"jpg", (String)this.getImageTypeWithMime(path), (boolean)true)) return true;
        String string2 = url;
        Locale locale = Locale.CHINA;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.CHINA");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (StringsKt.endsWith$default((String)string4, (String)"jpeg", (boolean)false, (int)2, null)) return true;
        string2 = url;
        Locale locale3 = Locale.CHINA;
        Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"Locale.CHINA");
        locale2 = locale3;
        bl = false;
        string3 = string2;
        bl2 = false;
        String string5 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.endsWith$default((String)string5, (String)"jpg", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBmpImageWithMime(@NotNull String url, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.equals((String)"bmp", (String)this.getImageTypeWithMime(path), (boolean)true)) return true;
        String string2 = url;
        Locale locale = Locale.CHINA;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.CHINA");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.endsWith$default((String)string4, (String)"bmp", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isWebpImageWithMime(@NotNull String url, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.equals((String)"webp", (String)this.getImageTypeWithMime(path), (boolean)true)) return true;
        String string2 = url;
        Locale locale = Locale.CHINA;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.CHINA");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.endsWith$default((String)string4, (String)"webp", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isHeifImageWithMime(@NotNull String url, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.equals((String)"heif", (String)this.getImageTypeWithMime(path), (boolean)true)) return true;
        String string2 = url;
        Locale locale = Locale.CHINA;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.CHINA");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (StringsKt.endsWith$default((String)string4, (String)"heif", (boolean)false, (int)2, null)) return true;
        string2 = url;
        Locale locale3 = Locale.CHINA;
        Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"Locale.CHINA");
        locale2 = locale3;
        bl = false;
        string3 = string2;
        bl2 = false;
        String string5 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.endsWith$default((String)string5, (String)"heic", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isStaticImage(@NotNull String url, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean isWebpImageWithMime = this.isWebpImageWithMime(url, path);
        Log.d((String)TAG, (String)("isStaticImage: isWebpImageWithMime = " + isWebpImageWithMime));
        if (isWebpImageWithMime) {
            boolean animWebp = this.isAnimWebp(url, path);
            Log.d((String)TAG, (String)("isStaticImage: animWebp = " + animWebp));
            return !animWebp;
        }
        boolean jpegImageWithMime = this.isJpegImageWithMime(url, path);
        Log.d((String)TAG, (String)("isStaticImage: jpegImageWithMime = " + jpegImageWithMime));
        boolean pngImageWithMime = this.isPngImageWithMime(url, path);
        Log.d((String)TAG, (String)("isStaticImage: pngImageWithMime = " + pngImageWithMime));
        boolean bmpImageWithMime = this.isBmpImageWithMime(url, path);
        Log.d((String)TAG, (String)("isStaticImage: bmpImageWithMime = " + bmpImageWithMime));
        boolean heifImageWithMime = this.isHeifImageWithMime(url, path);
        Log.d((String)TAG, (String)("isStaticImage: heifImageWithMime = " + heifImageWithMime));
        boolean animImageWithMime = this.isAnimImageWithMime(url, path);
        Log.d((String)TAG, (String)("isStaticImage: animImageWithMime = " + animImageWithMime));
        return (jpegImageWithMime || pngImageWithMime || bmpImageWithMime || heifImageWithMime) && !animImageWithMime;
    }

    private ImageUtil() {
    }

    static {
        ImageUtil imageUtil;
        INSTANCE = imageUtil = new ImageUtil();
    }
}

