/*
 * Decompiled with CFR 0.152.
 */
package com.shashank.sony.fancywalkthroughlib.utils;

import android.support.v4.view.ViewPager;
import android.support.v7.widget.CardView;
import android.view.View;

public class ShadowTransformer
implements ViewPager.OnPageChangeListener,
ViewPager.PageTransformer {
    private ViewPager mViewPager;
    private CardAdapter mAdapter;
    private float mLastOffset;
    private boolean mScalingEnabled;

    public ShadowTransformer(ViewPager viewPager, CardAdapter adapter) {
        this.mViewPager = viewPager;
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mAdapter = adapter;
    }

    public void enableScaling(boolean enable) {
        CardView currentCard;
        if (this.mScalingEnabled && !enable) {
            CardView currentCard2 = this.mAdapter.getCardViewAt(this.mViewPager.getCurrentItem());
            if (currentCard2 != null) {
                currentCard2.animate().scaleY(1.0f);
                currentCard2.animate().scaleX(1.0f);
            }
        } else if (!this.mScalingEnabled && enable && (currentCard = this.mAdapter.getCardViewAt(this.mViewPager.getCurrentItem())) != null) {
            currentCard.animate().scaleY(1.1f);
            currentCard.animate().scaleX(1.1f);
        }
        this.mScalingEnabled = enable;
    }

    public void transformPage(View page, float position) {
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        CardView nextCard;
        float realOffset;
        int nextPosition;
        int realCurrentPosition;
        boolean goingLeft;
        float baseElevation = this.mAdapter.getBaseElevation();
        boolean bl = goingLeft = this.mLastOffset > positionOffset;
        if (goingLeft) {
            realCurrentPosition = position + 1;
            nextPosition = position;
            realOffset = 1.0f - positionOffset;
        } else {
            nextPosition = position + 1;
            realCurrentPosition = position;
            realOffset = positionOffset;
        }
        if (nextPosition > this.mAdapter.getCount() - 1 || realCurrentPosition > this.mAdapter.getCount() - 1) {
            return;
        }
        CardView currentCard = this.mAdapter.getCardViewAt(realCurrentPosition);
        if (currentCard != null) {
            if (this.mScalingEnabled) {
                currentCard.setScaleX((float)(1.0 + 0.1 * (double)(1.0f - realOffset)));
                currentCard.setScaleY((float)(1.0 + 0.1 * (double)(1.0f - realOffset)));
            }
            currentCard.setCardElevation(baseElevation + baseElevation * 5.0f * (1.0f - realOffset));
        }
        if ((nextCard = this.mAdapter.getCardViewAt(nextPosition)) != null) {
            if (this.mScalingEnabled) {
                nextCard.setScaleX((float)(1.0 + 0.1 * (double)realOffset));
                nextCard.setScaleY((float)(1.0 + 0.1 * (double)realOffset));
            }
            nextCard.setCardElevation(baseElevation + baseElevation * 5.0f * realOffset);
        }
        this.mLastOffset = positionOffset;
    }

    public void onPageSelected(int position) {
    }

    public void onPageScrollStateChanged(int state) {
    }

    public static interface CardAdapter {
        public static final int MAX_ELEVATION_FACTOR = 6;

        public float getBaseElevation();

        public CardView getCardViewAt(int var1);

        public int getCount();
    }
}

