/*
 * Decompiled with CFR 0.152.
 */
package com.shashank.sony.fancywalkthroughlib;

import android.graphics.Typeface;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v7.widget.CardView;
import android.util.Log;
import android.view.ViewGroup;
import com.shashank.sony.fancywalkthroughlib.FancyWalkthroughCard;
import com.shashank.sony.fancywalkthroughlib.FancyWalkthroughFragment;
import com.shashank.sony.fancywalkthroughlib.utils.ShadowTransformer;
import java.util.ArrayList;
import java.util.List;

public class FancyWalkthroughAdapter
extends FragmentStatePagerAdapter
implements ShadowTransformer.CardAdapter {
    private String TAG = FancyWalkthroughAdapter.class.getSimpleName();
    List<FancyWalkthroughCard> pages = new ArrayList<FancyWalkthroughCard>();
    private List<FancyWalkthroughFragment> mFragments = new ArrayList<FancyWalkthroughFragment>();
    private float mBaseElevation;
    private Typeface typeface;

    public FancyWalkthroughAdapter(List<FancyWalkthroughCard> pages, FragmentManager fm, float baseElevation, Typeface typeface) {
        super(fm);
        this.pages = pages;
        this.typeface = typeface;
        this.mBaseElevation = baseElevation;
        for (int i = 0; i < pages.size(); ++i) {
            this.addCardFragment(pages.get(i));
        }
    }

    public Fragment getItem(int position) {
        return this.mFragments.get(position);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Object fragment = super.instantiateItem(container, position);
        this.mFragments.set(position, (FancyWalkthroughFragment)((Object)fragment));
        return fragment;
    }

    @Override
    public float getBaseElevation() {
        return this.mBaseElevation;
    }

    @Override
    public CardView getCardViewAt(int position) {
        this.setTypeface(this.typeface, position);
        return this.mFragments.get(position).getCardView();
    }

    public void addCardFragment(FancyWalkthroughCard page) {
        this.mFragments.add(FancyWalkthroughFragment.newInstance(page));
    }

    @Override
    public int getCount() {
        return this.pages.size();
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        super.destroyItem(container, position, object);
    }

    public void setTypeface(Typeface typeface, int i) {
        if (typeface != null) {
            if (this.mFragments.get(i) == null) {
                Log.i((String)this.TAG, (String)"Fragment is null");
                return;
            }
            if (this.mFragments.get(i).getTitleView() == null) {
                Log.i((String)this.TAG, (String)"TitleView is null");
                return;
            }
            if (this.mFragments.get(i).getTitleView() == null) {
                Log.i((String)this.TAG, (String)"DescriptionView is null");
                return;
            }
            this.mFragments.get(i).getTitleView().setTypeface(typeface);
            this.mFragments.get(i).getDescriptionView().setTypeface(typeface);
        }
    }
}

