/*
 * Decompiled with CFR 0.152.
 */
package com.ruffian.library.widget.helper;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewTreeObserver;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import androidx.annotation.StyleableRes;
import androidx.core.text.TextUtilsCompat;
import com.ruffian.library.widget.R;
import com.ruffian.library.widget.clip.ClipHelper;
import com.ruffian.library.widget.clip.ClipPathManager;
import com.ruffian.library.widget.clip.IClip;
import com.ruffian.library.widget.shadow.ShadowBitmapDrawable;
import com.ruffian.library.widget.utils.RippleDrawableUtils;
import java.util.Locale;

public class RBaseHelper<T extends View>
implements IClip,
ViewTreeObserver.OnGlobalLayoutListener {
    protected final int _C = 0;
    protected final int _S = -1;
    protected int BG_TYPE_COLOR = 1;
    protected int BG_TYPE_COLOR_ARRAY = 2;
    protected int BG_TYPE_IMG = 3;
    private float mCornerRadius;
    private float mCornerRadiusTopLeft;
    private float mCornerRadiusTopRight;
    private float mCornerRadiusBottomLeft;
    private float mCornerRadiusBottomRight;
    private float mBorderDashWidth = -1.0f;
    private float mBorderDashGap = -1.0f;
    private int mBorderWidthNormal = -1;
    private int mBorderWidthPressed = -1;
    private int mBorderWidthUnable = -1;
    private int mBorderWidthChecked = -1;
    private int mBorderWidthSelected = -1;
    private int mBorderColorNormal = 0;
    private int mBorderColorPressed = 0;
    private int mBorderColorUnable = 0;
    private int mBorderColorChecked = 0;
    private int mBorderColorSelected = 0;
    private int mBackgroundColorNormal = 0;
    private int mBackgroundColorPressed = 0;
    private int mBackgroundColorUnable = 0;
    private int mBackgroundColorChecked = 0;
    private int mBackgroundColorSelected = 0;
    private int[] mBackgroundColorNormalArray;
    private int[] mBackgroundColorPressedArray;
    private int[] mBackgroundColorUnableArray;
    private int[] mBackgroundColorCheckedArray;
    private int[] mBackgroundColorSelectedArray;
    private GradientDrawable mBackgroundNormal;
    private GradientDrawable mBackgroundPressed;
    private GradientDrawable mBackgroundUnable;
    private GradientDrawable mBackgroundChecked;
    private GradientDrawable mBackgroundSelected;
    private Drawable mBackgroundNormalBmp;
    private Drawable mBackgroundPressedBmp;
    private Drawable mBackgroundUnableBmp;
    private Drawable mBackgroundCheckedBmp;
    private Drawable mBackgroundSelectedBmp;
    private int mGradientType = 0;
    private float mGradientRadius;
    private float mGradientCenterX;
    private float mGradientCenterY;
    private GradientDrawable.Orientation mGradientOrientation = GradientDrawable.Orientation.TOP_BOTTOM;
    private ShadowBitmapDrawable mShadowDrawable;
    private int mShadowDx;
    private int mShadowDy;
    private int mShadowColor;
    private int mShadowRadius;
    private boolean mIsEnabled = true;
    private boolean mUseRipple;
    private int mRippleColor;
    private Drawable mRippleMaskDrawable;
    private int mRippleMaskStyle;
    private final int MASK_STYLE_NULL = 1;
    private final int MASK_STYLE_NORMAL = 2;
    private final int MASK_STYLE_DRAWABLE = 3;
    private Drawable mViewBackground;
    private Drawable mBackgroundDrawable;
    private int[][] states = new int[6][];
    private StateListDrawable mStateBackground;
    private float[] mBorderRadii = new float[8];
    private int mTouchSlop;
    protected Context mContext;
    private boolean mHasPressedBgColor = false;
    private boolean mHasPressedBgBmp = false;
    private boolean mHasUnableBgColor = false;
    private boolean mHasUnableBgBmp = false;
    private boolean mHasCheckedBgColor = false;
    private boolean mHasSelectedBgColor = false;
    private boolean mHasCheckedBgBmp = false;
    private boolean mHasSelectedBgBmp = false;
    private boolean mHasPressedBorderColor = false;
    private boolean mHasUnableBorderColor = false;
    private boolean mHasCheckedBorderColor = false;
    private boolean mHasSelectedBorderColor = false;
    private boolean mHasPressedBorderWidth = false;
    private boolean mHasUnableBorderWidth = false;
    private boolean mHasCheckedBorderWidth = false;
    private boolean mHasSelectedBorderWidth = false;
    protected T mView;
    protected ClipHelper mClipHelper = new ClipHelper();
    private boolean mClipLayout = false;

    public RBaseHelper(Context context, T view, AttributeSet attrs) {
        this.mView = view;
        this.mContext = context;
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.initAttributeSet(context, attrs);
        this.addOnGlobalLayoutListener();
    }

    private void initAttributeSet(Context context, AttributeSet attrs) {
        if (context == null || attrs == null) {
            this.setup();
            return;
        }
        TypedArray a = this.mView.getContext().obtainStyledAttributes(attrs, R.styleable.RBaseView);
        this.mCornerRadius = a.getDimensionPixelSize(R.styleable.RBaseView_corner_radius, -1);
        this.mCornerRadiusTopLeft = a.getDimensionPixelSize(R.styleable.RBaseView_corner_radius_top_left, 0);
        this.mCornerRadiusTopRight = a.getDimensionPixelSize(R.styleable.RBaseView_corner_radius_top_right, 0);
        this.mCornerRadiusBottomLeft = a.getDimensionPixelSize(R.styleable.RBaseView_corner_radius_bottom_left, 0);
        this.mCornerRadiusBottomRight = a.getDimensionPixelSize(R.styleable.RBaseView_corner_radius_bottom_right, 0);
        this.mBorderDashWidth = a.getDimensionPixelSize(R.styleable.RBaseView_border_dash_width, -1);
        this.mBorderDashGap = a.getDimensionPixelSize(R.styleable.RBaseView_border_dash_gap, -1);
        this.mBorderWidthNormal = a.getDimensionPixelSize(R.styleable.RBaseView_border_width_normal, -1);
        this.mBorderWidthPressed = a.getDimensionPixelSize(R.styleable.RBaseView_border_width_pressed, -1);
        this.mBorderWidthUnable = a.getDimensionPixelSize(R.styleable.RBaseView_border_width_unable, -1);
        this.mBorderWidthChecked = a.getDimensionPixelSize(R.styleable.RBaseView_border_width_checked, -1);
        this.mBorderWidthSelected = a.getDimensionPixelSize(R.styleable.RBaseView_border_width_selected, -1);
        this.mBorderColorNormal = a.getColor(R.styleable.RBaseView_border_color_normal, 0);
        this.mBorderColorPressed = a.getColor(R.styleable.RBaseView_border_color_pressed, 0);
        this.mBorderColorUnable = a.getColor(R.styleable.RBaseView_border_color_unable, 0);
        this.mBorderColorChecked = a.getColor(R.styleable.RBaseView_border_color_checked, 0);
        this.mBorderColorSelected = a.getColor(R.styleable.RBaseView_border_color_selected, 0);
        Object[] bgInfoNormal = this.getBackgroundInfo(a, R.styleable.RBaseView_background_normal);
        this.mBackgroundColorNormal = (Integer)bgInfoNormal[1];
        this.mBackgroundColorNormalArray = (int[])bgInfoNormal[2];
        this.mBackgroundNormalBmp = (Drawable)bgInfoNormal[3];
        Object[] bgInfoPressed = this.getBackgroundInfo(a, R.styleable.RBaseView_background_pressed);
        this.mBackgroundColorPressed = (Integer)bgInfoPressed[1];
        this.mBackgroundColorPressedArray = (int[])bgInfoPressed[2];
        this.mBackgroundPressedBmp = (Drawable)bgInfoPressed[3];
        Object[] bgInfoUnable = this.getBackgroundInfo(a, R.styleable.RBaseView_background_unable);
        this.mBackgroundColorUnable = (Integer)bgInfoUnable[1];
        this.mBackgroundColorUnableArray = (int[])bgInfoUnable[2];
        this.mBackgroundUnableBmp = (Drawable)bgInfoUnable[3];
        Object[] bgInfoChecked = this.getBackgroundInfo(a, R.styleable.RBaseView_background_checked);
        this.mBackgroundColorChecked = (Integer)bgInfoChecked[1];
        this.mBackgroundColorCheckedArray = (int[])bgInfoChecked[2];
        this.mBackgroundCheckedBmp = (Drawable)bgInfoChecked[3];
        Object[] bgInfoSelected = this.getBackgroundInfo(a, R.styleable.RBaseView_background_selected);
        this.mBackgroundColorSelected = (Integer)bgInfoSelected[1];
        this.mBackgroundColorSelectedArray = (int[])bgInfoSelected[2];
        this.mBackgroundSelectedBmp = (Drawable)bgInfoSelected[3];
        this.mGradientType = a.getInt(R.styleable.RBaseView_gradient_type, 0);
        this.mGradientOrientation = this.getGradientOrientation(a);
        this.mGradientRadius = a.getDimensionPixelSize(R.styleable.RBaseView_gradient_radius, -1);
        this.mGradientCenterX = a.getFloat(R.styleable.RBaseView_gradient_centerX, 0.5f);
        this.mGradientCenterY = a.getFloat(R.styleable.RBaseView_gradient_centerY, 0.5f);
        this.mIsEnabled = a.getBoolean(R.styleable.RBaseView_enabled, true);
        this.mUseRipple = a.getBoolean(R.styleable.RBaseView_ripple, false);
        this.mRippleColor = a.getColor(R.styleable.RBaseView_ripple_color, -65536);
        this.mRippleMaskDrawable = a.getDrawable(R.styleable.RBaseView_ripple_mask);
        this.mRippleMaskStyle = a.getInt(R.styleable.RBaseView_ripple_mask_style, 2);
        this.mShadowDx = a.getDimensionPixelSize(R.styleable.RBaseView_shadow_dx, 0);
        this.mShadowDy = a.getDimensionPixelSize(R.styleable.RBaseView_shadow_dy, 0);
        this.mShadowColor = a.getColor(R.styleable.RBaseView_shadow_color, -7829368);
        this.mShadowRadius = a.getDimensionPixelSize(R.styleable.RBaseView_shadow_radius, -1);
        this.mClipLayout = a.getBoolean(R.styleable.RBaseView_clip_layout, false);
        a.recycle();
        this.setup();
    }

    private void setup() {
        boolean isEnabled = this.mView.isEnabled();
        if (isEnabled) {
            this.mView.setEnabled(this.mIsEnabled);
        }
        this.mBackgroundNormal = new GradientDrawable();
        this.mBackgroundPressed = new GradientDrawable();
        this.mBackgroundUnable = new GradientDrawable();
        this.mBackgroundChecked = new GradientDrawable();
        this.mBackgroundSelected = new GradientDrawable();
        this.mViewBackground = this.mView.getBackground();
        this.mStateBackground = new StateListDrawable();
        this.states[0] = new int[]{-16842910};
        this.states[1] = new int[]{16842908};
        this.states[2] = new int[]{16842919};
        this.states[3] = new int[]{0x10100A0};
        this.states[4] = new int[]{0x10100A1};
        this.states[5] = new int[]{16842910};
        this.setupDefaultValue(true);
        this.setGradient();
        this.setStateListDrawable();
        this.setBorder();
        this.setRadius();
        this.setBackgroundState();
    }

    private void setupDefaultValue(boolean init) {
        if (init) {
            this.mHasPressedBgColor = this.mBackgroundColorPressed != 0 || this.mBackgroundColorPressedArray != null;
            this.mHasUnableBgColor = this.mBackgroundColorUnable != 0 || this.mBackgroundColorUnableArray != null;
            this.mHasCheckedBgColor = this.mBackgroundColorChecked != 0 || this.mBackgroundColorCheckedArray != null;
            this.mHasSelectedBgColor = this.mBackgroundColorSelected != 0 || this.mBackgroundColorSelectedArray != null;
            this.mHasPressedBgBmp = this.mBackgroundPressedBmp != null;
            this.mHasUnableBgBmp = this.mBackgroundUnableBmp != null;
            this.mHasCheckedBgBmp = this.mBackgroundCheckedBmp != null;
            this.mHasSelectedBgBmp = this.mBackgroundSelectedBmp != null;
            this.mHasPressedBorderColor = this.mBorderColorPressed != 0;
            this.mHasUnableBorderColor = this.mBorderColorUnable != 0;
            this.mHasCheckedBorderColor = this.mBorderColorChecked != 0;
            this.mHasSelectedBorderColor = this.mBorderColorSelected != 0;
            this.mHasPressedBorderWidth = this.mBorderWidthPressed != -1;
            this.mHasUnableBorderWidth = this.mBorderWidthUnable != -1;
            this.mHasCheckedBorderWidth = this.mBorderWidthChecked != -1;
            boolean bl = this.mHasSelectedBorderWidth = this.mBorderWidthSelected != -1;
        }
        if (!this.mHasPressedBgColor) {
            this.mBackgroundColorPressed = this.mBackgroundColorNormal;
            this.mBackgroundColorPressedArray = this.mBackgroundColorNormalArray;
        }
        if (!this.mHasPressedBgBmp) {
            this.mBackgroundPressedBmp = this.mBackgroundNormalBmp;
        }
        if (!this.mHasUnableBgColor) {
            this.mBackgroundColorUnable = this.mBackgroundColorNormal;
            this.mBackgroundColorUnableArray = this.mBackgroundColorNormalArray;
        }
        if (!this.mHasUnableBgBmp) {
            this.mBackgroundUnableBmp = this.mBackgroundNormalBmp;
        }
        if (!this.mHasCheckedBgColor) {
            this.mBackgroundColorChecked = this.mBackgroundColorNormal;
            this.mBackgroundColorCheckedArray = this.mBackgroundColorNormalArray;
        }
        if (!this.mHasSelectedBgColor) {
            this.mBackgroundColorSelected = this.mBackgroundColorNormal;
            this.mBackgroundColorSelectedArray = this.mBackgroundColorNormalArray;
        }
        if (!this.mHasCheckedBgBmp) {
            this.mBackgroundCheckedBmp = this.mBackgroundNormalBmp;
        }
        if (!this.mHasSelectedBgBmp) {
            this.mBackgroundSelectedBmp = this.mBackgroundNormalBmp;
        }
        this.mBackgroundNormal = this.mBackgroundColorNormalArray != null && this.mBackgroundColorNormalArray.length > 0 ? this.setColors(this.mBackgroundNormal, this.mBackgroundColorNormalArray) : this.setColors(this.mBackgroundNormal, new int[]{this.mBackgroundColorNormal, this.mBackgroundColorNormal});
        this.mBackgroundPressed = this.mBackgroundColorPressedArray != null && this.mBackgroundColorPressedArray.length > 0 ? this.setColors(this.mBackgroundPressed, this.mBackgroundColorPressedArray) : this.setColors(this.mBackgroundPressed, new int[]{this.mBackgroundColorPressed, this.mBackgroundColorPressed});
        this.mBackgroundUnable = this.mBackgroundColorUnableArray != null && this.mBackgroundColorUnableArray.length > 0 ? this.setColors(this.mBackgroundUnable, this.mBackgroundColorUnableArray) : this.setColors(this.mBackgroundUnable, new int[]{this.mBackgroundColorUnable, this.mBackgroundColorUnable});
        this.mBackgroundChecked = this.mBackgroundColorCheckedArray != null && this.mBackgroundColorCheckedArray.length > 0 ? this.setColors(this.mBackgroundChecked, this.mBackgroundColorCheckedArray) : this.setColors(this.mBackgroundChecked, new int[]{this.mBackgroundColorChecked, this.mBackgroundColorChecked});
        this.mBackgroundSelected = this.mBackgroundColorSelectedArray != null && this.mBackgroundColorSelectedArray.length > 0 ? this.setColors(this.mBackgroundSelected, this.mBackgroundColorSelectedArray) : this.setColors(this.mBackgroundSelected, new int[]{this.mBackgroundColorSelected, this.mBackgroundColorSelected});
        if (!this.mHasPressedBorderWidth) {
            this.mBorderWidthPressed = this.mBorderWidthNormal;
        }
        if (!this.mHasUnableBorderWidth) {
            this.mBorderWidthUnable = this.mBorderWidthNormal;
        }
        if (!this.mHasCheckedBorderWidth) {
            this.mBorderWidthChecked = this.mBorderWidthNormal;
        }
        if (!this.mHasSelectedBorderWidth) {
            this.mBorderWidthSelected = this.mBorderWidthNormal;
        }
        if (!this.mHasPressedBorderColor) {
            this.mBorderColorPressed = this.mBorderColorNormal;
        }
        if (!this.mHasUnableBorderColor) {
            this.mBorderColorUnable = this.mBorderColorNormal;
        }
        if (!this.mHasCheckedBorderColor) {
            this.mBorderColorChecked = this.mBorderColorNormal;
        }
        if (!this.mHasSelectedBorderColor) {
            this.mBorderColorSelected = this.mBorderColorNormal;
        }
    }

    public float getGradientRadius() {
        return this.mGradientRadius;
    }

    public float getGradientCenterX() {
        return this.mGradientCenterX;
    }

    public float getGradientCenterY() {
        return this.mGradientCenterY;
    }

    public int getGradientType() {
        return this.mGradientType;
    }

    public RBaseHelper setGradientRadius(float gradientRadius) {
        this.mGradientRadius = gradientRadius;
        this.setGradient();
        this.setBackgroundState();
        return this;
    }

    public RBaseHelper setGradientCenterX(float gradientCenterX) {
        this.mGradientCenterX = gradientCenterX;
        this.setGradient();
        this.setBackgroundState();
        return this;
    }

    public RBaseHelper setGradientCenterY(float gradientCenterY) {
        this.mGradientCenterY = gradientCenterY;
        this.setGradient();
        this.setBackgroundState();
        return this;
    }

    public RBaseHelper setGradientType(int gradientType) {
        if (gradientType < 0 || gradientType > 2) {
            gradientType = 0;
        }
        this.mGradientType = gradientType;
        this.setGradient();
        this.setBackgroundState();
        return this;
    }

    public RBaseHelper setGradientOrientation(GradientDrawable.Orientation orientation) {
        this.mGradientOrientation = orientation;
        this.setGradient();
        this.setBackgroundState();
        return this;
    }

    private void setGradient() {
        this.mBackgroundNormal.setGradientType(this.mGradientType);
        this.mBackgroundNormal.setGradientRadius(this.mGradientRadius);
        this.mBackgroundNormal.setGradientCenter(this.mGradientCenterX, this.mGradientCenterY);
        this.mBackgroundPressed.setGradientType(this.mGradientType);
        this.mBackgroundPressed.setGradientRadius(this.mGradientRadius);
        this.mBackgroundPressed.setGradientCenter(this.mGradientCenterX, this.mGradientCenterY);
        this.mBackgroundUnable.setGradientType(this.mGradientType);
        this.mBackgroundUnable.setGradientRadius(this.mGradientRadius);
        this.mBackgroundUnable.setGradientCenter(this.mGradientCenterX, this.mGradientCenterY);
        this.mBackgroundChecked.setGradientType(this.mGradientType);
        this.mBackgroundChecked.setGradientRadius(this.mGradientRadius);
        this.mBackgroundChecked.setGradientCenter(this.mGradientCenterX, this.mGradientCenterY);
        this.mBackgroundSelected.setGradientType(this.mGradientType);
        this.mBackgroundSelected.setGradientRadius(this.mGradientRadius);
        this.mBackgroundSelected.setGradientCenter(this.mGradientCenterX, this.mGradientCenterY);
    }

    public RBaseHelper setStateBackgroundColor(@ColorInt int normal, @ColorInt int pressed, @ColorInt int unable, @ColorInt int checked, @ColorInt int selected) {
        this.mBackgroundColorNormal = normal;
        this.mBackgroundColorPressed = pressed;
        this.mBackgroundColorUnable = unable;
        this.mBackgroundColorChecked = checked;
        this.mBackgroundColorSelected = selected;
        this.mBackgroundColorNormalArray = null;
        this.mBackgroundColorPressedArray = null;
        this.mBackgroundColorUnableArray = null;
        this.mBackgroundColorCheckedArray = null;
        this.mBackgroundColorSelectedArray = null;
        this.mBackgroundNormalBmp = null;
        this.mBackgroundPressedBmp = null;
        this.mBackgroundSelectedBmp = null;
        this.mBackgroundCheckedBmp = null;
        this.mHasPressedBgColor = true;
        this.mHasCheckedBgColor = true;
        this.mHasSelectedBgColor = true;
        this.mHasUnableBgColor = true;
        this.mHasPressedBgBmp = false;
        this.mHasCheckedBgBmp = false;
        this.mHasSelectedBgBmp = false;
        this.mHasUnableBgBmp = false;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setStateBackgroundColorArray(int[] normalArray, int[] pressedArray, int[] unableArray, int[] checkedArray, int[] selectedArray) {
        this.mBackgroundColorNormalArray = normalArray;
        this.mBackgroundColorPressedArray = pressedArray;
        this.mBackgroundColorUnableArray = unableArray;
        this.mBackgroundColorCheckedArray = checkedArray;
        this.mBackgroundColorSelectedArray = selectedArray;
        this.mBackgroundColorNormal = 0;
        this.mBackgroundColorPressed = 0;
        this.mBackgroundColorUnable = 0;
        this.mBackgroundColorChecked = 0;
        this.mBackgroundColorSelected = 0;
        this.mBackgroundNormalBmp = null;
        this.mBackgroundPressedBmp = null;
        this.mBackgroundSelectedBmp = null;
        this.mBackgroundCheckedBmp = null;
        this.mHasPressedBgColor = true;
        this.mHasCheckedBgColor = true;
        this.mHasSelectedBgColor = true;
        this.mHasUnableBgColor = true;
        this.mHasPressedBgBmp = false;
        this.mHasCheckedBgBmp = false;
        this.mHasSelectedBgBmp = false;
        this.mHasUnableBgBmp = false;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setStateBackgroundColor(Drawable normal, Drawable pressed, Drawable unable, Drawable checked, Drawable selected) {
        this.mBackgroundNormalBmp = normal;
        this.mBackgroundPressedBmp = pressed;
        this.mBackgroundUnableBmp = unable;
        this.mBackgroundCheckedBmp = checked;
        this.mBackgroundSelectedBmp = selected;
        this.mBackgroundColorNormalArray = null;
        this.mBackgroundColorPressedArray = null;
        this.mBackgroundColorUnableArray = null;
        this.mBackgroundColorCheckedArray = null;
        this.mBackgroundColorSelectedArray = null;
        this.mBackgroundColorNormal = 0;
        this.mBackgroundColorPressed = 0;
        this.mBackgroundColorUnable = 0;
        this.mBackgroundColorChecked = 0;
        this.mBackgroundColorSelected = 0;
        this.mHasPressedBgColor = false;
        this.mHasCheckedBgColor = false;
        this.mHasSelectedBgColor = false;
        this.mHasUnableBgColor = false;
        this.mHasPressedBgBmp = true;
        this.mHasCheckedBgBmp = true;
        this.mHasSelectedBgBmp = true;
        this.mHasUnableBgBmp = true;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundColorNormal(@ColorInt int colorNormal) {
        this.mBackgroundColorNormal = colorNormal;
        this.mBackgroundColorNormalArray = null;
        this.mBackgroundNormalBmp = null;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundColorNormalArray(int[] colorNormalArray) {
        this.mBackgroundColorNormalArray = colorNormalArray;
        this.mBackgroundColorNormal = 0;
        this.mBackgroundNormalBmp = null;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundDrawableNormal(Drawable drawableNormal) {
        this.mBackgroundNormalBmp = drawableNormal;
        this.mBackgroundColorNormalArray = null;
        this.mBackgroundColorNormal = 0;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundColorPressed(@ColorInt int colorPressed) {
        this.mBackgroundColorPressed = colorPressed;
        this.mBackgroundColorPressedArray = null;
        this.mBackgroundPressedBmp = null;
        this.mHasPressedBgColor = true;
        this.mHasPressedBgBmp = false;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundColorPressedArray(int[] colorPressedArray) {
        this.mBackgroundColorPressedArray = colorPressedArray;
        this.mBackgroundColorPressed = 0;
        this.mBackgroundPressedBmp = null;
        this.mHasPressedBgColor = true;
        this.mHasPressedBgBmp = false;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundDrawablePressed(Drawable drawablePressed) {
        this.mBackgroundPressedBmp = drawablePressed;
        this.mBackgroundColorPressedArray = null;
        this.mBackgroundColorPressed = 0;
        this.mHasPressedBgColor = false;
        this.mHasPressedBgBmp = true;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundColorUnable(@ColorInt int colorUnable) {
        this.mBackgroundColorUnable = colorUnable;
        this.mBackgroundColorUnableArray = null;
        this.mBackgroundUnableBmp = null;
        this.mHasUnableBgColor = true;
        this.mHasUnableBgBmp = false;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundDrawableUnable(Drawable drawableUnable) {
        this.mBackgroundUnableBmp = drawableUnable;
        this.mBackgroundColorUnable = 0;
        this.mBackgroundColorUnableArray = null;
        this.mHasUnableBgColor = false;
        this.mHasUnableBgBmp = true;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundColorUnableArray(int[] colorUnableArray) {
        this.mBackgroundColorUnableArray = colorUnableArray;
        this.mBackgroundColorUnable = 0;
        this.mBackgroundUnableBmp = null;
        this.mHasUnableBgColor = true;
        this.mHasUnableBgBmp = false;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundColorChecked(@ColorInt int colorChecked) {
        this.mBackgroundColorChecked = colorChecked;
        this.mBackgroundColorCheckedArray = null;
        this.mBackgroundCheckedBmp = null;
        this.mHasCheckedBgColor = true;
        this.mHasCheckedBgBmp = false;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundColorSelected(@ColorInt int colorSelected) {
        this.mBackgroundColorSelected = colorSelected;
        this.mBackgroundColorSelectedArray = null;
        this.mBackgroundSelectedBmp = null;
        this.mHasSelectedBgColor = true;
        this.mHasSelectedBgBmp = false;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundColorCheckedArray(int[] colorCheckedArray) {
        this.mBackgroundColorCheckedArray = colorCheckedArray;
        this.mBackgroundColorChecked = 0;
        this.mBackgroundCheckedBmp = null;
        this.mHasCheckedBgColor = true;
        this.mHasCheckedBgBmp = false;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundColorSelectedArray(int[] colorSelectedArray) {
        this.mBackgroundColorSelectedArray = colorSelectedArray;
        this.mBackgroundColorSelected = 0;
        this.mBackgroundSelectedBmp = null;
        this.mHasSelectedBgColor = true;
        this.mHasSelectedBgBmp = false;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundDrawableChecked(Drawable drawableChecked) {
        this.mBackgroundCheckedBmp = drawableChecked;
        this.mBackgroundColorChecked = 0;
        this.mBackgroundColorCheckedArray = null;
        this.mHasCheckedBgColor = false;
        this.mHasCheckedBgBmp = true;
        this.updateBackgroundValue();
        return this;
    }

    public RBaseHelper setBackgroundDrawableSelected(Drawable drawableSelected) {
        this.mBackgroundSelectedBmp = drawableSelected;
        this.mBackgroundColorSelected = 0;
        this.mBackgroundColorSelectedArray = null;
        this.mHasSelectedBgColor = false;
        this.mHasSelectedBgBmp = true;
        this.updateBackgroundValue();
        return this;
    }

    public int getBackgroundColorNormal() {
        return this.mBackgroundColorNormal;
    }

    public int getBackgroundColorPressed() {
        return this.mBackgroundColorPressed;
    }

    public int getBackgroundColorUnable() {
        return this.mBackgroundColorUnable;
    }

    public int getBackgroundColorChecked() {
        return this.mBackgroundColorChecked;
    }

    public int getBackgroundColorSelected() {
        return this.mBackgroundColorSelected;
    }

    public int[] getBackgroundColorNormalArray() {
        return this.mBackgroundColorNormalArray;
    }

    public int[] getBackgroundColorPressedArray() {
        return this.mBackgroundColorPressedArray;
    }

    public int[] getBackgroundColorUnableArray() {
        return this.mBackgroundColorUnableArray;
    }

    public int[] getBackgroundColorCheckedArray() {
        return this.mBackgroundColorCheckedArray;
    }

    public int[] getBackgroundColorSelectedArray() {
        return this.mBackgroundColorSelectedArray;
    }

    public Drawable getBackgroundDrawableNormal() {
        return this.mBackgroundNormalBmp;
    }

    public Drawable getBackgroundDrawablePressed() {
        return this.mBackgroundPressedBmp;
    }

    public Drawable getBackgroundDrawableUnable() {
        return this.mBackgroundUnableBmp;
    }

    public Drawable getBackgroundDrawableChecked() {
        return this.mBackgroundCheckedBmp;
    }

    public Drawable getBackgroundDrawableSelected() {
        return this.mBackgroundSelectedBmp;
    }

    private void updateBackgroundValue() {
        this.setupDefaultValue(false);
        this.setStateListDrawable();
        this.setBackgroundState();
    }

    private void setStateListDrawable() {
        this.mStateBackground = new StateListDrawable();
        if (this.mBackgroundUnableBmp == null) {
            this.mStateBackground.addState(this.states[0], (Drawable)this.mBackgroundUnable);
        } else {
            this.mStateBackground.addState(this.states[0], this.mBackgroundUnableBmp);
        }
        if (this.mBackgroundPressedBmp == null) {
            this.mStateBackground.addState(this.states[1], (Drawable)this.mBackgroundPressed);
        } else {
            this.mStateBackground.addState(this.states[1], this.mBackgroundPressedBmp);
        }
        if (this.mBackgroundPressedBmp == null) {
            this.mStateBackground.addState(this.states[2], (Drawable)this.mBackgroundPressed);
        } else {
            this.mStateBackground.addState(this.states[2], this.mBackgroundPressedBmp);
        }
        if (this.mBackgroundCheckedBmp == null) {
            this.mStateBackground.addState(this.states[3], (Drawable)this.mBackgroundChecked);
        } else {
            this.mStateBackground.addState(this.states[3], this.mBackgroundCheckedBmp);
        }
        if (this.mBackgroundSelectedBmp == null) {
            this.mStateBackground.addState(this.states[4], (Drawable)this.mBackgroundSelected);
        } else {
            this.mStateBackground.addState(this.states[4], this.mBackgroundSelectedBmp);
        }
        if (this.mBackgroundNormalBmp == null) {
            this.mStateBackground.addState(this.states[5], (Drawable)this.mBackgroundNormal);
        } else {
            this.mStateBackground.addState(this.states[5], this.mBackgroundNormalBmp);
        }
    }

    private void setBackgroundState() {
        boolean hasCustom = false;
        boolean hasCusBorder = false;
        boolean hasCusCorner = false;
        boolean unHasBgColor = this.mBackgroundColorNormal == 0 && this.mBackgroundColorUnable == 0 && this.mBackgroundColorPressed == 0 && this.mBackgroundColorChecked == 0 && this.mBackgroundColorSelected == 0;
        boolean unHasBgColorArray = this.mBackgroundColorNormalArray == null && this.mBackgroundColorUnableArray == null && this.mBackgroundColorPressedArray == null && this.mBackgroundColorCheckedArray == null && this.mBackgroundColorSelectedArray == null;
        boolean unHasBgDrawable = this.mBackgroundNormalBmp == null && this.mBackgroundPressedBmp == null && this.mBackgroundUnableBmp == null && this.mBackgroundCheckedBmp == null && this.mBackgroundSelectedBmp == null;
        boolean hasCusBg = !unHasBgColor || !unHasBgColorArray || !unHasBgDrawable;
        if (this.mBorderDashWidth != -1.0f || this.mBorderDashGap != -1.0f || this.mBorderWidthNormal != -1 || this.mBorderWidthPressed != -1 || this.mBorderWidthUnable != -1 || this.mBorderWidthChecked != -1 || this.mBorderWidthSelected != -1 || this.mBorderColorNormal != 0 || this.mBorderColorPressed != 0 || this.mBorderColorUnable != 0 || this.mBorderColorChecked != 0 || this.mBorderColorSelected != 0) {
            hasCusBorder = true;
        }
        if (this.mCornerRadius != -1.0f || this.mCornerRadiusTopLeft != 0.0f || this.mCornerRadiusTopRight != 0.0f || this.mCornerRadiusBottomLeft != 0.0f || this.mCornerRadiusBottomRight != 0.0f) {
            hasCusCorner = true;
        }
        if (hasCusBg || hasCusCorner || hasCusBorder) {
            hasCustom = true;
        }
        if (!(hasCustom || this.useShadow() || this.useRipple())) {
            this.mBackgroundDrawable = this.mViewBackground;
        } else {
            this.mBackgroundDrawable = this.getBackgroundDrawable(hasCustom, this.mRippleColor);
            if (this.useShadow()) {
                if (this.mShadowDrawable == null) {
                    this.mShadowDrawable = new ShadowBitmapDrawable();
                }
                this.mShadowDrawable.updateParameter(this.mShadowColor, this.mShadowRadius, this.mShadowDx, this.mShadowDy, this.mBorderRadii);
                int left = this.mShadowRadius + Math.abs(this.mShadowDx);
                int right = this.mShadowRadius + Math.abs(this.mShadowDx);
                int top = this.mShadowRadius + Math.abs(this.mShadowDy);
                int bottom = this.mShadowRadius + Math.abs(this.mShadowDy);
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mShadowDrawable, this.mBackgroundDrawable});
                layerDrawable.setLayerInset(1, left, top, right, bottom);
                this.mBackgroundDrawable = layerDrawable;
            }
        }
        if (Build.VERSION.SDK_INT < 16) {
            this.mView.setBackgroundDrawable(this.mBackgroundDrawable);
        } else {
            this.mView.setBackground(this.mBackgroundDrawable);
        }
    }

    private Drawable getBackgroundDrawable(boolean hasCustom, int rippleColor) {
        if (!this.isUseRipple()) {
            return this.mStateBackground;
        }
        Object[] objects = this.getRippleDrawableWithTag(hasCustom, rippleColor);
        RippleDrawable rippleDrawable = (RippleDrawable)objects[0];
        boolean isMaskNull = (Boolean)objects[1];
        if (isMaskNull) {
            return rippleDrawable;
        }
        StateListDrawable stateBackground = new StateListDrawable();
        int[][] states = new int[][]{{-16842910}, {0x10100A0}, {0x10100A1}, {16842910}};
        if (this.mBackgroundUnableBmp == null) {
            stateBackground.addState(states[0], (Drawable)this.mBackgroundUnable);
        } else {
            stateBackground.addState(states[0], this.mBackgroundUnableBmp);
        }
        if (this.mBackgroundCheckedBmp == null) {
            stateBackground.addState(states[1], (Drawable)this.mBackgroundChecked);
        } else {
            stateBackground.addState(states[1], this.mBackgroundCheckedBmp);
        }
        if (this.mBackgroundSelectedBmp == null) {
            stateBackground.addState(states[2], (Drawable)this.mBackgroundSelected);
        } else {
            stateBackground.addState(states[2], this.mBackgroundSelectedBmp);
        }
        stateBackground.addState(states[3], (Drawable)rippleDrawable);
        return stateBackground;
    }

    @RequiresApi(api=21)
    private Object[] getRippleDrawableWithTag(boolean hasCustom, int rippleColor) {
        Object contentDrawable = null;
        if (hasCustom) {
            contentDrawable = this.mBackgroundNormalBmp == null ? this.mBackgroundNormal : this.mBackgroundNormalBmp;
        }
        Drawable maskDrawable = null;
        switch (this.mRippleMaskStyle) {
            case 1: {
                maskDrawable = null;
                break;
            }
            case 2: {
                if (hasCustom) {
                    if (this.mBackgroundNormalBmp != null) {
                        maskDrawable = this.mBackgroundNormalBmp;
                        break;
                    }
                    RoundRectShape roundShape = new RoundRectShape(this.mBorderRadii, null, null);
                    ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundShape);
                    maskDrawable = shapeDrawable;
                    break;
                }
                maskDrawable = new ShapeDrawable((Shape)new RectShape());
                break;
            }
            case 3: {
                maskDrawable = this.mRippleMaskDrawable;
            }
        }
        int[][] stateList = new int[][]{{16842919}, {16842908}, {16843518}, new int[0]};
        int[] stateColorList = new int[]{rippleColor, rippleColor, rippleColor, rippleColor};
        ColorStateList colorStateList = new ColorStateList((int[][])stateList, stateColorList);
        RippleDrawable rippleDrawable = new RippleDrawableUtils(contentDrawable, maskDrawable).getRippleDrawable(colorStateList);
        boolean isMaskNull = contentDrawable == null && maskDrawable == null;
        return new Object[]{rippleDrawable, isMaskNull};
    }

    public boolean useShadow() {
        return this.mShadowRadius >= 0;
    }

    public RBaseHelper setShadowRadius(int shadowRadius) {
        this.mShadowRadius = shadowRadius;
        this.setBackgroundState();
        return this;
    }

    public int getShadowRadius() {
        return this.mShadowRadius;
    }

    public RBaseHelper setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
        this.setBackgroundState();
        return this;
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public RBaseHelper setShadowDx(int shadowDx) {
        this.mShadowDx = shadowDx;
        this.setBackgroundState();
        return this;
    }

    public int getShadowDx() {
        return this.mShadowDx;
    }

    public RBaseHelper setShadowDy(int shadowDy) {
        this.mShadowDy = shadowDy;
        this.setBackgroundState();
        return this;
    }

    public int getShadowDy() {
        return this.mShadowDy;
    }

    public RBaseHelper setUseRipple(boolean useRipple) {
        this.mUseRipple = useRipple;
        this.setBackgroundState();
        return this;
    }

    public boolean useRipple() {
        return this.mUseRipple;
    }

    public RBaseHelper setRippleColor(@ColorInt int rippleColor) {
        this.mRippleColor = rippleColor;
        this.mUseRipple = true;
        this.setBackgroundState();
        return this;
    }

    public int getRippleColor() {
        return this.mRippleColor;
    }

    public RBaseHelper setRippleMaskDrawable(Drawable rippleMaskDrawable) {
        this.mRippleMaskDrawable = rippleMaskDrawable;
        this.mUseRipple = true;
        this.mRippleMaskStyle = 3;
        this.setBackgroundState();
        return this;
    }

    public Drawable getRippleMaskDrawable() {
        return this.mRippleMaskDrawable;
    }

    public RBaseHelper setBorderWidthNormal(int width) {
        this.mBorderWidthNormal = width;
        this.updateBorderValue();
        return this;
    }

    public int getBorderWidthNormal() {
        return this.mBorderWidthNormal;
    }

    public RBaseHelper setBorderColorNormal(@ColorInt int color) {
        this.mBorderColorNormal = color;
        this.updateBorderValue();
        return this;
    }

    public int getBorderColorNormal() {
        return this.mBorderColorNormal;
    }

    public RBaseHelper setBorderWidthPressed(int width) {
        this.mBorderWidthPressed = width;
        this.mHasPressedBorderWidth = true;
        this.updateBorderValue();
        return this;
    }

    public int getBorderWidthPressed() {
        return this.mBorderWidthPressed;
    }

    public RBaseHelper setBorderColorPressed(@ColorInt int color) {
        this.mBorderColorPressed = color;
        this.mHasPressedBorderColor = true;
        this.updateBorderValue();
        return this;
    }

    public int getBorderColorPressed() {
        return this.mBorderColorPressed;
    }

    public RBaseHelper setBorderColorChecked(@ColorInt int color) {
        this.mBorderColorChecked = color;
        this.mHasCheckedBorderColor = true;
        this.updateBorderValue();
        return this;
    }

    public int getBorderColorChecked() {
        return this.mBorderColorChecked;
    }

    public RBaseHelper setBorderColorSelected(@ColorInt int color) {
        this.mBorderColorSelected = color;
        this.mHasSelectedBorderColor = true;
        this.updateBorderValue();
        return this;
    }

    public int getBorderColorSelected() {
        return this.mBorderColorSelected;
    }

    public RBaseHelper setBorderWidthChecked(int width) {
        this.mBorderWidthChecked = width;
        this.mHasCheckedBorderWidth = true;
        this.updateBorderValue();
        return this;
    }

    public int getBorderWidthChecked() {
        return this.mBorderWidthChecked;
    }

    public RBaseHelper setBorderWidthSelected(int width) {
        this.mBorderWidthSelected = width;
        this.mHasSelectedBorderWidth = true;
        this.updateBorderValue();
        return this;
    }

    public int getBorderWidthSelected() {
        return this.mBorderWidthSelected;
    }

    public RBaseHelper setBorderWidthUnable(int width) {
        this.mBorderWidthUnable = width;
        this.mHasUnableBorderWidth = true;
        this.updateBorderValue();
        return this;
    }

    public int getBorderWidthUnable() {
        return this.mBorderWidthUnable;
    }

    public RBaseHelper setBorderColorUnable(@ColorInt int color) {
        this.mBorderColorUnable = color;
        this.mHasUnableBorderColor = true;
        this.updateBorderValue();
        return this;
    }

    public int getBorderColorUnable() {
        return this.mBorderColorUnable;
    }

    public RBaseHelper setBorderWidth(int normal, int pressed, int unable, int checked, int selected) {
        this.mBorderWidthNormal = normal;
        this.mBorderWidthPressed = pressed;
        this.mBorderWidthUnable = unable;
        this.mBorderWidthChecked = checked;
        this.mBorderWidthSelected = selected;
        this.mHasPressedBorderWidth = true;
        this.mHasUnableBorderWidth = true;
        this.mHasCheckedBorderWidth = true;
        this.mHasSelectedBorderWidth = true;
        this.updateBorderValue();
        return this;
    }

    public RBaseHelper setBorderColor(@ColorInt int normal, @ColorInt int pressed, @ColorInt int unable, @ColorInt int checked, @ColorInt int selected) {
        this.mBorderColorNormal = normal;
        this.mBorderColorPressed = pressed;
        this.mBorderColorUnable = unable;
        this.mBorderColorChecked = checked;
        this.mBorderColorSelected = selected;
        this.mHasPressedBorderColor = true;
        this.mHasUnableBorderColor = true;
        this.mHasCheckedBorderColor = true;
        this.mHasSelectedBorderColor = true;
        this.updateBorderValue();
        return this;
    }

    public RBaseHelper setBorderDashWidth(float dashWidth) {
        this.mBorderDashWidth = dashWidth;
        this.updateBorderValue();
        return this;
    }

    public float getBorderDashWidth() {
        return this.mBorderDashWidth;
    }

    public RBaseHelper setBorderDashGap(float dashGap) {
        this.mBorderDashGap = dashGap;
        this.updateBorderValue();
        return this;
    }

    public float getBorderDashGap() {
        return this.mBorderDashGap;
    }

    public RBaseHelper setBorderDash(float dashWidth, float dashGap) {
        this.mBorderDashWidth = dashWidth;
        this.mBorderDashGap = dashGap;
        this.updateBorderValue();
        return this;
    }

    private void setBorder() {
        this.mBackgroundNormal.setStroke(this.mBorderWidthNormal, this.mBorderColorNormal, this.mBorderDashWidth, this.mBorderDashGap);
        this.mBackgroundPressed.setStroke(this.mBorderWidthPressed, this.mBorderColorPressed, this.mBorderDashWidth, this.mBorderDashGap);
        this.mBackgroundUnable.setStroke(this.mBorderWidthUnable, this.mBorderColorUnable, this.mBorderDashWidth, this.mBorderDashGap);
        this.mBackgroundChecked.setStroke(this.mBorderWidthChecked, this.mBorderColorChecked, this.mBorderDashWidth, this.mBorderDashGap);
        this.mBackgroundSelected.setStroke(this.mBorderWidthSelected, this.mBorderColorSelected, this.mBorderDashWidth, this.mBorderDashGap);
    }

    private void updateBorderValue() {
        this.setupDefaultValue(false);
        this.setBorder();
        this.setBackgroundState();
    }

    public void setCornerRadius(float radius) {
        this.mCornerRadius = radius;
        this.updateRadiusValue();
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    public RBaseHelper setCornerRadiusTopLeft(float topLeft) {
        this.mCornerRadius = -1.0f;
        this.mCornerRadiusTopLeft = topLeft;
        this.updateRadiusValue();
        return this;
    }

    public float getCornerRadiusTopLeft() {
        return this.mCornerRadiusTopLeft;
    }

    public RBaseHelper setCornerRadiusTopRight(float topRight) {
        this.mCornerRadius = -1.0f;
        this.mCornerRadiusTopRight = topRight;
        this.updateRadiusValue();
        return this;
    }

    public float getCornerRadiusTopRight() {
        return this.mCornerRadiusTopRight;
    }

    public RBaseHelper setCornerRadiusBottomRight(float bottomRight) {
        this.mCornerRadius = -1.0f;
        this.mCornerRadiusBottomRight = bottomRight;
        this.updateRadiusValue();
        return this;
    }

    public float getCornerRadiusBottomRight() {
        return this.mCornerRadiusBottomRight;
    }

    public RBaseHelper setCornerRadiusBottomLeft(float bottomLeft) {
        this.mCornerRadius = -1.0f;
        this.mCornerRadiusBottomLeft = bottomLeft;
        this.updateRadiusValue();
        return this;
    }

    public float getCornerRadiusBottomLeft() {
        return this.mCornerRadiusBottomLeft;
    }

    public RBaseHelper setCornerRadius(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        this.mCornerRadius = -1.0f;
        this.mCornerRadiusTopLeft = topLeft;
        this.mCornerRadiusTopRight = topRight;
        this.mCornerRadiusBottomRight = bottomRight;
        this.mCornerRadiusBottomLeft = bottomLeft;
        this.updateRadiusValue();
        return this;
    }

    private void updateRadiusValue() {
        this.setRadius();
        this.setBackgroundState();
    }

    private void setRadius() {
        if (this.mCornerRadius >= 0.0f) {
            this.mBorderRadii[0] = this.mCornerRadius;
            this.mBorderRadii[1] = this.mCornerRadius;
            this.mBorderRadii[2] = this.mCornerRadius;
            this.mBorderRadii[3] = this.mCornerRadius;
            this.mBorderRadii[4] = this.mCornerRadius;
            this.mBorderRadii[5] = this.mCornerRadius;
            this.mBorderRadii[6] = this.mCornerRadius;
            this.mBorderRadii[7] = this.mCornerRadius;
        } else {
            boolean isRtl = RBaseHelper.isRtl();
            this.mBorderRadii[0] = isRtl ? this.mCornerRadiusTopRight : this.mCornerRadiusTopLeft;
            this.mBorderRadii[1] = isRtl ? this.mCornerRadiusTopRight : this.mCornerRadiusTopLeft;
            this.mBorderRadii[2] = isRtl ? this.mCornerRadiusTopLeft : this.mCornerRadiusTopRight;
            this.mBorderRadii[3] = isRtl ? this.mCornerRadiusTopLeft : this.mCornerRadiusTopRight;
            this.mBorderRadii[4] = isRtl ? this.mCornerRadiusBottomLeft : this.mCornerRadiusBottomRight;
            this.mBorderRadii[5] = isRtl ? this.mCornerRadiusBottomLeft : this.mCornerRadiusBottomRight;
            this.mBorderRadii[6] = isRtl ? this.mCornerRadiusBottomRight : this.mCornerRadiusBottomLeft;
            this.mBorderRadii[7] = isRtl ? this.mCornerRadiusBottomRight : this.mCornerRadiusBottomLeft;
        }
        this.mBackgroundNormal.setCornerRadii(this.mBorderRadii);
        this.mBackgroundPressed.setCornerRadii(this.mBorderRadii);
        this.mBackgroundUnable.setCornerRadii(this.mBorderRadii);
        this.mBackgroundChecked.setCornerRadii(this.mBorderRadii);
        this.mBackgroundSelected.setCornerRadii(this.mBorderRadii);
    }

    private void addOnGlobalLayoutListener() {
        if (this.mView == null) {
            return;
        }
        this.mView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                ViewTreeObserver observer = v.getViewTreeObserver();
                observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)RBaseHelper.this);
            }

            public void onViewDetachedFromWindow(View v) {
                ViewTreeObserver observer = v.getViewTreeObserver();
                observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)RBaseHelper.this);
                v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            }
        });
    }

    private Object[] getBackgroundInfo(TypedArray a, @StyleableRes int styleableRes) {
        int bgType = this.BG_TYPE_COLOR;
        int bgColor = 0;
        int[] bgColorArray = null;
        Drawable drawable = null;
        int resId = a.getResourceId(styleableRes, 0);
        if (resId == 0) {
            bgColor = a.getColor(styleableRes, 0);
            bgType = this.BG_TYPE_COLOR;
        } else {
            String typeName = this.mContext.getResources().getResourceTypeName(resId);
            if ("array".equals(typeName)) {
                bgType = this.BG_TYPE_COLOR_ARRAY;
                String[] strArray = this.mContext.getResources().getStringArray(resId);
                int[] intArray = this.mContext.getResources().getIntArray(resId);
                int length = Math.min(intArray.length, strArray.length);
                bgColorArray = new int[length];
                for (int i = 0; i < length; ++i) {
                    String strIndex = strArray[i];
                    int intIndex = intArray[i];
                    bgColorArray[i] = !TextUtils.isEmpty((CharSequence)strIndex) ? Color.parseColor((String)strIndex) : intIndex;
                }
            } else if ("color".equals(typeName)) {
                bgColor = a.getColor(styleableRes, 0);
                bgType = this.BG_TYPE_COLOR;
            } else if ("mipmap".equals(typeName) || "drawable".equals(typeName)) {
                bgType = this.BG_TYPE_IMG;
                drawable = a.getDrawable(styleableRes);
            }
        }
        return new Object[]{bgType, bgColor, bgColorArray, drawable};
    }

    private GradientDrawable.Orientation getGradientOrientation(TypedArray a) {
        GradientDrawable.Orientation orientation = GradientDrawable.Orientation.BL_TR;
        int gradientOrientation = a.getInt(R.styleable.RBaseView_gradient_orientation, 0);
        switch (gradientOrientation) {
            case 0: {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case 1: {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case 2: {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case 3: {
                orientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case 4: {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case 5: {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case 6: {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case 7: {
                orientation = GradientDrawable.Orientation.TL_BR;
            }
        }
        return orientation;
    }

    private GradientDrawable setColors(GradientDrawable drawable, int[] colors) {
        if (drawable == null) {
            drawable = new GradientDrawable();
        }
        if (Build.VERSION.SDK_INT >= 16) {
            drawable.setOrientation(this.mGradientOrientation);
            drawable.setColors(colors);
        } else {
            drawable = new GradientDrawable(this.mGradientOrientation, colors);
        }
        return drawable;
    }

    protected boolean isOutsideView(int x, int y) {
        boolean flag = false;
        if (x < 0 - this.mTouchSlop || x >= this.mView.getWidth() + this.mTouchSlop || y < 0 - this.mTouchSlop || y >= this.mView.getHeight() + this.mTouchSlop) {
            flag = true;
        }
        return flag;
    }

    protected float dp2px(int dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
    }

    private boolean isUseRipple() {
        return Build.VERSION.SDK_INT >= 21 && this.mUseRipple;
    }

    private void initClip() {
        this.mClipHelper.initClip((View)this.mView, this.mClipLayout, new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                Path path = new Path();
                path.addRoundRect(new RectF(0.0f, 0.0f, (float)width, (float)height), RBaseHelper.this.mBorderRadii, Path.Direction.CCW);
                return path;
            }
        });
    }

    @Override
    public void dispatchDraw(Canvas canvas) {
        this.mClipHelper.dispatchDraw(canvas);
    }

    @Override
    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mClipHelper.onLayout(changed, left, top, right, bottom);
    }

    public void onGlobalLayout() {
        ViewTreeObserver observer = this.mView.getViewTreeObserver();
        observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        if (Build.VERSION.SDK_INT < 21) {
            float half = (float)this.mView.getHeight() / 2.0f;
            for (int i = 0; i < this.mBorderRadii.length; ++i) {
                if (!(this.mBorderRadii[i] > half)) continue;
                this.mBorderRadii[i] = half;
            }
        }
        if (this.mGradientRadius <= 0.0f) {
            int width = this.mView.getWidth();
            int height = this.mView.getHeight();
            float radius = (float)Math.min(width, height) / 2.0f;
            this.setGradientRadius(radius);
        }
        this.initClip();
    }

    protected static boolean isRtl() {
        return TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
    }
}

