/*
 * Decompiled with CFR 0.152.
 */
package com.ruffian.library.widget.clip;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.view.ViewCompat;
import com.ruffian.library.widget.clip.ClipPathManager;
import com.ruffian.library.widget.clip.IClip;

public class ClipHelper
implements IClip {
    private final Paint clipPaint = new Paint(1);
    protected PorterDuffXfermode DST_OUT_MODE = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
    protected PorterDuffXfermode DST_IN_MODE = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private final Path clipPath = new Path();
    private final Path rectView = new Path();
    private ClipPathManager clipPathManager = new ClipPathManager();
    private boolean requestShapeUpdate = true;
    private View mView;
    private boolean mClipLayout;

    public ClipHelper() {
        this.clipPaint.setAntiAlias(true);
        this.clipPaint.setColor(-16776961);
        this.clipPaint.setStyle(Paint.Style.FILL);
        this.clipPaint.setStrokeWidth(1.0f);
    }

    public void initClip(View view, boolean clipLayout, ClipPathManager.ClipPathCreator clipPathCreator) {
        this.mView = view;
        this.mClipLayout = clipLayout;
        if (!this.canClip()) {
            return;
        }
        this.getView().setDrawingCacheEnabled(true);
        this.getView().setWillNotDraw(false);
        if (Build.VERSION.SDK_INT <= 27) {
            this.clipPaint.setXfermode((Xfermode)this.DST_IN_MODE);
            this.getView().setLayerType(1, this.clipPaint);
        } else {
            this.clipPaint.setXfermode((Xfermode)this.DST_OUT_MODE);
            this.getView().setLayerType(1, null);
        }
        this.clipPathManager.setClipPathCreator(clipPathCreator);
        this.requestShapeUpdate();
    }

    @Override
    public void dispatchDraw(Canvas canvas) {
        if (!this.canClip()) {
            return;
        }
        if (this.requestShapeUpdate) {
            this.calculateLayout(canvas.getWidth(), canvas.getHeight());
            this.requestShapeUpdate = false;
        }
        if (Build.VERSION.SDK_INT <= 27) {
            canvas.drawPath(this.clipPath, this.clipPaint);
        } else {
            canvas.drawPath(this.rectView, this.clipPaint);
        }
        if (Build.VERSION.SDK_INT <= 27) {
            this.getView().setLayerType(2, null);
        }
    }

    @Override
    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!this.canClip()) {
            return;
        }
        if (changed) {
            this.requestShapeUpdate();
        }
    }

    private void calculateLayout(int width, int height) {
        this.rectView.reset();
        this.rectView.addRect(0.0f, 0.0f, 1.0f * (float)this.getView().getWidth(), 1.0f * (float)this.getView().getHeight(), Path.Direction.CW);
        if (width > 0 && height > 0) {
            this.clipPathManager.setupClipLayout(width, height);
            this.clipPath.reset();
            this.clipPath.set(this.clipPathManager.getClipPath());
            if (Build.VERSION.SDK_INT > 27) {
                boolean bl = this.rectView.op(this.clipPath, Path.Op.DIFFERENCE);
            }
            if (Build.VERSION.SDK_INT >= 21 && ViewCompat.getElevation((View)this.getView()) > 0.0f) {
                try {
                    this.getView().setOutlineProvider(this.getView().getOutlineProvider());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.getView().postInvalidate();
    }

    public void requestShapeUpdate() {
        this.requestShapeUpdate = true;
        this.getView().postInvalidate();
    }

    public View getView() {
        return this.mView;
    }

    public boolean canClip() {
        return this.getView() != null && this.getView() instanceof ViewGroup && this.mClipLayout;
    }
}

