/*
 * Decompiled with CFR 0.152.
 */
package com.github.hiteshsondhi88.libffmpeg;

import android.content.Context;
import android.os.AsyncTask;
import com.github.hiteshsondhi88.libffmpeg.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

class Util {
    Util() {
    }

    static boolean isDebug(Context context) {
        return 0 != (context.getApplicationContext().getApplicationInfo().flags &= 2);
    }

    static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static String convertInputStreamToString(InputStream inputStream) {
        try {
            String str;
            BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder sb = new StringBuilder();
            while ((str = r.readLine()) != null) {
                sb.append(str);
            }
            return sb.toString();
        }
        catch (IOException e) {
            Log.e("error converting input stream to string", e);
            return null;
        }
    }

    static void destroyProcess(Process process) {
        if (process != null) {
            process.destroy();
        }
    }

    static boolean killAsync(AsyncTask asyncTask) {
        return asyncTask != null && !asyncTask.isCancelled() && asyncTask.cancel(true);
    }

    static boolean isProcessCompleted(Process process) {
        try {
            if (process == null) {
                return true;
            }
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }
}

