/*
 * Decompiled with CFR 0.152.
 */
package segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column;

import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.view.View;
import section_layout.widget.custom.android.com.sectionlayout.SectionLayout;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column.SegmentData;

public abstract class SegmentViewHolder<D>
extends SectionLayout.ViewHolder<SegmentData<D>> {
    private SegmentData<D> segmentData;
    private final View.OnClickListener onSectionViewClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (SegmentViewHolder.this.segmentData != null) {
                SegmentViewHolder.this.segmentData.getOnSegmentClickListener().onSegmentClick(SegmentViewHolder.this);
            }
        }
    };

    public SegmentViewHolder(@NonNull View sectionView) {
        super(sectionView);
    }

    protected final void onBind(SegmentData<D> segmentData) {
        this.segmentData = segmentData;
        this.getSectionView().setOnClickListener(this.onSectionViewClickListener);
        this.onSegmentBind(segmentData.getSegmentData());
    }

    public final void setSelected(boolean isSelected) {
        if (this.segmentData.isSelected() && isSelected) {
            this.segmentData.isSelected = true;
            this.onSegmentSelected(true, true);
        } else if (isSelected) {
            this.segmentData.isSelected = true;
            this.onSegmentSelected(true, false);
        } else {
            this.segmentData.isSelected = false;
            this.onSegmentSelected(false, false);
        }
    }

    public void onSegmentSelected(boolean isSelected, boolean isReselected) {
    }

    public int getAbsolutePosition() {
        return this.segmentData.absolutePosition;
    }

    public boolean isSelected() {
        return this.segmentData.isSelected;
    }

    public int getRow() {
        return this.segmentData.getRow();
    }

    public int getColumn() {
        return this.segmentData.getColumn();
    }

    public D getSegmentData() {
        return this.segmentData.getSegmentData();
    }

    public int getSelectedStrokeColor() {
        return this.segmentData.getSelectedStrokeColor();
    }

    public int getUnSelectedStrokeColor() {
        return this.segmentData.getUnSelectedStrokeColor();
    }

    public int getStrokeWidth() {
        return this.segmentData.getStrokeWidth();
    }

    public int getSelectBackgroundColor() {
        return this.segmentData.getSelectBackgroundColor();
    }

    public int getUnSelectedBackgroundColor() {
        return this.segmentData.getUnSelectedBackgroundColor();
    }

    public int getFocusedBackgroundColor() {
        return this.segmentData.getFocusedBackgroundColor();
    }

    public int getSelectionAnimationDuration() {
        return this.segmentData.getSelectionAnimationDuration();
    }

    public int getSelectedTextColor() {
        return this.segmentData.getSelectedTextColor();
    }

    public int getUnSelectedTextColor() {
        return this.segmentData.getUnSelectedTextColor();
    }

    public int getTextSize() {
        return this.segmentData.getTextSize();
    }

    public Typeface getTypeFace() {
        return this.segmentData.getTypeFace();
    }

    public int getCurrentSize() {
        return this.segmentData.getCurrentSize();
    }

    public int getColumnCount() {
        return this.segmentData.getColumnCount();
    }

    public int getTextHorizontalPadding() {
        return this.segmentData.getTextHorizontalPadding();
    }

    public int getTextVerticalPadding() {
        return this.segmentData.getTextVerticalPadding();
    }

    public int getSegmentVerticalMargin() {
        return this.segmentData.getSegmentVerticalMargin();
    }

    public int getSegmentHorizontalMargin() {
        return this.segmentData.getSegmentHorizontalMargin();
    }

    public int getTopLeftRadius() {
        return this.segmentData.getTopLeftRadius();
    }

    public int getTopRightRadius() {
        return this.segmentData.getTopRightRadius();
    }

    public int getBottomRightRadius() {
        return this.segmentData.getBottomRightRadius();
    }

    public int getBottomLeftRadius() {
        return this.segmentData.getBottomLeftRadius();
    }

    public boolean isRadiusForEverySegment() {
        return this.segmentData.isRadiusForEverySegment();
    }

    protected abstract void onSegmentBind(D var1);
}

