/*
 * Decompiled with CFR 0.152.
 */
package segmented_control.widget.custom.android.com.segmentedcontrol.custom_segment;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import segmented_control.widget.custom.android.com.segmented_control.R;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column.SegmentViewHolder;
import segmented_control.widget.custom.android.com.segmentedcontrol.utils.Utils;

public class SegmentViewHolderImpl
extends SegmentViewHolder<CharSequence> {
    private TextView itemTV;
    private float[] radius;
    private ValueAnimator va;
    private int[] windowLocation;
    private final ValueAnimator.AnimatorUpdateListener bgAnimListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            int colorArgb = (Integer)animation.getAnimatedValue();
            Drawable bg = Utils.getBackground(SegmentViewHolderImpl.this.getStrokeWidth(), SegmentViewHolderImpl.this.isSelected() ? SegmentViewHolderImpl.this.getSelectedStrokeColor() : SegmentViewHolderImpl.this.getUnSelectedStrokeColor(), colorArgb, SegmentViewHolderImpl.this.radius);
            SegmentViewHolderImpl.this.setBackground(bg);
        }
    };
    private final View.OnTouchListener segmentTouchListener = new View.OnTouchListener(){

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouch(View v, MotionEvent event) {
            if (SegmentViewHolderImpl.this.isSelected()) {
                return false;
            }
            if (event.getAction() == 0) {
                SegmentViewHolderImpl.this.setBackground(SegmentViewHolderImpl.this.getFocusedBackground());
            } else if (!(event.getAction() != 1 && event.getAction() != 3 && event.getAction() != 6 && event.getAction() != 4 || Utils.isInBounds(event.getX(), event.getY(), SegmentViewHolderImpl.this.windowLocation[0], SegmentViewHolderImpl.this.windowLocation[1], SegmentViewHolderImpl.this.getSectionView().getMeasuredWidth(), SegmentViewHolderImpl.this.getSectionView().getMeasuredHeight()))) {
                SegmentViewHolderImpl.this.setBackground(SegmentViewHolderImpl.this.isSelected() ? SegmentViewHolderImpl.this.getSelectedBackground() : SegmentViewHolderImpl.this.getUnSelectedBackground());
            }
            return false;
        }
    };

    public SegmentViewHolderImpl(@NonNull View sectionView) {
        super(sectionView);
        this.itemTV = (TextView)sectionView.findViewById(R.id.item_segment_tv);
        sectionView.setOnTouchListener(this.segmentTouchListener);
    }

    @Override
    protected void onSegmentBind(CharSequence segmentData) {
        this.initScreenLocation();
        this.itemTV.setText(segmentData);
        this.radius = this.isRadiusForEverySegment() ? Utils.createRadius(this.getTopLeftRadius(), this.getTopRightRadius(), this.getBottomRightRadius(), this.getBottomLeftRadius()) : Utils.defineRadiusForPosition(this.getAbsolutePosition(), this.getColumnCount(), this.getCurrentSize(), this.getTopLeftRadius(), this.getTopRightRadius(), this.getBottomRightRadius(), this.getBottomLeftRadius());
        this.setSectionDecorationSelected(false, false);
        this.itemTV.setTextSize(0, (float)this.getTextSize());
        if (this.getTypeFace() != null) {
            this.itemTV.setTypeface(this.getTypeFace());
        }
        this.itemTV.setPadding(this.getTextHorizontalPadding(), this.getTextVerticalPadding(), this.getTextHorizontalPadding(), this.getTextVerticalPadding());
        ((ViewGroup.MarginLayoutParams)this.itemTV.getLayoutParams()).setMargins(this.getSegmentHorizontalMargin(), this.getSegmentVerticalMargin(), this.getSegmentHorizontalMargin(), this.getSegmentVerticalMargin());
    }

    private void initScreenLocation() {
        this.windowLocation = new int[2];
        this.getSectionView().getLocationOnScreen(this.windowLocation);
    }

    @Override
    public void onSegmentSelected(boolean isSelected, boolean isReselected) {
        super.onSegmentSelected(isSelected, isReselected);
        this.setSectionDecorationSelected(isSelected, isReselected);
    }

    private Drawable getSelectedBackground() {
        return Utils.getBackground(this.getStrokeWidth(), this.getSelectedStrokeColor(), this.getSelectBackgroundColor(), this.radius);
    }

    private Drawable getUnSelectedBackground() {
        return Utils.getBackground(this.getStrokeWidth(), this.getUnSelectedStrokeColor(), this.getUnSelectedBackgroundColor(), this.radius);
    }

    private Drawable getFocusedBackground() {
        return Utils.getBackground(this.getStrokeWidth(), this.isSelected() ? this.getSelectedStrokeColor() : this.getUnSelectedStrokeColor(), this.getFocusedBackgroundColor(), this.radius);
    }

    private void setSectionDecorationSelected(boolean isSelected, boolean isReselected) {
        if (isReselected) {
            return;
        }
        if (this.hasBackground()) {
            this.animateNewBackground(isSelected);
        } else {
            this.setBackground(isSelected ? this.getSelectedBackground() : this.getUnSelectedBackground());
        }
        this.itemTV.setTextColor(isSelected ? this.getSelectedTextColor() : this.getUnSelectedTextColor());
    }

    private void animateNewBackground(boolean isSelected) {
        if (this.va != null) {
            this.va.end();
            this.va.removeUpdateListener(this.bgAnimListener);
        }
        int startColor = isSelected ? this.getFocusedBackgroundColor() : this.getSelectBackgroundColor();
        int endColor = isSelected ? this.getSelectBackgroundColor() : this.getUnSelectedBackgroundColor();
        this.va = Utils.createBackgroundAnimation(startColor, endColor);
        this.va.addUpdateListener(this.bgAnimListener);
        this.va.setDuration((long)this.getSelectionAnimationDuration());
        this.va.start();
    }

    private void setBackground(Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.itemTV.setBackground(drawable);
        } else {
            this.itemTV.setBackgroundDrawable(drawable);
        }
    }

    private boolean hasBackground() {
        return this.itemTV.getBackground() != null;
    }
}

