/*
 * Decompiled with CFR 0.152.
 */
package segmented_control.widget.custom.android.com.segmentedcontrol;

import android.graphics.Typeface;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import section_layout.widget.custom.android.com.sectionlayout.SectionLayout;
import section_layout.widget.custom.android.com.sectionlayout.distributive_section_layout.DistributiveSectionLayout;
import segmented_control.widget.custom.android.com.segmentedcontrol.Configs;
import segmented_control.widget.custom.android.com.segmentedcontrol.Notifier;
import segmented_control.widget.custom.android.com.segmentedcontrol.SegmentConsumer;
import segmented_control.widget.custom.android.com.segmentedcontrol.SegmentedControlViewComponent;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row.SegmentRowAdapter;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row.SegmentRowViewHolder;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column.SegmentAdapter;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column.SegmentData;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column.SegmentDecoration;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column.SegmentViewHolder;
import segmented_control.widget.custom.android.com.segmentedcontrol.listeners.OnSegmentClickListener;
import segmented_control.widget.custom.android.com.segmentedcontrol.listeners.OnSegmentSelectRequestListener;
import segmented_control.widget.custom.android.com.segmentedcontrol.listeners.OnSegmentSelectedListener;
import view_component.lib_android.com.view_component.base_view.ControllerComponent;

class SegmentedControlControllerComponent<D>
extends ControllerComponent<SegmentedControlViewComponent<D>> {
    private final Configs configs = Configs.getDefault();
    private LinkedList<SegmentViewHolder<D>> selectedSegments = new LinkedList();
    private final Notifier<D> notifier = new Notifier();
    private final List<D> dataList = new ArrayList<D>();
    private final OnSegmentClickListener<D> onSegmentClickListener = new OnSegmentClickListener<D>(){

        @Override
        public void onSegmentClick(SegmentViewHolder<D> segmentViewHolder) {
            boolean contains;
            SegmentedControlControllerComponent.this.notifier.onSegmentClick(segmentViewHolder);
            int index = SegmentedControlControllerComponent.this.selectedSegments.indexOf((Object)segmentViewHolder);
            boolean bl = contains = index != -1;
            if (contains) {
                SegmentViewHolder viewHolder = (SegmentViewHolder)((Object)SegmentedControlControllerComponent.this.selectedSegments.get(index));
                if (((SegmentedControlControllerComponent)SegmentedControlControllerComponent.this).configs.reselectionEnabled) {
                    viewHolder.setSelected(true);
                    SegmentedControlControllerComponent.this.notifier.onSegmentSelected(segmentViewHolder, true, true);
                } else {
                    SegmentedControlControllerComponent.this.selectedSegments.remove(index);
                    viewHolder.setSelected(false);
                    SegmentedControlControllerComponent.this.notifier.onSegmentSelected(segmentViewHolder, false, false);
                }
            } else if (SegmentedControlControllerComponent.this.notifier.onSegmentSelectRequest(segmentViewHolder)) {
                SegmentViewHolder lastSelected = SegmentedControlControllerComponent.this.addSelectedSegmentViewHolder(segmentViewHolder);
                if (lastSelected != null) {
                    lastSelected.setSelected(false);
                    SegmentedControlControllerComponent.this.notifier.onSegmentSelected(lastSelected, false, false);
                }
                segmentViewHolder.setSelected(true);
                SegmentedControlControllerComponent.this.notifier.onSegmentSelected(segmentViewHolder, true, false);
            }
        }
    };

    SegmentedControlControllerComponent() {
    }

    @Nullable
    private SegmentViewHolder<D> addSelectedSegmentViewHolder(SegmentViewHolder<D> segmentViewHolder) {
        this.selectedSegments.add(segmentViewHolder);
        if (this.selectedSegments.size() > this.configs.supportedSelectionsCount) {
            return this.selectedSegments.remove(0);
        }
        return null;
    }

    private SegmentViewHolder<D> getLastSelectedViewHolder() {
        return this.selectedSegments.size() > 0 ? this.selectedSegments.getLast() : null;
    }

    private void addSegment(D segmentData) {
        if (this.getVerticalSectionLayout().size() == 0 || !this.canAddToLastRow()) {
            this.addNewRow();
        }
        this.addSegmentToLastRow(segmentData);
    }

    private void removeAllSegments(boolean removeLastSelected) {
        for (int row = 0; row < this.getVerticalSectionLayout().size(); ++row) {
            this.getHorizontalSectionLayout(row).removeAllSections();
        }
        this.getVerticalSectionLayout().removeAllSections();
        this.dataList.clear();
        if (removeLastSelected) {
            this.selectedSegments.clear();
        }
    }

    private void addSegmentToLastRow(D segmentData) {
        DistributiveSectionLayout<SegmentData<D>> horizontalSectionLayout = this.getHorizontalSectionLayout(this.getLastRowIndex());
        horizontalSectionLayout.addSection(SegmentData.create(segmentData, this.onSegmentClickListener, this.getAbsolutePosition(this.getLastHorizontalSectionLayout().size(), this.getVerticalSectionLayout().size() - 1), this.getLastRowIndex(), horizontalSectionLayout.size(), this.size(), this.configs.columnCount, this.configs.segmentDecoration));
        horizontalSectionLayout.requestLayout();
    }

    private int[] getRowAndColumnWithAbsolutePosition(int position) {
        int smallDiff = position % this.configs.columnCount;
        int diff = position - smallDiff;
        int row = diff / this.configs.columnCount + (smallDiff == this.configs.columnCount ? 1 : 0);
        int column = position % this.configs.columnCount;
        return new int[]{row, column};
    }

    void notifyConfigIsChanged() {
        this.recreate(false);
    }

    public void clearSelection(boolean notifySegmentSelectedListener) {
        if (!this.selectedSegments.isEmpty()) {
            for (SegmentViewHolder segmentViewHolder : this.selectedSegments) {
                segmentViewHolder.setSelected(false);
                if (!notifySegmentSelectedListener) continue;
                this.notifier.onSegmentSelected(segmentViewHolder, false, false);
            }
            this.selectedSegments.clear();
        }
    }

    private void recreate(boolean removeLastSelected) {
        if (this.dataList.size() == 0) {
            return;
        }
        ArrayList<D> itemsData = new ArrayList<D>(this.dataList);
        this.removeAllSegments(removeLastSelected);
        this.addSegments(itemsData);
        SegmentViewHolder<D> lastSelection = this.getLastSelectedViewHolder();
        if (lastSelection != null) {
            this.setSelectedSegment(lastSelection.getAbsolutePosition());
        }
    }

    private boolean canAddToLastRow() {
        return this.getHorizontalSectionLayout(this.getLastRowIndex()).size() < this.configs.columnCount;
    }

    private void addNewRow() {
        this.getVerticalSectionLayout().addSection((Object)this.configs.willDistributeEvenly);
    }

    private SectionLayout getVerticalSectionLayout() {
        return ((SegmentedControlViewComponent)this.getViewComponent()).verticalSectionLayout;
    }

    private DistributiveSectionLayout<SegmentData<D>> getHorizontalSectionLayout(int row) {
        SegmentRowViewHolder segmentedViewHolder = (SegmentRowViewHolder)this.getVerticalSectionLayout().getViewHolderForAdapterPosition(row);
        return segmentedViewHolder.getDistributiveSectionLayout();
    }

    private DistributiveSectionLayout<SegmentData<D>> getLastHorizontalSectionLayout() {
        return this.getHorizontalSectionLayout(this.getLastRowIndex());
    }

    private int getLastRowIndex() {
        return this.getVerticalSectionLayout().size() - 1;
    }

    SegmentViewHolder<D> findSegmentByAbsolutePosition(int position) {
        int[] point = this.getRowAndColumnWithAbsolutePosition(position);
        return this.findSegmentByColumnAndRow(point[0], point[1]);
    }

    SegmentViewHolder<D> findSegmentByColumnAndRow(int column, int row) {
        return (SegmentViewHolder)this.getHorizontalSectionLayout(column).getViewHolderForAdapterPosition(row);
    }

    void forEachSegment(SegmentConsumer<D> segmentConsumer) {
        for (int row = 0; row < this.getVerticalSectionLayout().size(); ++row) {
            DistributiveSectionLayout<SegmentData<D>> horizontalSectionLayout = this.getHorizontalSectionLayout(row);
            for (int column = 0; column < horizontalSectionLayout.size(); ++column) {
                segmentConsumer.apply(this.findSegmentByColumnAndRow(row, column));
            }
        }
    }

    void setAccentColor(int color2) {
        this.configs.segmentDecoration = SegmentDecoration.createDefault(this.getContext(), color2);
    }

    void setSelectedStrokeColor(int color2) {
        this.configs.segmentDecoration.selectedStrokeColor = color2;
    }

    void setUnSelectedStrokeColor(int color2) {
        this.configs.segmentDecoration.unSelectedStrokeColor = color2;
    }

    void setStrokeWidth(int width) {
        this.configs.segmentDecoration.strokeWidth = width;
    }

    void setSelectedBackgroundColor(int color2) {
        this.configs.segmentDecoration.selectBackgroundColor = color2;
    }

    void setUnSelectedBackgroundColor(int color2) {
        this.configs.segmentDecoration.unSelectedBackgroundColor = color2;
    }

    void setFocusedBackgroundColor(int color2) {
        this.configs.segmentDecoration.focusedBackgroundColor = color2;
    }

    void setReselectionEnabled(boolean isEnabled) {
        this.configs.reselectionEnabled = isEnabled;
    }

    void setSelectionAnimationDuration(int duration) {
        this.configs.segmentDecoration.selectionAnimationDuration = duration;
    }

    void setSelectedTextColor(int color2) {
        this.configs.segmentDecoration.selectedTextColor = color2;
    }

    void setUnSelectedTextColor(int color2) {
        this.configs.segmentDecoration.unSelectedTextColor = color2;
    }

    void setTextSize(int textSize) {
        this.configs.segmentDecoration.textSize = textSize;
    }

    void setTypeFace(Typeface typeFace) {
        this.configs.segmentDecoration.typeface = typeFace;
    }

    void setTextVerticalPadding(int padding) {
        this.configs.segmentDecoration.textVerticalPadding = padding;
    }

    void setTextHorizontalPadding(int padding) {
        this.configs.segmentDecoration.textHorizontalPadding = padding;
    }

    void setSegmentVerticalMargin(int margin) {
        this.configs.segmentDecoration.segmentVerticalMargin = margin;
    }

    void setSegmentHorizontalMargin(int margin) {
        this.configs.segmentDecoration.segmentHorizontalMargin = margin;
    }

    void setRadius(int radius) {
        this.setTopLeftRadius(radius);
        this.setTopRightRadius(radius);
        this.setBottomRightRadius(radius);
        this.setBottomLeftRadius(radius);
    }

    void setTopLeftRadius(int radius) {
        this.configs.segmentDecoration.topLeftRadius = radius;
    }

    void setTopRightRadius(int radius) {
        this.configs.segmentDecoration.topRightRadius = radius;
    }

    void setBottomRightRadius(int radius) {
        this.configs.segmentDecoration.bottomRightRadius = radius;
    }

    void setBottomLeftRadius(int radius) {
        this.configs.segmentDecoration.bottomLeftRadius = radius;
    }

    void setRadiusForEverySegment(boolean radiusForEverySegment) {
        this.configs.segmentDecoration.radiusForEverySegment = radiusForEverySegment;
    }

    void setAdapter(SegmentAdapter adapter) {
        ((SegmentedControlViewComponent)this.getViewComponent()).verticalSectionLayout.withAdapter(new SegmentRowAdapter(adapter));
    }

    void addSegments(D[] segmentDataArray) {
        if (segmentDataArray == null || segmentDataArray.length == 0) {
            return;
        }
        this.addSegments(new ArrayList<D>(Arrays.asList(segmentDataArray)));
    }

    void addSegments(List<D> segmentDataList) {
        if (segmentDataList == null || segmentDataList.size() == 0) {
            return;
        }
        this.dataList.addAll(new ArrayList<D>(segmentDataList));
        for (D segmentData : this.dataList) {
            this.addSegment(segmentData);
        }
    }

    void removeAllSegments() {
        this.removeAllSegments(true);
    }

    void setDistributeEvenly(boolean willDistributeEvenly) {
        this.configs.willDistributeEvenly = willDistributeEvenly;
    }

    void setSupportedSelectionsCount(int supportedSelectionsCount) {
        this.configs.supportedSelectionsCount = supportedSelectionsCount;
    }

    void setColumnCount(int columnCount) {
        this.configs.columnCount = columnCount;
    }

    void addOnSegmentClickListener(OnSegmentClickListener<D> onSegmentClickListener) {
        this.notifier.addOnSegmentClickListener(onSegmentClickListener);
    }

    void removeOnSegmentClickListener(OnSegmentClickListener<D> onSegmentClickListener) {
        this.notifier.removeOnSegmentClickListener(onSegmentClickListener);
    }

    void addOnSegmentSelectListener(OnSegmentSelectedListener<D> onSegmentSelectedListener) {
        this.notifier.addOnSegmentSelectListener(onSegmentSelectedListener);
    }

    void removeOnSegmentSelectListener(OnSegmentSelectedListener<D> onSegmentSelectedListener) {
        this.notifier.removeOnSegmentSelectListener(onSegmentSelectedListener);
    }

    void setOnSegmentSelectRequestListener(OnSegmentSelectRequestListener<D> onSegmentSelectRequestListener) {
        this.notifier.setOnSegmentSelectRequestListener(onSegmentSelectRequestListener);
    }

    void setSelectedSegment(int absolutePosition) {
        int[] point = this.getRowAndColumnWithAbsolutePosition(absolutePosition);
        this.setSelectedSegment(point[0], point[1]);
    }

    void setSelectedSegment(int column, int row) {
        this.onSegmentClickListener.onSegmentClick(this.findSegmentByColumnAndRow(column, row));
    }

    List<SegmentViewHolder<D>> getSelectedViewHolders() {
        return this.selectedSegments;
    }

    int[] getLastSelectedColumnAndRow() {
        SegmentViewHolder<D> lastSelection = this.getLastSelectedViewHolder();
        if (lastSelection != null) {
            return new int[]{lastSelection.getColumn(), lastSelection.getRow()};
        }
        return new int[]{-1, -1};
    }

    int getLastSelectedAbsolutePosition() {
        SegmentViewHolder<D> lastSelection = this.getLastSelectedViewHolder();
        if (lastSelection != null) {
            return lastSelection.getAbsolutePosition();
        }
        return -1;
    }

    boolean isSelected() {
        return !this.selectedSegments.isEmpty();
    }

    int size() {
        return this.dataList.size();
    }

    int getAbsolutePosition(int column, int row) {
        return row * this.configs.columnCount + column;
    }
}

