/*
 * Decompiled with CFR 0.152.
 */
package segmented_control.widget.custom.android.com.segmentedcontrol;

import java.util.ArrayList;
import java.util.List;
import segmented_control.widget.custom.android.com.segmentedcontrol.Consumer;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column.SegmentViewHolder;
import segmented_control.widget.custom.android.com.segmentedcontrol.listeners.OnSegmentClickListener;
import segmented_control.widget.custom.android.com.segmentedcontrol.listeners.OnSegmentSelectRequestListener;
import segmented_control.widget.custom.android.com.segmentedcontrol.listeners.OnSegmentSelectedListener;
import segmented_control.widget.custom.android.com.segmentedcontrol.utils.Utils;

class Notifier<D>
implements OnSegmentClickListener<D>,
OnSegmentSelectedListener<D>,
OnSegmentSelectRequestListener<D> {
    private List<OnSegmentClickListener<D>> onSegmentClickListeners;
    private List<OnSegmentSelectedListener<D>> onSegmentSelectedListeners;
    private OnSegmentSelectRequestListener<D> onSegmentSelectRequestListener;

    Notifier() {
    }

    @Override
    public void onSegmentClick(final SegmentViewHolder<D> segmentViewHolder) {
        this.onEvent(this.onSegmentClickListeners, new Consumer<OnSegmentClickListener<D>>(){

            @Override
            public void apply(OnSegmentClickListener<D> onSegmentClickListener) {
                onSegmentClickListener.onSegmentClick(segmentViewHolder);
            }
        });
    }

    @Override
    public void onSegmentSelected(final SegmentViewHolder<D> segmentViewHolder, final boolean isSelected, final boolean isReselected) {
        this.onEvent(this.onSegmentSelectedListeners, new Consumer<OnSegmentSelectedListener<D>>(){

            @Override
            public void apply(OnSegmentSelectedListener<D> onSegmentSelectedListener) {
                onSegmentSelectedListener.onSegmentSelected(segmentViewHolder, isSelected, isReselected);
            }
        });
    }

    @Override
    public boolean onSegmentSelectRequest(SegmentViewHolder<D> segmentViewHolder) {
        return this.onSegmentSelectRequestListener == null || this.onSegmentSelectRequestListener.onSegmentSelectRequest(segmentViewHolder);
    }

    void addOnSegmentClickListener(OnSegmentClickListener<D> onSegmentClickListener) {
        this.onSegmentClickListeners = Utils.lazy(this.onSegmentClickListeners, new ArrayList());
        this.onSegmentClickListeners.add(onSegmentClickListener);
    }

    void removeOnSegmentClickListener(OnSegmentClickListener<D> onSegmentClickListener) {
        this.onSegmentClickListeners = Utils.lazy(this.onSegmentClickListeners, new ArrayList());
        this.onSegmentClickListeners.remove(onSegmentClickListener);
    }

    void addOnSegmentSelectListener(OnSegmentSelectedListener<D> onSegmentSelectedListener) {
        this.onSegmentSelectedListeners = Utils.lazy(this.onSegmentSelectedListeners, new ArrayList());
        this.onSegmentSelectedListeners.add(onSegmentSelectedListener);
    }

    void removeOnSegmentSelectListener(OnSegmentSelectedListener<D> onSegmentSelectedListener) {
        this.onSegmentSelectedListeners = Utils.lazy(this.onSegmentSelectedListeners, new ArrayList());
        this.onSegmentSelectedListeners.remove(onSegmentSelectedListener);
    }

    void setOnSegmentSelectRequestListener(OnSegmentSelectRequestListener<D> onSegmentSelectRequestListener) {
        this.onSegmentSelectRequestListener = onSegmentSelectRequestListener;
    }

    private <T> void onEvent(List<T> eventListeners, Consumer<T> listenerConsumer) {
        if (eventListeners != null && eventListeners.size() != 0) {
            for (T t : eventListeners) {
                listenerConsumer.apply(t);
            }
        }
    }
}

