/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.core.mappings;

import com.github.mkopylec.charon.configuration.CharonProperties;
import com.github.mkopylec.charon.configuration.MappingProperties;
import com.github.mkopylec.charon.core.http.HttpClientProvider;
import com.github.mkopylec.charon.core.mappings.MappingsCorrector;
import com.github.mkopylec.charon.core.utils.UriCorrector;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;

public abstract class MappingsProvider {
    private static final Logger log = LoggerFactory.getLogger(MappingsProvider.class);
    protected final ServerProperties server;
    protected final CharonProperties charon;
    protected final MappingsCorrector mappingsCorrector;
    protected final HttpClientProvider httpClientProvider;
    protected List<MappingProperties> mappings;

    public MappingsProvider(ServerProperties server, CharonProperties charon, MappingsCorrector mappingsCorrector, HttpClientProvider httpClientProvider) {
        this.server = server;
        this.charon = charon;
        this.mappingsCorrector = mappingsCorrector;
        this.httpClientProvider = httpClientProvider;
    }

    public MappingProperties resolveMapping(String originUri, HttpServletRequest request) {
        List resolvedMappings;
        if (this.shouldUpdateMappings(request)) {
            this.updateMappings();
        }
        if (CollectionUtils.isEmpty(resolvedMappings = this.mappings.stream().filter(mapping -> originUri.startsWith(this.concatContextAndMappingPaths((MappingProperties)mapping))).collect(Collectors.toList()))) {
            return null;
        }
        return (MappingProperties)resolvedMappings.get(0);
    }

    @PostConstruct
    protected synchronized void updateMappings() {
        List<MappingProperties> newMappings = this.retrieveMappings();
        this.mappingsCorrector.correct(newMappings);
        this.mappings = newMappings;
        this.httpClientProvider.updateHttpClients(this.mappings);
        log.info("Destination mappings updated to: {}", this.mappings);
    }

    protected String concatContextAndMappingPaths(MappingProperties mapping) {
        return UriCorrector.correctUri(this.server.getContextPath()) + mapping.getPath();
    }

    protected abstract boolean shouldUpdateMappings(HttpServletRequest var1);

    protected abstract List<MappingProperties> retrieveMappings();
}

