/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.core.mappings;

import com.github.mkopylec.charon.configuration.MappingProperties;
import com.github.mkopylec.charon.core.utils.UriCorrector;
import com.github.mkopylec.charon.exceptions.CharonException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MappingsCorrector {
    public void correct(List<MappingProperties> mappings) {
        if (CollectionUtils.isNotEmpty(mappings)) {
            mappings.forEach(this::correctMapping);
            int numberOfPaths = mappings.stream().map(MappingProperties::getPath).collect(Collectors.toSet()).size();
            if (numberOfPaths < mappings.size()) {
                throw new CharonException("Duplicated destination paths in mappings");
            }
            mappings.sort((mapping1, mapping2) -> mapping2.getPath().compareTo(mapping1.getPath()));
        }
    }

    protected void correctMapping(MappingProperties mapping) {
        this.correctName(mapping);
        this.correctDestinations(mapping);
        this.correctPath(mapping);
        this.correctTimeout(mapping);
    }

    protected void correctName(MappingProperties mapping) {
        if (StringUtils.isBlank((CharSequence)mapping.getName())) {
            throw new CharonException("Empty name for mapping " + mapping);
        }
    }

    protected void correctDestinations(MappingProperties mapping) {
        if (CollectionUtils.isEmpty(mapping.getDestinations())) {
            throw new CharonException("No destination hosts for mapping " + mapping);
        }
        ArrayList<String> correctedHosts = new ArrayList<String>(mapping.getDestinations().size());
        mapping.getDestinations().forEach(destination -> {
            if (StringUtils.isBlank((CharSequence)destination)) {
                throw new CharonException("Empty destination for mapping " + mapping);
            }
            if (!destination.matches(".+://.+")) {
                destination = "http://" + destination;
            }
            destination = StringUtils.removeEnd((String)destination, (String)"/");
            correctedHosts.add((String)destination);
        });
        mapping.setDestinations(correctedHosts);
    }

    protected void correctPath(MappingProperties mapping) {
        if (StringUtils.isBlank((CharSequence)mapping.getPath())) {
            throw new CharonException("No destination path for mapping " + mapping);
        }
        String path = UriCorrector.correctUri(mapping.getPath());
        mapping.setPath(path);
    }

    protected void correctTimeout(MappingProperties mapping) {
        int connectTimeout = mapping.getTimeout().getConnect();
        if (connectTimeout < 0) {
            throw new CharonException("Invalid connect timeout value: " + connectTimeout);
        }
        int readTimeout = mapping.getTimeout().getRead();
        if (readTimeout < 0) {
            throw new CharonException("Invalid read timeout value: " + readTimeout);
        }
    }
}

