/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.core.http;

import com.github.mkopylec.charon.exceptions.CharonException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;

public class RequestDataExtractor {
    public byte[] extractBody(HttpServletRequest request) {
        try {
            return IOUtils.toByteArray((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new CharonException("Error extracting body of HTTP request with URI: " + this.extractUri(request), e);
        }
    }

    public HttpHeaders extractHttpHeaders(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            ArrayList value = Collections.list(request.getHeaders(name));
            headers.put(name, value);
        }
        return headers;
    }

    public HttpMethod extractHttpMethod(HttpServletRequest request) {
        return HttpMethod.resolve((String)request.getMethod());
    }

    public String extractUri(HttpServletRequest request) {
        return request.getRequestURI() + this.getQuery(request);
    }

    protected String getQuery(HttpServletRequest request) {
        return request.getQueryString() == null ? "" : "?" + request.getQueryString();
    }
}

