/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.core.http;

import com.github.mkopylec.charon.configuration.MappingProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class HttpClientProvider {
    protected Map<String, RestOperations> httpClients = new HashMap<String, RestOperations>();

    public void updateHttpClients(List<MappingProperties> mappings) {
        this.httpClients = mappings.stream().collect(Collectors.toMap(MappingProperties::getName, this::createHttpClient));
    }

    public RestOperations getHttpClient(String mappingName) {
        return this.httpClients.get(mappingName);
    }

    protected RestOperations createHttpClient(MappingProperties mapping) {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().disableRedirectHandling().build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)client);
        requestFactory.setConnectTimeout(mapping.getTimeout().getConnect());
        requestFactory.setReadTimeout(mapping.getTimeout().getRead());
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }
}

