/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.configuration;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.github.mkopylec.charon.configuration.CharonProperties;
import com.github.mkopylec.charon.configuration.MappingProperties;
import com.github.mkopylec.charon.core.balancer.LoadBalancer;
import com.github.mkopylec.charon.core.balancer.RandomLoadBalancer;
import com.github.mkopylec.charon.core.http.ForwardedRequestInterceptor;
import com.github.mkopylec.charon.core.http.HttpClientProvider;
import com.github.mkopylec.charon.core.http.NoOpForwardedRequestInterceptor;
import com.github.mkopylec.charon.core.http.NoOpReceivedResponseInterceptor;
import com.github.mkopylec.charon.core.http.ReceivedResponseInterceptor;
import com.github.mkopylec.charon.core.http.RequestDataExtractor;
import com.github.mkopylec.charon.core.http.RequestForwarder;
import com.github.mkopylec.charon.core.http.ReverseProxyFilter;
import com.github.mkopylec.charon.core.mappings.ConfigurationMappingsProvider;
import com.github.mkopylec.charon.core.mappings.MappingsCorrector;
import com.github.mkopylec.charon.core.mappings.MappingsProvider;
import com.github.mkopylec.charon.core.retry.LoggingListener;
import com.github.mkopylec.charon.core.trace.LoggingTraceInterceptor;
import com.github.mkopylec.charon.core.trace.ProxyingTraceInterceptor;
import com.github.mkopylec.charon.core.trace.TraceInterceptor;
import com.github.mkopylec.charon.exceptions.CharonException;
import com.ryantenney.metrics.spring.config.annotation.EnableMetrics;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurerAdapter;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableMetrics
@EnableConfigurationProperties(value={CharonProperties.class, ServerProperties.class})
public class CharonConfiguration
extends MetricsConfigurerAdapter {
    @Autowired
    protected CharonProperties charon;
    @Autowired
    protected ServerProperties server;

    @Bean
    public FilterRegistrationBean charonReverseProxyFilterRegistrationBean(ReverseProxyFilter proxyFilter, MetricRegistry metricRegistry) {
        int metricsReportingInterval = this.charon.getMetrics().getReporting().getIntervalInSeconds();
        int graphitePort = this.charon.getMetrics().getReporting().getGraphite().getPort();
        String graphiteHostname = this.charon.getMetrics().getReporting().getGraphite().getHostname();
        this.startMetricReporters(metricsReportingInterval, graphitePort, graphiteHostname, metricRegistry);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)proxyFilter, new ServletRegistrationBean[0]);
        registrationBean.setOrder(this.charon.getFilterOrder());
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public ReverseProxyFilter charonReverseProxyFilter(@Qualifier(value="charonRetryOperations") RetryOperations retryOperations, @Qualifier(value="charonDefaultRetryOperations") RetryOperations defaultRetryOperations, RequestDataExtractor extractor, MappingsProvider mappingsProvider, @Qualifier(value="charonTaskExecutor") TaskExecutor taskExecutor, RequestForwarder requestForwarder, ProxyingTraceInterceptor traceInterceptor) {
        return new ReverseProxyFilter(this.charon, retryOperations, defaultRetryOperations, extractor, mappingsProvider, taskExecutor, requestForwarder, traceInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpClientProvider charonHttpClientProvider() {
        return new HttpClientProvider();
    }

    @Bean
    @ConditionalOnMissingBean(name={"charonRetryOperations"})
    public RetryOperations charonRetryOperations(@Qualifier(value="charonRetryListener") RetryListener listener) {
        return this.createRetryOperations(listener, this.charon.getRetrying().getMaxAttempts(), this.charon.getRetrying().getRetryOn().getExceptions());
    }

    @Bean
    @ConditionalOnMissingBean(name={"charonDefaultRetryOperations"})
    public RetryOperations charonDefaultRetryOperations(@Qualifier(value="charonRetryListener") RetryListener listener) {
        return this.createRetryOperations(listener, 1, Collections.emptyList());
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestDataExtractor charonRequestDataExtractor() {
        return new RequestDataExtractor();
    }

    @Bean
    @ConditionalOnMissingBean
    public MappingsProvider charonMappingsProvider(MappingsCorrector mappingsCorrector, HttpClientProvider httpClientProvider) {
        return new ConfigurationMappingsProvider(this.server, this.charon, mappingsCorrector, httpClientProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public LoadBalancer charonLoadBalancer() {
        return new RandomLoadBalancer();
    }

    @Bean
    @ConditionalOnMissingBean
    public MappingsCorrector charonMappingsCorrector() {
        return new MappingsCorrector();
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskExecutor charonTaskExecutor() {
        if (this.isAsynchronousMappingPresent()) {
            ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
            taskExecutor.setQueueCapacity(this.charon.getAsynchronousForwardingThreadPool().getQueueCapacity());
            taskExecutor.setCorePoolSize(this.charon.getAsynchronousForwardingThreadPool().getSize().getInitial());
            taskExecutor.setMaxPoolSize(this.charon.getAsynchronousForwardingThreadPool().getSize().getMaximum());
            return taskExecutor;
        }
        return null;
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestForwarder charonRequestForwarder(HttpClientProvider httpClientProvider, MappingsProvider mappingsProvider, LoadBalancer loadBalancer, MetricRegistry metricRegistry, ProxyingTraceInterceptor traceInterceptor, ForwardedRequestInterceptor forwardedRequestInterceptor, ReceivedResponseInterceptor receivedResponseInterceptor) {
        return new RequestForwarder(this.server, this.charon, httpClientProvider, mappingsProvider, loadBalancer, metricRegistry, traceInterceptor, forwardedRequestInterceptor, receivedResponseInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    public RetryListener charonRetryListener() {
        return new LoggingListener(this.charon);
    }

    @Bean
    @ConditionalOnMissingBean
    public TraceInterceptor charonTraceInterceptor() {
        return new LoggingTraceInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ProxyingTraceInterceptor charonProxyingTraceInterceptor(TraceInterceptor traceInterceptor) {
        return new ProxyingTraceInterceptor(this.charon, traceInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    public ForwardedRequestInterceptor charonForwardedRequestInterceptor() {
        return new NoOpForwardedRequestInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ReceivedResponseInterceptor charonReceivedResponseInterceptor() {
        return new NoOpReceivedResponseInterceptor();
    }

    @PostConstruct
    protected void checkConfiguration() {
        int maxAttempts = this.charon.getRetrying().getMaxAttempts();
        if (maxAttempts < 1) {
            throw new CharonException("Invalid max number of attempts to forward HTTP request value: " + maxAttempts);
        }
        int metricsReportingInterval = this.charon.getMetrics().getReporting().getIntervalInSeconds();
        if (metricsReportingInterval < 1) {
            throw new CharonException("Invalid metrics reporting interval value: " + metricsReportingInterval);
        }
        int graphitePort = this.charon.getMetrics().getReporting().getGraphite().getPort();
        if (graphitePort < 1) {
            throw new CharonException("Invalid Graphite server port value: " + graphitePort);
        }
        String graphiteHostname = this.charon.getMetrics().getReporting().getGraphite().getHostname();
        if (StringUtils.isBlank((CharSequence)graphiteHostname) && this.shouldCreateGraphiteMetricsReporter()) {
            throw new CharonException("Invalid Graphite server hostname value: " + graphiteHostname);
        }
        int queueCapacity = this.charon.getAsynchronousForwardingThreadPool().getQueueCapacity();
        if (queueCapacity < 0) {
            throw new CharonException("Invalid asynchronous requests thread pool executor queue capacity value: " + queueCapacity);
        }
        int initialSize = this.charon.getAsynchronousForwardingThreadPool().getSize().getInitial();
        if (initialSize < 0) {
            throw new CharonException("Invalid asynchronous requests thread pool executor initial size value: " + initialSize);
        }
        int maximumSize = this.charon.getAsynchronousForwardingThreadPool().getSize().getMaximum();
        if (maximumSize < 1) {
            throw new CharonException("Invalid asynchronous requests thread pool executor maximum size value: " + maximumSize);
        }
        if (initialSize > maximumSize) {
            throw new CharonException("Initial size of asynchronous requests thread pool executor value: " + initialSize + " greater than maximum size value: " + maximumSize);
        }
    }

    protected void startMetricReporters(int metricsReportingInterval, int graphitePort, String graphiteHostname, MetricRegistry metricRegistry) {
        if (this.shouldCreateLoggingMetricsReporter()) {
            ((Slf4jReporter)this.registerReporter((Closeable)Slf4jReporter.forRegistry((MetricRegistry)metricRegistry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).withLoggingLevel(Slf4jReporter.LoggingLevel.TRACE).outputTo(LoggerFactory.getLogger(ReverseProxyFilter.class)).build())).start((long)metricsReportingInterval, TimeUnit.SECONDS);
        }
        if (this.shouldCreateGraphiteMetricsReporter()) {
            Graphite graphite = new Graphite(graphiteHostname, graphitePort);
            ((GraphiteReporter)this.registerReporter((Closeable)GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build(graphite))).start((long)metricsReportingInterval, TimeUnit.SECONDS);
        }
    }

    protected RetryOperations createRetryOperations(RetryListener listener, int maxAttempts, List<Class<? extends Throwable>> retryableErrors) {
        HashMap retryableExceptions = new HashMap(retryableErrors.size());
        retryableErrors.forEach(error -> retryableExceptions.put(error, true));
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(maxAttempts, retryableExceptions);
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        retryTemplate.registerListener(listener);
        return retryTemplate;
    }

    protected boolean shouldCreateLoggingMetricsReporter() {
        return this.charon.getMetrics().isEnabled() && this.charon.getMetrics().getReporting().getLogger().isEnabled();
    }

    protected boolean shouldCreateGraphiteMetricsReporter() {
        return this.charon.getMetrics().isEnabled() && this.charon.getMetrics().getReporting().getGraphite().isEnabled();
    }

    protected boolean isAsynchronousMappingPresent() {
        return !this.charon.getMappings().stream().filter(MappingProperties::isAsynchronous).collect(Collectors.toList()).isEmpty();
    }
}

