/*
 * Decompiled with CFR 0.152.
 */
package com.nabinbhandari.android.permissions;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.nabinbhandari.android.permissions.PermissionHandler;
import com.nabinbhandari.android.permissions.PermissionsActivity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;

public class Permissions {
    static boolean loggingEnabled = true;

    public static void disableLogging() {
        loggingEnabled = false;
    }

    static void log(String message) {
        if (loggingEnabled) {
            Log.d((String)"Permissions", (String)message);
        }
    }

    public static void check(Context context, String permission, String rationale, PermissionHandler handler) {
        Permissions.check(context, new String[]{permission}, rationale, null, handler);
    }

    public static void check(Context context, String permission, int rationaleId, PermissionHandler handler) {
        String rationale = null;
        try {
            rationale = context.getString(rationaleId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Permissions.check(context, new String[]{permission}, rationale, null, handler);
    }

    public static void check(Context context, String[] permissions, String rationale, Options options, PermissionHandler handler) {
        if (Build.VERSION.SDK_INT < 23) {
            handler.onGranted();
            Permissions.log("Android version < 23");
        } else {
            LinkedHashSet permissionsSet = new LinkedHashSet();
            Collections.addAll(permissionsSet, permissions);
            boolean allPermissionProvided = true;
            for (String aPermission : permissionsSet) {
                if (context.checkSelfPermission(aPermission) == 0) continue;
                allPermissionProvided = false;
                break;
            }
            if (allPermissionProvided) {
                handler.onGranted();
                Permissions.log("Permission(s) " + (PermissionsActivity.permissionHandler == null ? "already granted." : "just granted from settings."));
                PermissionsActivity.permissionHandler = null;
            } else {
                PermissionsActivity.permissionHandler = handler;
                ArrayList permissionsList = new ArrayList(permissionsSet);
                Intent intent = new Intent(context, PermissionsActivity.class).putExtra("permissions", permissionsList).putExtra("rationale", rationale).putExtra("options", (Serializable)options);
                if (options != null && options.createNewTask) {
                    intent.addFlags(0x10000000);
                }
                context.startActivity(intent);
            }
        }
    }

    public static void check(Context context, String[] permissions, int rationaleId, Options options, PermissionHandler handler) {
        String rationale = null;
        try {
            rationale = context.getString(rationaleId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Permissions.check(context, permissions, rationale, options, handler);
    }

    public static class Options
    implements Serializable {
        String settingsText = "Settings";
        String rationaleDialogTitle = "Permissions Required";
        String settingsDialogTitle = "Permissions Required";
        String settingsDialogMessage = "Required permission(s) have been set not to ask again! Please provide them from settings.";
        boolean sendBlockedToSettings = true;
        boolean createNewTask = false;

        public Options setSettingsText(String settingsText) {
            this.settingsText = settingsText;
            return this;
        }

        public Options setCreateNewTask(boolean createNewTask) {
            this.createNewTask = createNewTask;
            return this;
        }

        public Options setRationaleDialogTitle(String rationaleDialogTitle) {
            this.rationaleDialogTitle = rationaleDialogTitle;
            return this;
        }

        public Options setSettingsDialogTitle(String settingsDialogTitle) {
            this.settingsDialogTitle = settingsDialogTitle;
            return this;
        }

        public Options setSettingsDialogMessage(String settingsDialogMessage) {
            this.settingsDialogMessage = settingsDialogMessage;
            return this;
        }

        public Options sendDontAskAgainToSettings(boolean send) {
            this.sendBlockedToSettings = send;
            return this;
        }
    }
}

