/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask;

import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import com.redmadrobot.inputmask.helper.Mask;
import com.redmadrobot.inputmask.model.CaretString;
import com.redmadrobot.inputmask.model.Notation;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001HB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bB3\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000eBG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010/\u001a\u00020\u001bJ\u0006\u00100\u001a\u00020\u001bJ\u0012\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u0016J*\u00105\u001a\u0002022\b\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u001bH\u0016J\u001a\u0010;\u001a\u0002022\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020\rH\u0016J(\u0010?\u001a\u0002022\u0006\u0010@\u001a\u0002072\u0006\u0010A\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u001bH\u0016J\u0006\u0010D\u001a\u00020\u0004J\u0010\u0010E\u001a\u0002022\u0006\u0010@\u001a\u00020\u0004H\u0016J\u0006\u0010F\u001a\u00020\u001bJ\u0006\u0010G\u001a\u00020\u001bR\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006I"}, d2={"Lcom/redmadrobot/inputmask/MaskedTextChangedListener;", "Landroid/text/TextWatcher;", "Landroid/view/View$OnFocusChangeListener;", "format", "", "field", "Landroid/widget/EditText;", "valueListener", "Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;", "(Ljava/lang/String;Landroid/widget/EditText;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "listener", "(Ljava/lang/String;Landroid/widget/EditText;Landroid/text/TextWatcher;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "autocomplete", "", "(Ljava/lang/String;ZLandroid/widget/EditText;Landroid/text/TextWatcher;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "customNotations", "", "Lcom/redmadrobot/inputmask/model/Notation;", "(Ljava/lang/String;Ljava/util/List;ZLandroid/widget/EditText;Landroid/text/TextWatcher;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "afterText", "getAfterText", "()Ljava/lang/String;", "setAfterText", "(Ljava/lang/String;)V", "getAutocomplete", "()Z", "caretPosition", "", "getCaretPosition", "()I", "setCaretPosition", "(I)V", "Ljava/lang/ref/WeakReference;", "getField", "()Ljava/lang/ref/WeakReference;", "getListener", "()Landroid/text/TextWatcher;", "setListener", "(Landroid/text/TextWatcher;)V", "mask", "Lcom/redmadrobot/inputmask/helper/Mask;", "getMask", "()Lcom/redmadrobot/inputmask/helper/Mask;", "getValueListener", "()Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;", "setValueListener", "(Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "acceptableTextLength", "acceptableValueLength", "afterTextChanged", "", "edit", "Landroid/text/Editable;", "beforeTextChanged", "p0", "", "p1", "p2", "p3", "onFocusChange", "view", "Landroid/view/View;", "hasFocus", "onTextChanged", "text", "cursorPosition", "before", "count", "placeholder", "setText", "totalTextLength", "totalValueLength", "ValueListener", "inputmask_release"})
public class MaskedTextChangedListener
implements TextWatcher,
View.OnFocusChangeListener {
    @NotNull
    private final Mask mask;
    @NotNull
    private String afterText;
    private int caretPosition;
    @NotNull
    private final WeakReference<EditText> field;
    private final boolean autocomplete;
    @Nullable
    private TextWatcher listener;
    @Nullable
    private ValueListener valueListener;

    @NotNull
    public final Mask getMask() {
        return this.mask;
    }

    @NotNull
    public final String getAfterText() {
        return this.afterText;
    }

    public final void setAfterText(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.afterText = string;
    }

    public final int getCaretPosition() {
        return this.caretPosition;
    }

    public final void setCaretPosition(int n) {
        this.caretPosition = n;
    }

    @NotNull
    public final WeakReference<EditText> getField() {
        return this.field;
    }

    public void setText(@NotNull String text) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Mask.Result result = this.mask.apply(new CaretString(text, text.length()), this.autocomplete);
            EditText editText = (EditText)this.field.get();
            if (editText != null) {
                editText.setText((CharSequence)result.getFormattedText().getString());
            }
            EditText editText2 = (EditText)this.field.get();
            if (editText2 != null) {
                editText2.setSelection(result.getFormattedText().getCaretPosition());
            }
            ValueListener valueListener = this.valueListener;
            if (valueListener == null) break block2;
            valueListener.onTextChanged(result.getComplete(), result.getExtractedValue());
        }
    }

    @NotNull
    public final String placeholder() {
        return this.mask.placeholder();
    }

    public final int acceptableTextLength() {
        return this.mask.acceptableTextLength();
    }

    public final int totalTextLength() {
        return this.mask.totalTextLength();
    }

    public final int acceptableValueLength() {
        return this.mask.acceptableValueLength();
    }

    public final int totalValueLength() {
        return this.mask.totalValueLength();
    }

    public void afterTextChanged(@Nullable Editable edit) {
        block4: {
            EditText editText = (EditText)this.field.get();
            if (editText != null) {
                editText.removeTextChangedListener((TextWatcher)this);
            }
            Editable editable = edit;
            if (editable != null) {
                editable.replace(0, edit.length(), (CharSequence)this.afterText);
            }
            EditText editText2 = (EditText)this.field.get();
            if (editText2 != null) {
                editText2.setSelection(this.caretPosition);
            }
            EditText editText3 = (EditText)this.field.get();
            if (editText3 != null) {
                editText3.addTextChangedListener((TextWatcher)this);
            }
            TextWatcher textWatcher = this.listener;
            if (textWatcher == null) break block4;
            textWatcher.afterTextChanged(edit);
        }
    }

    public void beforeTextChanged(@Nullable CharSequence p0, int p1, int p2, int p3) {
        block0: {
            TextWatcher textWatcher = this.listener;
            if (textWatcher == null) break block0;
            textWatcher.beforeTextChanged(p0, p1, p2, p3);
        }
    }

    public void onTextChanged(@NotNull CharSequence text, int cursorPosition, int before, int count) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            boolean isDeletion = before > 0 && count == 0;
            Mask.Result result = this.mask.apply(new CaretString(((Object)text).toString(), isDeletion ? cursorPosition : cursorPosition + count), this.autocomplete && !isDeletion);
            this.afterText = result.getFormattedText().getString();
            this.caretPosition = isDeletion ? cursorPosition : result.getFormattedText().getCaretPosition();
            ValueListener valueListener = this.valueListener;
            if (valueListener == null) break block0;
            valueListener.onTextChanged(result.getComplete(), result.getExtractedValue());
        }
    }

    public void onFocusChange(@Nullable View view, boolean hasFocus) {
        block6: {
            String string;
            CharSequence charSequence;
            if (!this.autocomplete || !hasFocus) break block6;
            EditText editText = (EditText)this.field.get();
            Object object = editText != null ? editText.getText() : null;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if ((charSequence = (CharSequence)object).length() == 0) {
                string = "";
            } else {
                EditText editText2 = (EditText)this.field.get();
                string = String.valueOf(editText2 != null ? editText2.getText() : null);
            }
            String text = string;
            Mask.Result result = this.mask.apply(new CaretString(text, text.length()), this.autocomplete);
            EditText editText3 = (EditText)this.field.get();
            if (editText3 != null) {
                editText3.setText((CharSequence)result.getFormattedText().getString());
            }
            EditText editText4 = (EditText)this.field.get();
            if (editText4 != null) {
                editText4.setSelection(result.getFormattedText().getCaretPosition());
            }
            ValueListener valueListener = this.valueListener;
            if (valueListener != null) {
                valueListener.onTextChanged(result.getComplete(), result.getExtractedValue());
            }
        }
    }

    public final boolean getAutocomplete() {
        return this.autocomplete;
    }

    @Nullable
    public final TextWatcher getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable TextWatcher textWatcher) {
        this.listener = textWatcher;
    }

    @Nullable
    public final ValueListener getValueListener() {
        return this.valueListener;
    }

    public final void setValueListener(@Nullable ValueListener valueListener) {
        this.valueListener = valueListener;
    }

    public MaskedTextChangedListener(@NotNull String format, @NotNull List<Notation> customNotations, boolean autocomplete, @NotNull EditText field, @Nullable TextWatcher listener, @Nullable ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull(customNotations, (String)"customNotations");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this.autocomplete = autocomplete;
        this.listener = listener;
        this.valueListener = valueListener;
        this.mask = Mask.Factory.getOrCreate(format, customNotations);
        this.afterText = "";
        this.field = new WeakReference<EditText>(field);
    }

    public /* synthetic */ MaskedTextChangedListener(String string, List list, boolean bl, EditText editText, TextWatcher textWatcher, ValueListener valueListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            textWatcher = null;
        }
        if ((n & 0x20) != 0) {
            valueListener = null;
        }
        this(string, list, bl, editText, textWatcher, valueListener);
    }

    public MaskedTextChangedListener(@NotNull String format, @NotNull EditText field, @Nullable ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this(format, field, null, valueListener);
    }

    public MaskedTextChangedListener(@NotNull String format, @NotNull EditText field, @Nullable TextWatcher listener, @Nullable ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this(format, true, field, listener, valueListener);
    }

    public MaskedTextChangedListener(@NotNull String format, boolean autocomplete, @NotNull EditText field, @Nullable TextWatcher listener, @Nullable ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this(format, CollectionsKt.emptyList(), autocomplete, field, listener, valueListener);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;", "", "onTextChanged", "", "maskFilled", "", "extractedValue", "", "inputmask_release"})
    public static interface ValueListener {
        public void onTextChanged(boolean var1, @NotNull String var2);
    }
}

