/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database.transaction;

import android.os.Looper;
import android.os.Process;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransactionQueue;
import com.raizlabs.android.dbflow.structure.database.transaction.PriorityTransactionWrapper;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;

public class PriorityTransactionQueue
extends Thread
implements ITransactionQueue {
    private final PriorityBlockingQueue<PriorityEntry<Transaction>> queue = new PriorityBlockingQueue();
    private boolean isQuitting = false;

    public PriorityTransactionQueue(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        Process.setThreadPriority((int)10);
        while (true) {
            PriorityEntry<Transaction> transaction;
            try {
                transaction = this.queue.take();
            }
            catch (InterruptedException e) {
                if (!this.isQuitting) continue;
                PriorityBlockingQueue<PriorityEntry<Transaction>> priorityBlockingQueue = this.queue;
                synchronized (priorityBlockingQueue) {
                    this.queue.clear();
                }
                return;
            }
            ((Transaction)transaction.entry).executeSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@NonNull Transaction transaction) {
        PriorityBlockingQueue<PriorityEntry<Transaction>> priorityBlockingQueue = this.queue;
        synchronized (priorityBlockingQueue) {
            PriorityEntry priorityEntry = new PriorityEntry(this, transaction);
            if (!this.queue.contains(priorityEntry)) {
                this.queue.add(priorityEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(@NonNull Transaction transaction) {
        PriorityBlockingQueue<PriorityEntry<Transaction>> priorityBlockingQueue = this.queue;
        synchronized (priorityBlockingQueue) {
            PriorityEntry priorityEntry = new PriorityEntry(this, transaction);
            if (this.queue.contains(priorityEntry)) {
                this.queue.remove(priorityEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(@NonNull String tag) {
        PriorityBlockingQueue<PriorityEntry<Transaction>> priorityBlockingQueue = this.queue;
        synchronized (priorityBlockingQueue) {
            Iterator<PriorityEntry<Transaction>> it = this.queue.iterator();
            while (it.hasNext()) {
                Object next = it.next().entry;
                if (((Transaction)next).name() == null || !((Transaction)next).name().equals(tag)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startIfNotAlive() {
        PriorityTransactionQueue priorityTransactionQueue = this;
        synchronized (priorityTransactionQueue) {
            if (!this.isAlive()) {
                try {
                    this.start();
                }
                catch (IllegalThreadStateException i) {
                    FlowLog.log(FlowLog.Level.E, i);
                }
            }
        }
    }

    @Override
    public void quit() {
        this.isQuitting = true;
        this.interrupt();
    }

    private void throwInvalidTransactionType(Transaction transaction) {
        throw new IllegalArgumentException("Transaction of type:" + (transaction != null ? transaction.transaction().getClass() : "Unknown") + " should be of type PriorityTransactionWrapper");
    }

    static class PriorityEntry<E extends Transaction>
    implements Comparable<PriorityEntry<Transaction>> {
        final E entry;
        final PriorityTransactionWrapper transactionWrapper;
        final /* synthetic */ PriorityTransactionQueue this$0;

        public PriorityEntry(E entry) {
            this.this$0 = this$0;
            this.entry = entry;
            this.transactionWrapper = ((Transaction)entry).transaction() instanceof PriorityTransactionWrapper ? (PriorityTransactionWrapper)((Transaction)entry).transaction() : new PriorityTransactionWrapper.Builder(((Transaction)entry).transaction()).build();
        }

        public E getEntry() {
            return this.entry;
        }

        @Override
        public int compareTo(@NonNull PriorityEntry<Transaction> another) {
            return this.transactionWrapper.compareTo(another.transactionWrapper);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PriorityEntry that = (PriorityEntry)o;
            return this.transactionWrapper != null ? this.transactionWrapper.equals(that.transactionWrapper) : that.transactionWrapper == null;
        }

        public int hashCode() {
            return this.transactionWrapper != null ? this.transactionWrapper.hashCode() : 0;
        }
    }
}

