/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.IConditional;
import com.raizlabs.android.dbflow.sql.language.IOperator;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.util.Collection;

public class Property<T>
implements IProperty<Property<T>>,
IConditional,
IOperator<T> {
    public static final Property<String> ALL_PROPERTY = new Property(null, NameAlias.rawBuilder("*").build());
    public static final Property<?> WILDCARD = new Property(null, NameAlias.rawBuilder("?").build());
    @Nullable
    final Class<?> table;
    protected NameAlias nameAlias;

    public static Property<String> allProperty(Class<?> table) {
        return new Property(table, NameAlias.rawBuilder("*").build()).withTable();
    }

    public Property(@Nullable Class<?> table, @NonNull NameAlias nameAlias) {
        this.table = table;
        this.nameAlias = nameAlias;
    }

    public Property(@Nullable Class<?> table, @Nullable String columnName) {
        this.table = table;
        if (columnName != null) {
            this.nameAlias = new NameAlias.Builder(columnName).build();
        }
    }

    public Property(@Nullable Class<?> table, @NonNull String columnName, @NonNull String aliasName) {
        this(table, NameAlias.builder(columnName).as(aliasName).build());
    }

    @Override
    @NonNull
    public Property<T> withTable() {
        return this.withTable(new NameAlias.Builder(FlowManager.getTableName(this.table)).build());
    }

    @Override
    @NonNull
    public NameAlias getNameAlias() {
        return this.nameAlias;
    }

    public String getQuery() {
        return this.getNameAlias().getQuery();
    }

    @Override
    @NonNull
    public String getCursorKey() {
        return this.getNameAlias().getQuery();
    }

    @NonNull
    public String getDefinition() {
        return this.getNameAlias().getFullQuery();
    }

    public String toString() {
        return this.getNameAlias().toString();
    }

    @Override
    @NonNull
    public Operator is(@NonNull IConditional conditional) {
        return this.getCondition().is(conditional);
    }

    @Override
    @NonNull
    public Operator eq(@NonNull IConditional conditional) {
        return this.getCondition().eq(conditional);
    }

    @Override
    @NonNull
    public Operator isNot(@NonNull IConditional conditional) {
        return this.getCondition().isNot(conditional);
    }

    @Override
    @NonNull
    public Operator notEq(@NonNull IConditional conditional) {
        return this.getCondition().notEq(conditional);
    }

    @Override
    @NonNull
    public Operator like(@NonNull IConditional conditional) {
        return this.getCondition().like(conditional);
    }

    @Override
    @NonNull
    public Operator glob(@NonNull IConditional conditional) {
        return this.getCondition().glob(conditional);
    }

    @Override
    @NonNull
    public Operator<T> like(@NonNull String value) {
        return this.getCondition().like(value);
    }

    @Override
    @NonNull
    public Operator<T> notLike(@NonNull String value) {
        return this.getCondition().notLike(value);
    }

    @Override
    @NonNull
    public Operator<T> glob(@NonNull String value) {
        return this.getCondition().glob(value);
    }

    @Override
    @NonNull
    public Operator greaterThan(@NonNull IConditional conditional) {
        return this.getCondition().greaterThan(conditional);
    }

    @Override
    @NonNull
    public Operator greaterThanOrEq(@NonNull IConditional conditional) {
        return this.getCondition().greaterThanOrEq(conditional);
    }

    @Override
    @NonNull
    public Operator lessThan(@NonNull IConditional conditional) {
        return this.getCondition().lessThan(conditional);
    }

    @Override
    @NonNull
    public Operator lessThanOrEq(@NonNull IConditional conditional) {
        return this.getCondition().lessThanOrEq(conditional);
    }

    @Override
    @NonNull
    public Operator.Between between(@NonNull IConditional conditional) {
        return this.getCondition().between(conditional);
    }

    @Override
    @NonNull
    public Operator.In in(@NonNull IConditional firstConditional, IConditional ... conditionals) {
        return this.getCondition().in(firstConditional, conditionals);
    }

    @Override
    @NonNull
    public Operator.In notIn(@NonNull IConditional firstConditional, IConditional ... conditionals) {
        return this.getCondition().notIn(firstConditional, conditionals);
    }

    @Override
    @NonNull
    public Operator is(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().is(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator isNull() {
        return this.getCondition().isNull();
    }

    @Override
    @NonNull
    public Operator eq(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().eq(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator isNot(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().isNot(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator isNotNull() {
        return this.getCondition().isNotNull();
    }

    @Override
    @NonNull
    public Operator notEq(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().notEq(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator like(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().like(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator notLike(@NonNull IConditional conditional) {
        return this.getCondition().notLike(conditional);
    }

    @Override
    @NonNull
    public Operator notLike(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().notLike(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator glob(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().glob(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator greaterThan(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().greaterThan(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator greaterThanOrEq(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().greaterThanOrEq(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator lessThan(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().lessThan(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator lessThanOrEq(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().lessThanOrEq(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator.Between between(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.getCondition().between(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator.In in(@NonNull BaseModelQueriable firstBaseModelQueriable, BaseModelQueriable ... baseModelQueriables) {
        return this.getCondition().in(firstBaseModelQueriable, baseModelQueriables);
    }

    @Override
    @NonNull
    public Operator.In notIn(@NonNull BaseModelQueriable firstBaseModelQueriable, BaseModelQueriable ... baseModelQueriables) {
        return this.getCondition().notIn(firstBaseModelQueriable, baseModelQueriables);
    }

    @Override
    @NonNull
    public Operator concatenate(@NonNull IConditional conditional) {
        return this.getCondition().concatenate(conditional);
    }

    @Override
    @NonNull
    public Operator plus(@NonNull BaseModelQueriable value) {
        return this.getCondition().plus(value);
    }

    @Override
    @NonNull
    public Operator minus(@NonNull BaseModelQueriable value) {
        return this.getCondition().minus(value);
    }

    @Override
    @NonNull
    public Operator div(@NonNull BaseModelQueriable value) {
        return this.getCondition().div(value);
    }

    @Override
    @NonNull
    public Operator times(@NonNull BaseModelQueriable value) {
        return this.getCondition().times(value);
    }

    @Override
    @NonNull
    public Operator rem(@NonNull BaseModelQueriable value) {
        return this.getCondition().rem(value);
    }

    @Override
    @NonNull
    public Class<?> getTable() {
        return this.table;
    }

    @Override
    @NonNull
    public Property<T> plus(@NonNull IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("+", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    @NonNull
    public Property<T> minus(@NonNull IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("-", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    @NonNull
    public Property<T> div(@NonNull IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("/", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public Property<T> times(@NonNull IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("*", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    @NonNull
    public Property<T> rem(@NonNull IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("%", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    @NonNull
    public Property<T> concatenate(@NonNull IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("||", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    @NonNull
    public Property<T> as(@NonNull String aliasName) {
        return new Property<T>(this.table, this.getNameAlias().newBuilder().as(aliasName).build());
    }

    @Override
    @NonNull
    public Property<T> distinct() {
        return new Property<T>(this.table, this.getDistinctAliasName());
    }

    @Override
    @NonNull
    public Property<T> withTable(@NonNull NameAlias tableNameAlias) {
        return new Property<T>(this.table, this.getNameAlias().newBuilder().withTable(tableNameAlias.getQuery()).build());
    }

    @Override
    @NonNull
    public Operator<T> is(@Nullable T value) {
        return this.getCondition().is(value);
    }

    @Override
    @NonNull
    public Operator<T> eq(@Nullable T value) {
        return this.getCondition().eq(value);
    }

    @Override
    @NonNull
    public Operator<T> isNot(@Nullable T value) {
        return this.getCondition().isNot(value);
    }

    @Override
    @NonNull
    public Operator<T> notEq(@Nullable T value) {
        return this.getCondition().notEq(value);
    }

    @Override
    @NonNull
    public Operator<T> greaterThan(@NonNull T value) {
        return this.getCondition().greaterThan(value);
    }

    @Override
    @NonNull
    public Operator<T> greaterThanOrEq(@NonNull T value) {
        return this.getCondition().greaterThanOrEq(value);
    }

    @Override
    @NonNull
    public Operator<T> lessThan(@NonNull T value) {
        return this.getCondition().lessThan(value);
    }

    @Override
    @NonNull
    public Operator<T> lessThanOrEq(@NonNull T value) {
        return this.getCondition().lessThanOrEq(value);
    }

    @Override
    @NonNull
    public Operator.Between<T> between(@NonNull T value) {
        return this.getCondition().between(value);
    }

    @Override
    @NonNull
    public Operator.In<T> in(@NonNull T firstValue, T ... values) {
        return this.getCondition().in(firstValue, values);
    }

    @Override
    @NonNull
    public Operator.In<T> notIn(@NonNull T firstValue, T ... values) {
        return this.getCondition().notIn(firstValue, values);
    }

    @Override
    @NonNull
    public Operator.In<T> in(@NonNull Collection<T> values) {
        return this.getCondition().in(values);
    }

    @Override
    @NonNull
    public Operator.In<T> notIn(@NonNull Collection<T> values) {
        return this.getCondition().notIn(values);
    }

    @Override
    @NonNull
    public Operator<T> concatenate(@Nullable T value) {
        return this.getCondition().concatenate((Object)value);
    }

    @Override
    @NonNull
    public Operator<T> plus(@NonNull T value) {
        return this.getCondition().plus(value);
    }

    @Override
    @NonNull
    public Operator<T> minus(@NonNull T value) {
        return this.getCondition().minus(value);
    }

    @Override
    @NonNull
    public Operator<T> div(@NonNull T value) {
        return this.getCondition().div(value);
    }

    @Override
    public Operator<T> times(@NonNull T value) {
        return this.getCondition().times(value);
    }

    @Override
    @NonNull
    public Operator<T> rem(@NonNull T value) {
        return this.getCondition().rem(value);
    }

    @Override
    @NonNull
    public OrderBy asc() {
        return OrderBy.fromProperty(this).ascending();
    }

    @Override
    @NonNull
    public OrderBy desc() {
        return OrderBy.fromProperty(this).descending();
    }

    protected NameAlias getDistinctAliasName() {
        return this.getNameAlias().newBuilder().distinct().build();
    }

    @NonNull
    protected Operator<T> getCondition() {
        return Operator.op(this.getNameAlias());
    }
}

