/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseTransformable;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.IndexedBy;
import com.raizlabs.android.dbflow.sql.language.Join;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Update;
import com.raizlabs.android.dbflow.sql.language.property.IndexProperty;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.BaseModel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class From<TModel>
extends BaseTransformable<TModel> {
    @NonNull
    private Query queryBase;
    @Nullable
    private NameAlias tableAlias;
    @NonNull
    private final List<Join> joins = new ArrayList<Join>();

    private NameAlias getTableAlias() {
        if (this.tableAlias == null) {
            this.tableAlias = new NameAlias.Builder(FlowManager.getTableName(this.getTable())).build();
        }
        return this.tableAlias;
    }

    public From(@NonNull Query querybase, @NonNull Class<TModel> table) {
        super(table);
        this.queryBase = querybase;
    }

    @NonNull
    public From<TModel> as(String alias) {
        this.tableAlias = this.getTableAlias().newBuilder().as(alias).build();
        return this;
    }

    @NonNull
    public <TJoin> Join<TJoin, TModel> join(Class<TJoin> table, @NonNull Join.JoinType joinType) {
        Join join = new Join(this, table, joinType);
        this.joins.add(join);
        return join;
    }

    @NonNull
    public <TJoin> Join<TJoin, TModel> join(ModelQueriable<TJoin> modelQueriable, @NonNull Join.JoinType joinType) {
        Join join = new Join(this, joinType, modelQueriable);
        this.joins.add(join);
        return join;
    }

    @NonNull
    public <TJoin> Join<TJoin, TModel> crossJoin(Class<TJoin> table) {
        return this.join(table, Join.JoinType.CROSS);
    }

    @NonNull
    public <TJoin> Join<TJoin, TModel> crossJoin(ModelQueriable<TJoin> modelQueriable) {
        return this.join(modelQueriable, Join.JoinType.CROSS);
    }

    @NonNull
    public <TJoin> Join<TJoin, TModel> innerJoin(Class<TJoin> table) {
        return this.join(table, Join.JoinType.INNER);
    }

    @NonNull
    public <TJoin> Join<TJoin, TModel> innerJoin(ModelQueriable<TJoin> modelQueriable) {
        return this.join(modelQueriable, Join.JoinType.INNER);
    }

    @NonNull
    public <TJoin> Join<TJoin, TModel> leftOuterJoin(Class<TJoin> table) {
        return this.join(table, Join.JoinType.LEFT_OUTER);
    }

    @NonNull
    public <TJoin> Join<TJoin, TModel> leftOuterJoin(ModelQueriable<TJoin> modelQueriable) {
        return this.join(modelQueriable, Join.JoinType.LEFT_OUTER);
    }

    @NonNull
    public <TJoin> Join<TJoin, TModel> naturalJoin(Class<TJoin> table) {
        return this.join(table, Join.JoinType.NATURAL);
    }

    @NonNull
    public <TJoin> Join<TJoin, TModel> naturalJoin(ModelQueriable<TJoin> modelQueriable) {
        return this.join(modelQueriable, Join.JoinType.NATURAL);
    }

    @NonNull
    public IndexedBy<TModel> indexedBy(IndexProperty<TModel> indexProperty) {
        return new IndexedBy<TModel>(indexProperty, this);
    }

    @Override
    @NonNull
    public BaseModel.Action getPrimaryAction() {
        return this.queryBase instanceof Delete ? BaseModel.Action.DELETE : BaseModel.Action.CHANGE;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder().append((Object)this.queryBase.getQuery());
        if (!(this.queryBase instanceof Update)) {
            queryBuilder.append((Object)"FROM ");
        }
        queryBuilder.append((Object)this.getTableAlias());
        if (this.queryBase instanceof Select) {
            if (!this.joins.isEmpty()) {
                queryBuilder.appendSpace();
            }
            for (Join join : this.joins) {
                queryBuilder.append((Object)join.getQuery());
            }
        } else {
            queryBuilder.appendSpace();
        }
        return queryBuilder.getQuery();
    }

    @Override
    @NonNull
    public Query getQueryBuilderBase() {
        return this.queryBase;
    }

    @NonNull
    public Set<Class<?>> getAssociatedTables() {
        LinkedHashSet tables = new LinkedHashSet();
        tables.add(this.getTable());
        for (Join join : this.joins) {
            tables.add(join.getTable());
        }
        return tables;
    }
}

