/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.database.sqlite.SQLiteDoneException;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.runtime.NotifyDistributor;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.Actionable;
import com.raizlabs.android.dbflow.sql.queriable.Queriable;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatementWrapper;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.FlowCursor;

public abstract class BaseQueriable<TModel>
implements Queriable,
Actionable {
    private final Class<TModel> table;

    protected BaseQueriable(Class<TModel> table) {
        this.table = table;
    }

    @NonNull
    public Class<TModel> getTable() {
        return this.table;
    }

    @Override
    public long count(@NonNull DatabaseWrapper databaseWrapper) {
        return this.longValue(databaseWrapper);
    }

    @Override
    public long count() {
        return this.longValue();
    }

    @Override
    public long longValue() {
        return this.longValue(FlowManager.getWritableDatabaseForTable(this.table));
    }

    @Override
    public long longValue(DatabaseWrapper databaseWrapper) {
        try {
            String query = this.getQuery();
            FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
            return SqlUtils.longForQuery(databaseWrapper, query);
        }
        catch (SQLiteDoneException sde) {
            FlowLog.log(FlowLog.Level.W, sde);
            return 0L;
        }
    }

    @Override
    public boolean hasData() {
        return this.count() > 0L;
    }

    @Override
    public boolean hasData(@NonNull DatabaseWrapper databaseWrapper) {
        return this.count(databaseWrapper) > 0L;
    }

    @Override
    public FlowCursor query() {
        this.query(FlowManager.getWritableDatabaseForTable(this.table));
        return null;
    }

    @Override
    public FlowCursor query(@NonNull DatabaseWrapper databaseWrapper) {
        if (this.getPrimaryAction().equals((Object)BaseModel.Action.INSERT)) {
            DatabaseStatement databaseStatement = this.compileStatement(databaseWrapper);
            databaseStatement.executeInsert();
            databaseStatement.close();
        } else {
            String query = this.getQuery();
            FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
            databaseWrapper.execSQL(query);
        }
        return null;
    }

    @Override
    public long executeInsert() {
        return this.executeInsert(FlowManager.getWritableDatabaseForTable(this.table));
    }

    @Override
    public long executeInsert(@NonNull DatabaseWrapper databaseWrapper) {
        return this.compileStatement().executeInsert();
    }

    @Override
    public void execute() {
        FlowCursor cursor = this.query();
        if (cursor != null) {
            cursor.close();
        } else {
            NotifyDistributor.get().notifyTableChanged(this.getTable(), this.getPrimaryAction());
        }
    }

    @Override
    public void execute(@NonNull DatabaseWrapper databaseWrapper) {
        FlowCursor cursor = this.query(databaseWrapper);
        if (cursor != null) {
            cursor.close();
        } else {
            NotifyDistributor.get().notifyTableChanged(this.getTable(), this.getPrimaryAction());
        }
    }

    @Override
    @NonNull
    public DatabaseStatement compileStatement() {
        return this.compileStatement(FlowManager.getWritableDatabaseForTable(this.table));
    }

    @Override
    @NonNull
    public DatabaseStatement compileStatement(@NonNull DatabaseWrapper databaseWrapper) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Compiling Query Into Statement: " + query);
        return new DatabaseStatementWrapper(databaseWrapper.compileStatement(query), this);
    }

    public String toString() {
        return this.getQuery();
    }

    @Override
    @NonNull
    public abstract BaseModel.Action getPrimaryAction();
}

