/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.runtime;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.runtime.DBBatchSaveQueue;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransactionQueue;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;

public abstract class BaseTransactionManager {
    private final ITransactionQueue transactionQueue;
    private DBBatchSaveQueue saveQueue;

    public BaseTransactionManager(@NonNull ITransactionQueue transactionQueue, @NonNull DatabaseDefinition databaseDefinition) {
        this.transactionQueue = transactionQueue;
        this.saveQueue = new DBBatchSaveQueue(databaseDefinition);
        this.checkQueue();
    }

    @NonNull
    public DBBatchSaveQueue getSaveQueue() {
        try {
            if (!this.saveQueue.isAlive()) {
                this.saveQueue.start();
            }
        }
        catch (IllegalThreadStateException i) {
            FlowLog.logError(i);
        }
        return this.saveQueue;
    }

    @NonNull
    public ITransactionQueue getQueue() {
        return this.transactionQueue;
    }

    public void checkQueue() {
        this.getQueue().startIfNotAlive();
    }

    public void stopQueue() {
        this.getQueue().quit();
    }

    public void addTransaction(@NonNull Transaction transaction) {
        this.getQueue().add(transaction);
    }

    public void cancelTransaction(@NonNull Transaction transaction) {
        this.getQueue().cancel(transaction);
    }
}

