/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.annotation.Collate;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.converter.TypeConverter;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.BaseOperator;
import com.raizlabs.android.dbflow.sql.language.IConditional;
import com.raizlabs.android.dbflow.sql.language.IOperator;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Operator<T>
extends BaseOperator
implements IOperator<T> {
    private TypeConverter typeConverter;
    private boolean convertToDB;

    public static String convertValueToString(Object value) {
        return BaseOperator.convertValueToString(value, false);
    }

    @NonNull
    public static <T> Operator<T> op(NameAlias column) {
        return new Operator<T>(column);
    }

    @NonNull
    public static <T> Operator<T> op(NameAlias alias, TypeConverter typeConverter, boolean convertToDB) {
        return new Operator<T>(alias, typeConverter, convertToDB);
    }

    Operator(NameAlias nameAlias) {
        super(nameAlias);
    }

    Operator(NameAlias alias, TypeConverter typeConverter, boolean convertToDB) {
        super(alias);
        this.typeConverter = typeConverter;
        this.convertToDB = convertToDB;
    }

    Operator(Operator operator) {
        super(operator.nameAlias);
        this.typeConverter = operator.typeConverter;
        this.convertToDB = operator.convertToDB;
        this.value = operator.value;
    }

    @Override
    public void appendConditionToQuery(@NonNull QueryBuilder queryBuilder) {
        queryBuilder.append((Object)this.columnName()).append((Object)this.operation());
        if (this.isValueSet) {
            queryBuilder.append((Object)this.convertObjectToString(this.value(), true));
        }
        if (this.postArgument() != null) {
            queryBuilder.appendSpace().append((Object)this.postArgument());
        }
    }

    @Override
    @NonNull
    public Operator<T> is(@Nullable T value) {
        this.operation = "=";
        return this.value(value);
    }

    @Override
    @NonNull
    public Operator<T> eq(@Nullable T value) {
        return this.is(value);
    }

    @Override
    @NonNull
    public Operator<T> isNot(@Nullable T value) {
        this.operation = "!=";
        return this.value(value);
    }

    @Override
    @NonNull
    public Operator<T> notEq(@Nullable T value) {
        return this.isNot(value);
    }

    @Override
    @NonNull
    public Operator<T> like(@NonNull String value) {
        this.operation = String.format(" %1s ", "LIKE");
        return this.value(value);
    }

    @Override
    @NonNull
    public Operator<T> notLike(@NonNull String value) {
        this.operation = String.format(" %1s ", "NOT LIKE");
        return this.value(value);
    }

    @Override
    @NonNull
    public Operator<T> glob(@NonNull String value) {
        this.operation = String.format(" %1s ", "GLOB");
        return this.value(value);
    }

    public Operator<T> value(@Nullable Object value) {
        this.value = value;
        this.isValueSet = true;
        return this;
    }

    @Override
    @NonNull
    public Operator<T> greaterThan(@NonNull T value) {
        this.operation = ">";
        return this.value(value);
    }

    @Override
    @NonNull
    public Operator<T> greaterThanOrEq(@NonNull T value) {
        this.operation = ">=";
        return this.value(value);
    }

    @Override
    @NonNull
    public Operator<T> lessThan(@NonNull T value) {
        this.operation = "<";
        return this.value(value);
    }

    @Override
    @NonNull
    public Operator<T> lessThanOrEq(@NonNull T value) {
        this.operation = "<=";
        return this.value(value);
    }

    @Override
    @NonNull
    public Operator<T> plus(@NonNull T value) {
        return this.assignValueOp(value, "+");
    }

    @Override
    @NonNull
    public Operator<T> minus(@NonNull T value) {
        return this.assignValueOp(value, "-");
    }

    @Override
    @NonNull
    public Operator<T> div(@NonNull T value) {
        return this.assignValueOp(value, "/");
    }

    @Override
    public Operator<T> times(@NonNull T value) {
        return this.assignValueOp(value, "*");
    }

    @Override
    @NonNull
    public Operator<T> rem(@NonNull T value) {
        return this.assignValueOp(value, "%");
    }

    @NonNull
    public Operator<T> operation(String operation) {
        this.operation = operation;
        return this;
    }

    @NonNull
    public Operator<T> collate(@NonNull String collation) {
        this.postArg = "COLLATE " + collation;
        return this;
    }

    @NonNull
    public Operator<T> collate(@NonNull Collate collation) {
        if (collation.equals((Object)Collate.NONE)) {
            this.postArg = null;
        } else {
            this.collate(collation.name());
        }
        return this;
    }

    @NonNull
    public Operator<T> postfix(@NonNull String postfix) {
        this.postArg = postfix;
        return this;
    }

    @Override
    @NonNull
    public Operator<T> isNull() {
        this.operation = String.format(" %1s ", "IS NULL");
        return this;
    }

    @Override
    @NonNull
    public Operator<T> isNotNull() {
        this.operation = String.format(" %1s ", "IS NOT NULL");
        return this;
    }

    @Override
    @NonNull
    public Operator<T> separator(@NonNull String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    @NonNull
    public Operator is(@NonNull IConditional conditional) {
        return this.assignValueOp(conditional, "=");
    }

    @Override
    @NonNull
    public Operator eq(@NonNull IConditional conditional) {
        return this.assignValueOp(conditional, "=");
    }

    @Override
    @NonNull
    public Operator isNot(@NonNull IConditional conditional) {
        return this.assignValueOp(conditional, "!=");
    }

    @Override
    @NonNull
    public Operator notEq(@NonNull IConditional conditional) {
        return this.assignValueOp(conditional, "!=");
    }

    @Override
    @NonNull
    public Operator<T> like(@NonNull IConditional conditional) {
        return this.like(conditional.getQuery());
    }

    @Override
    @NonNull
    public Operator<T> glob(@NonNull IConditional conditional) {
        return this.glob(conditional.getQuery());
    }

    @Override
    @NonNull
    public Operator<T> greaterThan(@NonNull IConditional conditional) {
        return this.assignValueOp(conditional, ">");
    }

    @Override
    @NonNull
    public Operator<T> greaterThanOrEq(@NonNull IConditional conditional) {
        return this.assignValueOp(conditional, ">=");
    }

    @Override
    @NonNull
    public Operator<T> lessThan(@NonNull IConditional conditional) {
        return this.assignValueOp(conditional, "<");
    }

    @Override
    @NonNull
    public Operator<T> lessThanOrEq(@NonNull IConditional conditional) {
        return this.assignValueOp(conditional, "<=");
    }

    @Override
    @NonNull
    public Between between(@NonNull IConditional conditional) {
        return new Between(this, conditional);
    }

    @Override
    @NonNull
    public In in(@NonNull IConditional firstConditional, IConditional ... conditionals) {
        return new In(this, firstConditional, true, conditionals);
    }

    @Override
    @NonNull
    public In notIn(@NonNull IConditional firstConditional, IConditional ... conditionals) {
        return new In(this, firstConditional, false, conditionals);
    }

    @Override
    @NonNull
    public In notIn(@NonNull BaseModelQueriable firstBaseModelQueriable, @NonNull BaseModelQueriable[] baseModelQueriables) {
        return new In(this, firstBaseModelQueriable, false, baseModelQueriables);
    }

    @Override
    @NonNull
    public Operator is(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, "=");
    }

    @Override
    @NonNull
    public Operator eq(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, "=");
    }

    @Override
    @NonNull
    public Operator isNot(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, "!=");
    }

    @Override
    @NonNull
    public Operator notEq(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, "!=");
    }

    @Override
    @NonNull
    public Operator<T> like(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, "LIKE");
    }

    @Override
    @NonNull
    public Operator notLike(@NonNull IConditional conditional) {
        return this.assignValueOp(conditional, "NOT LIKE");
    }

    @Override
    @NonNull
    public Operator notLike(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, "NOT LIKE");
    }

    @Override
    @NonNull
    public Operator<T> glob(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, "GLOB");
    }

    @Override
    @NonNull
    public Operator<T> greaterThan(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, ">");
    }

    @Override
    @NonNull
    public Operator<T> greaterThanOrEq(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, ">=");
    }

    @Override
    @NonNull
    public Operator<T> lessThan(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, "<");
    }

    @Override
    @NonNull
    public Operator<T> lessThanOrEq(@NonNull BaseModelQueriable baseModelQueriable) {
        return this.assignValueOp(baseModelQueriable, "<=");
    }

    @Override
    @NonNull
    public Operator plus(IConditional value) {
        return this.assignValueOp(value, "+");
    }

    @Override
    @NonNull
    public Operator minus(IConditional value) {
        return this.assignValueOp(value, "-");
    }

    @Override
    @NonNull
    public Operator div(IConditional value) {
        return this.assignValueOp(value, "/");
    }

    @Override
    @NonNull
    public Operator times(IConditional value) {
        return this.assignValueOp(value, "*");
    }

    @Override
    @NonNull
    public Operator rem(IConditional value) {
        return this.assignValueOp(value, "%");
    }

    @Override
    @NonNull
    public Operator plus(@NonNull BaseModelQueriable value) {
        return this.assignValueOp(value, "+");
    }

    @Override
    @NonNull
    public Operator minus(@NonNull BaseModelQueriable value) {
        return this.assignValueOp(value, "-");
    }

    @Override
    @NonNull
    public Operator div(@NonNull BaseModelQueriable value) {
        return this.assignValueOp(value, "/");
    }

    @Override
    @NonNull
    public Operator times(@NonNull BaseModelQueriable value) {
        return this.assignValueOp(value, "*");
    }

    @Override
    @NonNull
    public Operator rem(@NonNull BaseModelQueriable value) {
        return this.assignValueOp(value, "%");
    }

    @Override
    @NonNull
    public Between between(@NonNull BaseModelQueriable baseModelQueriable) {
        return new Between(this, baseModelQueriable);
    }

    @Override
    @NonNull
    public In in(@NonNull BaseModelQueriable firstBaseModelQueriable, BaseModelQueriable ... baseModelQueriables) {
        return new In(this, firstBaseModelQueriable, true, baseModelQueriables);
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder();
        this.appendConditionToQuery(queryBuilder);
        return queryBuilder.getQuery();
    }

    @Override
    @NonNull
    public Operator<T> concatenate(@Nullable Object value) {
        this.operation = new QueryBuilder((Object)"=").append((Object)this.columnName()).toString();
        TypeConverter typeConverter = this.typeConverter;
        if (typeConverter == null && value != null) {
            typeConverter = FlowManager.getTypeConverterForClass(value.getClass());
        }
        if (typeConverter != null && this.convertToDB) {
            value = typeConverter.getDBValue(value);
        }
        if (value instanceof String || value instanceof IOperator || value instanceof Character) {
            this.operation = String.format("%1s %1s ", this.operation, "||");
        } else if (value instanceof Number) {
            this.operation = String.format("%1s %1s ", this.operation, "+");
        } else {
            throw new IllegalArgumentException(String.format("Cannot concatenate the %1s", value != null ? value.getClass() : "null"));
        }
        this.value = value;
        this.isValueSet = true;
        return this;
    }

    @Override
    @NonNull
    public Operator<T> concatenate(@NonNull IConditional conditional) {
        return this.concatenate((Object)conditional);
    }

    @Override
    @NonNull
    public Between<T> between(@NonNull T value) {
        return new Between(this, value);
    }

    @Override
    @SafeVarargs
    @NonNull
    public final In<T> in(@NonNull T firstArgument, T ... arguments) {
        return new In(this, firstArgument, true, (Object[])arguments);
    }

    @Override
    @SafeVarargs
    @NonNull
    public final In<T> notIn(@NonNull T firstArgument, T ... arguments) {
        return new In(this, firstArgument, false, (Object[])arguments);
    }

    @Override
    @NonNull
    public In<T> in(@NonNull Collection<T> values) {
        return new In(this, values, true);
    }

    @Override
    @NonNull
    public In<T> notIn(@NonNull Collection<T> values) {
        return new In(this, values, false);
    }

    @Override
    public String convertObjectToString(Object object, boolean appendInnerParenthesis) {
        if (this.typeConverter != null) {
            Object converted = object;
            try {
                converted = this.convertToDB ? this.typeConverter.getDBValue(object) : object;
            }
            catch (ClassCastException c) {
                FlowLog.log(FlowLog.Level.W, c);
            }
            return BaseOperator.convertValueToString(converted, appendInnerParenthesis, false);
        }
        return super.convertObjectToString(object, appendInnerParenthesis);
    }

    private Operator<T> assignValueOp(Object value, String operation) {
        this.operation = operation;
        return this.value(value);
    }

    public static class In<T>
    extends BaseOperator
    implements Query {
        private List<T> inArguments = new ArrayList<T>();

        @SafeVarargs
        private In(Operator<T> operator, T firstArgument, boolean isIn, T ... arguments) {
            super(operator.columnAlias());
            this.inArguments.add(firstArgument);
            Collections.addAll(this.inArguments, arguments);
            this.operation = String.format(" %1s ", isIn ? "IN" : "NOT IN");
        }

        private In(Operator<T> operator, Collection<T> args, boolean isIn) {
            super(operator.columnAlias());
            this.inArguments.addAll(args);
            this.operation = String.format(" %1s ", isIn ? "IN" : "NOT IN");
        }

        @NonNull
        public In<T> and(@Nullable T argument) {
            this.inArguments.add(argument);
            return this;
        }

        @Override
        public void appendConditionToQuery(@NonNull QueryBuilder queryBuilder) {
            queryBuilder.append((Object)this.columnName()).append((Object)this.operation()).append((Object)"(").append((Object)OperatorGroup.joinArguments(",", this.inArguments, this)).append((Object)")");
        }

        public String getQuery() {
            QueryBuilder builder = new QueryBuilder();
            this.appendConditionToQuery(builder);
            return builder.getQuery();
        }
    }

    public static class Between<T>
    extends BaseOperator
    implements Query {
        @Nullable
        private T secondValue;

        private Between(Operator<T> operator, T value) {
            super(operator.nameAlias);
            this.operation = String.format(" %1s ", "BETWEEN");
            this.value = value;
            this.isValueSet = true;
            this.postArg = operator.postArgument();
        }

        @NonNull
        public Between<T> and(@Nullable T secondValue) {
            this.secondValue = secondValue;
            return this;
        }

        @Nullable
        public T secondValue() {
            return this.secondValue;
        }

        @Override
        public void appendConditionToQuery(@NonNull QueryBuilder queryBuilder) {
            queryBuilder.append((Object)this.columnName()).append((Object)this.operation()).append((Object)this.convertObjectToString(this.value(), true)).appendSpaceSeparated((Object)"AND").append((Object)this.convertObjectToString(this.secondValue(), true)).appendSpace().appendOptional((Object)this.postArgument());
        }

        public String getQuery() {
            QueryBuilder builder = new QueryBuilder();
            this.appendConditionToQuery(builder);
            return builder.getQuery();
        }
    }

    public static class Operation {
        public static final String EQUALS = "=";
        public static final String NOT_EQUALS = "!=";
        public static final String CONCATENATE = "||";
        public static final String PLUS = "+";
        public static final String MINUS = "-";
        public static final String DIVISION = "/";
        public static final String MULTIPLY = "*";
        public static final String MOD = "%";
        public static final String LIKE = "LIKE";
        public static final String NOT_LIKE = "NOT LIKE";
        public static final String GLOB = "GLOB";
        public static final String GREATER_THAN = ">";
        public static final String GREATER_THAN_OR_EQUALS = ">=";
        public static final String LESS_THAN = "<";
        public static final String LESS_THAN_OR_EQUALS = "<=";
        public static final String BETWEEN = "BETWEEN";
        public static final String AND = "AND";
        public static final String OR = "OR";
        public static final String EMPTY_PARAM = "?";
        public static final String IS_NOT_NULL = "IS NOT NULL";
        public static final String IS_NULL = "IS NULL";
        public static final String IN = "IN";
        public static final String NOT_IN = "NOT IN";
    }
}

