/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.List;

public class Index<TModel>
implements Query {
    @NonNull
    private final String indexName;
    @NonNull
    private Class<TModel> table;
    private List<NameAlias> columns;
    private boolean isUnique = false;

    public Index(@NonNull String indexName) {
        this.indexName = indexName;
        this.columns = new ArrayList<NameAlias>();
    }

    @NonNull
    public Index<TModel> unique(boolean unique) {
        this.isUnique = unique;
        return this;
    }

    @NonNull
    public Index<TModel> on(@NonNull Class<TModel> table, IProperty ... properties) {
        this.table = table;
        for (IProperty property : properties) {
            this.and(property);
        }
        return this;
    }

    @NonNull
    public Index<TModel> on(@NonNull Class<TModel> table, @NonNull NameAlias firstAlias, NameAlias ... columns) {
        this.table = table;
        this.and(firstAlias);
        for (NameAlias column : columns) {
            this.and(column);
        }
        return this;
    }

    @NonNull
    public Index<TModel> and(@NonNull IProperty property) {
        if (!this.columns.contains(property.getNameAlias())) {
            this.columns.add(property.getNameAlias());
        }
        return this;
    }

    @NonNull
    public Index<TModel> and(@NonNull NameAlias columnName) {
        if (!this.columns.contains(columnName)) {
            this.columns.add(columnName);
        }
        return this;
    }

    @NonNull
    public String getIndexName() {
        return this.indexName;
    }

    @NonNull
    public Class<TModel> getTable() {
        return this.table;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void enable(@NonNull DatabaseWrapper databaseWrapper) {
        if (this.table == null) {
            throw new IllegalStateException("Please call on() to set a table to use this index on.");
        }
        if (this.columns == null || this.columns.isEmpty()) {
            throw new IllegalStateException("There should be at least one column in this index");
        }
        databaseWrapper.execSQL(this.getQuery());
    }

    public void enable() {
        this.enable(FlowManager.getDatabaseForTable(this.table).getWritableDatabase());
    }

    public void disable() {
        SqlUtils.dropIndex(FlowManager.getDatabaseForTable(this.table).getWritableDatabase(), this.indexName);
    }

    public void disable(DatabaseWrapper databaseWrapper) {
        SqlUtils.dropIndex(databaseWrapper, this.indexName);
    }

    public String getQuery() {
        return new QueryBuilder((Object)"CREATE ").append((Object)(this.isUnique ? "UNIQUE " : "")).append((Object)"INDEX IF NOT EXISTS ").appendQuotedIfNeeded(this.indexName).append((Object)" ON ").append((Object)FlowManager.getTableName(this.table)).append((Object)"(").appendList(this.columns).append((Object)")").getQuery();
    }
}

