/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database.transaction;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;

public final class Transaction {
    private static Handler TRANSACTION_HANDLER;
    final Error errorCallback;
    final Success successCallback;
    final ITransaction transaction;
    final DatabaseDefinition databaseDefinition;
    final String name;
    final boolean shouldRunInTransaction;
    final boolean runCallbacksOnSameThread;

    static Handler getTransactionHandler() {
        if (TRANSACTION_HANDLER == null) {
            TRANSACTION_HANDLER = new Handler(Looper.getMainLooper());
        }
        return TRANSACTION_HANDLER;
    }

    Transaction(Builder builder) {
        this.databaseDefinition = builder.databaseDefinition;
        this.errorCallback = builder.errorCallback;
        this.successCallback = builder.successCallback;
        this.transaction = builder.transaction;
        this.name = builder.name;
        this.shouldRunInTransaction = builder.shouldRunInTransaction;
        this.runCallbacksOnSameThread = builder.runCallbacksOnSameThread;
    }

    @Nullable
    public Error error() {
        return this.errorCallback;
    }

    @Nullable
    public Success success() {
        return this.successCallback;
    }

    @NonNull
    public ITransaction transaction() {
        return this.transaction;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    public void execute() {
        this.databaseDefinition.getTransactionManager().addTransaction(this);
    }

    public void cancel() {
        this.databaseDefinition.getTransactionManager().cancelTransaction(this);
    }

    public void executeSync() {
        try {
            if (this.shouldRunInTransaction) {
                this.databaseDefinition.executeTransaction(this.transaction);
            } else {
                this.transaction.execute(this.databaseDefinition.getWritableDatabase());
            }
            if (this.successCallback != null) {
                if (this.runCallbacksOnSameThread) {
                    this.successCallback.onSuccess(this);
                } else {
                    Transaction.getTransactionHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            Transaction.this.successCallback.onSuccess(Transaction.this);
                        }
                    });
                }
            }
        }
        catch (Throwable throwable) {
            FlowLog.logError(throwable);
            if (this.errorCallback != null) {
                if (this.runCallbacksOnSameThread) {
                    this.errorCallback.onError(this, throwable);
                } else {
                    Transaction.getTransactionHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            Transaction.this.errorCallback.onError(Transaction.this, throwable);
                        }
                    });
                }
            }
            throw new RuntimeException("An exception occurred while executing a transaction", throwable);
        }
    }

    @NonNull
    public Builder newBuilder() {
        return new Builder(this.transaction, this.databaseDefinition).error(this.errorCallback).success(this.successCallback).name(this.name).shouldRunInTransaction(this.shouldRunInTransaction).runCallbacksOnSameThread(this.runCallbacksOnSameThread);
    }

    public static final class Builder {
        final ITransaction transaction;
        @NonNull
        final DatabaseDefinition databaseDefinition;
        Error errorCallback;
        Success successCallback;
        String name;
        boolean shouldRunInTransaction = true;
        private boolean runCallbacksOnSameThread;

        public Builder(@NonNull ITransaction transaction, @NonNull DatabaseDefinition databaseDefinition) {
            this.transaction = transaction;
            this.databaseDefinition = databaseDefinition;
        }

        @NonNull
        public Builder error(@Nullable Error errorCallback) {
            this.errorCallback = errorCallback;
            return this;
        }

        @NonNull
        public Builder success(@Nullable Success successCallback) {
            this.successCallback = successCallback;
            return this;
        }

        @NonNull
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder shouldRunInTransaction(boolean shouldRunInTransaction) {
            this.shouldRunInTransaction = shouldRunInTransaction;
            return this;
        }

        @NonNull
        public Builder runCallbacksOnSameThread(boolean runCallbacksOnSameThread) {
            this.runCallbacksOnSameThread = runCallbacksOnSameThread;
            return this;
        }

        @NonNull
        public Transaction build() {
            return new Transaction(this);
        }

        public void execute() {
            this.build().execute();
        }
    }

    public static interface Success {
        public void onSuccess(@NonNull Transaction var1);
    }

    public static interface Error {
        public void onError(@NonNull Transaction var1, @NonNull Throwable var2);
    }
}

