/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.config;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.DatabaseHolder;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.converter.TypeConverter;
import com.raizlabs.android.dbflow.runtime.ModelNotifier;
import com.raizlabs.android.dbflow.runtime.TableNotifierRegister;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.migration.Migration;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import com.raizlabs.android.dbflow.structure.InvalidDBConfiguration;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.ModelViewAdapter;
import com.raizlabs.android.dbflow.structure.QueryModelAdapter;
import com.raizlabs.android.dbflow.structure.RetrievalAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlowManager {
    static FlowConfig config;
    private static GlobalDatabaseHolder globalDatabaseHolder;
    private static HashSet<Class<? extends DatabaseHolder>> loadedModules;
    private static final String DEFAULT_DATABASE_HOLDER_NAME = "GeneratedDatabaseHolder";
    private static final String DEFAULT_DATABASE_HOLDER_PACKAGE_NAME;
    private static final String DEFAULT_DATABASE_HOLDER_CLASSNAME;

    @NonNull
    public static String getTableName(Class<?> table) {
        ModelAdapter<?> modelAdapter = FlowManager.getModelAdapterOrNull(table);
        String tableName = null;
        if (modelAdapter == null) {
            ModelViewAdapter<?> modelViewAdapter = FlowManager.getModelViewAdapterOrNull(table);
            if (modelViewAdapter != null) {
                tableName = modelViewAdapter.getViewName();
            } else {
                FlowManager.throwCannotFindAdapter("ModelAdapter/ModelViewAdapter", table);
            }
        } else {
            tableName = modelAdapter.getTableName();
        }
        return tableName;
    }

    public static Class<?> getTableClassForName(String databaseName, String tableName) {
        DatabaseDefinition databaseDefinition = FlowManager.getDatabase(databaseName);
        Class<?> modelClass = databaseDefinition.getModelClassForName(tableName);
        if (modelClass == null && (modelClass = databaseDefinition.getModelClassForName(QueryBuilder.quote((String)tableName))) == null) {
            throw new IllegalArgumentException(String.format("The specified table %1s was not found. Did you forget to add the @Table annotation and point it to %1s?", tableName, databaseName));
        }
        return modelClass;
    }

    public static Class<?> getTableClassForName(Class<?> databaseClass, String tableName) {
        DatabaseDefinition databaseDefinition = FlowManager.getDatabase(databaseClass);
        Class<?> modelClass = databaseDefinition.getModelClassForName(tableName);
        if (modelClass == null && (modelClass = databaseDefinition.getModelClassForName(QueryBuilder.quote((String)tableName))) == null) {
            throw new IllegalArgumentException(String.format("The specified table %1s was not found. Did you forget to add the @Table annotation and point it to %1s?", tableName, databaseClass));
        }
        return modelClass;
    }

    @NonNull
    public static DatabaseDefinition getDatabaseForTable(Class<?> table) {
        FlowManager.checkDatabaseHolder();
        DatabaseDefinition databaseDefinition = globalDatabaseHolder.getDatabaseForTable(table);
        if (databaseDefinition == null) {
            throw new InvalidDBConfiguration("Model object: " + table.getName() + " is not registered with a Database. Did you forget an annotation?");
        }
        return databaseDefinition;
    }

    @NonNull
    public static DatabaseDefinition getDatabase(Class<?> databaseClass) {
        FlowManager.checkDatabaseHolder();
        DatabaseDefinition databaseDefinition = globalDatabaseHolder.getDatabase(databaseClass);
        if (databaseDefinition == null) {
            throw new InvalidDBConfiguration("Database: " + databaseClass.getName() + " is not a registered Database. Did you forget the @Database annotation?");
        }
        return databaseDefinition;
    }

    @NonNull
    public static String getDatabaseName(Class<?> database) {
        return FlowManager.getDatabase(database).getDatabaseName();
    }

    @NonNull
    public static DatabaseWrapper getWritableDatabaseForTable(Class<?> table) {
        return FlowManager.getDatabaseForTable(table).getWritableDatabase();
    }

    @NonNull
    public static DatabaseDefinition getDatabase(String databaseName) {
        FlowManager.checkDatabaseHolder();
        DatabaseDefinition database = globalDatabaseHolder.getDatabase(databaseName);
        if (database != null) {
            return database;
        }
        throw new InvalidDBConfiguration("The specified database" + databaseName + " was not found. Did you forget the @Database annotation?");
    }

    @NonNull
    public static DatabaseWrapper getWritableDatabase(String databaseName) {
        return FlowManager.getDatabase(databaseName).getWritableDatabase();
    }

    @NonNull
    public static DatabaseWrapper getWritableDatabase(Class<?> databaseClass) {
        return FlowManager.getDatabase(databaseClass).getWritableDatabase();
    }

    public static void initModule(Class<? extends DatabaseHolder> generatedClassName) {
        FlowManager.loadDatabaseHolder(generatedClassName);
    }

    public static FlowConfig getConfig() {
        if (config == null) {
            throw new IllegalStateException("Configuration is not initialized. Please call init(FlowConfig) in your application class.");
        }
        return config;
    }

    protected static void loadDatabaseHolder(Class<? extends DatabaseHolder> holderClass) {
        if (loadedModules.contains(holderClass)) {
            return;
        }
        try {
            DatabaseHolder dbHolder = holderClass.newInstance();
            if (dbHolder != null) {
                globalDatabaseHolder.add(dbHolder);
                loadedModules.add(holderClass);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new ModuleNotFoundException("Cannot load " + holderClass, e);
        }
    }

    public static void reset() {
        Set entrySet = FlowManager.globalDatabaseHolder.databaseClassLookupMap.entrySet();
        for (Map.Entry value : entrySet) {
            ((DatabaseDefinition)value.getValue()).reset();
        }
        globalDatabaseHolder.reset();
        loadedModules.clear();
    }

    @NonNull
    public static Context getContext() {
        if (config == null) {
            throw new IllegalStateException("You must provide a valid FlowConfig instance. We recommend calling init() in your application class.");
        }
        return config.getContext();
    }

    public static void init(@NonNull Context context) {
        FlowManager.init(new FlowConfig.Builder(context).build());
    }

    public static void init(@NonNull FlowConfig flowConfig) {
        config = flowConfig;
        try {
            Class<?> defaultHolderClass = Class.forName(DEFAULT_DATABASE_HOLDER_CLASSNAME);
            FlowManager.loadDatabaseHolder(defaultHolderClass);
        }
        catch (ModuleNotFoundException e) {
            FlowLog.log(FlowLog.Level.W, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            FlowLog.log(FlowLog.Level.W, "Could not find the default GeneratedDatabaseHolder");
        }
        if (flowConfig.databaseHolders() != null && !flowConfig.databaseHolders().isEmpty()) {
            for (Class<? extends DatabaseHolder> holder : flowConfig.databaseHolders()) {
                FlowManager.loadDatabaseHolder(holder);
            }
        }
        if (flowConfig.openDatabasesOnInit()) {
            List<DatabaseDefinition> databaseDefinitions = globalDatabaseHolder.getDatabaseDefinitions();
            for (DatabaseDefinition databaseDefinition : databaseDefinitions) {
                databaseDefinition.getWritableDatabase();
            }
        }
    }

    public static TypeConverter getTypeConverterForClass(Class<?> objectClass) {
        FlowManager.checkDatabaseHolder();
        return globalDatabaseHolder.getTypeConverterForClass(objectClass);
    }

    public static synchronized void destroy() {
        Set entrySet = FlowManager.globalDatabaseHolder.databaseClassLookupMap.entrySet();
        for (Map.Entry value : entrySet) {
            ((DatabaseDefinition)value.getValue()).destroy();
        }
        config = null;
        globalDatabaseHolder = new GlobalDatabaseHolder();
        loadedModules.clear();
    }

    @NonNull
    public static <TModel> InstanceAdapter<TModel> getInstanceAdapter(Class<TModel> modelClass) {
        InstanceAdapter internalAdapter = FlowManager.getModelAdapterOrNull(modelClass);
        if (internalAdapter == null && (internalAdapter = FlowManager.getModelViewAdapterOrNull(modelClass)) == null) {
            internalAdapter = FlowManager.getQueryModelAdapterOrNull(modelClass);
        }
        if (internalAdapter == null) {
            FlowManager.throwCannotFindAdapter("InstanceAdapter", modelClass);
        }
        return internalAdapter;
    }

    @NonNull
    public static <TModel> RetrievalAdapter<TModel> getRetrievalAdapter(Class<TModel> modelClass) {
        InstanceAdapter retrievalAdapter = FlowManager.getModelAdapterOrNull(modelClass);
        if (retrievalAdapter == null && (retrievalAdapter = FlowManager.getModelViewAdapterOrNull(modelClass)) == null) {
            retrievalAdapter = FlowManager.getQueryModelAdapterOrNull(modelClass);
        }
        if (retrievalAdapter == null) {
            FlowManager.throwCannotFindAdapter("RetrievalAdapter", modelClass);
        }
        return retrievalAdapter;
    }

    @NonNull
    public static <TModel> ModelAdapter<TModel> getModelAdapter(Class<TModel> modelClass) {
        ModelAdapter<TModel> modelAdapter = FlowManager.getModelAdapterOrNull(modelClass);
        if (modelAdapter == null) {
            FlowManager.throwCannotFindAdapter("ModelAdapter", modelClass);
        }
        return modelAdapter;
    }

    @NonNull
    public static <TModelView> ModelViewAdapter<TModelView> getModelViewAdapter(Class<TModelView> modelViewClass) {
        ModelViewAdapter<TModelView> modelViewAdapter = FlowManager.getModelViewAdapterOrNull(modelViewClass);
        if (modelViewAdapter == null) {
            FlowManager.throwCannotFindAdapter("ModelViewAdapter", modelViewClass);
        }
        return modelViewAdapter;
    }

    @NonNull
    public static <TQueryModel> QueryModelAdapter<TQueryModel> getQueryModelAdapter(Class<TQueryModel> queryModelClass) {
        QueryModelAdapter<TQueryModel> queryModelAdapter = FlowManager.getQueryModelAdapterOrNull(queryModelClass);
        if (queryModelAdapter == null) {
            FlowManager.throwCannotFindAdapter("QueryModelAdapter", queryModelClass);
        }
        return queryModelAdapter;
    }

    @NonNull
    public static ModelNotifier getModelNotifierForTable(Class<?> table) {
        return FlowManager.getDatabaseForTable(table).getModelNotifier();
    }

    @NonNull
    public static TableNotifierRegister newRegisterForTable(Class<?> table) {
        return FlowManager.getModelNotifierForTable(table).newRegister();
    }

    @Nullable
    private static <T> ModelAdapter<T> getModelAdapterOrNull(Class<T> modelClass) {
        return FlowManager.getDatabaseForTable(modelClass).getModelAdapterForTable(modelClass);
    }

    @Nullable
    private static <T> ModelViewAdapter<T> getModelViewAdapterOrNull(Class<T> modelClass) {
        return FlowManager.getDatabaseForTable(modelClass).getModelViewAdapterForTable(modelClass);
    }

    @Nullable
    private static <T> QueryModelAdapter<T> getQueryModelAdapterOrNull(Class<T> modelClass) {
        return FlowManager.getDatabaseForTable(modelClass).getQueryModelAdapterForQueryClass(modelClass);
    }

    static Map<Integer, List<Migration>> getMigrations(String databaseName) {
        return FlowManager.getDatabase(databaseName).getMigrations();
    }

    public static boolean isDatabaseIntegrityOk(String databaseName) {
        return FlowManager.getDatabase(databaseName).getHelper().isDatabaseIntegrityOk();
    }

    private static void throwCannotFindAdapter(String type, Class<?> clazz) {
        throw new IllegalArgumentException("Cannot find " + type + " for " + clazz + ". Ensure the class is annotated with proper annotation.");
    }

    private static void checkDatabaseHolder() {
        if (!globalDatabaseHolder.isInitialized()) {
            throw new IllegalStateException("The global database holder is not initialized. Ensure you call FlowManager.init() before accessing the database.");
        }
    }

    static {
        globalDatabaseHolder = new GlobalDatabaseHolder();
        loadedModules = new HashSet();
        DEFAULT_DATABASE_HOLDER_PACKAGE_NAME = FlowManager.class.getPackage().getName();
        DEFAULT_DATABASE_HOLDER_CLASSNAME = DEFAULT_DATABASE_HOLDER_PACKAGE_NAME + "." + DEFAULT_DATABASE_HOLDER_NAME;
    }

    public static class ModuleNotFoundException
    extends RuntimeException {
        public ModuleNotFoundException() {
        }

        public ModuleNotFoundException(String detailMessage) {
            super(detailMessage);
        }

        public ModuleNotFoundException(String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
        }

        public ModuleNotFoundException(Throwable throwable) {
            super(throwable);
        }
    }

    private static class GlobalDatabaseHolder
    extends DatabaseHolder {
        private boolean initialized = false;

        private GlobalDatabaseHolder() {
        }

        public void add(DatabaseHolder holder) {
            this.databaseDefinitionMap.putAll(holder.databaseDefinitionMap);
            this.databaseNameMap.putAll(holder.databaseNameMap);
            this.typeConverters.putAll(holder.typeConverters);
            this.databaseClassLookupMap.putAll(holder.databaseClassLookupMap);
            this.initialized = true;
        }

        public boolean isInitialized() {
            return this.initialized;
        }
    }
}

