/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database.transaction;

import android.os.Looper;
import android.os.Process;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransactionQueue;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

public class DefaultTransactionQueue
extends Thread
implements ITransactionQueue {
    private final LinkedBlockingQueue<Transaction> queue = new LinkedBlockingQueue();
    private boolean isQuitting = false;

    public DefaultTransactionQueue(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        Process.setThreadPriority((int)10);
        while (true) {
            Transaction transaction;
            try {
                transaction = this.queue.take();
            }
            catch (InterruptedException e) {
                DefaultTransactionQueue defaultTransactionQueue = this;
                synchronized (defaultTransactionQueue) {
                    if (this.isQuitting) {
                        LinkedBlockingQueue<Transaction> linkedBlockingQueue = this.queue;
                        synchronized (linkedBlockingQueue) {
                            this.queue.clear();
                        }
                        return;
                    }
                    continue;
                }
            }
            if (this.isQuitting) continue;
            transaction.executeSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@NonNull Transaction runnable) {
        LinkedBlockingQueue<Transaction> linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            if (!this.queue.contains(runnable)) {
                this.queue.add(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(@NonNull Transaction runnable) {
        LinkedBlockingQueue<Transaction> linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            if (this.queue.contains(runnable)) {
                this.queue.remove(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(@NonNull String tag) {
        LinkedBlockingQueue<Transaction> linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            Iterator<Transaction> it = this.queue.iterator();
            while (it.hasNext()) {
                Transaction next = it.next();
                if (next.name() == null || !next.name().equals(tag)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startIfNotAlive() {
        DefaultTransactionQueue defaultTransactionQueue = this;
        synchronized (defaultTransactionQueue) {
            if (!this.isAlive()) {
                try {
                    this.start();
                }
                catch (IllegalThreadStateException i) {
                    FlowLog.log(FlowLog.Level.E, i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quit() {
        DefaultTransactionQueue defaultTransactionQueue = this;
        synchronized (defaultTransactionQueue) {
            this.isQuitting = true;
        }
        this.interrupt();
    }
}

