/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.database.DatabaseUtils;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.converter.TypeConverter;
import com.raizlabs.android.dbflow.data.Blob;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;

public abstract class BaseOperator
implements SQLOperator {
    protected String operation = "";
    protected Object value;
    @NonNull
    protected NameAlias nameAlias;
    protected String postArg;
    protected String separator;
    protected boolean isValueSet;

    @Nullable
    public static String convertValueToString(Object value, boolean appendInnerQueryParenthesis) {
        return BaseOperator.convertValueToString(value, appendInnerQueryParenthesis, true);
    }

    @Nullable
    public static String convertValueToString(@Nullable Object value, boolean appendInnerQueryParenthesis, boolean typeConvert) {
        String stringVal;
        TypeConverter typeConverter;
        if (value == null) {
            return "NULL";
        }
        if (typeConvert && (typeConverter = FlowManager.getTypeConverterForClass(value.getClass())) != null) {
            value = typeConverter.getDBValue(value);
        }
        if (value instanceof Number) {
            stringVal = String.valueOf(value);
        } else if (value instanceof Enum) {
            stringVal = DatabaseUtils.sqlEscapeString((String)((Enum)value).name());
        } else if (appendInnerQueryParenthesis && value instanceof BaseModelQueriable) {
            stringVal = String.format("(%1s)", ((BaseModelQueriable)value).getQuery().trim());
        } else if (value instanceof NameAlias) {
            stringVal = ((NameAlias)value).getQuery();
        } else if (value instanceof SQLOperator) {
            QueryBuilder queryBuilder = new QueryBuilder();
            ((SQLOperator)value).appendConditionToQuery(queryBuilder);
            stringVal = queryBuilder.toString();
        } else if (value instanceof Query) {
            stringVal = ((Query)value).getQuery();
        } else if (value instanceof Blob || value instanceof byte[]) {
            byte[] bytes = value instanceof Blob ? ((Blob)value).getBlob() : (byte[])value;
            stringVal = "X" + DatabaseUtils.sqlEscapeString((String)SqlUtils.byteArrayToHexString(bytes));
        } else {
            stringVal = String.valueOf(value);
            if (!stringVal.equals("?")) {
                stringVal = DatabaseUtils.sqlEscapeString((String)stringVal);
            }
        }
        return stringVal;
    }

    @NonNull
    public static String joinArguments(@NonNull CharSequence delimiter, @NonNull Iterable tokens, @NonNull BaseOperator condition) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(condition.convertObjectToString(token, false));
        }
        return sb.toString();
    }

    @NonNull
    public static String joinArguments(@NonNull CharSequence delimiter, @NonNull Object[] tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(BaseOperator.convertValueToString(token, false, true));
        }
        return sb.toString();
    }

    @NonNull
    public static String joinArguments(@NonNull CharSequence delimiter, @NonNull Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(BaseOperator.convertValueToString(token, false, true));
        }
        return sb.toString();
    }

    BaseOperator(@NonNull NameAlias nameAlias) {
        this.nameAlias = nameAlias;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    @NonNull
    public String columnName() {
        return this.nameAlias.getQuery();
    }

    @Override
    @NonNull
    public SQLOperator separator(@NonNull String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    @Nullable
    public String separator() {
        return this.separator;
    }

    @Override
    public boolean hasSeparator() {
        return this.separator != null && this.separator.length() > 0;
    }

    @Override
    @NonNull
    public String operation() {
        return this.operation;
    }

    public String postArgument() {
        return this.postArg;
    }

    NameAlias columnAlias() {
        return this.nameAlias;
    }

    public String convertObjectToString(Object object, boolean appendInnerParenthesis) {
        return BaseOperator.convertValueToString(object, appendInnerParenthesis);
    }
}

