/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.runtime;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.runtime.ModelNotifier;
import com.raizlabs.android.dbflow.runtime.OnTableChangedListener;
import com.raizlabs.android.dbflow.runtime.TableNotifierRegister;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DirectModelNotifier
implements ModelNotifier {
    private static DirectModelNotifier notifier;
    private final Map<Class<?>, Set<OnModelStateChangedListener>> modelChangedListenerMap = new LinkedHashMap();
    private final Map<Class<?>, Set<OnTableChangedListener>> tableChangedListenerMap = new LinkedHashMap();
    private final TableNotifierRegister singleRegister = new DirectTableNotifierRegister();

    @NonNull
    public static DirectModelNotifier get() {
        if (notifier == null) {
            notifier = new DirectModelNotifier();
        }
        return notifier;
    }

    private DirectModelNotifier() {
        if (notifier != null) {
            throw new IllegalStateException("Cannot instantiate more than one DirectNotifier. Use DirectNotifier.get()");
        }
    }

    @Override
    public <T> void notifyModelChanged(@NonNull T model, @NonNull ModelAdapter<T> adapter, @NonNull BaseModel.Action action) {
        Set<OnModelStateChangedListener> listeners = this.modelChangedListenerMap.get(adapter.getModelClass());
        if (listeners != null) {
            for (OnModelStateChangedListener listener : listeners) {
                if (listener == null) continue;
                listener.onModelChanged(model, action);
            }
        }
    }

    @Override
    public <T> void notifyTableChanged(@NonNull Class<T> table, @NonNull BaseModel.Action action) {
        Set<OnTableChangedListener> listeners = this.tableChangedListenerMap.get(table);
        if (listeners != null) {
            for (OnTableChangedListener listener : listeners) {
                if (listener == null) continue;
                listener.onTableChanged(table, action);
            }
        }
    }

    @Override
    public TableNotifierRegister newRegister() {
        return this.singleRegister;
    }

    public <T> void registerForModelChanges(@NonNull Class<T> table, @NonNull ModelChangedListener<T> listener) {
        this.registerForModelStateChanges(table, listener);
        this.registerForTableChanges(table, listener);
    }

    public <T> void registerForModelStateChanges(@NonNull Class<T> table, @NonNull OnModelStateChangedListener<T> listener) {
        Set<OnModelStateChangedListener> listeners = this.modelChangedListenerMap.get(table);
        if (listeners == null) {
            listeners = new LinkedHashSet<OnModelStateChangedListener>();
            this.modelChangedListenerMap.put(table, listeners);
        }
        listeners.add(listener);
    }

    public <T> void registerForTableChanges(@NonNull Class<T> table, @NonNull OnTableChangedListener listener) {
        Set<OnTableChangedListener> listeners = this.tableChangedListenerMap.get(table);
        if (listeners == null) {
            listeners = new LinkedHashSet<OnTableChangedListener>();
            this.tableChangedListenerMap.put(table, listeners);
        }
        listeners.add(listener);
    }

    public <T> void unregisterForModelChanges(@NonNull Class<T> table, @NonNull ModelChangedListener<T> listener) {
        this.unregisterForModelStateChanges(table, listener);
        this.unregisterForTableChanges(table, listener);
    }

    public <T> void unregisterForModelStateChanges(@NonNull Class<T> table, @NonNull OnModelStateChangedListener<T> listener) {
        Set<OnModelStateChangedListener> listeners = this.modelChangedListenerMap.get(table);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public <T> void unregisterForTableChanges(@NonNull Class<T> table, @NonNull OnTableChangedListener listener) {
        Set<OnTableChangedListener> listeners = this.tableChangedListenerMap.get(table);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    private class DirectTableNotifierRegister
    implements TableNotifierRegister {
        private List<Class> registeredTables = new ArrayList<Class>();
        @Nullable
        private OnTableChangedListener modelChangedListener;
        private final OnTableChangedListener internalChangeListener = new OnTableChangedListener(){

            @Override
            public void onTableChanged(@Nullable Class<?> table, @NonNull BaseModel.Action action) {
                if (DirectTableNotifierRegister.this.modelChangedListener != null) {
                    DirectTableNotifierRegister.this.modelChangedListener.onTableChanged(table, action);
                }
            }
        };

        private DirectTableNotifierRegister() {
        }

        @Override
        public <T> void register(@NonNull Class<T> tClass) {
            this.registeredTables.add(tClass);
            DirectModelNotifier.this.registerForTableChanges(tClass, this.internalChangeListener);
        }

        @Override
        public <T> void unregister(@NonNull Class<T> tClass) {
            this.registeredTables.remove(tClass);
            DirectModelNotifier.this.unregisterForTableChanges(tClass, this.internalChangeListener);
        }

        @Override
        public void unregisterAll() {
            for (Class table : this.registeredTables) {
                DirectModelNotifier.this.unregisterForTableChanges(table, this.internalChangeListener);
            }
            this.modelChangedListener = null;
        }

        @Override
        public void setListener(@Nullable OnTableChangedListener modelChangedListener) {
            this.modelChangedListener = modelChangedListener;
        }

        @Override
        public boolean isSubscribed() {
            return !this.registeredTables.isEmpty();
        }
    }

    public static interface ModelChangedListener<T>
    extends OnModelStateChangedListener<T>,
    OnTableChangedListener {
    }

    public static interface OnModelStateChangedListener<T> {
        public void onModelChanged(@NonNull T var1, @NonNull BaseModel.Action var2);
    }
}

