/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.DatabaseConfig;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.TableConfig;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.queriable.ListModelLoader;
import com.raizlabs.android.dbflow.sql.queriable.SingleModelLoader;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.FlowCursor;

public abstract class RetrievalAdapter<TModel> {
    private SingleModelLoader<TModel> singleModelLoader;
    private ListModelLoader<TModel> listModelLoader;
    private TableConfig<TModel> tableConfig;

    public RetrievalAdapter(@NonNull DatabaseDefinition databaseDefinition) {
        DatabaseConfig databaseConfig = FlowManager.getConfig().getConfigForDatabase(databaseDefinition.getAssociatedDatabaseClassFile());
        if (databaseConfig != null) {
            this.tableConfig = databaseConfig.getTableConfigForTable(this.getModelClass());
            if (this.tableConfig != null) {
                if (this.tableConfig.singleModelLoader() != null) {
                    this.singleModelLoader = this.tableConfig.singleModelLoader();
                }
                if (this.tableConfig.listModelLoader() != null) {
                    this.listModelLoader = this.tableConfig.listModelLoader();
                }
            }
        }
    }

    public void load(@NonNull TModel model) {
        this.load(model, FlowManager.getDatabaseForTable(this.getModelClass()).getWritableDatabase());
    }

    public void load(@NonNull TModel model, DatabaseWrapper databaseWrapper) {
        this.getSingleModelLoader().load(databaseWrapper, SQLite.select(new IProperty[0]).from(this.getModelClass()).where(this.getPrimaryConditionClause(model)).getQuery(), model);
    }

    public abstract void loadFromCursor(@NonNull FlowCursor var1, @NonNull TModel var2);

    public boolean exists(@NonNull TModel model) {
        return this.exists(model, FlowManager.getDatabaseForTable(this.getModelClass()).getWritableDatabase());
    }

    public abstract boolean exists(@NonNull TModel var1, @NonNull DatabaseWrapper var2);

    public abstract OperatorGroup getPrimaryConditionClause(@NonNull TModel var1);

    @NonNull
    public abstract Class<TModel> getModelClass();

    @Nullable
    protected TableConfig<TModel> getTableConfig() {
        return this.tableConfig;
    }

    @NonNull
    public ListModelLoader<TModel> getListModelLoader() {
        if (this.listModelLoader == null) {
            this.listModelLoader = this.createListModelLoader();
        }
        return this.listModelLoader;
    }

    @NonNull
    protected ListModelLoader<TModel> createListModelLoader() {
        return new ListModelLoader<TModel>(this.getModelClass());
    }

    @NonNull
    protected SingleModelLoader<TModel> createSingleModelLoader() {
        return new SingleModelLoader<TModel>(this.getModelClass());
    }

    @NonNull
    public SingleModelLoader<TModel> getSingleModelLoader() {
        if (this.singleModelLoader == null) {
            this.singleModelLoader = this.createSingleModelLoader();
        }
        return this.singleModelLoader;
    }

    @NonNull
    public SingleModelLoader<TModel> getNonCacheableSingleModelLoader() {
        return new SingleModelLoader<TModel>(this.getModelClass());
    }

    @NonNull
    public ListModelLoader<TModel> getNonCacheableListModelLoader() {
        return new ListModelLoader<TModel>(this.getModelClass());
    }

    public void setSingleModelLoader(@NonNull SingleModelLoader<TModel> singleModelLoader) {
        this.singleModelLoader = singleModelLoader;
    }

    public void setListModelLoader(@NonNull ListModelLoader<TModel> listModelLoader) {
        this.listModelLoader = listModelLoader;
    }
}

