/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.SQLiteType;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import com.raizlabs.android.dbflow.sql.language.property.PropertyFactory;
import java.util.ArrayList;
import java.util.List;

public class Method
extends Property {
    private final List<IProperty> propertyList = new ArrayList<IProperty>();
    private List<String> operationsList = new ArrayList<String>();
    private final IProperty methodProperty;

    @NonNull
    public static Method avg(IProperty ... properties) {
        return new Method("AVG", properties);
    }

    @NonNull
    public static Method count(IProperty ... properties) {
        return new Method("COUNT", properties);
    }

    @NonNull
    public static Method group_concat(IProperty ... properties) {
        return new Method("GROUP_CONCAT", properties);
    }

    @NonNull
    public static Method max(IProperty ... properties) {
        return new Method("MAX", properties);
    }

    @NonNull
    public static Method min(IProperty ... properties) {
        return new Method("MIN", properties);
    }

    @NonNull
    public static Method sum(IProperty ... properties) {
        return new Method("SUM", properties);
    }

    @NonNull
    public static Method total(IProperty ... properties) {
        return new Method("TOTAL", properties);
    }

    @NonNull
    public static Cast cast(@NonNull IProperty property) {
        return new Cast(property);
    }

    @NonNull
    public static Method replace(@NonNull IProperty property, String findString, String replacement) {
        return new Method("REPLACE", property, PropertyFactory.from(findString), PropertyFactory.from(replacement));
    }

    public static Method strftime(@NonNull String formatString, @NonNull String timeString, String ... modifiers) {
        ArrayList<Property<String>> propertyList = new ArrayList<Property<String>>();
        propertyList.add(PropertyFactory.from(formatString));
        propertyList.add(PropertyFactory.from(timeString));
        for (String modifier : modifiers) {
            propertyList.add(PropertyFactory.from(modifier));
        }
        return new Method("strftime", propertyList.toArray(new IProperty[propertyList.size()]));
    }

    public static Method datetime(long timeStamp, String ... modifiers) {
        ArrayList<Property<Object>> propertyList = new ArrayList<Property<Object>>();
        propertyList.add(PropertyFactory.from(timeStamp));
        for (String modifier : modifiers) {
            propertyList.add(PropertyFactory.from(modifier));
        }
        return new Method("datetime", propertyList.toArray(new IProperty[propertyList.size()]));
    }

    public static Method date(@NonNull String timeString, String ... modifiers) {
        ArrayList<Property<String>> propertyList = new ArrayList<Property<String>>();
        propertyList.add(PropertyFactory.from(timeString));
        for (String modifier : modifiers) {
            propertyList.add(PropertyFactory.from(modifier));
        }
        return new Method("date", propertyList.toArray(new IProperty[propertyList.size()]));
    }

    public static Method ifNull(@NonNull IProperty first, @NonNull IProperty secondIfFirstNull) {
        return new Method("IFNULL", first, secondIfFirstNull);
    }

    public static Method nullIf(@NonNull IProperty first, @NonNull IProperty second) {
        return new Method("NULLIF", first, second);
    }

    public Method(IProperty ... properties) {
        this((String)null, properties);
    }

    public Method(String methodName, IProperty ... properties) {
        super(null, (String)null);
        this.methodProperty = new Property(null, NameAlias.rawBuilder(methodName).build());
        if (properties.length == 0) {
            this.propertyList.add(Property.ALL_PROPERTY);
        } else {
            for (IProperty property : properties) {
                this.addProperty(property);
            }
        }
    }

    @Override
    @NonNull
    public Method plus(@NonNull IProperty property) {
        return this.append(property, " +");
    }

    @Override
    @NonNull
    public Method minus(@NonNull IProperty property) {
        return this.append(property, " -");
    }

    @Override
    @NonNull
    public Property div(@NonNull IProperty property) {
        return this.append(property, " /");
    }

    @Override
    public Property times(@NonNull IProperty property) {
        return this.append(property, " *");
    }

    @Override
    @NonNull
    public Property rem(@NonNull IProperty property) {
        return this.append(property, " %");
    }

    public Method addProperty(@NonNull IProperty property) {
        return this.append(property, ",");
    }

    public Method append(IProperty property, String operation) {
        if (this.propertyList.size() == 1 && this.propertyList.get(0) == Property.ALL_PROPERTY) {
            this.propertyList.remove(0);
        }
        this.propertyList.add(property);
        this.operationsList.add(operation);
        return this;
    }

    @NonNull
    protected List<IProperty> getPropertyList() {
        return this.propertyList;
    }

    @Override
    @NonNull
    public NameAlias getNameAlias() {
        if (this.nameAlias == null) {
            String query = this.methodProperty.getQuery();
            if (query == null) {
                query = "";
            }
            query = query + "(";
            List<IProperty> propertyList = this.getPropertyList();
            for (int i = 0; i < propertyList.size(); ++i) {
                IProperty property = propertyList.get(i);
                if (i > 0) {
                    query = query + this.operationsList.get(i) + " ";
                }
                query = query + property.toString();
            }
            query = query + ")";
            this.nameAlias = NameAlias.rawBuilder(query).build();
        }
        return this.nameAlias;
    }

    public static class Cast {
        private final IProperty property;

        private Cast(@NonNull IProperty property) {
            this.property = property;
        }

        public IProperty as(SQLiteType sqLiteType) {
            Property newProperty = new Property(this.property.getTable(), this.property.getNameAlias().newBuilder().shouldAddIdentifierToAliasName(false).as(sqLiteType.name()).build());
            return new Method("CAST", newProperty);
        }
    }
}

